/*
 * Decompiled with CFR 0.152.
 */
package io.rong.common;

import io.rong.common.RLog;
import io.rong.common.utils.SSLUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;

public class NetUtils {
    private static final String TAG = NetUtils.class.getSimpleName();
    private static boolean isSelfCertificate;

    public static void enableHttpsSelfCertificate(boolean isEnable) {
        isSelfCertificate = isEnable;
    }

    public static HttpURLConnection createURLConnection(String urlStr) throws IOException {
        HttpURLConnection conn;
        if (urlStr.toLowerCase().startsWith("https")) {
            RLog.i(TAG, "https connection. isSelfCertificate: " + isSelfCertificate);
            URL url = new URL(urlStr);
            if (isSelfCertificate) {
                SSLContext sslContext = SSLUtils.getSSLContext();
                HttpsURLConnection c = (HttpsURLConnection)url.openConnection();
                c.setSSLSocketFactory(sslContext.getSocketFactory());
                c.setHostnameVerifier(new TrustAnyHostnameVerifier());
                conn = c;
            } else {
                conn = (HttpsURLConnection)url.openConnection();
            }
        } else {
            URL url = new URL(urlStr);
            conn = (HttpURLConnection)url.openConnection();
        }
        return conn;
    }

    private static class TrustAnyHostnameVerifier
    implements HostnameVerifier {
        private TrustAnyHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

