/*
 * Decompiled with CFR 0.152.
 */
package io.rong.common;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Process;
import android.text.TextUtils;
import io.rong.common.RLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.List;

public class SystemUtils {
    private static String TAG = "SystemUtils";

    public static boolean isAppRunning(Context context, String name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        List infos = am.getRunningAppProcesses();
        if (infos == null) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo info : infos) {
            if (!info.processName.equals(name)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentProcessName(Context context) {
        File cmdFile;
        String process = "";
        if (context != null) {
            int pid = Process.myPid();
            ActivityManager am = (ActivityManager)context.getSystemService("activity");
            List infos = am.getRunningAppProcesses();
            if (infos != null) {
                for (ActivityManager.RunningAppProcessInfo info : infos) {
                    if (info.pid != pid) continue;
                    process = info.processName;
                    break;
                }
            }
        }
        if (TextUtils.isEmpty((CharSequence)process) && (cmdFile = new File("/proc/self/cmdline")).exists() && !cmdFile.isDirectory()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(cmdFile)));
                process = reader.readLine();
            }
            catch (Exception e) {
                RLog.e(TAG, "getCurrentProcessName", e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        RLog.e(TAG, "getCurrentProcessName", e);
                    }
                }
            }
        }
        return process;
    }
}

