/*
 * Decompiled with CFR 0.152.
 */
package io.rong.common.fwlog;

import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import io.rong.common.fwlog.LogEntity;
import io.rong.common.fwlog.LogReporter;
import io.rong.common.fwlog.LogThresholdCallback;
import io.rong.common.fwlog.LogWriter;
import io.rong.common.fwlog.LogZipper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class SimpleLogWriter
implements LogWriter {
    protected String logPath;
    private File logFile;
    private FileWriter fileWriter;
    private LogThresholdCallback sizeCallback;
    private Handler writeHandler;

    public SimpleLogWriter(String logPath) {
        this.logPath = logPath;
        this.open();
    }

    protected SimpleLogWriter(String logPath, LogThresholdCallback callback) {
        HandlerThread writeThread = new HandlerThread("cn.rongcloud.fwLogWriter");
        writeThread.start();
        this.writeHandler = new Handler(writeThread.getLooper());
        this.sizeCallback = callback;
        this.logPath = logPath;
        this.open();
    }

    @Override
    public void write(final String log) {
        if (Thread.currentThread().getName().equals("cn.rongcloud.fwLogWriter")) {
            this.internalWrite(log);
        } else {
            this.writeHandler.post(new Runnable(){

                @Override
                public void run() {
                    SimpleLogWriter.this.internalWrite(log);
                }
            });
        }
    }

    protected final void internalWrite(String log) {
        try {
            if (this.fileWriter != null) {
                this.fileWriter.write(log + "\n");
                this.fileWriter.flush();
            }
        }
        catch (IOException e) {
            Log.e((String)"FwLog", (String)("write file error " + this.logPath));
            e.printStackTrace();
        }
        if (this.sizeCallback != null) {
            this.sizeCallback.onSize(this.logFile.length());
        }
    }

    private void flushAndStamp() {
        this.logFile = new File(this.logPath);
        if (!this.logFile.exists() || this.logFile.length() == 0L) {
            Log.e((String)"FwLog", (String)("file not exist " + this.logPath));
            return;
        }
        this.close();
        long startLogTime = LogEntity.getInstance().getStartLogTime();
        long endLogTime = this.logFile.lastModified();
        if (endLogTime == 0L) {
            endLogTime = System.currentTimeMillis();
        }
        String zipFilename = startLogTime + "_" + endLogTime + this.getZipFileSuffix();
        String zipFilePath = LogEntity.getInstance().getLogDir() + File.separator + zipFilename;
        if (LogZipper.gzipFile(this.logFile.getAbsolutePath(), zipFilePath)) {
            this.logFile.delete();
            this.open();
            LogEntity.getInstance().addLogStamp(zipFilename);
        }
        LogEntity.getInstance().setStartLogTime(System.currentTimeMillis());
        Log.e((String)"FwLog", (String)("zip file error " + this.logPath));
    }

    @Override
    public void flush() {
        this.writeHandler.post(new Runnable(){

            @Override
            public void run() {
                SimpleLogWriter.this.flushAndStamp();
            }
        });
    }

    @Override
    public void flushAndReport(final LogReporter logReporter) {
        if (LogEntity.getInstance().getUserId() == null) {
            return;
        }
        this.writeHandler.post(new Runnable(){

            @Override
            public void run() {
                SimpleLogWriter.this.flushAndStamp();
                logReporter.reportFileLog();
            }
        });
    }

    @Override
    public void open() {
        this.logFile = new File(this.logPath);
        try {
            this.fileWriter = new FileWriter(this.logFile, true);
        }
        catch (IOException e) {
            Log.e((String)"FwLog", (String)("open file error " + this.logPath));
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
        try {
            if (this.fileWriter != null) {
                this.fileWriter.close();
            }
        }
        catch (IOException e) {
            Log.e((String)"FwLog", (String)("close file error " + this.logPath));
            e.printStackTrace();
        }
    }

    protected String getZipFileSuffix() {
        return ".gz";
    }
}

