/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import io.rong.common.RLog;
import io.rong.common.fwlog.FwLog;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.common.DeviceUtils;

public class ConnectChangeReceiver
extends BroadcastReceiver {
    private static final String TAG = "ConnectChangeReceiver";
    public static final String RECONNECT_ACTION = "action_reconnect";

    public void onReceive(Context context, Intent intent) {
        if (intent == null || intent.getAction() == null) {
            return;
        }
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        try {
            RLog.d(TAG, "intent : " + intent.toString());
            networkInfo = cm.getActiveNetworkInfo();
            RLog.d(TAG, "network : " + (networkInfo != null ? networkInfo.isAvailable() + " " + networkInfo.isConnected() : "null"));
        }
        catch (Exception e) {
            RLog.e(TAG, "getActiveNetworkInfo Exception", e);
        }
        boolean networkAvailable = networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected();
        FwLog.write(4, 4, "L-network_changed-S", "network|available", DeviceUtils.getNetworkType(context), networkAvailable);
        if (intent.getAction().equals("android.net.conn.CONNECTIVITY_CHANGE") && networkAvailable) {
            RongIMClient.reconnectServer(null);
        } else if (intent.getAction().equals(RECONNECT_ACTION) && networkAvailable) {
            RongIMClient.reconnectServer(null);
        } else if (intent.getAction().equals("android.intent.action.USER_PRESENT")) {
            RongIMClient.ConnectionStatusListener.ConnectionStatus state = RongIMClient.getInstance().getCurrentConnectionStatus();
            if (state.equals((Object)RongIMClient.ConnectionStatusListener.ConnectionStatus.NETWORK_UNAVAILABLE) && networkAvailable) {
                RongIMClient.reconnectServer(null);
            }
        } else if (intent.getAction().equals(RECONNECT_ACTION) && networkInfo != null && networkInfo.isAvailable() && !networkInfo.isConnected()) {
            RongIMClient.ConnectionStatusListener.ConnectionStatus state = RongIMClient.getInstance().getCurrentConnectionStatus();
            if (state.equals((Object)RongIMClient.ConnectionStatusListener.ConnectionStatus.NETWORK_UNAVAILABLE) && networkAvailable) {
                RongIMClient.reconnectServer(null);
            }
        } else {
            RLog.e(TAG, "Network exception, NetworkInfo = " + (networkInfo != null ? networkInfo.isAvailable() + ", " + networkInfo.isConnected() : "null"));
        }
    }
}

