/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import io.rong.common.FileUtils;
import io.rong.common.RLog;
import io.rong.common.WakeLockUtils;
import io.rong.common.fwlog.FwLog;
import io.rong.common.fwlog.IRealTimeLogListener;
import io.rong.common.fwlog.RealTimeLogInfo;
import io.rong.imlib.MessageTag;
import io.rong.imlib.NativeObject;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.common.DeviceUtils;
import io.rong.imlib.filetransfer.Configuration;
import io.rong.imlib.filetransfer.FileTransferClient;
import io.rong.imlib.filetransfer.FtConst;
import io.rong.imlib.filetransfer.FtUtilities;
import io.rong.imlib.filetransfer.RequestCallBack;
import io.rong.imlib.filetransfer.RequestOption;
import io.rong.imlib.model.ChatRoomInfo;
import io.rong.imlib.model.ChatRoomMemberInfo;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Discussion;
import io.rong.imlib.model.Group;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.MessageContent;
import io.rong.imlib.model.PublicServiceProfile;
import io.rong.imlib.model.PublicServiceProfileList;
import io.rong.imlib.model.RCEncryptedSession;
import io.rong.imlib.model.RTCUser;
import io.rong.imlib.model.SearchConversationResult;
import io.rong.imlib.model.SendMessageOption;
import io.rong.imlib.model.UnknownMessage;
import io.rong.imlib.model.UserData;
import io.rong.imlib.navigation.NavigationCacheHelper;
import io.rong.imlib.navigation.NavigationClient;
import io.rong.imlib.navigation.NavigationObserver;
import io.rong.message.DiscussionNotificationMessage;
import io.rong.message.FileMessage;
import io.rong.message.IHandleMessageListener;
import io.rong.message.ImageMessage;
import io.rong.message.LocationMessage;
import io.rong.message.MediaMessageContent;
import io.rong.message.MessageHandler;
import io.rong.message.RCEncryptedMessage;
import io.rong.message.SightMessage;
import io.rong.message.TextMessage;
import io.rong.message.utils.RCDHCodecTool;
import java.io.File;
import java.lang.reflect.Constructor;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public final class NativeClient {
    private static final String TAG = "NativeClient";
    private static NativeClient client = null;
    private Context mContext = null;
    private boolean enableReconnectKick = false;
    private NativeObject nativeObj;
    private Handler mWorkHandler;
    private String mFileServer;
    private String appKey;
    private String deviceId;
    private String dbPath;
    private String curUserId;
    private HashMap<String, Constructor<? extends MessageContent>> messageContentConstructorMap;
    private HashMap<String, MessageHandler> messageHandlerMap;
    private ConnectHandler mConnectHandler = new ConnectHandler();
    private Timer timer;

    private MessageContent renderMessageContent(String objectName, byte[] content, Message message) {
        MessageContent result = this.newMessageContent(objectName, content);
        if (result instanceof UnknownMessage) {
            return result;
        }
        MessageHandler messageHandler = this.getMessageHandler(objectName);
        if (messageHandler != null) {
            messageHandler.decodeMessage(message, result);
        } else {
            RLog.e(TAG, "renderMessageContent \u8be5\u6d88\u606f\u672a\u6ce8\u518c\uff0c\u8bf7\u8c03\u7528registerMessageType\u65b9\u6cd5\u6ce8\u518c\u3002");
        }
        return result;
    }

    private NativeClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NativeClient getInstance() {
        if (client != null) return client;
        Class<NativeClient> clazz = NativeClient.class;
        synchronized (NativeClient.class) {
            if (client != null) return client;
            client = new NativeClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return client;
        }
    }

    public void init(Context context, String appKey, String deviceId) {
        this.mContext = context.getApplicationContext();
        this.appKey = appKey;
        this.deviceId = deviceId;
        this.nativeObj = new NativeObject(context);
        this.messageHandlerMap = new HashMap();
        this.messageContentConstructorMap = new HashMap();
        HandlerThread workThread = new HandlerThread("PING_WORK");
        workThread.start();
        this.mWorkHandler = new Handler(workThread.getLooper());
        File dbFile = this.mContext.getFilesDir();
        if (dbFile == null || !dbFile.exists()) {
            if (dbFile == null) {
                dbFile = this.mContext.getDir("rcdb", 0);
            } else {
                dbFile.mkdirs();
            }
            this.dbPath = dbFile.getPath();
        } else {
            this.dbPath = dbFile.getPath();
        }
        int result = this.nativeObj.InitClient(appKey, context.getPackageName(), deviceId, this.dbPath, "");
        this.nativeObj.SetRealTimeLogListener(new IRealTimeLogListener(){

            @Override
            public void OnLogGenerated(RealTimeLogInfo logInfo) {
                RLog.d(NativeClient.TAG, "OnLogGenerated = " + logInfo);
                int code = logInfo.getCode();
                int nativeCode = logInfo.getNativeCode();
                int seqId = logInfo.getSeqId();
                String sessionId = logInfo.getSessionId();
                String method = logInfo.getMethod();
                String type = logInfo.getType();
                String tag = logInfo.getTag();
                switch (code) {
                    case 30003: {
                        FwLog.rtWrite(2, 128, "P-rtmsg-E", "code|method|nativeCode|sessionId|seq_id", code, method, nativeCode, sessionId, seqId);
                        break;
                    }
                    case 30008: {
                        FwLog.rtWrite(2, 16, "P-rtcon-E", "code|method|nativeCode|sessionId|seq_id", code, method, nativeCode, sessionId, seqId);
                        break;
                    }
                    case 31000: {
                        FwLog.rtWrite(2, 16, "P-rtcon-E", "code|method|nativeCode|sessionId|seq_id", code, method, nativeCode, sessionId, seqId);
                        break;
                    }
                    case 30010: {
                        FwLog.rtWrite(2, 16, "P-rttcp-E", "code|method|nativeCode|sessionId|seq_id", code, method, nativeCode, sessionId, seqId);
                        break;
                    }
                }
            }
        });
        FwLog.write(4, 4, "L-init-O", "appkey|deviceId|dbPath|initResult", appKey, deviceId, this.dbPath, result);
        this.initFileTransferClient();
    }

    public void registerMessageType(Class<? extends MessageContent> msgType) throws Exception {
        try {
            MessageTag tag = msgType.getAnnotation(MessageTag.class);
            if (tag != null) {
                String objName = tag.value();
                Constructor<? extends MessageContent> constructor = msgType.getDeclaredConstructor(byte[].class);
                Constructor<? extends MessageHandler> handlerConstructor = tag.messageHandler().getConstructor(Context.class);
                MessageHandler messageHandler = handlerConstructor.newInstance(this.mContext);
                this.messageHandlerMap.put(objName, messageHandler);
                this.messageContentConstructorMap.put(objName, constructor);
                this.nativeObj.RegisterMessageType(objName, tag.flag());
            }
        }
        catch (Throwable throwable) {
            FwLog.write(2, 128, "L-regtype-E", null, new Object[0]);
        }
    }

    public void connect(final String token, final boolean isReconnect, final boolean inForeground, final IResultCallback<String> callback) {
        this.setEnvInfo(this.mContext);
        NavigationClient.getInstance().addObserver(new NavigationObserver(){

            @Override
            public void onSuccess(String userId, NativeObject.ConnectionEntry[] connectionEntries) {
                RLog.d(NativeClient.TAG, "[connect] get cmp success: " + NativeClient.connectionEntryArrayToString(connectionEntries));
                boolean isPrivate = NavigationCacheHelper.getPrivateCloudConfig(NativeClient.this.mContext);
                NativeClient.this.nativeObj.SetEnvironment(isPrivate);
                FileTransferClient.getInstance().setServiceType(isPrivate ? FtConst.ServiceType.PRIVATE_CLOUD : FtConst.ServiceType.QI_NIU);
                boolean enable = NavigationCacheHelper.isConnPolicyEnable(NativeClient.this.mContext);
                FwLog.setLogMonitor(NavigationCacheHelper.getLogMonitor(NativeClient.this.mContext));
                FwLog.setLogServer(NavigationCacheHelper.getOnlineLogServer(NativeClient.this.mContext), NavigationCacheHelper.getOfflineLogServer(NativeClient.this.mContext));
                FwLog.setUserId(NavigationCacheHelper.getUserId(NativeClient.this.mContext));
                NativeClient.this.mConnectHandler.connect(token, userId, enable, connectionEntries, isReconnect, inForeground, callback);
            }

            @Override
            public void onError(String userId, NativeObject.ConnectionEntry[] connectionEntries, int errorCode) {
                RLog.e(NativeClient.TAG, "[connect] get cmp error: " + NativeClient.connectionEntryArrayToString(connectionEntries) + ", errorCode = " + errorCode);
                boolean isPrivate = NavigationCacheHelper.getPrivateCloudConfig(NativeClient.this.mContext);
                if (connectionEntries == null || connectionEntries.length == 0) {
                    callback.onError(errorCode);
                    NavigationClient.getInstance().clearObserver();
                } else {
                    NativeClient.this.nativeObj.SetEnvironment(isPrivate);
                    boolean connectionPolicy = NavigationCacheHelper.isConnPolicyEnable(NativeClient.this.mContext);
                    NativeClient.this.mConnectHandler.connect(token, userId, connectionPolicy, connectionEntries, isReconnect, inForeground, callback);
                }
                if (errorCode == 30008) {
                    FwLog.rtWrite(2, 16, "P-rtcon-E", "code|method|nativeCode|sessionId|seq_id", errorCode, "navi", 0, 0, "0");
                }
                FileTransferClient.getInstance().setServiceType(isPrivate ? FtConst.ServiceType.PRIVATE_CLOUD : FtConst.ServiceType.QI_NIU);
            }
        });
        NavigationClient.getInstance().getCMPServerString(this.mContext, this.appKey, token);
    }

    public static String connectionEntryArrayToString(NativeObject.ConnectionEntry[] connectionEntries) {
        if (connectionEntries == null || connectionEntries.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (NativeObject.ConnectionEntry entry : connectionEntries) {
            sb.append(entry.getHost());
            sb.append(":");
            sb.append(entry.getPort());
            sb.append(",");
        }
        String str = sb.toString();
        return str.substring(0, str.length() - 1);
    }

    public void tryConnect(final String token, String userId, final boolean useComplexConnection, NativeObject.ConnectionEntry[] connectionEntries, boolean isReconnect, final boolean inForeground, final ConnectResultCallback<String> callback) {
        this.curUserId = userId;
        boolean mpOpened = NavigationClient.getInstance().isMPOpened(this.mContext);
        boolean usOpened = NavigationClient.getInstance().isUSOpened(this.mContext);
        boolean grOpened = NavigationClient.getInstance().isGROpened(this.mContext);
        boolean ipv6Preffered = false;
        String MCCMNC = "";
        try {
            TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
            if (telephonyManager != null) {
                MCCMNC = telephonyManager.getNetworkOperator();
            }
        }
        catch (SecurityException e) {
            RLog.e(TAG, "tryConnect SecurityException", e);
        }
        String netType = DeviceUtils.getNetworkType(this.mContext);
        RLog.d(TAG, "[connect] device info: " + Build.MANUFACTURER + ", " + Build.MODEL + ", " + Build.VERSION.SDK_INT + ", " + "2.9.18" + ", " + netType + ", " + MCCMNC);
        RLog.d(TAG, "[connect] tryConnect::cmp:" + NativeClient.connectionEntryArrayToString(connectionEntries) + ", userId : " + userId);
        if (useComplexConnection) {
            this.nativeObj.SetConnectionCollectionListener(new NativeObject.ConnectionCollectionListener(){

                @Override
                public void OnComplete(NativeObject.ConnectionEntry entry) {
                    FwLog.write(entry.getError() == 0 ? 4 : 2, 16, "P-connect_entry-S", "code|cmp|duration", entry.getError(), entry.getHost() + ":" + entry.getPort(), entry.getDuration());
                    RLog.e(NativeClient.TAG, "connectionCollection onComplete" + entry.getHost() + " " + entry.getPort() + " " + entry.getError() + " " + entry.getDuration());
                    NavigationCacheHelper.updateComplexConnectionEntry(NativeClient.this.mContext, entry);
                }
            });
        }
        FwLog.write(4, 16, "P-connect-T", "strategy|cached|use", useComplexConnection ? "parallel" : "serial", NativeClient.connectionEntryArrayToString(this.mConnectHandler.mConnectionEntries), NativeClient.connectionEntryArrayToString(connectionEntries));
        boolean enable = this.enableReconnectKick && isReconnect;
        int groupMessageLimit = 0;
        if (grOpened) {
            groupMessageLimit = NavigationClient.getInstance().getGroupMessageLimit(this.mContext);
        }
        NativeObject.UserProfile userProfile = new NativeObject.UserProfile();
        userProfile.setIpv6Preffered(ipv6Preffered);
        userProfile.setPublicService(mpOpened);
        userProfile.setPushSetting(usOpened);
        userProfile.setSdkReconnect(enable);
        userProfile.setGroupMessageLimit(groupMessageLimit);
        this.nativeObj.Connect(token, connectionEntries, userId, new NativeObject.ConnectAckCallback(){

            @Override
            public void operationComplete(int status, String userId, int code, short duration, String logInfo) {
                RLog.d(NativeClient.TAG, "[connect] operationComplete status:" + status + ", logInfo:" + logInfo);
                if (status == 0) {
                    FwLog.write(4, 16, "P-connect-R", "status_code|user_id|native_code|duration|network", status, userId, code, duration, DeviceUtils.getNetworkType(NativeClient.this.mContext));
                    if (callback != null) {
                        callback.onSuccess(userId);
                    }
                    NavigationClient.getInstance().clearObserver();
                    NavigationClient.getInstance().requestCmpIfNeed(NativeClient.this.mContext, NativeClient.this.appKey, token);
                } else {
                    FwLog.write(2, 16, "P-connect-R", "status_code|user_id|native_code|duration|network|bg", status, userId, code, duration, DeviceUtils.getNetworkType(NativeClient.this.mContext), inForeground ? "false" : "true");
                    NavigationClient.getInstance().clearObserver();
                    if (status == 31006 || status == 31004) {
                        NavigationClient.getInstance().clearCache(NativeClient.this.mContext);
                        callback.onTerminal(status);
                    } else if (status == 32061) {
                        NavigationClient.getInstance().clearCacheTime(NativeClient.this.mContext);
                        if (useComplexConnection) {
                            callback.onTerminal(status);
                        } else {
                            callback.onError(status);
                        }
                    } else if (status == 33003 || status == 30001 || status == 30002 || status == 31000 || status == 30014 || status == 30010 || status == 30011) {
                        callback.onError(status);
                    } else if (status == 32054) {
                        if (useComplexConnection) {
                            NavigationCacheHelper.setSuccessedCpmToEnd(NativeClient.this.mContext);
                        }
                        callback.onError(status);
                    } else if (status == 31009) {
                        callback.onTerminal(status);
                    } else {
                        callback.onError(status);
                    }
                }
            }
        }, "2.9.18", userProfile);
    }

    void ping(final Context context) {
        if (this.mWorkHandler != null) {
            this.mWorkHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (NativeClient.this.nativeObj != null) {
                        WakeLockUtils.startNextHeartbeat(context);
                        NativeClient.this.nativeObj.ping();
                    }
                }
            });
        }
    }

    public String getCurrentUserId() {
        if (this.curUserId == null) {
            this.curUserId = NavigationClient.getInstance().getUserId(this.mContext);
            return this.curUserId;
        }
        return this.curUserId;
    }

    public void disconnect() {
        this.disconnect(true);
    }

    public void disconnect(boolean isReceivePush) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        RLog.d(TAG, "[connect] disconnect:" + isReceivePush);
        this.nativeObj.Disconnect(isReceivePush ? 2 : 4);
    }

    public List<Conversation> getConversationList() {
        int[] conversationTypes = new int[]{Conversation.ConversationType.PRIVATE.getValue(), Conversation.ConversationType.DISCUSSION.getValue(), Conversation.ConversationType.GROUP.getValue(), Conversation.ConversationType.SYSTEM.getValue()};
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        return this.getConversationList(conversationTypes);
    }

    public List<Conversation> getGroupConversationList() {
        int[] conversationTypes = new int[]{Conversation.ConversationType.GROUP.getValue()};
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        return this.getConversationList(conversationTypes);
    }

    public List<Conversation> getConversationList(int[] conversationTypeValues) {
        NativeObject.Conversation[] conversations = null;
        try {
            conversations = this.nativeObj.GetConversationListEx(conversationTypeValues);
        }
        catch (Exception e) {
            RLog.e(TAG, "getConversationList Exception", e);
        }
        if (conversations == null) {
            return null;
        }
        ArrayList<Conversation> result = new ArrayList<Conversation>();
        for (NativeObject.Conversation item : conversations) {
            result.add(this.renderConversationFromNative(item));
        }
        return result;
    }

    public List<Conversation> getBlockedConversationList(int[] conversationTypes) {
        NativeObject.Conversation[] conversations = this.nativeObj.GetBlockedConversations(conversationTypes);
        if (conversations == null) {
            return null;
        }
        ArrayList<Conversation> result = new ArrayList<Conversation>();
        for (NativeObject.Conversation item : conversations) {
            result.add(this.renderConversationFromNative(item));
        }
        return result;
    }

    public List<Conversation> getConversationListByPage(int[] conversationTypeValues, long timeStamp, int count) {
        NativeObject.Conversation[] conversations = null;
        try {
            conversations = this.nativeObj.GetConversationList(conversationTypeValues, timeStamp, count);
        }
        catch (Exception e) {
            RLog.e(TAG, "getConversationListByPage Exception", e);
        }
        if (conversations == null) {
            return null;
        }
        ArrayList<Conversation> result = new ArrayList<Conversation>();
        for (NativeObject.Conversation item : conversations) {
            result.add(this.renderConversationFromNative(item));
        }
        return result;
    }

    private Conversation renderConversationFromNative(NativeObject.Conversation conversation) {
        Conversation result = new Conversation();
        result.setTargetId(conversation.getTargetId());
        result.setLatestMessageId(conversation.getMessageId());
        result.setConversationTitle(conversation.getConversationTitle());
        result.setUnreadMessageCount(conversation.getUnreadMessageCount());
        result.setConversationType(Conversation.ConversationType.setValue(conversation.getConversationType()));
        result.setTop(conversation.isTop());
        result.setObjectName(conversation.getObjectName());
        if (conversation.getMessageId() > 0) {
            Message message = new Message();
            message.setMessageId(conversation.getMessageId());
            message.setSenderUserId(conversation.getSenderUserId());
            result.setLatestMessage(this.renderMessageContent(conversation.getObjectName(), conversation.getContent(), message));
        }
        result.setReceivedStatus(new Message.ReceivedStatus(conversation.getReadStatus()));
        result.setReceivedTime(conversation.getReceivedTime());
        result.setSentTime(conversation.getSentTime());
        result.setSenderUserId(conversation.getSenderUserId());
        result.setSentStatus(Message.SentStatus.setValue(conversation.getSentStatus()));
        result.setSenderUserName(conversation.getSenderName());
        result.setDraft(conversation.getDraft());
        result.setPortraitUrl(conversation.getPortraitUrl());
        result.setNotificationStatus(conversation.isBlockPush() ? Conversation.ConversationNotificationStatus.DO_NOT_DISTURB : Conversation.ConversationNotificationStatus.NOTIFY);
        result.setMentionedCount(conversation.getMentionCount());
        return result;
    }

    private Conversation renderConversationFromJson(JSONObject jsonObj) {
        Conversation conversation = new Conversation();
        conversation.setTargetId(jsonObj.optString("target_id"));
        conversation.setLatestMessageId(jsonObj.optInt("last_message_id"));
        conversation.setConversationTitle(jsonObj.optString("conversation_title"));
        conversation.setUnreadMessageCount(jsonObj.optInt("unread_count"));
        conversation.setConversationType(Conversation.ConversationType.setValue(jsonObj.optInt("conversation_category")));
        conversation.setTop(jsonObj.optInt("is_top") == 1);
        conversation.setObjectName(jsonObj.optString("object_name"));
        if (conversation.getLatestMessageId() > 0) {
            Message message = new Message();
            message.setMessageId(conversation.getLatestMessageId());
            message.setSenderUserId(conversation.getSenderUserId());
            MessageContent content = this.renderMessageContent(conversation.getObjectName(), jsonObj.optString("content").getBytes(), message);
            conversation.setLatestMessage(content);
        }
        conversation.setReceivedStatus(new Message.ReceivedStatus(jsonObj.optInt("read_status")));
        conversation.setReceivedTime(jsonObj.optLong("receive_time"));
        conversation.setSentTime(jsonObj.optLong("send_time"));
        conversation.setSentStatus(Message.SentStatus.setValue(jsonObj.optInt("send_status")));
        conversation.setSenderUserId(jsonObj.optString("sender_user_id"));
        conversation.setSenderUserName(jsonObj.optString("sender_user_name"));
        conversation.setDraft(jsonObj.optString("draft_message"));
        conversation.setNotificationStatus(jsonObj.optInt("block_push") == 100 ? Conversation.ConversationNotificationStatus.DO_NOT_DISTURB : Conversation.ConversationNotificationStatus.NOTIFY);
        return conversation;
    }

    public Conversation getConversation(Conversation.ConversationType conversationType, String targetId) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("ConversationType \u548c TargetId \u53c2\u6570\u5f02\u5e38");
        }
        NativeObject.Conversation conversation = this.nativeObj.GetConversationEx(targetId, conversationType.getValue());
        if (conversation == null) {
            return null;
        }
        Conversation c = this.renderConversationFromNative(conversation);
        c.setConversationType(conversationType);
        return c;
    }

    public boolean removeConversation(Conversation.ConversationType conversationType, String targetId) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || TextUtils.isEmpty((CharSequence)targetId.trim())) {
            throw new IllegalArgumentException("ConversationType \u548c TargetId \u53c2\u6570\u5f02\u5e38");
        }
        targetId = targetId.trim();
        return this.nativeObj.RemoveConversation(conversationType.getValue(), targetId);
    }

    public boolean setConversationToTop(Conversation.ConversationType conversationType, String targetId, boolean isTop, boolean needCreate) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("ConversationType \u6216 TargetId \u53c2\u6570\u5f02\u5e38");
        }
        return this.nativeObj.SetIsTop(conversationType.getValue(), targetId, isTop, needCreate);
    }

    private void preCheck(Object ... params) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (params == null) {
            return;
        }
        for (Object param : params) {
            if (param != null && (!(param instanceof String) || !TextUtils.isEmpty((CharSequence)((String)param)))) continue;
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38");
        }
    }

    private String replaceNullStr(String string) {
        return string == null ? "" : string;
    }

    public boolean createEncryptedConversation(String targetId, RCEncryptedSession chatInfo) {
        this.preCheck(targetId, chatInfo);
        return this.nativeObj.CreateEncryptedConversation(this.replaceNullStr(targetId), this.replaceNullStr(chatInfo.getTargetId()), this.replaceNullStr(chatInfo.getRemoteEncId()), this.replaceNullStr(chatInfo.getEncKey()), this.replaceNullStr(chatInfo.getEncXA()), chatInfo.getEncStatus());
    }

    public RCEncryptedSession getEncryptedConversation(String targetId) {
        this.preCheck(targetId);
        RCEncryptedSession chaInfo = this.nativeObj.GetEncryptedConversationInfo(targetId);
        RLog.d(TAG, "getEncryptedConversation --> " + (chaInfo == null ? "null" : chaInfo.toString()));
        return chaInfo;
    }

    public List<RCEncryptedSession> getAllEncryptedConversations() {
        this.preCheck(new Object[0]);
        List<RCEncryptedSession> rcEncryptedSessions = this.nativeObj.GetEncryptedConversations();
        return rcEncryptedSessions;
    }

    public boolean setEncryptedConversation(String targetId, RCEncryptedSession chatInfo) {
        this.preCheck(targetId, chatInfo);
        return this.nativeObj.SetEncryptedConversationInfo(this.replaceNullStr(targetId), this.replaceNullStr(chatInfo.getTargetId()), this.replaceNullStr(chatInfo.getRemoteEncId()), this.replaceNullStr(chatInfo.getEncKey()), this.replaceNullStr(chatInfo.getEncXA()), chatInfo.getEncStatus());
    }

    public boolean removeEncryptedConversation(String targetId) {
        this.preCheck(targetId);
        return this.nativeObj.RemoveEncryptedConversation(this.replaceNullStr(targetId));
    }

    public boolean clearEncryptedConversations() {
        this.preCheck(new Object[0]);
        return this.nativeObj.ClearEncryptedConversations();
    }

    public int getTotalUnreadCount() {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        return this.nativeObj.GetTotalUnreadCount();
    }

    public int getUnreadCount(Conversation.ConversationType conversationType, String targetId) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)targetId) || conversationType == null) {
            throw new IllegalArgumentException("ConversationType \u6216 TargetId \u53c2\u6570\u5f02\u5e38");
        }
        return this.nativeObj.GetUnreadCount(targetId, conversationType.getValue());
    }

    public int getTotalUnreadCount(Conversation ... conversations) {
        NativeObject.Conversation[] nativeConversations = new NativeObject.Conversation[conversations.length];
        for (int i = 0; i < conversations.length; ++i) {
            NativeObject.Conversation conversation = new NativeObject.Conversation();
            conversation.setConversationType(conversations[i].getConversationType().getValue());
            conversation.setTargetId(conversations[i].getTargetId());
            nativeConversations[i] = conversation;
        }
        return this.nativeObj.GetDNDUnreadCount(nativeConversations);
    }

    public int getUnreadCount(Conversation.ConversationType ... conversationTypes) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationTypes == null || conversationTypes.length == 0) {
            throw new IllegalArgumentException("ConversationTypes \u53c2\u6570\u5f02\u5e38\u3002");
        }
        int[] conversationTypeValues = new int[conversationTypes.length];
        int i = 0;
        for (Conversation.ConversationType conversationType : conversationTypes) {
            conversationTypeValues[i] = conversationType.getValue();
            ++i;
        }
        return this.nativeObj.GetCateUnreadCount(conversationTypeValues, true);
    }

    public int getUnreadCount(boolean withDND, Conversation.ConversationType ... conversationTypes) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationTypes == null || conversationTypes.length == 0) {
            throw new IllegalArgumentException("ConversationTypes \u53c2\u6570\u5f02\u5e38\u3002");
        }
        int[] conversationTypeValues = new int[conversationTypes.length];
        int i = 0;
        for (Conversation.ConversationType conversationType : conversationTypes) {
            conversationTypeValues[i] = conversationType.getValue();
            ++i;
        }
        return this.nativeObj.GetCateUnreadCount(conversationTypeValues, withDND);
    }

    public List<Message> getLatestMessages(Conversation.ConversationType conversationType, String targetId, int count) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("ConversationTypes \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        targetId = targetId.trim();
        return this.getHistoryMessages(conversationType, targetId, -1, count);
    }

    public List<Message> getHistoryMessages(Conversation.ConversationType conversationType, String targetId, int oldestMessageId, int count) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("ConversationTypes \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        targetId = targetId.trim();
        NativeObject.Message[] array = this.nativeObj.GetHistoryMessagesEx(targetId, conversationType.getValue(), "", oldestMessageId, count, true);
        ArrayList<Message> list = new ArrayList<Message>();
        if (array == null) {
            return list;
        }
        for (NativeObject.Message item : array) {
            Message msg = new Message(item);
            msg.setContent(this.renderMessageContent(item.getObjectName(), item.getContent(), msg));
            list.add(msg);
        }
        return list;
    }

    public List<Message> getHistoryMessages(Conversation.ConversationType conversationType, String targetId, String objectName, int oldestMessageId, int count) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || TextUtils.isEmpty((CharSequence)objectName)) {
            throw new IllegalArgumentException("ConversationTypes, objectName \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        targetId = targetId.trim();
        NativeObject.Message[] messages = this.nativeObj.GetHistoryMessagesEx(targetId, conversationType.getValue(), objectName, oldestMessageId, count, true);
        ArrayList<Message> list = new ArrayList<Message>();
        if (messages == null) {
            return null;
        }
        for (NativeObject.Message item : messages) {
            Message msg = new Message(item);
            msg.setContent(this.renderMessageContent(item.getObjectName(), item.getContent(), msg));
            list.add(msg);
        }
        return list;
    }

    public List<Message> getHistoryMessages(Conversation.ConversationType conversationType, String targetId, String objectName, int oldestMessageId, int count, boolean direction) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || TextUtils.isEmpty((CharSequence)objectName)) {
            throw new IllegalArgumentException("ConversationTypes, objectName \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        targetId = targetId.trim();
        NativeObject.Message[] messages = this.nativeObj.GetHistoryMessagesEx(targetId, conversationType.getValue(), objectName, oldestMessageId, count, direction);
        ArrayList<Message> list = new ArrayList<Message>();
        if (messages == null) {
            return null;
        }
        for (NativeObject.Message item : messages) {
            Message msg = new Message(item);
            msg.setContent(this.renderMessageContent(item.getObjectName(), item.getContent(), msg));
            list.add(msg);
        }
        return list;
    }

    public List<Message> getHistoryMessages(Conversation.ConversationType conversationType, String targetId, List<String> objectNames, long timestamp, int count, boolean direction) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || objectNames == null || objectNames.size() == 0) {
            throw new IllegalArgumentException("ConversationTypes, objectName \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        targetId = targetId.trim();
        NativeObject.Message[] messages = this.nativeObj.GetHistoryMessagesByObjectNames(targetId, conversationType.getValue(), objectNames.toArray(new String[objectNames.size()]), timestamp, count, direction);
        ArrayList<Message> list = new ArrayList<Message>();
        if (messages == null) {
            return null;
        }
        for (NativeObject.Message item : messages) {
            Message msg = new Message(item);
            msg.setContent(this.renderMessageContent(item.getObjectName(), item.getContent(), msg));
            list.add(msg);
        }
        return list;
    }

    public void getRemoteHistoryMessages(Conversation.ConversationType conversationType, String targetId, long dataTime, int count, final IResultCallback<List<Message>> callback) {
        RLog.i(TAG, "getRemoteHistoryMessages call");
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || callback == null) {
            throw new IllegalArgumentException("ConversationTypes\uff0ccallback \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        targetId = targetId.trim();
        if (NavigationClient.getInstance().isGetRemoteHistoryEnabled(this.mContext)) {
            this.nativeObj.LoadHistoryMessage(targetId, conversationType.getValue(), dataTime, count, new NativeObject.HistoryMessageListener(){

                @Override
                public void onReceived(NativeObject.Message[] messages, long timestamp) {
                    ArrayList<Message> list = new ArrayList<Message>();
                    if (messages != null && messages.length > 0) {
                        for (NativeObject.Message item : messages) {
                            Message msg = new Message(item);
                            msg.setContent(NativeClient.this.renderMessageContent(item.getObjectName(), item.getContent(), msg));
                            list.add(msg);
                        }
                    }
                    callback.onSuccess(list);
                }

                @Override
                public void onError(int status) {
                    callback.onError(status);
                }
            });
        } else {
            callback.onError(33007);
        }
    }

    public void getChatroomHistoryMessages(String targetId, long recordTime, int count, int order, final IResultCallbackEx<List<Message>, Long> callback) {
        RLog.i(TAG, "getChatroomHistoryMessages");
        if (NavigationClient.getInstance().isChatroomHistoryEnabled(this.mContext)) {
            this.nativeObj.GetChatroomHistoryMessage(targetId, recordTime, count, order, new NativeObject.HistoryMessageListener(){

                @Override
                public void onReceived(NativeObject.Message[] messages, long timestamp) {
                    ArrayList<Message> list = new ArrayList<Message>();
                    if (messages != null && messages.length > 0) {
                        for (NativeObject.Message item : messages) {
                            Message msg = new Message(item);
                            msg.setContent(NativeClient.this.renderMessageContent(item.getObjectName(), item.getContent(), msg));
                            list.add(msg);
                        }
                    }
                    callback.onSuccess(list, timestamp);
                }

                @Override
                public void onError(int status) {
                    callback.onError(status);
                }
            });
        } else {
            callback.onError(23414);
        }
    }

    public void getUserStatus(String userId, final IResultCallbackEx<String, Integer> resultCallbackEx) {
        this.nativeObj.GetUserStatus(userId, new NativeObject.PushSettingListener(){

            @Override
            public void OnSuccess(String platformInfo, int status) {
                resultCallbackEx.onSuccess(platformInfo, status);
            }

            @Override
            public void OnError(int errorCode) {
                resultCallbackEx.onError(errorCode);
            }
        });
    }

    public void subscribeStatus(List<String> users, final IResultCallbackEx<Integer, Integer> resultCallbackEx) {
        this.nativeObj.SubscribeStatus(users.toArray(new String[users.size()]), new NativeObject.BizAckListener(){

            @Override
            public void operationComplete(int opStatus, int status) {
                if (opStatus == 0) {
                    resultCallbackEx.onSuccess(opStatus, status);
                } else {
                    resultCallbackEx.onError(opStatus);
                }
            }
        });
    }

    public void setSubscribeStatusListener(final IResultCallbackEx<String, String> resultCallback) {
        this.nativeObj.SetSubscribeStatusListener(new NativeObject.UserStatusListener(){

            @Override
            public void onStatusReceived(String objName, String content) {
                resultCallback.onSuccess(objName, content);
            }
        });
    }

    public void setPushSetting(int key, String value, final IResultCallback<Long> resultCallback) {
        this.nativeObj.SetPushSetting(key, value, new NativeObject.SetPushSettingListener(){

            @Override
            public void onSuccess(long version) {
                resultCallback.onSuccess(version);
            }

            @Override
            public void onError(int code) {
                resultCallback.onError(code);
            }
        });
    }

    public String getPushSetting(int key) {
        return this.nativeObj.GetPushSetting(key);
    }

    public void setUserStatus(int status, final IResultCallback<Integer> resultCallback) {
        this.nativeObj.SetUserStatus(status, new NativeObject.TokenListener(){

            @Override
            public void OnError(int errorCode, String token) {
                if (errorCode == 0) {
                    resultCallback.onSuccess(0);
                } else {
                    resultCallback.onError(errorCode);
                }
            }
        });
    }

    public boolean deleteMessages(int[] messageIds) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (messageIds == null || messageIds.length == 0) {
            throw new IllegalArgumentException("MessageIds \u53c2\u6570\u5f02\u5e38\u3002");
        }
        return this.nativeObj.DeleteMessages(messageIds);
    }

    public boolean deleteMessage(Conversation.ConversationType conversationType, String targetId) {
        return this.nativeObj.ClearMessages(conversationType.getValue(), targetId, true);
    }

    public void deleteMessages(Conversation.ConversationType conversationType, String targetId, Message[] messages, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (messages == null || messages.length == 0) {
            throw new IllegalArgumentException("messages \u53c2\u6570\u5f02\u5e38\u3002");
        }
        NativeObject.Message[] nativeMessages = new NativeObject.Message[messages.length];
        StringBuilder uIds = new StringBuilder();
        for (int i = 0; i < messages.length; ++i) {
            nativeMessages[i] = new NativeObject.Message();
            nativeMessages[i].setUId(messages[i].getUId());
            nativeMessages[i].setSentTime(messages[i].getSentTime());
            nativeMessages[i].setMessageDirection(messages[i].getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE));
            uIds.append(messages[i].getUId()).append("/");
        }
        FwLog.write(5, 128, "L-delete_messages-S", "messageUIds:", uIds.toString());
        this.nativeObj.DeleteRemoteMessages(conversationType.getValue(), targetId, nativeMessages, true, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long sendTime) {
                if (callback == null) {
                    return;
                }
                if (code == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(code);
                }
            }
        });
    }

    public boolean clearMessages(Conversation.ConversationType conversationType, String targetId) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("conversationType \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        return this.nativeObj.ClearMessages(conversationType.getValue(), targetId, false);
    }

    public void cleanRemoteHistoryMessages(Conversation.ConversationType conversationType, String targetId, long recordTime, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("conversationType \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.CleanRemoteHistoryMessage(conversationType.getValue(), targetId, recordTime, new NativeObject.BizAckListener(){

            @Override
            public void operationComplete(int opStatus, int status) {
                if (callback == null) {
                    return;
                }
                if (opStatus == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(opStatus);
                }
            }
        });
    }

    public void cleanHistoryMessages(Conversation.ConversationType conversationType, String targetId, long recordTime, OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("conversationType \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        boolean result = this.nativeObj.CleanHistoryMessages(conversationType.getValue(), targetId, recordTime);
        if (callback != null) {
            if (result) {
                callback.onSuccess();
            } else {
                callback.onError(-1);
            }
        }
    }

    public boolean clearMessagesUnreadStatus(Conversation.ConversationType conversationType, String targetId) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("conversationType \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        return this.nativeObj.ClearUnread(conversationType.getValue(), targetId);
    }

    public boolean setMessageExtra(int messageId, String value) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (messageId == 0) {
            throw new IllegalArgumentException("messageId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        return this.nativeObj.SetMessageExtra(messageId, value);
    }

    public boolean setMessageReceivedStatus(int messageId, Message.ReceivedStatus receivedStatus) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (receivedStatus == null || messageId == 0) {
            throw new IllegalArgumentException("receivedStatus \u6216 messageId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        return this.nativeObj.SetReadStatus(messageId, receivedStatus.getFlag());
    }

    public boolean setMessageSentStatus(int messageId, Message.SentStatus sentStatus) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (sentStatus == null || messageId == 0) {
            throw new IllegalArgumentException("sentStatus \u6216 messageId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        return this.nativeObj.SetSendStatus(messageId, sentStatus.getValue());
    }

    public String getTextMessageDraft(Conversation.ConversationType conversationType, String targetId) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("conversationType \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        return this.nativeObj.GetTextMessageDraft(conversationType.getValue(), targetId);
    }

    public boolean saveTextMessageDraft(Conversation.ConversationType conversationType, String targetId, String content) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("conversationType \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        return this.nativeObj.SetTextMessageDraft(conversationType.getValue(), targetId, content);
    }

    public boolean clearTextMessageDraft(Conversation.ConversationType conversationType, String targetId) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("conversationType \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        String draft = this.getTextMessageDraft(conversationType, targetId);
        if (!TextUtils.isEmpty((CharSequence)draft)) {
            return this.saveTextMessageDraft(conversationType, targetId, "");
        }
        return true;
    }

    public void getDiscussion(String discussionId, final IResultCallback<Discussion> callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)discussionId)) {
            throw new IllegalArgumentException(" discussionId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        NativeObject.DiscussionInfo discussionInfo = this.nativeObj.GetDiscussionInfoSync(discussionId);
        if (discussionInfo != null) {
            Discussion discussion = new Discussion(discussionInfo);
            if (discussion.getMemberIdList() == null || discussion.getMemberIdList().size() == 0) {
                this.nativeObj.GetDiscussionInfo(discussionId, new NativeObject.DiscussionInfoListener(){

                    @Override
                    public void onReceived(NativeObject.DiscussionInfo info) {
                        if (callback != null) {
                            callback.onSuccess(new Discussion(info));
                        }
                    }

                    @Override
                    public void OnError(int status) {
                        if (callback != null) {
                            callback.onError(status);
                        }
                    }
                });
            } else if (callback != null) {
                callback.onSuccess(discussion);
            }
        } else {
            this.nativeObj.GetDiscussionInfo(discussionId, new NativeObject.DiscussionInfoListener(){

                @Override
                public void onReceived(NativeObject.DiscussionInfo info) {
                    if (callback != null) {
                        callback.onSuccess(new Discussion(info));
                    }
                }

                @Override
                public void OnError(int status) {
                    if (callback != null) {
                        callback.onError(status);
                    }
                }
            });
        }
    }

    public void setDiscussionName(String discussionId, String name, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)discussionId) || TextUtils.isEmpty((CharSequence)discussionId.trim()) || TextUtils.isEmpty((CharSequence)name) || TextUtils.isEmpty((CharSequence)name.trim())) {
            throw new IllegalArgumentException(" discussionId \u6216 name \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.RenameDiscussion(discussionId, name, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long timestamp) {
                if (callback == null) {
                    return;
                }
                if (code == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(code);
                }
            }
        });
    }

    public void createDiscussion(String name, List<String> userIdList, final IResultCallback<String> callback) {
        if (!TextUtils.isEmpty((CharSequence)this.curUserId) && userIdList.contains(this.curUserId)) {
            userIdList.remove(this.curUserId);
        }
        String[] ids = new String[userIdList.size()];
        userIdList.toArray(ids);
        this.nativeObj.CreateInviteDiscussion(name, ids, new NativeObject.CreateDiscussionCallback(){

            @Override
            public void OnError(int errorCode) {
                if (callback != null) {
                    callback.onError(errorCode);
                }
            }

            @Override
            public void OnSuccess(String discussionId) {
                if (callback != null) {
                    callback.onSuccess(discussionId);
                }
            }
        });
    }

    public void searchPublicService(String keyWords, int businessType, int searchType, final IResultCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (keyWords == null) {
            throw new IllegalArgumentException("keyWords \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.SearchAccount(keyWords, businessType, searchType, new NativeObject.AccountInfoListener(){

            @Override
            public void onReceived(NativeObject.AccountInfo[] info) {
                ArrayList<PublicServiceProfile> list = new ArrayList<PublicServiceProfile>();
                for (int index = 0; index < info.length; ++index) {
                    PublicServiceProfile item = new PublicServiceProfile();
                    item.setTargetId(new String(info[index].getAccountId()));
                    item.setName(new String(info[index].getAccountName()));
                    item.setPublicServiceType(Conversation.ConversationType.setValue(info[index].getAccountType()));
                    item.setPortraitUri(Uri.parse((String)new String(info[index].getAccountUri())));
                    String ss = new String(info[index].getExtra());
                    RLog.i(NativeClient.TAG, "getPublicAccountInfoList extra:" + ss);
                    item.setExtra(ss);
                    list.add(item);
                }
                PublicServiceProfileList infoList = new PublicServiceProfileList(list);
                callback.onSuccess(infoList);
            }

            @Override
            public void OnError(int status) {
                callback.onError(status);
            }
        });
    }

    public void subscribePublicService(String targetId, int categoryId, boolean subscribe, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        this.nativeObj.SubscribeAccount(targetId, categoryId, subscribe, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long timestamp) {
                if (callback == null) {
                    return;
                }
                if (code == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(code);
                }
            }
        });
    }

    public void getPublicServiceProfile(String targetId, int categoryId, IResultCallback<PublicServiceProfile> callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (targetId == null) {
            throw new IllegalArgumentException("targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        if (callback != null) {
            PublicServiceProfile serviceInfo = new PublicServiceProfile();
            NativeObject.UserInfo info = this.nativeObj.GetUserInfoExSync(targetId, categoryId);
            if (info != null) {
                serviceInfo.setTargetId(targetId);
                serviceInfo.setName(info.getUserName());
                if (info.getUrl() != null) {
                    serviceInfo.setPortraitUri(Uri.parse((String)info.getUrl()));
                }
                serviceInfo.setPublicServiceType(Conversation.ConversationType.setValue(info.getCategoryId()));
                serviceInfo.setExtra(info.getAccountExtra());
                callback.onSuccess(serviceInfo);
            } else {
                RLog.e(TAG, "Public service info is null");
                callback.onSuccess(null);
            }
        }
    }

    public void getPublicServiceList(IResultCallback<PublicServiceProfileList> callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (callback != null) {
            NativeObject.AccountInfo[] info = this.nativeObj.LoadAccountInfo();
            if (info != null && info.length > 0) {
                ArrayList<PublicServiceProfile> list = new ArrayList<PublicServiceProfile>();
                for (int index = 0; index < info.length; ++index) {
                    PublicServiceProfile item = new PublicServiceProfile();
                    item.setTargetId(new String(info[index].getAccountId()));
                    item.setName(new String(info[index].getAccountName()));
                    item.setPublicServiceType(Conversation.ConversationType.setValue(info[index].getAccountType()));
                    item.setPortraitUri(Uri.parse((String)new String(info[index].getAccountUri())));
                    String ss = new String(info[index].getExtra());
                    item.setExtra(ss);
                    list.add(item);
                }
                PublicServiceProfileList infoList = new PublicServiceProfileList(list);
                callback.onSuccess(infoList);
            } else {
                RLog.e(TAG, "Public service list is empty");
                ArrayList<PublicServiceProfile> list = new ArrayList<PublicServiceProfile>();
                PublicServiceProfileList infoList = new PublicServiceProfileList(list);
                callback.onSuccess(infoList);
            }
        }
    }

    public void addMemberToDiscussion(String discussionId, List<String> userIdList, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)discussionId) || userIdList == null || userIdList.size() == 0) {
            throw new IllegalArgumentException("discussionId \u6216 userIdList \u53c2\u6570\u5f02\u5e38\u3002");
        }
        String[] ids = new String[userIdList.size()];
        userIdList.toArray(ids);
        this.nativeObj.InviteMemberToDiscussion(discussionId, ids, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long timestamp) {
                if (callback == null) {
                    return;
                }
                if (code == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(code);
                }
            }
        });
    }

    public void removeMemberFromDiscussion(String discussionId, String userId, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)discussionId) || TextUtils.isEmpty((CharSequence)userId)) {
            throw new IllegalArgumentException("discussionId \u6216 userId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.RemoveMemberFromDiscussion(discussionId, userId, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long timestamp) {
                if (callback == null) {
                    return;
                }
                if (code == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(code);
                }
            }
        });
    }

    public void quitDiscussion(String discussionId, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)discussionId)) {
            throw new IllegalArgumentException("discussionId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.QuitDiscussion(discussionId, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long timestamp) {
                if (callback == null) {
                    return;
                }
                if (code == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(code);
                }
            }
        });
    }

    public Message getMessage(int messageId) {
        NativeObject.Message nativeMsg = this.nativeObj.GetMessageById(messageId);
        if (nativeMsg == null) {
            return null;
        }
        Message message = new Message(nativeMsg);
        MessageContent content = this.renderMessageContent(nativeMsg.getObjectName(), nativeMsg.getContent(), message);
        message.setContent(content);
        return message;
    }

    private String getSearchableWord(MessageContent content) {
        List<String> list;
        String filteredStr = "";
        if (content != null && (list = content.getSearchableWord()) != null && list.size() > 0) {
            StringBuilder builder = new StringBuilder();
            for (String str : list) {
                builder.append(str).append("\n");
            }
            filteredStr = builder.toString();
        }
        return filteredStr;
    }

    public void sendMessage(Conversation.ConversationType conversationType, String targetId, MessageContent content, String pushContent, String pushData, ISendMessageCallback<Message> callback) {
        Message message = Message.obtain(targetId, conversationType, content);
        this.sendMessage(message, pushContent, pushData, null, callback);
    }

    public void sendMessage(Message message, String pushContent, String pushData, String[] userIds, ISendMessageCallback<Message> callback) {
        boolean isMentioned;
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (message.getConversationType() == null || TextUtils.isEmpty((CharSequence)message.getTargetId()) || message.getContent() == null) {
            throw new IllegalArgumentException("message, ConversationType \u6216 TargetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        MessageTag msgTag = message.getContent().getClass().getAnnotation(MessageTag.class);
        if (TextUtils.isEmpty((CharSequence)message.getSenderUserId())) {
            message.setSenderUserId(this.curUserId);
        }
        message.setMessageDirection(Message.MessageDirection.SEND);
        message.setSentStatus(Message.SentStatus.SENDING);
        message.setSentTime(System.currentTimeMillis());
        message.setObjectName(msgTag.value());
        byte[] data = new byte[1];
        if ((msgTag.flag() & 1) == 1 && message.getMessageId() <= 0) {
            int id = this.nativeObj.SaveMessage(message.getTargetId(), message.getConversationType().getValue(), msgTag.value(), message.getSenderUserId(), data, false, 0, Message.SentStatus.SENDING.getValue(), System.currentTimeMillis(), this.getSearchableWord(message.getContent()), 1, "");
            if (id < 0) {
                message.setSentStatus(Message.SentStatus.FAILED);
                if (id == RongIMClient.ErrorCode.PARAMETER_ERROR.getValue()) {
                    callback.onError(message, RongIMClient.ErrorCode.PARAMETER_ERROR.getValue());
                } else {
                    callback.onError(message, RongIMClient.ErrorCode.BIZ_ERROR_DATABASE_ERROR.getValue());
                }
                return;
            }
            message.setMessageId(id);
        }
        int type = msgTag.flag() == 16 ? 1 : 3;
        MessageHandler handler = this.getMessageHandler(msgTag.value());
        if (handler == null) {
            RLog.e(TAG, "sendMessage MessageHandler is null");
            if (callback != null) {
                callback.onError(message, RongIMClient.ErrorCode.PARAMETER_ERROR.getValue());
            }
            return;
        }
        handler.encodeMessage(message);
        data = message.getContent().encode();
        if (callback != null) {
            callback.onAttached(message);
        }
        boolean bl = isMentioned = message.getContent().getMentionedInfo() != null;
        if (message.getMessageId() > 0) {
            this.nativeObj.SetMessageContent(message.getMessageId(), data, "");
        }
        this.sendMessageIfNeedEncrypt(message, pushContent, pushData, userIds, callback, msgTag, data, type, isMentioned);
    }

    public void sendMessageOption(Message message, String pushContent, String pushData, SendMessageOption option, String[] userIds, ISendMessageCallback<Message> callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (message.getConversationType() == null || TextUtils.isEmpty((CharSequence)message.getTargetId()) || message.getContent() == null) {
            throw new IllegalArgumentException("message, ConversationType \u6216 TargetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        MessageTag msgTag = message.getContent().getClass().getAnnotation(MessageTag.class);
        if (TextUtils.isEmpty((CharSequence)message.getSenderUserId())) {
            message.setSenderUserId(this.curUserId);
        }
        message.setMessageDirection(Message.MessageDirection.SEND);
        message.setSentStatus(Message.SentStatus.SENDING);
        message.setSentTime(System.currentTimeMillis());
        message.setObjectName(msgTag.value());
        byte[] data = new byte[1];
        if ((msgTag.flag() & 1) == 1 && message.getMessageId() <= 0) {
            int id = this.nativeObj.SaveMessage(message.getTargetId(), message.getConversationType().getValue(), msgTag.value(), message.getSenderUserId(), data, false, 0, Message.SentStatus.SENDING.getValue(), System.currentTimeMillis(), this.getSearchableWord(message.getContent()), 1, "");
            if (id < 0) {
                message.setSentStatus(Message.SentStatus.FAILED);
                if (id == RongIMClient.ErrorCode.PARAMETER_ERROR.getValue()) {
                    callback.onError(message, RongIMClient.ErrorCode.PARAMETER_ERROR.getValue());
                } else {
                    callback.onError(message, RongIMClient.ErrorCode.BIZ_ERROR_DATABASE_ERROR.getValue());
                }
                return;
            }
            message.setMessageId(id);
        }
        int type = msgTag.flag() == 16 ? 1 : 3;
        MessageHandler handler = this.getMessageHandler(msgTag.value());
        if (handler == null) {
            RLog.e(TAG, "sendMessage MessageHandler is null");
            if (callback != null) {
                callback.onError(message, RongIMClient.ErrorCode.PARAMETER_ERROR.getValue());
            }
            return;
        }
        handler.encodeMessage(message);
        data = message.getContent().encode();
        if (callback != null) {
            callback.onAttached(message);
        }
        boolean isMentioned = message.getContent().getMentionedInfo() != null;
        boolean isVoIPPush = option.isVoIPPush();
        if (message.getMessageId() > 0) {
            this.nativeObj.SetMessageContent(message.getMessageId(), data, "");
        }
        this.sendMessageIfNeedEncrypt(message, pushContent, pushData, userIds, callback, msgTag, data, type, isMentioned, isVoIPPush);
    }

    private void sendMessageIfNeedEncrypt(final Message message, String pushContent, String pushData, String[] userIds, final ISendMessageCallback<Message> callback, final MessageTag msgTag, byte[] data, int type, boolean isMentioned) {
        Message encMsg;
        try {
            encMsg = this.encryptMessageContentIfNeeded(data, message);
        }
        catch (RuntimeException e) {
            RLog.e(TAG, "stop sending message cause exception occurs while calling encrypteMessageContent() -> " + e.getLocalizedMessage());
            return;
        }
        if (encMsg == null) {
            this.nativeObj.SendMessage(message.getTargetId(), message.getConversationType().getValue(), type, msgTag.value(), data, TextUtils.isEmpty((CharSequence)pushContent) ? null : pushContent.getBytes(), TextUtils.isEmpty((CharSequence)pushData) ? null : pushData.getBytes(), message.getMessageId(), userIds, new NativeObject.PublishAckListener(){

                @Override
                public void operationComplete(int code, String msgUId, long sendTime) {
                    RLog.d(NativeClient.TAG, "sendMessage code = " + code + ", id = " + message.getMessageId() + ", uid = " + msgUId + " " + message.getObjectName());
                    if (code == 0) {
                        message.setSentStatus(Message.SentStatus.SENT);
                        message.setSentTime(sendTime);
                        message.setUId(msgUId);
                        if (callback != null) {
                            callback.onSuccess(message);
                        }
                    } else {
                        FwLog.write(2, 128, "P-send_msg-S", "code|type|id|tag", code, message.getConversationType().getValue(), message.getTargetId(), msgTag.value());
                        if (code == RongIMClient.ErrorCode.RC_MSG_BLOCKED_SENSITIVE_WORD.getValue()) {
                            NativeClient.this.nativeObj.SetSendStatus(message.getMessageId(), Message.SentStatus.FAILED.getValue());
                            message.setSentStatus(Message.SentStatus.FAILED);
                        } else if (code == RongIMClient.ErrorCode.RC_MSG_REPLACED_SENSITIVE_WORD.getValue()) {
                            message.setSentStatus(Message.SentStatus.SENT);
                            message.setSentTime(sendTime);
                            message.setUId(msgUId);
                        } else {
                            message.setSentStatus(Message.SentStatus.FAILED);
                        }
                        if (callback != null) {
                            callback.onError(message, code);
                        }
                    }
                }
            }, isMentioned);
        } else {
            this.nativeObj.SendMessage(encMsg.getTargetId(), encMsg.getConversationType().getValue(), type, encMsg.getObjectName(), encMsg.getContent().encode(), TextUtils.isEmpty((CharSequence)pushContent) ? null : pushContent.getBytes(), TextUtils.isEmpty((CharSequence)pushData) ? null : pushData.getBytes(), encMsg.getMessageId(), userIds, new NativeObject.PublishAckListener(){

                @Override
                public void operationComplete(int code, String msgUId, long sendTime) {
                    RLog.d(NativeClient.TAG, "sendMessage code = " + code + ", id = " + message.getMessageId() + ", uid = " + msgUId + " " + message.getObjectName());
                    if (code == 0) {
                        message.setSentStatus(Message.SentStatus.SENT);
                        message.setSentTime(sendTime);
                        message.setUId(msgUId);
                        if (callback != null) {
                            callback.onSuccess(message);
                        }
                    } else {
                        FwLog.write(2, 128, "P-send_msg-S", "code|type|id|tag", code, message.getConversationType().getValue(), message.getTargetId(), msgTag.value());
                        if (code == RongIMClient.ErrorCode.RC_MSG_BLOCKED_SENSITIVE_WORD.getValue()) {
                            NativeClient.this.nativeObj.SetSendStatus(message.getMessageId(), Message.SentStatus.FAILED.getValue());
                            message.setSentStatus(Message.SentStatus.FAILED);
                        } else if (code == RongIMClient.ErrorCode.RC_MSG_REPLACED_SENSITIVE_WORD.getValue()) {
                            message.setSentStatus(Message.SentStatus.SENT);
                            message.setSentTime(sendTime);
                            message.setUId(msgUId);
                        } else {
                            message.setSentStatus(Message.SentStatus.FAILED);
                        }
                        if (callback != null) {
                            callback.onError(message, code);
                        }
                    }
                }
            }, isMentioned);
        }
    }

    private void sendMessageIfNeedEncrypt(final Message message, String pushContent, String pushData, String[] userIds, final ISendMessageCallback<Message> callback, final MessageTag msgTag, byte[] data, int type, boolean isMentioned, boolean isVoIPPush) {
        Message encMsg;
        try {
            encMsg = this.encryptMessageContentIfNeeded(data, message);
        }
        catch (RuntimeException e) {
            RLog.e(TAG, "stop sending message cause exception occurs while calling encrypteMessageContent() -> " + e.getLocalizedMessage());
            return;
        }
        if (encMsg == null) {
            this.nativeObj.sendMessageWithOption(message.getTargetId(), message.getConversationType().getValue(), type, msgTag.value(), data, TextUtils.isEmpty((CharSequence)pushContent) ? null : pushContent.getBytes(), TextUtils.isEmpty((CharSequence)pushData) ? null : pushData.getBytes(), message.getMessageId(), userIds, new NativeObject.PublishAckListener(){

                @Override
                public void operationComplete(int code, String msgUId, long sendTime) {
                    RLog.d(NativeClient.TAG, "sendMessage code = " + code + ", id = " + message.getMessageId() + ", uid = " + msgUId + " " + message.getObjectName());
                    if (code == 0) {
                        message.setSentStatus(Message.SentStatus.SENT);
                        message.setSentTime(sendTime);
                        message.setUId(msgUId);
                        if (callback != null) {
                            callback.onSuccess(message);
                        }
                    } else {
                        FwLog.write(2, 128, "P-send_msg-S", "code|type|id|tag", code, message.getConversationType().getValue(), message.getTargetId(), msgTag.value());
                        if (code == RongIMClient.ErrorCode.RC_MSG_BLOCKED_SENSITIVE_WORD.getValue()) {
                            NativeClient.this.nativeObj.SetSendStatus(message.getMessageId(), Message.SentStatus.FAILED.getValue());
                            message.setSentStatus(Message.SentStatus.FAILED);
                        } else if (code == RongIMClient.ErrorCode.RC_MSG_REPLACED_SENSITIVE_WORD.getValue()) {
                            message.setSentStatus(Message.SentStatus.SENT);
                            message.setSentTime(sendTime);
                            message.setUId(msgUId);
                        } else {
                            message.setSentStatus(Message.SentStatus.FAILED);
                        }
                        if (callback != null) {
                            callback.onError(message, code);
                        }
                    }
                }
            }, isMentioned, isVoIPPush);
        } else {
            this.nativeObj.sendMessageWithOption(encMsg.getTargetId(), encMsg.getConversationType().getValue(), type, encMsg.getObjectName(), encMsg.getContent().encode(), TextUtils.isEmpty((CharSequence)pushContent) ? null : pushContent.getBytes(), TextUtils.isEmpty((CharSequence)pushData) ? null : pushData.getBytes(), encMsg.getMessageId(), userIds, new NativeObject.PublishAckListener(){

                @Override
                public void operationComplete(int code, String msgUId, long sendTime) {
                    RLog.d(NativeClient.TAG, "sendMessage code = " + code + ", id = " + message.getMessageId() + ", uid = " + msgUId + " " + message.getObjectName());
                    if (code == 0) {
                        message.setSentStatus(Message.SentStatus.SENT);
                        message.setSentTime(sendTime);
                        message.setUId(msgUId);
                        if (callback != null) {
                            callback.onSuccess(message);
                        }
                    } else {
                        FwLog.write(2, 128, "P-send_msg-S", "code|type|id|tag", code, message.getConversationType().getValue(), message.getTargetId(), msgTag.value());
                        if (code == RongIMClient.ErrorCode.RC_MSG_BLOCKED_SENSITIVE_WORD.getValue()) {
                            NativeClient.this.nativeObj.SetSendStatus(message.getMessageId(), Message.SentStatus.FAILED.getValue());
                            message.setSentStatus(Message.SentStatus.FAILED);
                        } else if (code == RongIMClient.ErrorCode.RC_MSG_REPLACED_SENSITIVE_WORD.getValue()) {
                            message.setSentStatus(Message.SentStatus.SENT);
                            message.setSentTime(sendTime);
                            message.setUId(msgUId);
                        } else {
                            message.setSentStatus(Message.SentStatus.FAILED);
                        }
                        if (callback != null) {
                            callback.onError(message, code);
                        }
                    }
                }
            }, isMentioned, isVoIPPush);
        }
    }

    private Message encryptMessageContentIfNeeded(byte[] content, Message message) throws RuntimeException {
        Message encMsg = null;
        if (message.getConversationType() == Conversation.ConversationType.ENCRYPTED) {
            String targetId = message.getTargetId();
            if (targetId == null || targetId.length() == 0) {
                throw new RuntimeException("error! message TargetId is empty. message -> " + message.toString());
            }
            String[] ids = targetId.split(";;;");
            if (ids.length != 2) {
                throw new RuntimeException("error occurs while spliting targetId -> " + targetId);
            }
            RCEncryptedSession encryptedSession = this.nativeObj.GetEncryptedConversationInfo(targetId);
            if (encryptedSession == null) {
                throw new RuntimeException("error ! getEncryptedConversationInfo is null.");
            }
            String encKeyStr = encryptedSession.getEncKey();
            RCDHCodecTool.RCSecretKey encKey = RCDHCodecTool.fromString2RCSecretKey(encKeyStr);
            if (encKey == null) {
                throw new RuntimeException("error occurs when transfering encKey.");
            }
            byte[] encryptedData = RCDHCodecTool.encrypt(content, encKey);
            String encryptedContent = Base64.encodeToString((byte[])encryptedData, (int)2);
            RCEncryptedMessage encContent = new RCEncryptedMessage();
            encContent.setEncryptedContent(encryptedContent);
            encContent.setOriginalObjName(message.getObjectName());
            encContent.setRemoteEncId(encryptedSession.getRemoteEncId());
            encMsg = Message.obtain(ids[1], message.getConversationType(), encContent);
            encMsg.setObjectName(encContent.getClass().getAnnotation(MessageTag.class).value());
            encMsg.setExtra(message.getExtra());
            encMsg.setMessageDirection(message.getMessageDirection());
            encMsg.setMessageId(message.getMessageId());
            encMsg.setUId(message.getUId());
            encMsg.setReadReceiptInfo(message.getReadReceiptInfo());
            encMsg.setReadTime(message.getReadTime());
            encMsg.setSenderUserId(message.getSenderUserId());
            encMsg.setSentStatus(message.getSentStatus());
            encMsg.setReceivedStatus(message.getReceivedStatus());
            encMsg.setSentTime(message.getSentTime());
            encMsg.setReceivedTime(message.getReceivedTime());
        }
        return encMsg;
    }

    public void sendLocationMessage(Message message, final String pushContent, final String pushData, final ISendMessageCallback<Message> callback) {
        final MessageTag msgTag = message.getContent().getClass().getAnnotation(MessageTag.class);
        if (TextUtils.isEmpty((CharSequence)message.getSenderUserId())) {
            message.setSenderUserId(this.curUserId);
        }
        message.setMessageDirection(Message.MessageDirection.SEND);
        message.setSentTime(System.currentTimeMillis());
        message.setObjectName(msgTag.value());
        byte[] data = message.getContent().encode();
        int id = this.nativeObj.SaveMessage(message.getTargetId(), message.getConversationType().getValue(), msgTag.value(), message.getSenderUserId(), data, false, 0, Message.SentStatus.SENDING.getValue(), System.currentTimeMillis(), this.getSearchableWord(message.getContent()), 1, "");
        if (id < 0 && callback != null) {
            message.setSentStatus(Message.SentStatus.FAILED);
            if (id == RongIMClient.ErrorCode.PARAMETER_ERROR.getValue()) {
                callback.onError(message, RongIMClient.ErrorCode.PARAMETER_ERROR.getValue());
            } else {
                callback.onError(message, RongIMClient.ErrorCode.BIZ_ERROR_DATABASE_ERROR.getValue());
            }
            return;
        }
        message.setMessageId(id);
        if (callback != null) {
            message.setSentStatus(Message.SentStatus.SENDING);
            callback.onAttached(message);
        }
        if (message.getMessageId() == 0) {
            RLog.e(TAG, "Location Message saved error");
            if (callback != null) {
                message.setSentStatus(Message.SentStatus.FAILED);
                this.nativeObj.SetSendStatus(message.getMessageId(), Message.SentStatus.FAILED.getValue());
                callback.onError(message, RongIMClient.ErrorCode.PARAMETER_ERROR.getValue());
            }
            return;
        }
        MessageHandler handler = this.getMessageHandler(msgTag.value());
        if (handler == null) {
            RLog.e(TAG, "MessageHandler is null");
            if (callback != null) {
                message.setSentStatus(Message.SentStatus.FAILED);
                this.nativeObj.SetSendStatus(message.getMessageId(), Message.SentStatus.FAILED.getValue());
                callback.onError(message, RongIMClient.ErrorCode.PARAMETER_ERROR.getValue());
            }
            return;
        }
        handler.setHandleMessageListener(new IHandleMessageListener(){

            @Override
            public void onHandleResult(Message message, int resultCode) {
                RLog.d(NativeClient.TAG, "onHandleResult " + ((LocationMessage)message.getContent()).getImgUri());
                if (resultCode == 0) {
                    boolean isMentioned = NativeClient.this.isMentionedMessage(message);
                    byte[] data = message.getContent().encode();
                    NativeClient.this.nativeObj.SetMessageContent(message.getMessageId(), data, "");
                    NativeClient.this.sendMessageIfNeedEncrypt(message, pushContent, pushData, null, callback, msgTag, data, 3, isMentioned);
                } else {
                    message.setSentStatus(Message.SentStatus.FAILED);
                    NativeClient.this.nativeObj.SetSendStatus(message.getMessageId(), Message.SentStatus.FAILED.getValue());
                    if (callback != null) {
                        callback.onError(message, 30014);
                    }
                }
            }
        });
        handler.encodeMessage(message);
    }

    public void sendMediaMessage(final Message message, String[] userIds, final String pushContent, final String pushData, final ISendMediaMessageCallback<Message> mediaMessageCallback) {
        final String[] receiverIds = userIds;
        final MessageTag msgTag = message.getContent().getClass().getAnnotation(MessageTag.class);
        if (TextUtils.isEmpty((CharSequence)message.getSenderUserId())) {
            message.setSenderUserId(this.curUserId);
        }
        message.setSentTime(System.currentTimeMillis());
        message.setObjectName(msgTag.value());
        byte[] data = new byte[1];
        final boolean isMentioned = message.getContent().getMentionedInfo() != null;
        final MediaMessageContent mediaMessageContent = (MediaMessageContent)message.getContent();
        final MessageHandler handler = this.getMessageHandler(msgTag.value());
        if (handler == null) {
            RLog.e(TAG, "sendMediaMessage MessageHandler is null");
            if (mediaMessageCallback != null) {
                mediaMessageCallback.onError(message, RongIMClient.ErrorCode.PARAMETER_ERROR.getValue());
            }
            return;
        }
        if (message.getMessageId() <= 0) {
            int id = this.nativeObj.SaveMessage(message.getTargetId(), message.getConversationType().getValue(), msgTag.value(), message.getSenderUserId(), data, false, 0, Message.SentStatus.SENDING.getValue(), System.currentTimeMillis(), this.getSearchableWord(message.getContent()), 1, "");
            if (id < 0 && mediaMessageCallback != null) {
                message.setSentStatus(Message.SentStatus.FAILED);
                if (id == RongIMClient.ErrorCode.PARAMETER_ERROR.getValue()) {
                    mediaMessageCallback.onError(message, RongIMClient.ErrorCode.PARAMETER_ERROR.getValue());
                } else {
                    mediaMessageCallback.onError(message, RongIMClient.ErrorCode.BIZ_ERROR_DATABASE_ERROR.getValue());
                }
                return;
            }
            message.setMessageId(id);
        }
        message.setSentStatus(Message.SentStatus.SENDING);
        message.setMessageDirection(Message.MessageDirection.SEND);
        handler.encodeMessage(message);
        data = message.getContent().encode();
        this.nativeObj.SetMessageContent(message.getMessageId(), data, "");
        if (mediaMessageCallback != null) {
            mediaMessageCallback.onAttached(message);
        }
        if (mediaMessageContent.getMediaUrl() == null || mediaMessageContent.getMediaUrl() != null && TextUtils.isEmpty((CharSequence)mediaMessageContent.getMediaUrl().toString())) {
            IResultProgressCallback<String> progressCallback = new IResultProgressCallback<String>(){

                @Override
                public void onSuccess(String s) {
                    Uri localPath = mediaMessageContent.getLocalPath();
                    mediaMessageContent.setMediaUrl(Uri.parse((String)s));
                    handler.encodeMessage(message);
                    mediaMessageContent.setLocalPath(null);
                    message.setContent(mediaMessageContent);
                    byte[] finalData = mediaMessageContent.encode();
                    NativeClient.this.sendMessageIfNeedEncrypt(message, pushContent, pushData, receiverIds, new ISendMessageCallback<Message>(){

                        @Override
                        public void onAttached(Message message) {
                        }

                        @Override
                        public void onSuccess(Message message) {
                            if (mediaMessageCallback != null) {
                                mediaMessageCallback.onSuccess(message);
                            }
                        }

                        @Override
                        public void onError(Message message, int code) {
                            if (mediaMessageCallback != null) {
                                mediaMessageCallback.onError(message, code);
                            }
                        }
                    }, msgTag, finalData, 3, isMentioned);
                    mediaMessageContent.setLocalPath(localPath);
                    handler.encodeMessage(message);
                    NativeClient.this.nativeObj.SetMessageContent(message.getMessageId(), mediaMessageContent.encode(), "");
                }

                @Override
                public void onProgress(int progress) {
                    RLog.i(NativeClient.TAG, "upload onProgress " + progress);
                    if (mediaMessageCallback != null) {
                        mediaMessageCallback.onProgress(message, progress);
                    }
                }

                @Override
                public void onError(int code) {
                    message.setSentStatus(Message.SentStatus.FAILED);
                    if (mediaMessageCallback != null) {
                        mediaMessageCallback.onError(message, code);
                    }
                    NativeClient.this.nativeObj.SetSendStatus(message.getMessageId(), Message.SentStatus.FAILED.getValue());
                }

                @Override
                public void onCanceled(int messageId) {
                    message.setSentStatus(Message.SentStatus.CANCELED);
                    if (mediaMessageCallback != null) {
                        mediaMessageCallback.onCanceled(message);
                    }
                    NativeClient.this.nativeObj.SetSendStatus(message.getMessageId(), Message.SentStatus.CANCELED.getValue());
                }
            };
            this.uploadMedia(message, progressCallback);
        } else {
            Message encMsg;
            Uri localPath = mediaMessageContent.getLocalPath();
            handler.encodeMessage(message);
            mediaMessageContent.setLocalPath(null);
            message.setContent(mediaMessageContent);
            data = mediaMessageContent.encode();
            mediaMessageContent.setLocalPath(localPath);
            try {
                encMsg = this.encryptMessageContentIfNeeded(data, message);
            }
            catch (RuntimeException e) {
                RLog.e(TAG, "stop sending MediaMessage cause exception occurs while calling encrypteMessageContent() -> " + e.getLocalizedMessage());
                return;
            }
            if (encMsg == null) {
                this.nativeObj.SendMessage(message.getTargetId(), message.getConversationType().getValue(), 3, msgTag.value(), data, TextUtils.isEmpty((CharSequence)pushContent) ? null : pushContent.getBytes(), TextUtils.isEmpty((CharSequence)pushData) ? null : pushData.getBytes(), message.getMessageId(), receiverIds, new NativeObject.PublishAckListener(){

                    @Override
                    public void operationComplete(int code, String msgUId, long sendTime) {
                        RLog.d(NativeClient.TAG, "sendMediaMessage code = " + code + ", id = " + message.getMessageId() + ", uid = " + msgUId);
                        if (code == 0) {
                            message.setSentStatus(Message.SentStatus.SENT);
                            message.setSentTime(sendTime);
                            message.setUId(msgUId);
                            if (mediaMessageCallback != null) {
                                mediaMessageCallback.onSuccess(message);
                            }
                        } else {
                            message.setSentStatus(Message.SentStatus.FAILED);
                            if (mediaMessageCallback != null) {
                                mediaMessageCallback.onError(message, code);
                            }
                        }
                    }
                }, isMentioned);
            } else {
                this.nativeObj.SendMessage(encMsg.getTargetId(), encMsg.getConversationType().getValue(), 3, encMsg.getObjectName(), encMsg.getContent().encode(), TextUtils.isEmpty((CharSequence)pushContent) ? null : pushContent.getBytes(), TextUtils.isEmpty((CharSequence)pushData) ? null : pushData.getBytes(), encMsg.getMessageId(), receiverIds, new NativeObject.PublishAckListener(){

                    @Override
                    public void operationComplete(int code, String msgUId, long sendTime) {
                        RLog.d(NativeClient.TAG, "sendMediaMessage code = " + code + ", id = " + message.getMessageId() + ", uid = " + msgUId);
                        if (code == 0) {
                            message.setSentStatus(Message.SentStatus.SENT);
                            message.setSentTime(sendTime);
                            message.setUId(msgUId);
                            if (mediaMessageCallback != null) {
                                mediaMessageCallback.onSuccess(message);
                            }
                        } else {
                            message.setSentStatus(Message.SentStatus.FAILED);
                            if (mediaMessageCallback != null) {
                                mediaMessageCallback.onError(message, code);
                            }
                        }
                    }
                }, isMentioned);
            }
            mediaMessageContent.setLocalPath(localPath);
            handler.encodeMessage(message);
            this.nativeObj.SetMessageContent(message.getMessageId(), mediaMessageContent.encode(), "");
        }
    }

    public void sendMediaMessage(Message message, String pushContent, String pushData, ISendMediaMessageCallback<Message> mediaMessageCallback) {
        this.sendMediaMessage(message, null, pushContent, pushData, mediaMessageCallback);
    }

    public Message insertMessage(Conversation.ConversationType conversationType, String targetId, String senderUserId, MessageContent content, long sentTime) {
        MessageHandler handler;
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || content == null) {
            throw new IllegalArgumentException("conversationType \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        MessageTag msgTag = content.getClass().getAnnotation(MessageTag.class);
        if (msgTag == null) {
            throw new RuntimeException("\u81ea\u5b9a\u4e49\u6d88\u606f\u6ca1\u6709\u52a0\u6ce8\u89e3\u4fe1\u606f\u3002");
        }
        if (msgTag.flag() == 16) {
            RLog.e(TAG, "insertMessage MessageTag can not be STATUS.");
            return null;
        }
        String sender = senderUserId;
        Message message = new Message();
        message.setConversationType(conversationType);
        message.setTargetId(targetId);
        if (sender == null) {
            sender = this.curUserId;
        }
        if (this.curUserId == null) {
            message.setMessageDirection(Message.MessageDirection.SEND);
            message.setSentStatus(Message.SentStatus.SENT);
        } else {
            message.setMessageDirection(this.curUserId.equals(sender) ? Message.MessageDirection.SEND : Message.MessageDirection.RECEIVE);
            message.setSentStatus(this.curUserId.equals(sender) ? Message.SentStatus.SENT : Message.SentStatus.RECEIVED);
        }
        message.setSenderUserId(sender);
        message.setReceivedTime(sentTime);
        message.setSentTime(sentTime);
        message.setObjectName(msgTag.value());
        message.setContent(content);
        byte[] data = new byte[1];
        if (message.getMessageId() <= 0) {
            boolean direction = message.getMessageDirection() != null && message.getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE);
            int id = this.nativeObj.SaveMessage(message.getTargetId(), message.getConversationType().getValue(), msgTag.value(), sender, data, direction, 0, Message.SentStatus.SENDING.getValue(), message.getSentTime(), this.getSearchableWord(message.getContent()), 1, "");
            message.setMessageId(id);
        }
        if ((handler = this.getMessageHandler(msgTag.value())) != null) {
            handler.encodeMessage(message);
            data = message.getContent().encode();
            this.nativeObj.SetMessageContent(message.getMessageId(), data, "");
            this.nativeObj.SetSendStatus(message.getMessageId(), Message.SentStatus.SENT.getValue());
            RLog.d(TAG, "insertMessage Inserted, id = " + message.getMessageId());
        } else {
            RLog.e(TAG, "insertMessage \u8be5\u6d88\u606f\u672a\u6ce8\u518c\uff0c\u8bf7\u8c03\u7528registerMessageType\u65b9\u6cd5\u6ce8\u518c\u3002");
        }
        return message;
    }

    public Message insertSettingMessage(Message message) {
        MessageHandler handler;
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (message.getConversationType() == null || TextUtils.isEmpty((CharSequence)message.getTargetId()) || message.getContent() == null) {
            throw new IllegalArgumentException("conversationType \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        MessageTag msgTag = message.getContent().getClass().getAnnotation(MessageTag.class);
        if (msgTag == null) {
            throw new RuntimeException("\u81ea\u5b9a\u4e49\u6d88\u606f\u6ca1\u6709\u52a0\u6ce8\u89e3\u4fe1\u606f\u3002");
        }
        if (msgTag.flag() == 16) {
            RLog.e(TAG, "insertMessage MessageTag can not be STATUS.");
            return null;
        }
        String sender = message.getSenderUserId();
        if (sender == null) {
            sender = this.curUserId;
        }
        if (this.curUserId == null) {
            message.setMessageDirection(Message.MessageDirection.SEND);
            message.setSentStatus(Message.SentStatus.SENT);
        } else if (message.getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE)) {
            message.setSentStatus(Message.SentStatus.RECEIVED);
        }
        message.setReceivedTime(System.currentTimeMillis());
        message.setObjectName(msgTag.value());
        byte[] data = new byte[1];
        if (message.getMessageId() <= 0) {
            boolean direction = message.getMessageDirection() != null && message.getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE);
            int markUnread = message.getMessageDirection() == Message.MessageDirection.RECEIVE && message.getReceivedStatus().getFlag() == 0 && msgTag.flag() == 3 ? 0 : 1;
            int id = this.nativeObj.SaveMessage(message.getTargetId(), message.getConversationType().getValue(), msgTag.value(), sender, data, direction, message.getReceivedStatus().getFlag(), message.getSentStatus().getValue(), message.getSentTime(), this.getSearchableWord(message.getContent()), markUnread, "");
            message.setMessageId(id);
        }
        if ((handler = this.getMessageHandler(msgTag.value())) != null) {
            handler.encodeMessage(message);
            data = message.getContent().encode();
            this.nativeObj.SetMessageContent(message.getMessageId(), data, "");
            this.nativeObj.SetSendStatus(message.getMessageId(), message.getSentStatus().getValue());
            RLog.d(TAG, "insertMessage Inserted, id = " + message.getMessageId());
        } else {
            RLog.e(TAG, "insertMessage \u8be5\u6d88\u606f\u672a\u6ce8\u518c\uff0c\u8bf7\u8c03\u7528registerMessageType\u65b9\u6cd5\u6ce8\u518c\u3002");
        }
        return message;
    }

    public void uploadMedia(Message message, final IResultProgressCallback<String> callback) {
        if (message == null || message.getConversationType() == null || TextUtils.isEmpty((CharSequence)message.getTargetId()) || message.getContent() == null) {
            RLog.e(TAG, "conversation type or targetId or message content can't be null!");
            callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR.getValue());
            return;
        }
        String localPath = null;
        int type = FtConst.MimeType.FILE_IMAGE.getValue();
        if (message.getContent() instanceof ImageMessage) {
            localPath = ((ImageMessage)message.getContent()).getLocalUri().toString();
        } else if (message.getObjectName() != null && message.getObjectName().equals("RC:SightMsg")) {
            int duration = ((SightMessage)message.getContent()).getDuration();
            if (duration > this.getVideoLimitTime()) {
                RLog.e(TAG, "sight duration is too long! ");
                callback.onError(RongIMClient.ErrorCode.RC_SIGHT_MSG_DURATION_LIMIT_EXCEED.getValue());
                return;
            }
            type = FtConst.MimeType.FILE_SIGHT.getValue();
            localPath = ((MediaMessageContent)message.getContent()).getLocalPath().toString();
        } else if (message.getContent() instanceof MediaMessageContent) {
            type = FtConst.MimeType.FILE_TEXT_PLAIN.getValue();
            localPath = ((MediaMessageContent)message.getContent()).getLocalPath().toString();
        }
        if (TextUtils.isEmpty((CharSequence)localPath) || !localPath.startsWith("file://")) {
            RLog.e(TAG, "local path of the media file can't be empty!");
            callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR.getValue());
            return;
        }
        final String filePath = localPath.substring(7);
        final int uploadType = type;
        File file = new File(filePath);
        final long fileSize = file.length();
        final String fileName = file.getName();
        final FtConst.MimeType mimeType = FtUtilities.getMimeType(fileName);
        final int id = message.getMessageId();
        this.nativeObj.GetUploadToken(uploadType, new NativeObject.TokenListener(){

            @Override
            public void OnError(int errorCode, String token) {
                if (errorCode == 0) {
                    final String mimeKey = FtUtilities.generateKey(mimeType.getName()) + NativeClient.this.getSuffixName(fileName);
                    String mediaServer = NavigationClient.getInstance().getMediaServer(NativeClient.this.mContext);
                    if (!TextUtils.isEmpty((CharSequence)NativeClient.this.mFileServer)) {
                        mediaServer = NativeClient.this.mFileServer;
                    }
                    if (!mediaServer.toLowerCase().startsWith("http")) {
                        mediaServer = (Build.VERSION.SDK_INT >= 28 ? "https://" : "http://") + mediaServer;
                    }
                    final Date start = new Date(System.currentTimeMillis());
                    final String logServer = mediaServer;
                    FileTransferClient.getInstance().upload(id, filePath, token, new RequestOption(mimeKey, mimeType, mediaServer, new RequestCallBack(){

                        @Override
                        public void onError(int code) {
                            Date end = new Date(System.currentTimeMillis());
                            long diff = end.getTime() - start.getTime();
                            FwLog.write(2, 256, "L-media-S", "type|media_type|user_stop|size|url|duration|code", "upload", mimeType.getName(), false, fileSize / 1024L, logServer, diff, code);
                            RLog.d(NativeClient.TAG, "uploadMedia onError code =" + code);
                            callback.onError(code);
                        }

                        @Override
                        public void onComplete(String url) {
                            Date end = new Date(System.currentTimeMillis());
                            long diff = end.getTime() - start.getTime();
                            FwLog.write(5, 256, "L-media-S", "type|media_type|user_stop|size|url|duration|code", "upload", mimeType.getName(), false, fileSize / 1024L, logServer, diff, 0);
                            if (url == null) {
                                NativeClient.this.nativeObj.GetDownloadUrl(uploadType, mimeKey, fileName, new NativeObject.TokenListener(){

                                    @Override
                                    public void OnError(int errorCode, String token) {
                                        if (errorCode == 0) {
                                            callback.onSuccess(token);
                                        } else {
                                            RLog.d(NativeClient.TAG, "GetDownloadUrl onError code =" + errorCode);
                                            callback.onError(errorCode);
                                        }
                                    }
                                });
                            } else {
                                callback.onSuccess(url);
                            }
                        }

                        @Override
                        public void onProgress(int progress) {
                            callback.onProgress(progress);
                        }

                        @Override
                        public void onCanceled(Object tag) {
                            Date end = new Date(System.currentTimeMillis());
                            long diff = end.getTime() - start.getTime();
                            FwLog.write(5, 256, "L-media-S", "type|media_type|user_stop|size|url|duration|code", "upload", mimeType.getName(), true, fileSize / 1024L, logServer, diff, 0);
                            callback.onCanceled((Integer)tag);
                        }
                    }));
                } else {
                    callback.onError(errorCode);
                }
            }
        });
    }

    private String getSuffixName(String fileName) {
        String[] splitArray;
        String suffix = "";
        if (!TextUtils.isEmpty((CharSequence)fileName) && (splitArray = fileName.split("\\.")) != null && splitArray.length > 1) {
            suffix = "." + splitArray[splitArray.length - 1];
        }
        return suffix;
    }

    public void downloadMedia(Conversation.ConversationType conversationType, String targetId, int type, final String imageUrl, final IResultProgressCallback<String> callback) {
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || TextUtils.isEmpty((CharSequence)imageUrl)) {
            throw new IllegalArgumentException("conversationType\uff0cimageUrl \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        String path = FileUtils.getCachePath(this.mContext, "download");
        String fileName = FtUtilities.getFileName(path, this.shortMD5(imageUrl));
        long fileLength = 0L;
        final FtConst.MimeType mimeType = FtUtilities.getMimeType(fileName);
        final Date start = new Date(System.currentTimeMillis());
        FileTransferClient.getInstance().setMediaPath(path);
        FileTransferClient.getInstance().download(-1, imageUrl, fileLength, new RequestOption(fileName, FtConst.MimeType.setValue(type), new RequestCallBack(){

            @Override
            public void onError(int code) {
                Date end = new Date(System.currentTimeMillis());
                long diff = end.getTime() - start.getTime();
                FwLog.write(2, 256, "L-media-S", "type|media_type|user_stop|size|url|duration|code", "download", mimeType.getName(), false, 0, imageUrl, diff, code);
                RLog.d(NativeClient.TAG, "downloadMedia onError code =" + code);
                callback.onError(code);
            }

            @Override
            public void onComplete(String url) {
                Date end = new Date(System.currentTimeMillis());
                long diff = end.getTime() - start.getTime();
                File file = new File(url);
                long fileSize = file.length();
                FwLog.write(5, 256, "L-media-S", "type|media_type|user_stop|size|url|duration|code", "download", mimeType.getName(), false, fileSize / 1024L, imageUrl, diff, 0);
                RLog.d(NativeClient.TAG, "downloadMedia onComplete url =" + url);
                callback.onSuccess(url);
            }

            @Override
            public void onProgress(int progress) {
                callback.onProgress(progress);
            }

            @Override
            public void onCanceled(Object tag) {
                Date end = new Date(System.currentTimeMillis());
                long diff = end.getTime() - start.getTime();
                FwLog.write(5, 256, "L-media-S", "type|media_type|user_stop|size|url|duration|code", "download", mimeType.getName(), true, 0, imageUrl, diff, 0);
            }
        }));
    }

    public void downloadMediaMessage(final Message message, final IDownloadMediaMessageCallback<Message> callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        String remoteUrl = null;
        String name = "";
        long length = 0L;
        FtConst.MimeType type = FtConst.MimeType.NONE;
        if (message.getContent() instanceof ImageMessage && ((ImageMessage)message.getContent()).getRemoteUri() != null) {
            remoteUrl = ((ImageMessage)message.getContent()).getRemoteUri().toString();
            name = this.shortMD5(remoteUrl);
            type = FtConst.MimeType.FILE_IMAGE;
        } else if (message.getContent() instanceof FileMessage && ((FileMessage)message.getContent()).getFileUrl() != null) {
            remoteUrl = ((FileMessage)message.getContent()).getFileUrl().toString();
            FileMessage fileMessage = (FileMessage)message.getContent();
            name = fileMessage.getName();
            length = fileMessage.getSize();
            type = FtUtilities.getMimeType(fileMessage.getType());
            MediaMessageContent mediaMessageContent = (MediaMessageContent)message.getContent();
            mediaMessageContent.setLocalPath(null);
            byte[] data = mediaMessageContent.encode();
            this.nativeObj.SetMessageContent(message.getMessageId(), data, "");
        } else if (message.getContent() instanceof MediaMessageContent && ((MediaMessageContent)message.getContent()).getMediaUrl() != null) {
            remoteUrl = ((MediaMessageContent)message.getContent()).getMediaUrl().toString();
            name = ((MediaMessageContent)message.getContent()).getName();
            if (TextUtils.isEmpty((CharSequence)name)) {
                name = this.shortMD5(remoteUrl);
            }
            type = FtConst.MimeType.FILE_TEXT_PLAIN;
            if (message.getContent() instanceof SightMessage) {
                length = ((SightMessage)message.getContent()).getSize();
            }
        }
        if (TextUtils.isEmpty(remoteUrl)) {
            RLog.e(TAG, "remoteUrl of the media file can't be empty!");
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR.getValue());
            }
            return;
        }
        String path = FileUtils.getMediaDownloadDir(this.mContext);
        String fileName = FtUtilities.getFileName(path, name);
        final FtConst.MimeType mimeType = FtUtilities.getMimeType(fileName);
        final Date start = new Date(System.currentTimeMillis());
        final String finalRemoteUrl = remoteUrl;
        FileTransferClient.getInstance().setMediaPath(path);
        FileTransferClient.getInstance().download(message.getMessageId(), remoteUrl, length, new RequestOption(fileName, type, message.getMessageId(), new RequestCallBack(){

            @Override
            public void onError(int code) {
                Date end = new Date(System.currentTimeMillis());
                long diff = end.getTime() - start.getTime();
                FwLog.write(2, 256, "L-media-S", "type|media_type|user_stop|size|url|duration|code", "download", mimeType.getName(), false, 0, finalRemoteUrl, diff, code);
                RLog.d(NativeClient.TAG, "downloadMediaMessage onError code =" + code);
                callback.onError(code);
            }

            @Override
            public void onComplete(String localUrl) {
                Date end = new Date(System.currentTimeMillis());
                long diff = end.getTime() - start.getTime();
                File file = new File(localUrl);
                long fileSize = file.length();
                FwLog.write(5, 256, "L-media-S", "type|media_type|user_stop|size|url|duration|code", "download", mimeType.getName(), false, fileSize / 1024L, finalRemoteUrl, diff, 0);
                RLog.d(NativeClient.TAG, "downloadMediaMessage onComplete url =" + localUrl);
                MediaMessageContent mediaMessageContent = (MediaMessageContent)message.getContent();
                mediaMessageContent.setLocalPath(Uri.parse((String)localUrl));
                callback.onSuccess(message);
                byte[] data = mediaMessageContent.encode();
                NativeClient.this.nativeObj.SetMessageContent(message.getMessageId(), data, "");
            }

            @Override
            public void onProgress(int progress) {
                RLog.i(NativeClient.TAG, "download onProgress " + progress);
                callback.onProgress(progress);
            }

            @Override
            public void onCanceled(Object tag) {
                Date end = new Date(System.currentTimeMillis());
                long diff = end.getTime() - start.getTime();
                FwLog.write(5, 256, "L-media-S", "type|media_type|user_stop|size|url|duration|code", "download", mimeType.getName(), true, 0, finalRemoteUrl, diff, 0);
                callback.onCanceled();
            }
        }));
    }

    public void downloadMediaFile(String uid, String fileUrl, String fileName, String path, final IDownloadMediaFileCallback<Boolean> callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        final FtConst.MimeType mimeType = FtUtilities.getMimeType(fileName);
        final Date start = new Date(System.currentTimeMillis());
        final String finalRemoteUrl = fileUrl;
        String savedPath = FtUtilities.getFileName(path, fileName);
        String pausePath = FileUtils.getTempFilePath(this.mContext, uid);
        if (!new File(pausePath).exists()) {
            try {
                String newFileName = savedPath.substring(path.length() + 1);
                if (!newFileName.equals(fileName)) {
                    callback.onFileNameChanged(newFileName);
                }
            }
            catch (Exception e) {
                RLog.e(TAG, "downloadMediaFile", e);
            }
        }
        FileTransferClient.getInstance().setMediaPath(savedPath);
        FileTransferClient.getInstance().download(uid, fileUrl, new RequestOption(savedPath, mimeType, new RequestCallBack(){

            @Override
            public void onError(int code) {
                Date end = new Date(System.currentTimeMillis());
                long diff = end.getTime() - start.getTime();
                FwLog.write(2, 256, "L-media-S", "type|media_type|user_stop|size|url|duration|code", "download", mimeType.getName(), false, 0, finalRemoteUrl, diff, code);
                RLog.d(NativeClient.TAG, "downloadMediaMessage onError code =" + code);
                callback.onError(code);
            }

            @Override
            public void onComplete(String localUrl) {
                Date end = new Date(System.currentTimeMillis());
                long diff = end.getTime() - start.getTime();
                File file = new File(localUrl);
                long fileSize = file.length();
                FwLog.write(5, 256, "L-media-S", "type|media_type|user_stop|size|url|duration|code", "download", mimeType.getName(), false, fileSize / 1024L, finalRemoteUrl, diff, 0);
                RLog.d(NativeClient.TAG, "downloadMediaMessage onComplete url =" + localUrl);
                callback.onSuccess(true);
            }

            @Override
            public void onProgress(int progress) {
                RLog.i(NativeClient.TAG, "download onProgress " + progress);
                callback.onProgress(progress);
            }

            @Override
            public void onCanceled(Object tag) {
                Date end = new Date(System.currentTimeMillis());
                long diff = end.getTime() - start.getTime();
                FwLog.write(5, 256, "L-media-S", "type|media_type|user_stop|size|url|duration|code", "download", mimeType.getName(), true, 0, finalRemoteUrl, diff, 0);
                callback.onCanceled();
            }
        }));
    }

    public void getConversationNotificationStatus(Conversation.ConversationType conversationType, String targetId, final IResultCallback<Integer> callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || callback == null) {
            throw new IllegalArgumentException("conversationType \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.GetBlockPush(targetId, conversationType.getValue(), new NativeObject.BizAckListener(){

            @Override
            public void operationComplete(int opStatus, int status) {
                if (callback == null) {
                    return;
                }
                if (opStatus == 0) {
                    callback.onSuccess(status == 100 ? Conversation.ConversationNotificationStatus.DO_NOT_DISTURB.getValue() : Conversation.ConversationNotificationStatus.NOTIFY.getValue());
                } else {
                    callback.onError(opStatus);
                }
            }
        });
    }

    public void setConversationNotificationStatus(Conversation.ConversationType conversationType, String targetId, Conversation.ConversationNotificationStatus notificationStatus, final IResultCallback<Integer> callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || notificationStatus == null || TextUtils.isEmpty((CharSequence)targetId) || callback == null) {
            throw new IllegalArgumentException("conversationType, notificationStatus \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.SetBlockPush(targetId, conversationType.getValue(), notificationStatus == Conversation.ConversationNotificationStatus.DO_NOT_DISTURB, new NativeObject.BizAckListener(){

            @Override
            public void operationComplete(int opStatus, int status) {
                if (callback == null) {
                    return;
                }
                if (opStatus == 0) {
                    callback.onSuccess(status == 100 ? Conversation.ConversationNotificationStatus.DO_NOT_DISTURB.getValue() : Conversation.ConversationNotificationStatus.NOTIFY.getValue());
                } else {
                    RLog.d(NativeClient.TAG, "setConversationNotificationStatus operationComplete: opStatus = " + opStatus);
                    callback.onError(status);
                }
            }
        });
    }

    public boolean syncConversationNotificationStatus(Conversation.ConversationType conversationType, String targetId, Conversation.ConversationNotificationStatus notificationStatus) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || notificationStatus == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("conversationType, notificationStatus \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        return this.nativeObj.SetBlockPushSync(targetId, conversationType.getValue(), notificationStatus == Conversation.ConversationNotificationStatus.DO_NOT_DISTURB);
    }

    public void setDiscussionInviteStatus(String targetId, int status, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.SetInviteStatus(targetId, status, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int statusCode, String msgUId, long timestamp) {
                if (callback == null) {
                    return;
                }
                if (statusCode == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(statusCode);
                }
            }
        });
    }

    public void syncGroup(List<Group> groups, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (groups == null || groups.size() == 0) {
            throw new IllegalArgumentException(" groups \u53c2\u6570\u5f02\u5e38\u3002");
        }
        String[] ids = new String[groups.size()];
        String[] names = new String[groups.size()];
        int i = 0;
        for (Group item : groups) {
            ids[i] = item.getId();
            names[i++] = item.getName();
        }
        this.nativeObj.SyncGroups(ids, names, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long timestamp) {
                if (callback == null) {
                    return;
                }
                if (code == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(code);
                }
            }
        });
    }

    public void joinGroup(String groupId, String groupName, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (groupId == null || groupName == null) {
            throw new IllegalArgumentException("groupId \u6216 groupName\u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.JoinGroup(groupId, groupName, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long timestamp) {
                if (callback == null) {
                    return;
                }
                if (code == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(code);
                }
            }
        });
    }

    public void quitGroup(String groupId, final OperationCallback callback) {
        this.nativeObj.QuitGroup(groupId, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long timestamp) {
                if (callback == null) {
                    return;
                }
                if (code == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(code);
                }
            }
        });
    }

    public void setOnReceiveMessageListener(final OnReceiveMessageListener listener) {
        this.nativeObj.SetMessageListener(new NativeObject.ReceiveMessageListener(){

            @Override
            public void onReceived(NativeObject.Message nativeMessage, int left, boolean offline, boolean hasMsg, int cmdLeft) {
                String objectName;
                Message message = new Message(nativeMessage);
                switch (objectName = message.getObjectName()) {
                    case "RC:EncryptedMsg": {
                        String nativeSenderUserId = nativeMessage.getSenderUserId();
                        if (nativeSenderUserId != null && nativeSenderUserId.equals(NativeClient.this.getCurrentUserId())) {
                            RLog.d(NativeClient.TAG, "encryptedMsg from the same endpoint , do nothing.");
                            return;
                        }
                        MessageContent msgContent = NativeClient.this.renderMessageContent(objectName, nativeMessage.getContent(), message);
                        if (msgContent == null) {
                            RLog.e(NativeClient.TAG, "render EncryptedMsgContent returns null.");
                            return;
                        }
                        RCEncryptedMessage encMsgContent = (RCEncryptedMessage)msgContent;
                        String encId = encMsgContent.getRemoteEncId();
                        String targetId = nativeMessage.getTargetId();
                        RCEncryptedSession encryptedSession = NativeClient.this.nativeObj.GetEncryptedConversationInfo(encId + ";;;" + targetId);
                        if (encryptedSession == null) {
                            RLog.w(NativeClient.TAG, "GetEncryptedConversationInfo of " + encId + ";;;" + targetId + " is null ");
                            return;
                        }
                        String encKey = encryptedSession.getEncKey();
                        if (encKey == null || encKey.length() == 0) {
                            RLog.w(NativeClient.TAG, "result is null when getEncKey from encryptedSesseion of ->" + encId + ";;;" + targetId);
                            return;
                        }
                        RCDHCodecTool.RCSecretKey secretKey = RCDHCodecTool.fromString2RCSecretKey(encKey);
                        if (encMsgContent.getEncryptedContent() == null) {
                            RLog.e(NativeClient.TAG, "instance of RCEncryptedMessage getEncryptedContent() returns null.");
                            return;
                        }
                        byte[] data2Dec = Base64.decode((String)encMsgContent.getEncryptedContent(), (int)2);
                        byte[] decryptContent = RCDHCodecTool.decrypt(data2Dec, secretKey);
                        MessageContent originalMsgContent = NativeClient.this.renderMessageContent(encMsgContent.getOriginalObjName(), decryptContent, message);
                        message.setContent(originalMsgContent);
                        message.setObjectName(encMsgContent.getOriginalObjName());
                        message.setTargetId(encId + ";;;" + targetId);
                        message.setConversationType(Conversation.ConversationType.ENCRYPTED);
                        message.setMessageId(nativeMessage.getMessageId());
                        MessageTag originMsgTag = originalMsgContent.getClass().getAnnotation(MessageTag.class);
                        if ((originMsgTag.flag() & 1) != 1) break;
                        boolean isCount = (originMsgTag.flag() & 3) == 3;
                        int markUnread = isCount ? 0 : 1;
                        int messageId = NativeClient.this.nativeObj.SaveMessage(message.getTargetId(), message.getConversationType().getValue(), message.getObjectName(), message.getSenderUserId(), decryptContent, true, 0, Message.SentStatus.RECEIVED.getValue(), message.getSentTime(), NativeClient.this.getSearchableWord(originalMsgContent), markUnread, nativeMessage.getUId());
                        message.setMessageId(messageId);
                        break;
                    }
                    default: {
                        MessageContent content = NativeClient.this.renderMessageContent(nativeMessage.getObjectName(), nativeMessage.getContent(), message);
                        message.setContent(content);
                    }
                }
                if (message.getContent() instanceof DiscussionNotificationMessage) {
                    DiscussionNotificationMessage discussionNotificationMessage = (DiscussionNotificationMessage)message.getContent();
                    if (!NativeClient.this.curUserId.equals(discussionNotificationMessage.getOperator()) && discussionNotificationMessage.getType() == 4) {
                        String extension = discussionNotificationMessage.getExtension();
                        if (!TextUtils.isEmpty((CharSequence)extension)) {
                            String[] targetIds;
                            for (String targetId : targetIds = extension.split(",")) {
                                NativeClient.this.nativeObj.RemoveMemberFromDiscussionSync(message.getTargetId(), targetId);
                            }
                        }
                    } else {
                        NativeClient.this.nativeObj.GetDiscussionInfo(message.getTargetId(), new NativeObject.DiscussionInfoListener(){

                            @Override
                            public void onReceived(NativeObject.DiscussionInfo info) {
                            }

                            @Override
                            public void OnError(int status) {
                            }
                        });
                    }
                }
                if (listener != null) {
                    listener.onReceived(message, left, offline, hasMsg, cmdLeft);
                }
            }
        });
        this.nativeObj.SetGetSearchableWordListener(new NativeObject.GetSearchableWordListener(){

            @Override
            public byte[] getSearchableWord(String objectName, byte[] content) {
                String filteredStr = "";
                MessageContent result = NativeClient.this.newMessageContent(objectName, content);
                if (!(result instanceof UnknownMessage)) {
                    filteredStr = client.getSearchableWord(result);
                }
                return filteredStr.getBytes();
            }
        });
    }

    public void setConnectionStatusListener(final ICodeListener listener) {
        this.nativeObj.SetExceptionListener(new NativeObject.ExceptionListener(){

            @Override
            public void onError(int status, int kError, String loginInfo) {
                FwLog.write(5, 16, "P-connect-S", "status_code|native_code", status, kError);
                RLog.i(NativeClient.TAG, "loginInfo: " + loginInfo);
                if (listener != null) {
                    listener.onChanged(status);
                }
            }
        });
    }

    public long getDeltaTime() {
        return this.nativeObj.GetDeltaTime();
    }

    public void queryChatRoomInfo(final String id, int count, int order, final IResultCallback<ChatRoomInfo> callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)id)) {
            throw new IllegalArgumentException("\u804a\u5929\u5ba4 Id \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.QueryChatroomInfo(id, count, order, new NativeObject.ChatroomInfoListener(){

            @Override
            public void OnSuccess(int members, NativeObject.UserInfo[] users) {
                ArrayList<ChatRoomMemberInfo> list = new ArrayList<ChatRoomMemberInfo>();
                if (users != null) {
                    for (int i = 0; i < users.length; ++i) {
                        ChatRoomMemberInfo info = new ChatRoomMemberInfo();
                        info.setUserId(users[i].getUserId());
                        info.setJoinTime(users[i].getJoinTime());
                        list.add(info);
                    }
                }
                ChatRoomInfo info = new ChatRoomInfo();
                info.setChatRoomId(id);
                info.setTotalMemberCount(members);
                info.setMemberInfo(list);
                callback.onSuccess(info);
            }

            @Override
            public void OnError(int status) {
                callback.onError(status);
            }
        });
    }

    public void joinChatRoom(String id, int defMessageCount, final OperationCallback callback) {
        RLog.d(TAG, "joinChatRoom id: " + id + ", msgCount : " + defMessageCount);
        this.nativeObj.JoinChatRoom(id, Conversation.ConversationType.CHATROOM.getValue(), defMessageCount, false, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long timestamp) {
                if (code == 0) {
                    if (callback != null) {
                        callback.onSuccess();
                    }
                } else if (callback != null) {
                    callback.onError(code);
                }
            }
        });
    }

    public void reJoinChatRoom(String id, int defMessageCount, final OperationCallback callback) {
        RLog.d(TAG, "reJoinChatRoom id: " + id + ", msgCount : " + defMessageCount);
        this.nativeObj.JoinChatRoom(id, Conversation.ConversationType.CHATROOM.getValue(), defMessageCount, true, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long timestamp) {
                if (code == 0) {
                    if (callback != null) {
                        callback.onSuccess();
                    }
                } else if (callback != null) {
                    callback.onError(code);
                }
            }
        });
    }

    synchronized void startReplenishHeartbeat() {
        if (this.timer == null) {
            RLog.d(TAG, "start replenish heartbeat");
            this.timer = new Timer();
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    FwLog.write(4, 4, "L-ping-S", "interval|enabled", 15000, "polling");
                    NativeClient.this.nativeObj.ping();
                }
            };
            FwLog.write(4, 4, "L-ping-S", "interval|enabled", 2000, true);
            this.timer.schedule(task, 2000L, 15000L);
        }
    }

    synchronized void stopReplenishHeartbeat() {
        if (this.timer != null) {
            FwLog.write(4, 4, "L-ping-S", "interval|enabled", 15000, false);
            this.timer.cancel();
            this.timer = null;
            RLog.d(TAG, "stop replenish heartbeat");
        }
    }

    public void joinExistChatRoom(String id, int defMessageCount, final OperationCallback callback, boolean keepMsg) {
        RLog.d(TAG, "joinExistChatRoom id: " + id + ", msgCount : " + defMessageCount);
        this.nativeObj.JoinExistingChatroom(id, Conversation.ConversationType.CHATROOM.getValue(), defMessageCount, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long timestamp) {
                if (code == 0) {
                    if (callback != null) {
                        callback.onSuccess();
                    }
                } else if (callback != null) {
                    callback.onError(code);
                }
            }
        }, keepMsg);
    }

    public void quitChatRoom(String id, final OperationCallback callback) {
        RLog.d(TAG, "quitChatRoom id: " + id);
        this.nativeObj.QuitChatRoom(id, Conversation.ConversationType.CHATROOM.getValue(), new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long timestamp) {
                if (code == 0) {
                    if (callback != null) {
                        callback.onSuccess();
                    }
                } else if (callback != null) {
                    callback.onError(code);
                }
            }
        });
        this.clearMessages(Conversation.ConversationType.CHATROOM, id);
    }

    public boolean clearConversations(Conversation.ConversationType ... conversationTypes) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationTypes == null || conversationTypes.length == 0) {
            new IllegalAccessException("ConversationTypes \u53c2\u6570\u5f02\u5e38\u3002");
        }
        int[] conversationTypeValues = new int[conversationTypes.length];
        int i = 0;
        for (Conversation.ConversationType conversationType : conversationTypes) {
            conversationTypeValues[i] = conversationType.getValue();
            ++i;
        }
        return this.nativeObj.ClearConversations(conversationTypeValues);
    }

    public void addToBlacklist(String userId, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)userId) || callback == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.AddToBlacklist(userId, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long timestamp) {
                if (code == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(code);
                }
            }
        });
    }

    public void recallMessage(String objectName, byte[] content, String pushContent, int messageId, String targetId, int conversationType, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316");
        }
        this.nativeObj.RecallMessage(objectName, content, pushContent, messageId, targetId, conversationType, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long sendTime) {
                if (callback != null) {
                    if (code == 0) {
                        callback.onSuccess();
                    } else {
                        callback.onError(code);
                    }
                }
            }
        });
    }

    public void removeFromBlacklist(String userId, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)userId) || callback == null) {
            throw new IllegalArgumentException("\u7528\u6237 Id \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.RemoveFromBlacklist(userId, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long timestamp) {
                if (code == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(code);
                }
            }
        });
    }

    public void getBlacklistStatus(String userId, final IResultCallback<BlacklistStatus> callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)userId) || callback == null) {
            throw new IllegalArgumentException("\u7528\u6237 Id \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.GetBlacklistStatus(userId, new NativeObject.BizAckListener(){

            @Override
            public void operationComplete(int opStatus, int status) {
                if (opStatus == 0) {
                    if (status == 0) {
                        callback.onSuccess(BlacklistStatus.EXIT_BLACK_LIST);
                    } else if (status == 101) {
                        callback.onSuccess(BlacklistStatus.NOT_EXIT_BLACK_LIST);
                    }
                } else {
                    callback.onError(opStatus);
                }
            }
        });
    }

    public void getBlacklist(final IResultCallback<String> callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (callback == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.GetBlacklist(new NativeObject.SetBlacklistListener(){

            @Override
            public void OnSuccess(String userIds) {
                if (!TextUtils.isEmpty((CharSequence)userIds)) {
                    if (callback != null) {
                        callback.onSuccess(userIds);
                    }
                } else if (callback != null) {
                    callback.onSuccess(null);
                }
            }

            @Override
            public void OnError(int errorCode) {
                if (callback != null) {
                    callback.onError(errorCode);
                }
            }
        });
    }

    public void setNotificationQuietHours(String startTime, int spanMinutes, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)startTime) || spanMinutes <= 0 || spanMinutes >= 1440 || callback == null) {
            throw new IllegalArgumentException("startTime, spanMinutes \u6216 spanMinutes \u53c2\u6570\u5f02\u5e38\u3002");
        }
        Pattern pattern = Pattern.compile("^(([0-1][0-9])|2[0-3]):[0-5][0-9]:([0-5][0-9])$");
        Matcher matcher = pattern.matcher(startTime);
        if (!matcher.find()) {
            throw new IllegalArgumentException("startTime \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.AddPushSetting(startTime, spanMinutes, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long timestamp) {
                if (0 == code) {
                    callback.onSuccess();
                } else {
                    callback.onError(code);
                }
            }
        });
    }

    public void removeNotificationQuietHours(final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (callback == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.RemovePushSetting(new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long timestamp) {
                if (0 == code) {
                    callback.onSuccess();
                } else {
                    callback.onError(code);
                }
            }
        });
    }

    public void getNotificationQuietHours(final GetNotificationQuietHoursCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (callback == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.QueryPushSetting(new NativeObject.PushSettingListener(){

            @Override
            public void OnError(int status) {
                callback.onError(status);
            }

            @Override
            public void OnSuccess(String startTime, int spanMins) {
                callback.onSuccess(startTime, spanMins);
            }
        });
    }

    public void setUserData(UserData userData, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (userData == null) {
            throw new IllegalArgumentException("userData \u53c2\u6570\u5f02\u5e38\u3002");
        }
        JSONObject jsonObj = new JSONObject();
        try {
            if (userData.getPersonalInfo() != null) {
                JSONObject personalInfo = new JSONObject();
                personalInfo.putOpt("realName", (Object)userData.getPersonalInfo().getRealName());
                personalInfo.putOpt("sex", (Object)userData.getPersonalInfo().getSex());
                personalInfo.putOpt("age", (Object)userData.getPersonalInfo().getAge());
                personalInfo.putOpt("birthday", (Object)userData.getPersonalInfo().getBirthday());
                personalInfo.putOpt("job", (Object)userData.getPersonalInfo().getJob());
                personalInfo.putOpt("portraitUri", (Object)userData.getPersonalInfo().getPortraitUri());
                personalInfo.putOpt("comment", (Object)userData.getPersonalInfo().getComment());
                jsonObj.put("personalInfo", (Object)personalInfo);
            }
            if (userData.getAccountInfo() != null) {
                JSONObject accountInfo = new JSONObject();
                accountInfo.putOpt("appUserId", (Object)userData.getAccountInfo().getAppUserId());
                accountInfo.putOpt("userName", (Object)userData.getAccountInfo().getUserName());
                accountInfo.putOpt("nickName", (Object)userData.getAccountInfo().getNickName());
                jsonObj.putOpt("accountInfo", (Object)accountInfo);
            }
            if (userData.getContactInfo() != null) {
                JSONObject contactInfo = new JSONObject();
                contactInfo.putOpt("tel", (Object)userData.getContactInfo().getTel());
                contactInfo.putOpt("email", (Object)userData.getContactInfo().getEmail());
                contactInfo.putOpt("address", (Object)userData.getContactInfo().getAddress());
                contactInfo.putOpt("qq", (Object)userData.getContactInfo().getQQ());
                contactInfo.putOpt("weibo", (Object)userData.getContactInfo().getWeibo());
                contactInfo.putOpt("weixin", (Object)userData.getContactInfo().getWeixin());
                jsonObj.putOpt("contactInfo", (Object)contactInfo);
            }
            if (userData.getClientInfo() != null) {
                JSONObject clientInfo = new JSONObject();
                clientInfo.putOpt("network", (Object)userData.getClientInfo().getNetwork());
                clientInfo.putOpt("carrier", (Object)userData.getClientInfo().getCarrier());
                clientInfo.putOpt("systemVersion", (Object)userData.getClientInfo().getSystemVersion());
                clientInfo.putOpt("os", (Object)userData.getClientInfo().getOs());
                clientInfo.putOpt("device", (Object)userData.getClientInfo().getDevice());
                clientInfo.putOpt("mobilePhoneManufacturers", (Object)userData.getClientInfo().getMobilePhoneManufacturers());
                jsonObj.putOpt("clientInfo", (Object)clientInfo);
            }
            jsonObj.putOpt("appVersion", (Object)userData.getAppVersion());
            jsonObj.putOpt("extra", (Object)userData.getExtra());
            String result = jsonObj.toString();
            RLog.d(TAG, "UserData " + result);
            this.nativeObj.SetUserData(result, new NativeObject.PublishAckListener(){

                @Override
                public void operationComplete(int code, String msgUId, long timestamp) {
                    if (callback != null) {
                        if (code == 0) {
                            callback.onSuccess();
                        } else {
                            callback.onError(code);
                        }
                    }
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void setEnvInfo(Context context) {
        String network = "";
        String MCCMNC = "";
        try {
            TelephonyManager telephonyManager;
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivityManager != null && connectivityManager.getActiveNetworkInfo() != null) {
                network = connectivityManager.getActiveNetworkInfo().getTypeName();
            }
            if ((telephonyManager = (TelephonyManager)context.getSystemService("phone")) != null) {
                MCCMNC = telephonyManager.getNetworkOperator();
            }
        }
        catch (SecurityException e) {
            RLog.e(TAG, "setEnvInfo SecurityException", e);
        }
        String manufacturer = Build.MANUFACTURER;
        String model = Build.MODEL;
        if (manufacturer == null) {
            manufacturer = "";
        }
        if (model == null) {
            model = "";
        }
        this.nativeObj.SetDeviceInfo(manufacturer, model, String.valueOf(Build.VERSION.SDK_INT), network, MCCMNC);
    }

    public Message getMessageByUid(String uid) {
        NativeObject.Message message = this.nativeObj.GetMessageByUId(uid);
        if (message == null) {
            return null;
        }
        Message msg = new Message(message);
        MessageContent content = this.renderMessageContent(message.getObjectName(), message.getContent(), msg);
        msg.setContent(content);
        return msg;
    }

    public boolean updateMessageReceiptStatus(String targetId, int categoryId, long timestamp) {
        return this.nativeObj.UpdateMessageReceiptStatus(targetId, categoryId, timestamp);
    }

    public boolean clearUnreadByReceipt(int conversationType, String targetId, long timestamp) {
        return this.nativeObj.ClearUnreadByReceipt(targetId, conversationType, timestamp);
    }

    public long getSendTimeByMessageId(int messageId) {
        return this.nativeObj.GetSendTimeByMessageId(messageId);
    }

    public boolean updateConversationInfo(Conversation.ConversationType conversationType, String targetId, String title, String portrait) {
        return this.nativeObj.UpdateConversationInfo(targetId, conversationType.getValue(), title, portrait);
    }

    public void getVoIPKey(int engineType, String channelName, String extra, final IResultCallback<String> callback) {
        this.nativeObj.GetVoIPKey(engineType, channelName, extra, new NativeObject.TokenListener(){

            @Override
            public void OnError(int errorCode, String token) {
                if (errorCode == 0) {
                    callback.onSuccess(token);
                } else {
                    callback.onError(errorCode);
                }
            }
        });
    }

    public String getVoIPCallInfo() {
        return NavigationClient.getInstance().getVoIPCallInfo(this.mContext);
    }

    private String shortMD5(String ... args) {
        try {
            StringBuilder builder = new StringBuilder();
            for (String arg : args) {
                builder.append(arg);
            }
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(builder.toString().getBytes());
            byte[] mds = mdInst.digest();
            mds = Base64.encode((byte[])mds, (int)2);
            String result = new String(mds);
            result = result.replace("=", "").replace("+", "-").replace("/", "_").replace("\n", "");
            return result;
        }
        catch (Exception e) {
            RLog.e(TAG, "shortMD5", e);
            return "";
        }
    }

    public Uri obtainMediaFileSavedUri() {
        String key = this.shortMD5(this.appKey, this.curUserId);
        File file = this.mContext.getFilesDir();
        String path = file.getAbsolutePath();
        Uri uri = Uri.parse((String)(path + File.separator + key));
        return uri;
    }

    public void setServerInfo(String naviServer, String fileServer) {
        if (naviServer != null) {
            NavigationClient.getInstance().setNaviDomainList(naviServer);
        }
        this.mFileServer = NavigationClient.getInstance().formatServerAddress(fileServer, "");
        FileTransferClient.getInstance().setServiceType(FtConst.ServiceType.PRIVATE_CLOUD);
    }

    public boolean setMessageContent(int messageId, byte[] messageContent, String objectName) {
        return this.nativeObj.SetMessageContent(messageId, messageContent, objectName);
    }

    public String getToken() {
        return NavigationCacheHelper.getToken(this.mContext);
    }

    public int getVideoLimitTime() {
        return NavigationCacheHelper.getVideoLimitTime(this.mContext);
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    private boolean isMentionedMessage(Message message) {
        TextMessage textMessage;
        return message.getContent() instanceof TextMessage && (textMessage = (TextMessage)message.getContent()).getMentionedInfo() != null;
    }

    public List<Message> getUnreadMentionedMessages(Conversation.ConversationType conversationType, String targetId) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("ConversationTypes \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        targetId = targetId.trim();
        NativeObject.Message[] array = this.nativeObj.GetMentionMessages(targetId, conversationType.getValue());
        ArrayList<Message> list = new ArrayList<Message>();
        if (array == null) {
            return list;
        }
        for (NativeObject.Message item : array) {
            Message msg = new Message(item);
            msg.setContent(this.renderMessageContent(item.getObjectName(), item.getContent(), msg));
            list.add(msg);
        }
        return list;
    }

    public void setLogStatus(int level, NativeObject.NativeLogInfoListener listener) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        this.nativeObj.SetLogStatus(level, listener);
    }

    boolean updateReadReceiptRequestInfo(String msgUId, String info) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        return this.nativeObj.UpdateReadReceiptRequestInfo(msgUId, info);
    }

    void registerCmdMsgType(String objName) {
        if (TextUtils.isEmpty((CharSequence)objName)) {
            RLog.d(TAG, "registerCmdMsgType parameter error");
            return;
        }
        this.nativeObj.RegisterCmdMsgType(new String[]{objName});
    }

    void registerDeleteMessageType(List<String> objNames) {
        if (objNames != null && objNames.size() > 0) {
            RLog.e(TAG, "registerDeleteMessageType size: " + objNames.size());
            this.nativeObj.RegisterDeleteMessageType(objNames.toArray(new String[0]));
        }
    }

    List<Message> searchMessages(String targetId, Conversation.ConversationType conversationType, String keyword, int count, long timestamp) {
        NativeObject.Message[] messages = this.nativeObj.SearchMessages(targetId, conversationType.getValue(), keyword, count, timestamp);
        ArrayList<Message> list = new ArrayList<Message>();
        if (messages != null) {
            for (NativeObject.Message item : messages) {
                Message msg = new Message(item);
                msg.setContent(this.renderMessageContent(item.getObjectName(), item.getContent(), msg));
                list.add(msg);
            }
        }
        return list;
    }

    List<Message> searchMessagesByUser(String targetId, Conversation.ConversationType conversationType, String userId, int count, long timestamp) {
        NativeObject.Message[] messages = this.nativeObj.SearchMessagesByUser(targetId, conversationType.getValue(), userId, count, timestamp);
        ArrayList<Message> list = new ArrayList<Message>();
        if (messages != null) {
            for (NativeObject.Message item : messages) {
                Message msg = new Message(item);
                msg.setContent(this.renderMessageContent(item.getObjectName(), item.getContent(), msg));
                list.add(msg);
            }
        }
        return list;
    }

    List<SearchConversationResult> searchConversations(String keyword, int[] conversationTypes, String[] objName) {
        NativeObject.Conversation[] conversations = this.nativeObj.SearchConversations(keyword, conversationTypes, objName);
        ArrayList<SearchConversationResult> result = new ArrayList<SearchConversationResult>();
        if (conversations != null) {
            for (int i = 0; i < conversations.length; ++i) {
                Conversation conversation = this.renderConversationFromNative(conversations[i]);
                SearchConversationResult searchConversationResult = new SearchConversationResult();
                searchConversationResult.setConversation(conversation);
                searchConversationResult.setMatchCount(conversations[i].getMatchCount());
                result.add(searchConversationResult);
            }
        }
        return result;
    }

    List<Message> getMatchedMessages(String targetId, Conversation.ConversationType conversationType, long timestamp, int before, int after) {
        NativeObject.Message[] messages = this.nativeObj.GetMatchedMessages(targetId, conversationType.getValue(), timestamp, before, after);
        ArrayList<Message> list = new ArrayList<Message>();
        if (messages != null) {
            for (NativeObject.Message item : messages) {
                Message msg = new Message(item);
                msg.setContent(this.renderMessageContent(item.getObjectName(), item.getContent(), msg));
                list.add(msg);
            }
        }
        return list;
    }

    void getVendorToken(final IResultCallback<String> resultCallback) {
        this.nativeObj.GetVendorToken("", new NativeObject.TokenListener(){

            @Override
            public void OnError(int errorCode, String token) {
                if (resultCallback != null) {
                    if (errorCode == 0) {
                        resultCallback.onSuccess(token);
                    } else {
                        resultCallback.onError(errorCode);
                    }
                }
            }
        });
    }

    private MessageHandler getMessageHandler(String objectName) {
        return this.messageHandlerMap.get(objectName);
    }

    private MessageContent newMessageContent(String objectName, byte[] content) {
        Constructor<? extends MessageContent> constructor = this.messageContentConstructorMap.get(objectName);
        MessageContent result = null;
        if (constructor == null || content == null) {
            return new UnknownMessage(content);
        }
        try {
            result = constructor.newInstance(new Object[]{content});
        }
        catch (Exception e) {
            result = new UnknownMessage(content);
            FwLog.write(1, 128, "L-decode_msg-E", "msg_type|stacks", objectName, FwLog.stackToString(e));
        }
        return result;
    }

    private void initFileTransferClient() {
        Configuration.Builder builder = new Configuration.Builder();
        Configuration configuration = builder.connectTimeout(30).readTimeout(60).build();
        FileTransferClient.init(configuration);
        FileTransferClient.getInstance().setContext(this.mContext);
    }

    public String getOfflineMessageDuration() {
        return this.nativeObj.GetOfflineMessageDuration();
    }

    public void setOfflineMessageDuration(String duration, final IResultCallback<Long> callback) {
        this.nativeObj.SetOfflineMessageDuration(duration, new NativeObject.SetOfflineMessageDurationListener(){

            @Override
            public void onSuccess(long version) {
                if (callback != null) {
                    callback.onSuccess(version);
                }
            }

            @Override
            public void onError(int code) {
                if (callback != null) {
                    callback.onError(code);
                }
            }
        });
    }

    public void switchAppKey(String appKey, String deviceId) {
        this.disconnect(false);
        this.appKey = appKey;
        this.deviceId = deviceId;
        NavigationCacheHelper.clearCache(this.mContext);
        NavigationCacheHelper.clearNaviCache(this.mContext);
        this.nativeObj.InitClient(appKey, this.mContext.getPackageName(), deviceId, this.dbPath, FileUtils.getCachePath(this.mContext, "ronglog"));
        this.mFileServer = null;
    }

    public Message getTheFirstUnreadMessage(int conversationType, String targetId) {
        NativeObject.Message nativeMsg = this.nativeObj.GetTheFirstUnreadMessage(conversationType, targetId);
        if (nativeMsg == null) {
            return null;
        }
        Message message = new Message(nativeMsg);
        MessageContent content = this.renderMessageContent(nativeMsg.getObjectName(), nativeMsg.getContent(), message);
        message.setContent(content);
        return message;
    }

    boolean setMessageReadTime(long messageId, long timestamp) {
        return this.nativeObj.SetReadTime(messageId, timestamp);
    }

    public void setReconnectKickEnable(boolean enable) {
        this.enableReconnectKick = enable;
    }

    public void SetPushNotificationListener(PushNotificationListener listener) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        this.nativeObj.SetPushNotificationListener(listener);
    }

    public void exitRTCRoom(String roomId, final OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            throw new IllegalArgumentException("messages \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.ExitRTCRoom(roomId, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long sendTime) {
                if (callback != null) {
                    if (code == 0) {
                        callback.onSuccess();
                    } else {
                        callback.onError(code);
                    }
                }
            }
        });
    }

    public void getRTCUsers(String roomId, int order, final IResultCallback<List<RTCUser>> callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            throw new IllegalArgumentException("messages \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.GetRTCUsers(roomId, order, new NativeObject.RTCUserInfoListener(){

            @Override
            public void OnSuccess(RTCUser[] data, String token) {
                callback.onSuccess(Arrays.asList(data));
            }

            @Override
            public void OnError(int status) {
                callback.onError(status);
            }
        });
    }

    public void getRTCUserData(String roomId, int order, final IResultCallback<List<RTCUser>> callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            throw new IllegalArgumentException("messages \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.GetRTCUserData(roomId, order, new NativeObject.RTCUserInfoListener(){

            @Override
            public void OnSuccess(RTCUser[] data, String token) {
                callback.onSuccess(Arrays.asList(data));
            }

            @Override
            public void OnError(int status) {
                callback.onError(status);
            }
        });
    }

    public void sendRTCPing(String roomId, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            throw new IllegalArgumentException("messages \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.SendRTCPing(roomId, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long sendTime) {
                if (callback != null) {
                    if (code == 0) {
                        callback.onSuccess();
                    } else {
                        callback.onError(code);
                    }
                }
            }
        });
    }

    public boolean useRTCOnly() {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        return this.nativeObj.UseRTCOnly();
    }

    public void rtcPutInnerDatum(String roomId, int type, String key, String value, String objectName, String content, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            throw new IllegalArgumentException("roomId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.RTCPutInnerDatum(roomId, type, key, value, objectName, content, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long sendTime) {
                if (callback != null) {
                    if (code == 0) {
                        callback.onSuccess();
                    } else {
                        callback.onError(code);
                    }
                }
            }
        });
    }

    public void rtcPutOuterDatum(String roomId, int type, String key, String value, String objectName, String content, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            throw new IllegalArgumentException("roomId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.RTCPutOuterDatum(roomId, type, key, value, objectName, content, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long sendTime) {
                if (callback != null) {
                    if (code == 0) {
                        callback.onSuccess();
                    } else {
                        callback.onError(code);
                    }
                }
            }
        });
    }

    public void rtcDeleteInnerData(String roomId, int type, String[] keys, String objectName, String content, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            throw new IllegalArgumentException("roomId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.RTCDeleteInnerData(roomId, type, keys, objectName, content, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long sendTime) {
                if (callback != null) {
                    if (code == 0) {
                        callback.onSuccess();
                    } else {
                        callback.onError(code);
                    }
                }
            }
        });
    }

    public void rtcDeleteOuterData(String roomId, int type, String[] keys, String objectName, String content, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            throw new IllegalArgumentException("roomId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.RTCDeleteOuterData(roomId, type, keys, objectName, content, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long sendTime) {
                if (callback != null) {
                    if (code == 0) {
                        callback.onSuccess();
                    } else {
                        callback.onError(code);
                    }
                }
            }
        });
    }

    public void rtcGetInnerData(String roomId, int type, String[] keys, final IResultCallback<Map<String, String>> callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            throw new IllegalArgumentException("roomId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.RTCGetInnerData(roomId, type, keys, new NativeObject.RTCDataListener(){

            @Override
            public void OnSuccess(Map<String, String> data) {
                callback.onSuccess(data);
            }

            @Override
            public void OnError(int status) {
                callback.onError(status);
            }
        });
    }

    public void rtcGetOuterData(String roomId, int type, String[] keys, final IResultCallback<Map<String, String>> callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            throw new IllegalArgumentException("roomId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.RTCGetOuterData(roomId, type, keys, new NativeObject.RTCDataListener(){

            @Override
            public void OnSuccess(Map<String, String> data) {
                callback.onSuccess(data);
            }

            @Override
            public void OnError(int status) {
                callback.onError(status);
            }
        });
    }

    public void joinRTCRoomAndGetData(String roomId, int roomType, final IResultCallbackEx<List<RTCUser>, String> callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            throw new IllegalArgumentException("messages \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.JoinRTCRoomAndGetData(roomId, roomType, new NativeObject.RTCUserInfoListener(){

            @Override
            public void OnSuccess(RTCUser[] data, String token) {
                callback.onSuccess(Arrays.asList(data), token);
            }

            @Override
            public void OnError(int status) {
                callback.onError(status);
            }
        });
    }

    public void getRTCConfig(String model, String osVersion, long timestamp, final NativeObject.RTCConfigListener callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        this.nativeObj.GetRTCConfig(model, osVersion, timestamp, new NativeObject.RTCConfigListener(){

            @Override
            public void onSuccess(String config, long version) {
                callback.onSuccess(config, version);
            }

            @Override
            public void onError(int status) {
                callback.onError(status);
            }
        });
    }

    void getRTCToken(String roomId, final IResultCallback<String> resultCallback) {
        this.nativeObj.RTCGetToken(roomId, new NativeObject.TokenListener(){

            @Override
            public void OnError(int errorCode, String token) {
                if (resultCallback != null) {
                    if (errorCode == 0) {
                        resultCallback.onSuccess(token);
                    } else {
                        resultCallback.onError(errorCode);
                    }
                }
            }
        });
    }

    public static interface PushNotificationListener {
        public void OnPushNotificationChanged(long var1);
    }

    public static interface OnReceiveMessageListenerEx {
        public boolean onReceived(Message var1, int var2);
    }

    public static interface OnReceiveMessageListener {
        public void onReceived(Message var1, int var2, boolean var3, boolean var4, int var5);
    }

    public static interface GetNotificationQuietHoursCallback {
        public void onSuccess(String var1, int var2);

        public void onError(int var1);
    }

    public static interface IDownloadMediaFileCallback<T>
    extends IDownloadMediaMessageCallback<T> {
        public void onFileNameChanged(String var1);
    }

    public static interface IDownloadMediaMessageCallback<T> {
        public void onSuccess(T var1);

        public void onProgress(int var1);

        public void onCanceled();

        public void onError(int var1);
    }

    public static interface ISendMediaMessageCallback<T> {
        public void onAttached(T var1);

        public void onSuccess(T var1);

        public void onProgress(T var1, int var2);

        public void onError(T var1, int var2);

        public void onCanceled(T var1);
    }

    public static interface IResultProgressCallback<T> {
        public void onSuccess(T var1);

        public void onProgress(int var1);

        public void onError(int var1);

        public void onCanceled(int var1);
    }

    public static interface ISendMessageCallback<T> {
        public void onAttached(T var1);

        public void onSuccess(T var1);

        public void onError(T var1, int var2);
    }

    public static interface IResultCallbackEx<T, K> {
        public void onSuccess(T var1, K var2);

        public void onError(int var1);
    }

    public static interface ConnectResultCallback<T> {
        public void onSuccess(T var1);

        public void onError(int var1);

        public void onTerminal(int var1);
    }

    public static interface IResultCallback<T> {
        public void onSuccess(T var1);

        public void onError(int var1);
    }

    public static interface OperationCallback {
        public void onSuccess();

        public void onError(int var1);
    }

    public static interface ICodeListener {
        public void onChanged(int var1);
    }

    public static interface ICodeCallback {
        public void onResult(int var1);
    }

    public static enum BlacklistStatus {
        EXIT_BLACK_LIST(0),
        NOT_EXIT_BLACK_LIST(1);

        private int value = 1;

        private BlacklistStatus(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static BlacklistStatus setValue(int code) {
            for (BlacklistStatus c : BlacklistStatus.values()) {
                if (code != c.getValue()) continue;
                return c;
            }
            return NOT_EXIT_BLACK_LIST;
        }
    }

    private static class ConnectHandler
    extends Handler {
        private boolean mConnectionPolicyEnable;
        private NativeObject.ConnectionEntry[] mConnectionEntries;
        private IResultCallback<String> mCallback;
        private boolean mIsReconnect;
        private String mToken;
        private String mUserId;
        private boolean mInForeground;

        ConnectHandler() {
        }

        public void connect(String token, String userId, boolean connectionPolicyEnable, NativeObject.ConnectionEntry[] connectionEntries, boolean isReconnect, boolean inForeground, IResultCallback<String> callback) {
            this.mConnectionPolicyEnable = connectionPolicyEnable;
            this.mConnectionEntries = connectionEntries;
            this.mCallback = callback;
            this.mIsReconnect = isReconnect;
            this.mInForeground = inForeground;
            this.mToken = token;
            this.mUserId = userId;
            this.sendEmptyMessage(0);
        }

        public void handleMessage(android.os.Message msg) {
            NativeObject.ConnectionEntry[] connectionEntries = this.mConnectionPolicyEnable ? this.mConnectionEntries : new NativeObject.ConnectionEntry[]{this.mConnectionEntries[msg.what]};
            final int times = msg.what + 1;
            RLog.d(NativeClient.TAG, "[connect] tryConnect: times = " + times + ", isRetry = " + this.mIsReconnect + ", userPolicy = " + this.mConnectionPolicyEnable);
            client.tryConnect(this.mToken, this.mUserId, this.mConnectionPolicyEnable, connectionEntries, this.mIsReconnect, this.mInForeground, new ConnectResultCallback<String>(){

                @Override
                public void onSuccess(String userId) {
                    RLog.d(NativeClient.TAG, "[connect] tryConnect::onSuccess userId = " + userId);
                    ConnectHandler.this.mCallback.onSuccess(userId);
                }

                @Override
                public void onError(int code) {
                    RLog.d(NativeClient.TAG, "[connect] tryConnect::onError code = " + code + ", times = " + times + ", connectionEntries.length = " + ConnectHandler.this.mConnectionEntries.length);
                    if (ConnectHandler.this.mConnectionPolicyEnable || times >= ConnectHandler.this.mConnectionEntries.length) {
                        ConnectHandler.this.mCallback.onError(code);
                    } else {
                        ConnectHandler.this.sendEmptyMessageDelayed(times, 0L);
                    }
                }

                @Override
                public void onTerminal(int code) {
                    RLog.d(NativeClient.TAG, "[connect] tryConnect::onTerminal code = " + code + ", times = " + times + ", connectionEntires.length = " + ConnectHandler.this.mConnectionEntries.length);
                    ConnectHandler.this.mCallback.onError(code);
                }
            });
        }
    }
}

