/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.filetransfer;

import io.rong.imlib.filetransfer.CallDispatcher;
import io.rong.imlib.filetransfer.CancelCallback;
import io.rong.imlib.filetransfer.PauseCallback;
import io.rong.imlib.filetransfer.Request;
import java.util.concurrent.Future;

public class Call {
    private final Request request;
    private final CallDispatcher dispatcher;

    private Call(CallDispatcher dispatcher, Request request) {
        this.request = request;
        this.dispatcher = dispatcher;
    }

    public static Call create(CallDispatcher dispatcher, Request request) {
        return new Call(dispatcher, request);
    }

    public void enqueue() {
        AsyncCall asyncCall = new AsyncCall();
        this.dispatcher.enqueue(asyncCall);
    }

    class AsyncCall
    implements Runnable {
        protected Future future;

        AsyncCall() {
        }

        public Object tag() {
            return ((Call)Call.this).request.tag;
        }

        public void cancel(CancelCallback cancelCallback) {
            if (this.future != null && !this.future.isDone()) {
                this.future.cancel(true);
                this.future = null;
            }
            if (cancelCallback != null) {
                cancelCallback.onCanceled(((Call)Call.this).request.tag);
            }
            if (((Call)Call.this).request.requestCallBack != null && Call.this.dispatcher.inReadyCalls(((Call)Call.this).request.tag)) {
                ((Call)Call.this).request.requestCallBack.onCanceled(((Call)Call.this).request.tag);
            }
        }

        public void pause(PauseCallback pauseCallback) {
            ((Call)Call.this).request.info.setStop(true);
            pauseCallback.onPaused(((Call)Call.this).request.tag);
        }

        @Override
        public void run() {
            if (((Call)Call.this).request.isMessage) {
                Call.this.request.sendRequest();
            } else {
                Call.this.request.sendRequestForNoneMessage();
            }
            Call.this.dispatcher.finish(this);
        }
    }
}

