/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.filetransfer;

import android.content.Context;
import android.content.res.Resources;
import android.text.TextUtils;
import io.rong.common.FileUtils;
import io.rong.common.RLog;
import io.rong.imlib.filetransfer.Call;
import io.rong.imlib.filetransfer.CallDispatcher;
import io.rong.imlib.filetransfer.CancelCallback;
import io.rong.imlib.filetransfer.Configuration;
import io.rong.imlib.filetransfer.FtConst;
import io.rong.imlib.filetransfer.PauseCallback;
import io.rong.imlib.filetransfer.PrivateRequest;
import io.rong.imlib.filetransfer.QiniuRequest;
import io.rong.imlib.filetransfer.Request;
import io.rong.imlib.filetransfer.RequestOption;
import io.rong.imlib.model.FileInfo;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class FileTransferClient {
    private static final String TAG = FileTransferClient.class.getSimpleName();
    private Configuration configuration;
    private CallDispatcher dispatcher;
    private FtConst.ServiceType serviceType = FtConst.ServiceType.QI_NIU;
    private static FileTransferClient sInstance;
    private String mediaPath;
    private Context mContext;
    private Map<String, Boolean> downloadMap = new HashMap<String, Boolean>();

    private FileTransferClient(Configuration config) {
        this.configuration = config;
        this.dispatcher = new CallDispatcher();
    }

    public static void init(Configuration config) {
        if (sInstance == null) {
            sInstance = new FileTransferClient(config);
        }
    }

    public void setContext(Context context) {
        this.mContext = context;
    }

    public void setServiceType(FtConst.ServiceType serviceType) {
        this.serviceType = serviceType;
    }

    public static FileTransferClient getInstance() {
        return sInstance;
    }

    public void upload(int id, String url, String token, RequestOption option) {
        Request request = this.serviceType == FtConst.ServiceType.QI_NIU ? new QiniuRequest(this.configuration, option.getRequestCallBack()) : new PrivateRequest(this.configuration, option.getRequestCallBack());
        request.token = token;
        request.mimeType = option.getMimeType();
        request.method = "POST";
        request.serverIp = option.getServerIp();
        request.url = url;
        request.tag = id;
        request.fileName = option.getFileName();
        request.isMessage = true;
        request.requestCallBack = option.getRequestCallBack();
        Call call = Call.create(this.dispatcher, request);
        call.enqueue();
    }

    public void download(int id, String url, long length, RequestOption option) {
        FileInfo info = new FileInfo("", url);
        info.setFileName(option.getFileName());
        info.setStop(false);
        info.setMessageId(option.getMessageId());
        String pausePath = FileUtils.getTempFilePath(this.mContext, id);
        Request request = this.serviceType == FtConst.ServiceType.QI_NIU ? new QiniuRequest(info, this.configuration, option.getRequestCallBack(), pausePath) : new PrivateRequest(info, this.configuration, option.getRequestCallBack(), pausePath);
        request.mimeType = option.getMimeType();
        request.method = "GET";
        request.url = url;
        request.tag = id;
        request.fileName = option.getFileName();
        request.fileLength = length;
        request.isMessage = true;
        request.requestCallBack = option.getRequestCallBack();
        Call call = Call.create(this.dispatcher, request);
        call.enqueue();
    }

    public void download(String uid, String url, RequestOption option) {
        FileInfo info = new FileInfo("", url);
        info.setFileName(option.getFileName());
        info.setStop(false);
        info.setMessageId(option.getMessageId());
        String pausePath = FileUtils.getTempFilePath(this.mContext, uid);
        Request request = this.serviceType == FtConst.ServiceType.QI_NIU ? new QiniuRequest(info, this.configuration, option.getRequestCallBack(), pausePath) : new PrivateRequest(info, this.configuration, option.getRequestCallBack(), pausePath);
        request.mimeType = option.getMimeType();
        request.method = "GET";
        request.url = url;
        request.tag = uid;
        request.fileName = option.getFileName();
        request.requestCallBack = option.getRequestCallBack();
        request.isMessage = false;
        Call call = Call.create(this.dispatcher, request);
        call.enqueue();
    }

    public void cancel(int id, CancelCallback callback) {
        if (id > 0) {
            this.dispatcher.cancel(id, callback);
        }
    }

    public void pause(int id, PauseCallback callback) {
        if (id > 0) {
            this.dispatcher.pause(id, callback);
        }
    }

    public void pause(String tag, PauseCallback callback) {
        if (!TextUtils.isEmpty((CharSequence)tag)) {
            this.dispatcher.pause(tag, callback);
        }
    }

    public void cancelAll() {
        this.dispatcher.cancelAll();
        if (this.downloadMap != null) {
            this.downloadMap.clear();
        }
    }

    public String getMediaPath() {
        return this.mediaPath;
    }

    public void setMediaPath(String mediaPath) {
        this.mediaPath = mediaPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkSupportResumeTransfer(String url) {
        HttpURLConnection conn = null;
        boolean support = true;
        try {
            URL u = new URL(url);
            conn = (HttpURLConnection)u.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Range", "bytes=0-1");
            if (conn.getResponseCode() != 206) {
                support = false;
            }
        }
        catch (Exception e) {
            RLog.e(TAG, "checkSupportResumeTransfer", e);
            support = false;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
                conn = null;
            }
        }
        return support;
    }

    public int getDownloadEachSliceLength() {
        int length = 0;
        if (this.mContext != null) {
            Resources resources = this.mContext.getResources();
            length = resources.getInteger(resources.getIdentifier("rc_resume_file_transfer_size_each_slice", "integer", this.mContext.getPackageName()));
        }
        return length;
    }

    public void addToFileDownloadMap(int messageId, boolean isDownloading) {
        String md5 = FileUtils.getTempFileMD5(this.mContext, messageId);
        this.downloadMap.put(md5, isDownloading);
    }

    public void addToFileDownloadMap(String tag, boolean isDownloading) {
        String md5 = FileUtils.getTempFileMD5(this.mContext, tag);
        this.downloadMap.put(md5, isDownloading);
    }

    public void removeFromFileDownloadMap(int messageId) {
        String md5 = FileUtils.getTempFileMD5(this.mContext, messageId);
        if (this.downloadMap != null) {
            this.downloadMap.remove(md5);
        }
    }

    public void removeFromFileDownloadMap(String tag) {
        String md5 = FileUtils.getTempFileMD5(this.mContext, tag);
        if (this.downloadMap != null) {
            this.downloadMap.remove(md5);
        }
    }

    public boolean getDownloadingFromMap(Context context, int messageId) {
        String md5 = FileUtils.getTempFileMD5(context, messageId);
        if (this.downloadMap != null && this.downloadMap.size() > 0) {
            return this.downloadMap.get(md5);
        }
        return false;
    }

    public boolean getDownloadingFromMap(Context context, String tag) {
        String md5 = FileUtils.getTempFileMD5(context, tag);
        if (this.downloadMap != null && this.downloadMap.size() > 0) {
            return this.downloadMap.get(md5);
        }
        return false;
    }
}

