/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.filetransfer;

import android.text.TextUtils;
import io.rong.common.RLog;
import io.rong.imlib.filetransfer.Configuration;
import io.rong.imlib.filetransfer.FtConst;
import io.rong.imlib.filetransfer.Request;
import io.rong.imlib.filetransfer.RequestCallBack;
import io.rong.imlib.model.FileInfo;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.json.JSONObject;

public class PrivateRequest
extends Request {
    private static final String Boundary = "--526f6e67436c6f7564";
    private static final String TAG = "rc_url";
    private static final String TYPE = "type";
    private static final String PATH = "path";

    public PrivateRequest(Configuration config, RequestCallBack requestCallBack) {
        super(config, requestCallBack);
    }

    public PrivateRequest(FileInfo fileInfo, Configuration config, RequestCallBack requestCallBack, String pausePath) {
        super(fileInfo, config, requestCallBack, pausePath);
    }

    @Override
    public String getContentType() {
        return "multipart/form-data; boundary=--526f6e67436c6f7564";
    }

    @Override
    public long getContentLength() {
        File file = new File(this.url);
        String end = "\r\n----526f6e67436c6f7564--";
        return (long)this.getFormData().length() + file.length() + (long)end.length();
    }

    @Override
    public FtConst.MimeType getMimeType() {
        return this.mimeType;
    }

    @Override
    public String getBoundary() {
        return Boundary;
    }

    @Override
    public String getFormData() {
        String formData = "--";
        formData = formData + Boundary;
        formData = formData + "\r\nContent-Disposition: form-data; name=\"token\"\r\n\r\n";
        formData = formData + this.token;
        formData = formData + "\r\n--";
        formData = formData + Boundary;
        formData = formData + "\r\nContent-Disposition: form-data; name=\"key\"\r\n\r\n";
        formData = formData + this.fileName;
        formData = formData + "\r\n--";
        formData = formData + Boundary;
        formData = formData + "\r\nContent-Disposition: form-data; name=\"file\"; filename=\"";
        formData = formData + this.fileNameEncoding(this.url.substring(this.url.lastIndexOf("/") + 1));
        formData = formData + "\"\r\nContent-Type: ";
        formData = formData + this.mimeType.getName();
        formData = formData + "\r\n\r\n";
        return formData;
    }

    @Override
    public String getUploadedUrl(String data) {
        String url = null;
        if (!TextUtils.isEmpty((CharSequence)data)) {
            try {
                JSONObject jsonObject = new JSONObject(data);
                JSONObject body = jsonObject.getJSONObject(TAG);
                int type = body.getInt(TYPE);
                String path = body.getString(PATH);
                url = type == 1 ? path : this.serverIp + path;
            }
            catch (Exception e) {
                RLog.e(TAG, "getUploadedUrl error:" + data);
                RLog.e(TAG, "getUploadedUrl ", e);
            }
        }
        return url;
    }

    private String fileNameEncoding(String fileName) {
        try {
            return URLEncoder.encode(fileName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            RLog.e(TAG, "fileNameEncoding ", e);
            return fileName;
        }
    }
}

