/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.model;

import android.os.Parcel;
import android.os.Parcelable;
import io.rong.common.ParcelUtils;
import java.util.List;

public class MentionedInfo
implements Parcelable {
    private MentionedType type;
    private List<String> userIdList;
    private String mentionedContent;
    public static final Parcelable.Creator<MentionedInfo> CREATOR = new Parcelable.Creator<MentionedInfo>(){

        public MentionedInfo createFromParcel(Parcel source) {
            return new MentionedInfo(source);
        }

        public MentionedInfo[] newArray(int size) {
            return new MentionedInfo[size];
        }
    };

    public MentionedInfo() {
    }

    public MentionedInfo(Parcel in) {
        this.setType(MentionedType.valueOf(ParcelUtils.readIntFromParcel(in)));
        this.setMentionedUserIdList(ParcelUtils.readListFromParcel(in, String.class));
        this.setMentionedContent(ParcelUtils.readFromParcel(in));
    }

    public MentionedInfo(MentionedType type, List<String> userIdList, String mentionedContent) {
        if (type != null && type.equals((Object)MentionedType.ALL)) {
            this.userIdList = null;
        } else if (type != null && type.equals((Object)MentionedType.PART)) {
            if (userIdList == null || userIdList.size() == 0) {
                throw new IllegalArgumentException("When mentioned parts of the group members, userIdList can't be null!");
            }
            this.userIdList = userIdList;
        }
        this.type = type;
        this.mentionedContent = mentionedContent;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel(dest, this.getType().getValue());
        ParcelUtils.writeToParcel(dest, this.getMentionedUserIdList());
        ParcelUtils.writeToParcel(dest, this.getMentionedContent());
    }

    public MentionedType getType() {
        return this.type;
    }

    public List<String> getMentionedUserIdList() {
        return this.userIdList;
    }

    public String getMentionedContent() {
        return this.mentionedContent;
    }

    public void setType(MentionedType type) {
        this.type = type;
    }

    public void setMentionedUserIdList(List<String> userList) {
        this.userIdList = userList;
    }

    public void setMentionedContent(String content) {
        this.mentionedContent = content;
    }

    public static enum MentionedType {
        NONE(0),
        ALL(1),
        PART(2);

        private int value;

        private MentionedType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static MentionedType valueOf(int value) {
            for (MentionedType type : MentionedType.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            return NONE;
        }
    }
}

