/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.navigation;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import io.rong.common.RLog;
import io.rong.common.fwlog.FwLog;
import io.rong.imlib.NativeObject;
import io.rong.imlib.navigation.LocationConfig;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NavigationCacheHelper {
    private static final String TAG = "NavigationCacheHelper";
    private static final String NAVIGATION_PREFERENCE = "RongNavigation";
    private static final String NAVIGATION_IP_PREFERENCE = "RongNavigationIp";
    private static final long TIME_OUT = 0x6DDD00L;
    private static final String DEFAULT_VIDEO_TIME = "300";
    private static final String NAVI_TAG = "navi";
    private static final String CODE = "code";
    private static final String CMP_SERVER = "server";
    private static final String BACKUP_SERVER = "bs";
    private static final String VOIP_SERVER = "voipServer";
    private static final String MEDIA_SERVER = "uploadServer";
    private static final String LOCATION_CONFIG = "location";
    private static final String CACHED_TIME = "cached_time";
    private static final String APP_KEY = "appKey";
    private static final String TOKEN = "token";
    private static final String VOIP_CALL_INFO = "voipCallInfo";
    private static final String LOG_MONITOR = "monitor";
    private static final String OPEN_MP = "openMp";
    private static final String OPEN_US = "openUS";
    private static final String GET_REMOTE_SERVICE = "historyMsg";
    private static final String GET_GROUP_MESSAGE_LIMIT = "grpMsgLimit";
    private static final String GET_CHATROOM_HISTORY_SERVICE = "chatroomMsg";
    private static final String JOIN_MULTI_CHATROOM = "joinMChrm";
    private static final String USER_ID = "userId";
    private static final String TYPE = "type";
    private static final String LAST_SUCCESS_IP = "lastSuccessIp";
    private static final String LAST_SUCCESS_NAVI = "lastSuccessNavi";
    private static final String COMPLEX_CONNECTION = "complexConnection";
    public static final String CONN_POLICY = "connPolicy";
    private static final String VIDEO_TIMES = "videoTimes";
    private static long sCacheTime = 0L;
    private static boolean userPolicy = false;
    private static final String NAVI_SPLIT_SYMBOL = ";";
    private static final String OFFLINE_LOG_SERVER = "offlinelogserver";
    private static final String ONLINE_LOG_SERVER = "onlinelogserver";

    public static boolean isCacheValid(Context context, String appKey, String token, String naviUrls) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_PREFERENCE, 0);
        String cachedKey = sharedPreferences.getString(APP_KEY, null);
        String cachedToken = sharedPreferences.getString(TOKEN, null);
        String cachedCMP = sharedPreferences.getString(CMP_SERVER, null);
        String userId = sharedPreferences.getString(USER_ID, null);
        String cacheNaviDomainList = NavigationCacheHelper.getLastSuccessNaviDomainList(context);
        sCacheTime = sharedPreferences.getLong(CACHED_TIME, 0L);
        long currentTime = System.currentTimeMillis() - (long)TimeZone.getDefault().getRawOffset();
        boolean isValid = cachedKey != null && cachedKey.equals(appKey) && cachedToken != null && cachedToken.equals(token) && !NavigationCacheHelper.isCMPInvalid(cachedCMP) && currentTime - sCacheTime <= 0x6DDD00L && !TextUtils.isEmpty((CharSequence)userId) && NavigationCacheHelper.isNaviUrlsValid(cacheNaviDomainList, naviUrls);
        FwLog.write(4, 16, "L-get_navi-S", "cache_valid|delta_time", isValid, currentTime - sCacheTime);
        return isValid;
    }

    private static boolean isNaviUrlsValid(String cachedNaviDomain, String naviUrls) {
        if (TextUtils.isEmpty((CharSequence)naviUrls) || TextUtils.isEmpty((CharSequence)cachedNaviDomain)) {
            return false;
        }
        return naviUrls.equals(cachedNaviDomain);
    }

    public static boolean isUSOpened(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getBoolean(OPEN_US, false);
    }

    public static boolean isMPOpened(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getBoolean(OPEN_MP, true);
    }

    public static boolean isCacheTimeout(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_PREFERENCE, 0);
        long cachedTime = sharedPreferences.getLong(CACHED_TIME, 0L);
        long currentTime = System.currentTimeMillis() - (long)TimeZone.getDefault().getRawOffset();
        return cachedTime != 0L && currentTime - cachedTime > 0x6DDD00L;
    }

    public static long getCachedTime() {
        return sCacheTime;
    }

    public static void clearCache(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_PREFERENCE, 0);
        sharedPreferences.edit().clear().commit();
    }

    public static void clearNaviCache(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_IP_PREFERENCE, 0);
        sharedPreferences.edit().clear().commit();
    }

    public static String getCMPServerString(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_PREFERENCE, 0);
        String cmp = sharedPreferences.getString(CMP_SERVER, null);
        String backup = sharedPreferences.getString(BACKUP_SERVER, null);
        if (!TextUtils.isEmpty((CharSequence)backup)) {
            cmp = cmp + "," + backup;
        }
        return cmp;
    }

    private static List<NativeObject.ConnectionEntry> getComplexConnectionEntries(Context context) {
        ArrayList<NativeObject.ConnectionEntry> connectionEntryList;
        block4: {
            String[] entryStrArray;
            String complexConnectionStr;
            block3: {
                String[] backups;
                SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_PREFERENCE, 0);
                complexConnectionStr = sharedPreferences.getString(COMPLEX_CONNECTION, null);
                connectionEntryList = new ArrayList<NativeObject.ConnectionEntry>();
                if (complexConnectionStr != null) break block3;
                String cmp = sharedPreferences.getString(CMP_SERVER, null);
                if (cmp == null) {
                    return connectionEntryList;
                }
                NativeObject.ConnectionEntry connectionEntry = new NativeObject.ConnectionEntry();
                String host = cmp.substring(0, cmp.indexOf(58));
                int port = Integer.parseInt(cmp.substring(cmp.indexOf(58) + 1, cmp.length()));
                connectionEntry.setHost(host);
                connectionEntry.setPort(port);
                connectionEntryList.add(connectionEntry);
                String backupStr = sharedPreferences.getString(BACKUP_SERVER, null);
                if (TextUtils.isEmpty((CharSequence)backupStr)) break block4;
                for (String backup : backups = backupStr.split(",")) {
                    host = backup.substring(0, backup.indexOf(58));
                    port = Integer.parseInt(backup.substring(backup.indexOf(58) + 1, backup.length()));
                    connectionEntry = new NativeObject.ConnectionEntry();
                    connectionEntry.setHost(host);
                    connectionEntry.setPort(port);
                    connectionEntryList.add(connectionEntry);
                }
                break block4;
            }
            for (String entryStr : entryStrArray = complexConnectionStr.split(",")) {
                String[] elements = entryStr.split(":");
                String host = elements[0];
                int port = Integer.parseInt(elements[1]);
                int error = Integer.parseInt(elements[2]);
                int duration = Integer.parseInt(elements[3]);
                NativeObject.ConnectionEntry connectionEntry = new NativeObject.ConnectionEntry();
                connectionEntry.setHost(host);
                connectionEntry.setPort(port);
                connectionEntry.setError(error);
                connectionEntry.setDuration(duration);
                connectionEntryList.add(connectionEntry);
            }
        }
        return connectionEntryList;
    }

    public static NativeObject.ConnectionEntry[] getSortedComplexConnectionEntries(Context context) {
        List<NativeObject.ConnectionEntry> connectionEntryList = NavigationCacheHelper.getComplexConnectionEntries(context);
        NativeObject.ConnectionEntry[] connectionEntries = connectionEntryList.toArray(new NativeObject.ConnectionEntry[connectionEntryList.size()]);
        NavigationCacheHelper.sortComplexConnectionEntry(connectionEntries);
        return connectionEntries;
    }

    private static void sortComplexConnectionEntry(NativeObject.ConnectionEntry[] connectionEntries) {
        if (connectionEntries == null) {
            return;
        }
        Arrays.sort(connectionEntries, new Comparator<NativeObject.ConnectionEntry>(){

            @Override
            public int compare(NativeObject.ConnectionEntry o1, NativeObject.ConnectionEntry o2) {
                if (o1.getError() == 0 && o2.getError() == 0) {
                    return o1.getDuration() - o2.getDuration();
                }
                return o1.getError() == 0 ? -1 : 0;
            }
        });
    }

    public static void updateComplexConnectionEntry(Context context, NativeObject.ConnectionEntry entry) {
        List<NativeObject.ConnectionEntry> connectionEntryList = NavigationCacheHelper.getComplexConnectionEntries(context);
        connectionEntryList.remove(entry);
        connectionEntryList.add(entry);
        NativeObject.ConnectionEntry[] connectionEntries = connectionEntryList.toArray(new NativeObject.ConnectionEntry[connectionEntryList.size()]);
        NavigationCacheHelper.sortComplexConnectionEntry(connectionEntries);
        StringBuilder sb = new StringBuilder();
        for (NativeObject.ConnectionEntry connectionEntry : connectionEntries) {
            sb.append(connectionEntry.getHost());
            sb.append(":");
            sb.append(connectionEntry.getPort());
            sb.append(":");
            sb.append(connectionEntry.getError());
            sb.append(":");
            sb.append(connectionEntry.getDuration());
            sb.append(",");
        }
        String complexConnectionStr = sb.toString();
        complexConnectionStr = complexConnectionStr.substring(0, complexConnectionStr.length() - 1);
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_PREFERENCE, 0);
        sharedPreferences.edit().putString(COMPLEX_CONNECTION, complexConnectionStr).apply();
    }

    public static void setSuccessedCpmToEnd(Context context) {
        List<NativeObject.ConnectionEntry> connectionEntryList = NavigationCacheHelper.getComplexConnectionEntries(context);
        NativeObject.ConnectionEntry[] connectionEntries = connectionEntryList.toArray(new NativeObject.ConnectionEntry[connectionEntryList.size()]);
        NavigationCacheHelper.sortComplexConnectionEntry(connectionEntries);
        StringBuilder sb = new StringBuilder();
        if (connectionEntries.length > 0 && connectionEntries[0].getError() == 0) {
            for (int i = 1; i < connectionEntries.length; ++i) {
                sb.append(connectionEntries[i].getHost());
                sb.append(":");
                sb.append(connectionEntries[i].getPort());
                sb.append(":");
                sb.append(-1);
                sb.append(":");
                sb.append(0);
                sb.append(",");
            }
            sb.append(connectionEntries[0].getHost());
            sb.append(":");
            sb.append(connectionEntries[0].getPort());
            sb.append(":");
            sb.append(-1);
            sb.append(":");
            sb.append(0);
            sb.append(",");
            String complexConnectionStr = sb.toString();
            RLog.i(TAG, "complexConnectionStr\uff1a " + complexConnectionStr);
            complexConnectionStr = complexConnectionStr.substring(0, complexConnectionStr.length() - 1);
            SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_PREFERENCE, 0);
            sharedPreferences.edit().putString(COMPLEX_CONNECTION, complexConnectionStr).apply();
        }
    }

    public static void clearComplexConnectionEntries(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_PREFERENCE, 0);
        sharedPreferences.edit().remove(COMPLEX_CONNECTION).apply();
    }

    public static String getCMPServer(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getString(CMP_SERVER, null);
    }

    public static String getToken(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getString(TOKEN, null);
    }

    public static String getAppKey(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getString(APP_KEY, "");
    }

    public static void updateTime(Context context, long time) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_PREFERENCE, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong(CACHED_TIME, time);
        editor.commit();
    }

    public static void updateLastSuccessIp(Context context, String ip) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_IP_PREFERENCE, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(LAST_SUCCESS_IP, ip);
        editor.commit();
    }

    public static void cacheLastSuccessNaviDomain(Context context, String navi) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_IP_PREFERENCE, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(LAST_SUCCESS_NAVI, navi);
        editor.commit();
    }

    public static String getLastSuccessNaviDomain(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_IP_PREFERENCE, 0);
        return sharedPreferences.getString(LAST_SUCCESS_NAVI, null);
    }

    public static void cacheLastSuccessNaviDomainList(Context context, String naviList) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_IP_PREFERENCE, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(LAST_SUCCESS_NAVI, naviList);
        editor.commit();
    }

    public static String getLastSuccessNaviDomainList(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_IP_PREFERENCE, 0);
        return sharedPreferences.getString(LAST_SUCCESS_NAVI, null);
    }

    public static String getLastSuccessIp(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_IP_PREFERENCE, 0);
        return sharedPreferences.getString(LAST_SUCCESS_IP, null);
    }

    public static String getVoIPCallInfo(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getString(VOIP_CALL_INFO, null);
    }

    public static String getVoIPAddress(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getString(VOIP_SERVER, null);
    }

    public static String getMediaServer(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getString(MEDIA_SERVER, null);
    }

    public static boolean isGetRemoteEnabled(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getBoolean(GET_REMOTE_SERVICE, false);
    }

    public static int getGroupMessageLimit(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getInt(GET_GROUP_MESSAGE_LIMIT, 1000);
    }

    public static String getOfflineLogServer(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getString(OFFLINE_LOG_SERVER, "https://feedback.cn.ronghub.com");
    }

    public static String getOnlineLogServer(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getString(ONLINE_LOG_SERVER, null);
    }

    public static boolean isChatroomHistoryEnabled(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getBoolean(GET_CHATROOM_HISTORY_SERVICE, false);
    }

    public static boolean isJoinMChatroomEnabled(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getBoolean(JOIN_MULTI_CHATROOM, false);
    }

    public static LocationConfig getLocationConfig(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_PREFERENCE, 0);
        String value = sharedPreferences.getString(LOCATION_CONFIG, null);
        if (!TextUtils.isEmpty((CharSequence)value)) {
            try {
                LocationConfig config = new LocationConfig();
                JSONObject jsonObj = new JSONObject(value);
                config.setConfigure(jsonObj.optBoolean("configure"));
                if (jsonObj.has("conversationTypes")) {
                    JSONArray array = jsonObj.optJSONArray("conversationTypes");
                    int[] types = new int[array.length()];
                    for (int j = 0; j < array.length(); ++j) {
                        types[j] = array.optInt(j);
                    }
                    config.setConversationTypes(types);
                }
                config.setMaxParticipant(jsonObj.optInt("maxParticipant"));
                config.setDistanceFilter(jsonObj.optInt("distanceFilter"));
                config.setRefreshInterval(jsonObj.optInt("refreshInterval"));
                return config;
            }
            catch (JSONException e) {
                RLog.e(TAG, "getLocationConfig ", e);
            }
        }
        return null;
    }

    public static int getLogMonitor(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getInt(LOG_MONITOR, 0);
    }

    public static String getUserId(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getString(USER_ID, null);
    }

    public static void cacheRequest(Context context, String appKey, String token) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_PREFERENCE, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        long gmtTimestamp = System.currentTimeMillis() - (long)TimeZone.getDefault().getRawOffset();
        editor.putLong(CACHED_TIME, gmtTimestamp);
        editor.putString(APP_KEY, appKey);
        editor.putString(TOKEN, token);
        editor.commit();
    }

    private static boolean isValidCmp(String cmp) {
        try {
            String pattern = "(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])";
            Pattern pat = Pattern.compile(pattern);
            Matcher mat = pat.matcher(cmp);
            return mat.find();
        }
        catch (PatternSyntaxException e) {
            RLog.e(TAG, "isValidCmp: " + cmp, e);
            return false;
        }
    }

    public static int decode2File(Context context, String data, int httpCode) {
        int DATA_ERROR = 30008;
        int TOKEN_ERROR = 31004;
        int RESOURCE_ERROR = 30007;
        if (TextUtils.isEmpty((CharSequence)data)) {
            RLog.e(TAG, "[connect] decode2File: navi data is empty.");
            return 30008;
        }
        if (!data.contains(CODE)) {
            RLog.e(TAG, "[connect] decode2File: code is empty.");
            return 30008;
        }
        if (data.contains(CODE)) {
            SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_PREFERENCE, 0);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            String value = NavigationCacheHelper.decode(data, "<code>", "</code>");
            if (TextUtils.isEmpty((CharSequence)value)) {
                RLog.e(TAG, "[connect] decode2File: code is empty.");
                return 30008;
            }
            try {
                int code = Integer.parseInt(value);
                if (code != 200) {
                    RLog.e(TAG, "[connect] decode2File: code & httpCode " + code + "-" + httpCode);
                    if (code == 401 && httpCode == 403 || code == 403 && httpCode == 401) {
                        return 31004;
                    }
                    return 30007;
                }
            }
            catch (NumberFormatException e) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                e.printStackTrace(printWriter);
                printWriter.close();
                RLog.e(TAG, "decode2File ", e);
                return 30007;
            }
            value = NavigationCacheHelper.decode(data, "<server>", "</server>");
            if (NavigationCacheHelper.isCMPInvalid(value)) {
                RLog.e(TAG, "[connect] decode2File: cmp is invalid, " + data);
                return 30008;
            }
            editor.putString(CMP_SERVER, value);
            value = NavigationCacheHelper.decode(data, "<userId>", "</userId>");
            if (TextUtils.isEmpty((CharSequence)value)) {
                RLog.e(TAG, "[connect] decode2File: userId is invalid, " + data);
                return 30008;
            }
            editor.putString(USER_ID, value);
            value = NavigationCacheHelper.decode(data, "<bs>", "</bs>");
            if (!TextUtils.isEmpty((CharSequence)value)) {
                editor.putString(BACKUP_SERVER, value);
            }
            if (!TextUtils.isEmpty((CharSequence)(value = NavigationCacheHelper.decode(data, "<uploadServer>", "</uploadServer>")))) {
                editor.putString(MEDIA_SERVER, value);
            }
            if (!TextUtils.isEmpty((CharSequence)(value = NavigationCacheHelper.decode(data, "<location>", "</location>")))) {
                editor.putString(LOCATION_CONFIG, value.replaceAll("&quot;", "\""));
            }
            if (!TextUtils.isEmpty((CharSequence)(value = NavigationCacheHelper.decode(data, "<voipCallInfo>", "</voipCallInfo>")))) {
                editor.putString(VOIP_CALL_INFO, value.replaceAll("&quot;", "\""));
            }
            value = NavigationCacheHelper.decode(data, "<historyMsg>", "</historyMsg>");
            boolean opened = false;
            if (!TextUtils.isEmpty((CharSequence)value)) {
                opened = value.equals("true");
            }
            editor.putBoolean(GET_REMOTE_SERVICE, opened);
            value = NavigationCacheHelper.decode(data, "<grpMsgLimit>", "</grpMsgLimit>");
            if (TextUtils.isEmpty((CharSequence)value)) {
                value = "1000";
            }
            editor.putInt(GET_GROUP_MESSAGE_LIMIT, Integer.valueOf(value).intValue());
            value = NavigationCacheHelper.decode(data, "<chatroomMsg>", "</chatroomMsg>");
            opened = false;
            if (!TextUtils.isEmpty((CharSequence)value)) {
                opened = value.equals("true");
            }
            editor.putBoolean(GET_CHATROOM_HISTORY_SERVICE, opened);
            value = NavigationCacheHelper.decode(data, "<joinMChrm>", "</joinMChrm>");
            opened = false;
            if (!TextUtils.isEmpty((CharSequence)value)) {
                opened = value.equals("true");
            }
            editor.putBoolean(JOIN_MULTI_CHATROOM, opened);
            value = NavigationCacheHelper.decode(data, "<openMp>", "</openMp>");
            opened = true;
            if (!TextUtils.isEmpty((CharSequence)value)) {
                opened = Integer.parseInt(value) == 1;
            }
            editor.putBoolean(OPEN_MP, opened);
            value = NavigationCacheHelper.decode(data, "<openUS>", "</openUS>");
            opened = true;
            if (!TextUtils.isEmpty((CharSequence)value)) {
                opened = Integer.parseInt(value) == 1;
            }
            editor.putBoolean(OPEN_US, opened);
            value = NavigationCacheHelper.decode(data, "<monitor>", "</monitor>");
            if (TextUtils.isEmpty((CharSequence)value)) {
                value = "0";
            }
            editor.putInt(LOG_MONITOR, Integer.valueOf(value).intValue());
            value = NavigationCacheHelper.decode(data, "<type>", "</type>");
            if (TextUtils.isEmpty((CharSequence)value)) {
                value = "0";
            }
            editor.putBoolean(TYPE, Integer.valueOf(value) == 1);
            value = NavigationCacheHelper.decode(data, "<connPolicy>", "</connPolicy>");
            if (TextUtils.isEmpty((CharSequence)value)) {
                value = "0";
            }
            editor.putInt(CONN_POLICY, Integer.valueOf(value).intValue());
            value = NavigationCacheHelper.decode(data, "<videoTimes>", "</videoTimes>");
            if (TextUtils.isEmpty((CharSequence)value)) {
                value = DEFAULT_VIDEO_TIME;
            }
            editor.putInt(VIDEO_TIMES, Integer.valueOf(value).intValue());
            value = NavigationCacheHelper.decode(data, "<offlinelogserver>", "</offlinelogserver>");
            if (!TextUtils.isEmpty((CharSequence)value)) {
                editor.putString(OFFLINE_LOG_SERVER, value);
            }
            if (!TextUtils.isEmpty((CharSequence)(value = NavigationCacheHelper.decode(data, "<onlinelogserver>", "</onlinelogserver>")))) {
                editor.putString(ONLINE_LOG_SERVER, value);
            }
            editor.commit();
            return 0;
        }
        return 30008;
    }

    public static int getVideoLimitTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getInt(VIDEO_TIMES, Integer.valueOf(DEFAULT_VIDEO_TIME).intValue());
    }

    private static boolean isCMPInvalid(String cmp) {
        if (TextUtils.isEmpty((CharSequence)cmp)) {
            return true;
        }
        String[] strs = cmp.split(":");
        return strs.length != 2 || TextUtils.isEmpty((CharSequence)strs[0]) || TextUtils.isEmpty((CharSequence)strs[1]);
    }

    public static boolean getPrivateCloudConfig(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getBoolean(TYPE, false);
    }

    public static boolean isConnPolicyEnable(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAVIGATION_PREFERENCE, 0);
        boolean naviEnabled = sharedPreferences.getInt(CONN_POLICY, 0) == 1;
        RLog.i(TAG, "isConnPolicyEnable, userPolicy = " + userPolicy + ", naviPolicy = " + naviEnabled);
        if (naviEnabled) {
            return true;
        }
        return userPolicy;
    }

    public static void setUserPolicy(boolean enable) {
        RLog.i(TAG, "setUserPolicy, userPolicy = " + enable);
        userPolicy = enable;
    }

    private static String decode(String data, String key1, String key2) {
        int end;
        int start = data.indexOf(key1) + key1.length();
        if (start >= (end = data.indexOf(key2)) || end == 0) {
            return null;
        }
        return data.substring(start, end);
    }

    public static String decode2cmp(Context context, String data, int httpCode) {
        if (TextUtils.isEmpty((CharSequence)data)) {
            RLog.e(TAG, "decode2cmp : navi data invalid");
            return null;
        }
        if (!data.contains(CMP_SERVER) || !data.contains(CODE)) {
            RLog.e(TAG, "decode2cmp : cmp or code invalid");
            return null;
        }
        if (data.contains(CODE)) {
            String value = NavigationCacheHelper.decode(data, "<code>", "</code>");
            if (TextUtils.isEmpty((CharSequence)value)) {
                RLog.e(TAG, "decode2cmp : code invalid");
                return null;
            }
            try {
                int code = Integer.parseInt(value);
                if (code != 200) {
                    RLog.e(TAG, "decode2cmp : code & httpCode " + code + "-" + httpCode);
                    if (code == 401 && httpCode == 403 || code == 403 && httpCode == 401) {
                        return null;
                    }
                    return null;
                }
            }
            catch (NumberFormatException e) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                e.printStackTrace(printWriter);
                RLog.e(TAG, "decode2cmp ", e);
                printWriter.close();
                return null;
            }
            String cmpString = NavigationCacheHelper.decode(data, "<server>", "</server>");
            if (TextUtils.isEmpty((CharSequence)cmpString)) {
                RLog.e(TAG, "decode2cmp : data - " + cmpString);
                return null;
            }
            value = NavigationCacheHelper.decode(data, "<bs>", "</bs>");
            if (!TextUtils.isEmpty((CharSequence)value)) {
                cmpString = cmpString + "," + value;
            }
            RLog.d(TAG, "[connect] decode2cmp cmpString:" + cmpString);
            return cmpString;
        }
        return null;
    }
}

