/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.relinker;

import android.content.Context;
import io.rong.imlib.relinker.MissingLibraryException;
import io.rong.imlib.relinker.ReLinker;
import io.rong.imlib.relinker.ReLinkerInstance;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipFile;

public class ApkLibraryInstaller
implements ReLinker.LibraryInstaller {
    private static final int MAX_TRIES = 5;
    private static final int COPY_BUFFER_SIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void installLibrary(Context context, String[] abis, String mappedLibraryName, File destination, ReLinkerInstance instance) {
        block32: {
            zipFile = null;
            appInfo = context.getApplicationInfo();
            tries = 0;
            while (tries++ < 5) {
                try {
                    zipFile = new ZipFile(new File(appInfo.sourceDir), 1);
                    break;
                }
                catch (IOException var9_10) {
                }
            }
            if (zipFile == null) {
                instance.log("FATAL! Couldn't find application APK!");
                return;
            }
            tries = 0;
lbl15:
            // 6 sources

            while (true) {
                if (tries++ < 5) {
                    jniNameInApk = null;
                    libraryEntry = null;
                    var11_14 = abis;
                    var12_16 = var11_14.length;
                    break block32;
                }
                instance.log("FATAL! Couldn't extract the library from the APK!");
                return;
            }
            finally {
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (IOException var9_11) {}
            }
        }
        for (var13_18 = 0; var13_18 < var12_16; ++var13_18) {
            abi = var11_14[var13_18];
            jniNameInApk = "lib" + File.separatorChar + abi + File.separatorChar + mappedLibraryName;
            libraryEntry = zipFile.getEntry(jniNameInApk);
            if (libraryEntry != null) break;
        }
        if (jniNameInApk != null) {
            instance.log("Looking for %s in APK...", new Object[]{jniNameInApk});
        }
        if (libraryEntry == null) {
            if (jniNameInApk == null) throw new MissingLibraryException(mappedLibraryName);
            throw new MissingLibraryException(jniNameInApk);
        }
        instance.log("Found %s! Extracting...", new Object[]{jniNameInApk});
        try {
            if (!destination.exists() && !destination.createNewFile()) {
            }
        }
        catch (IOException ignored) {}
        ** GOTO lbl15
        inputStream = null;
        fileOut = null;
        try {
            block33: {
                inputStream = zipFile.getInputStream(libraryEntry);
                fileOut = new FileOutputStream(destination);
                written = this.copy(inputStream, fileOut);
                fileOut.getFD().sync();
                if (written == destination.length()) break block33;
                this.closeSilently(inputStream);
                this.closeSilently(fileOut);
                ** GOTO lbl15
            }
            this.closeSilently(inputStream);
            this.closeSilently(fileOut);
        }
        catch (FileNotFoundException e) {
            this.closeSilently(inputStream);
            this.closeSilently(fileOut);
            ** GOTO lbl15
            catch (IOException e) {
                this.closeSilently(inputStream);
                this.closeSilently(fileOut);
                ** continue;
                catch (Throwable var15_24) {
                    this.closeSilently(inputStream);
                    this.closeSilently(fileOut);
                    throw var15_24;
                }
            }
        }
        destination.setReadable(true, false);
        destination.setExecutable(true, false);
        destination.setWritable(true);
    }

    private long copy(InputStream in, OutputStream out) throws IOException {
        int read;
        long copied = 0L;
        byte[] buf = new byte[4096];
        while ((read = in.read(buf)) != -1) {
            out.write(buf, 0, read);
            copied += (long)read;
        }
        out.flush();
        return copied;
    }

    private void closeSilently(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

