/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.statistics;

import android.content.Context;
import android.os.Handler;
import android.util.Log;
import io.rong.imlib.statistics.DeviceId;
import io.rong.imlib.statistics.Statistics;
import io.rong.imlib.statistics.StatisticsStore;
import java.lang.reflect.Method;

public class AdvertisingIdAdapter {
    private static final String TAG = "AdvertisingIdAdapter";
    private static final String ADVERTISING_ID_CLIENT_CLASS_NAME = "com.google.android.gms.ads.identifier.AdvertisingIdClient";
    private static Handler handler;

    public static boolean isAdvertisingIdAvailable() {
        boolean advertisingIdAvailable = false;
        try {
            Class.forName(ADVERTISING_ID_CLIENT_CLASS_NAME);
            advertisingIdAvailable = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return advertisingIdAvailable;
    }

    public static void setAdvertisingId(final Context context, final StatisticsStore store, final DeviceId deviceId) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    deviceId.setId(DeviceId.Type.ADVERTISING_ID, AdvertisingIdAdapter.getAdvertisingId(context));
                }
                catch (Throwable t) {
                    if (t.getCause() != null && t.getCause().getClass().toString().contains("GooglePlayServicesAvailabilityException")) {
                        if (Statistics.sharedInstance().isLoggingEnabled()) {
                            Log.i((String)AdvertisingIdAdapter.TAG, (String)"Advertising ID cannot be determined yet");
                        }
                    }
                    if (t.getCause() != null && t.getCause().getClass().toString().contains("GooglePlayServicesNotAvailableException")) {
                        if (Statistics.sharedInstance().isLoggingEnabled()) {
                            Log.w((String)AdvertisingIdAdapter.TAG, (String)"Advertising ID cannot be determined because Play Services are not available");
                        }
                        deviceId.switchToIdType(DeviceId.Type.OPEN_UDID, context, store);
                    }
                    Log.e((String)AdvertisingIdAdapter.TAG, (String)"Couldn't get advertising ID", (Throwable)t);
                }
            }
        }).start();
    }

    private static String getAdvertisingId(Context context) throws Throwable {
        Class<?> cls = Class.forName(ADVERTISING_ID_CLIENT_CLASS_NAME);
        Method getAdvertisingIdInfo = cls.getMethod("getAdvertisingIdInfo", Context.class);
        Object info = getAdvertisingIdInfo.invoke(null, context);
        if (info != null) {
            Method getId = info.getClass().getMethod("getId", new Class[0]);
            Object id = getId.invoke(info, new Object[0]);
            return (String)id;
        }
        return null;
    }
}

