/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.statistics;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.FeatureInfo;
import android.content.pm.PackageManager;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.util.Log;
import io.rong.imlib.statistics.DeviceInfo;
import io.rong.imlib.statistics.Statistics;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class CrashDetails {
    private static ArrayList<String> logs = new ArrayList();
    private static int startTime = Statistics.currentTimestamp();
    private static Map<String, String> customSegments = null;
    private static boolean inBackground = true;
    private static long totalMemory = 0L;

    private static long getTotalRAM() {
        if (totalMemory == 0L) {
            RandomAccessFile reader = null;
            String load = null;
            try {
                reader = new RandomAccessFile("/proc/meminfo", "r");
                load = reader.readLine();
                Pattern p = Pattern.compile("(\\d+)");
                Matcher m = p.matcher(load);
                String value = "";
                while (m.find()) {
                    value = m.group(1);
                }
                reader.close();
                totalMemory = Long.parseLong(value) / 1024L;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return totalMemory;
    }

    static void inForeground() {
        inBackground = false;
    }

    static void inBackground() {
        inBackground = true;
    }

    static String isInBackground() {
        return Boolean.toString(inBackground);
    }

    static void addLog(String record) {
        logs.add(record);
    }

    static String getLogs() {
        String allLogs = "";
        for (String s : logs) {
            allLogs = allLogs + s + "\n";
        }
        logs.clear();
        return allLogs;
    }

    static void setCustomSegments(Map<String, String> segments) {
        customSegments = new HashMap<String, String>();
        customSegments.putAll(segments);
    }

    static JSONObject getCustomSegments() {
        if (customSegments != null && !customSegments.isEmpty()) {
            return new JSONObject(customSegments);
        }
        return null;
    }

    static String getManufacturer() {
        return Build.MANUFACTURER;
    }

    static String getCpu() {
        if (Build.VERSION.SDK_INT < 21) {
            return Build.CPU_ABI;
        }
        return Build.SUPPORTED_ABIS[0];
    }

    static String getOpenGL(Context context) {
        PackageManager packageManager = context.getPackageManager();
        FeatureInfo[] featureInfos = packageManager.getSystemAvailableFeatures();
        if (featureInfos != null && featureInfos.length > 0) {
            for (FeatureInfo featureInfo : featureInfos) {
                if (featureInfo.name != null) continue;
                if (featureInfo.reqGlEsVersion != 0) {
                    return Integer.toString((featureInfo.reqGlEsVersion & 0xFFFF0000) >> 16);
                }
                return "1";
            }
        }
        return "1";
    }

    static String getRamCurrent(Context context) {
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        activityManager.getMemoryInfo(mi);
        return Long.toString(CrashDetails.getTotalRAM() - mi.availMem / 0x100000L);
    }

    static String getRamTotal(Context context) {
        return Long.toString(CrashDetails.getTotalRAM());
    }

    static String getDiskCurrent() {
        if (Build.VERSION.SDK_INT < 18) {
            StatFs statFs = new StatFs(Environment.getRootDirectory().getAbsolutePath());
            long total = statFs.getBlockCount() * statFs.getBlockSize();
            long free = statFs.getAvailableBlocks() * statFs.getBlockSize();
            return Long.toString((total - free) / 0x100000L);
        }
        StatFs statFs = new StatFs(Environment.getRootDirectory().getAbsolutePath());
        long total = statFs.getBlockCountLong() * statFs.getBlockSizeLong();
        long free = statFs.getAvailableBlocksLong() * statFs.getBlockSizeLong();
        return Long.toString((total - free) / 0x100000L);
    }

    static String getDiskTotal() {
        if (Build.VERSION.SDK_INT < 18) {
            StatFs statFs = new StatFs(Environment.getRootDirectory().getAbsolutePath());
            long total = statFs.getBlockCount() * statFs.getBlockSize();
            return Long.toString(total / 0x100000L);
        }
        StatFs statFs = new StatFs(Environment.getRootDirectory().getAbsolutePath());
        long total = statFs.getBlockCountLong() * statFs.getBlockSizeLong();
        return Long.toString(total / 0x100000L);
    }

    static String getBatteryLevel(Context context) {
        block3: {
            try {
                Intent batteryIntent = context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
                int level = batteryIntent.getIntExtra("level", -1);
                int scale = batteryIntent.getIntExtra("scale", -1);
                if (level > -1 && scale > 0) {
                    return Float.toString((float)level / (float)scale * 100.0f);
                }
            }
            catch (Exception e) {
                if (!Statistics.sharedInstance().isLoggingEnabled()) break block3;
                Log.i((String)"Statistics", (String)"Can't get batter level");
            }
        }
        return null;
    }

    static String getRunningTime() {
        return Integer.toString(Statistics.currentTimestamp() - startTime);
    }

    static String getOrientation(Context context) {
        int orientation = context.getResources().getConfiguration().orientation;
        switch (orientation) {
            case 2: {
                return "Landscape";
            }
            case 1: {
                return "Portrait";
            }
            case 3: {
                return "Square";
            }
            case 0: {
                return "Unknown";
            }
        }
        return null;
    }

    static String isRooted() {
        String[] paths;
        for (String path : paths = new String[]{"/sbin/su", "/system/bin/su", "/system/xbin/su", "/data/local/xbin/su", "/data/local/bin/su", "/system/sd/xbin/su", "/system/bin/failsafe/su", "/data/local/su"}) {
            if (!new File(path).exists()) continue;
            return "true";
        }
        return "false";
    }

    static String isOnline(Context context) {
        try {
            ConnectivityManager conMgr = (ConnectivityManager)context.getSystemService("connectivity");
            if (conMgr != null && conMgr.getActiveNetworkInfo() != null && conMgr.getActiveNetworkInfo().isAvailable() && conMgr.getActiveNetworkInfo().isConnected()) {
                return "true";
            }
            return "false";
        }
        catch (Exception e) {
            if (Statistics.sharedInstance().isLoggingEnabled()) {
                Log.w((String)"Statistics", (String)"Got exception determining connectivity", (Throwable)e);
            }
            return null;
        }
    }

    static String isMuted(Context context) {
        AudioManager audio = (AudioManager)context.getSystemService("audio");
        switch (audio.getRingerMode()) {
            case 0: {
                return "true";
            }
            case 1: {
                return "true";
            }
        }
        return "false";
    }

    static String getCrashData(Context context, String error, Boolean nonfatal) {
        JSONObject json = new JSONObject();
        CrashDetails.fillJSONIfValuesNotEmpty(json, "_error", error, "_nonfatal", Boolean.toString(nonfatal), "_logs", CrashDetails.getLogs(), "_device", DeviceInfo.getDevice(), "_os", DeviceInfo.getOS(), "_os_version", DeviceInfo.getOSVersion(), "_resolution", DeviceInfo.getResolution(context), "_app_version", DeviceInfo.getAppVersion(context), "_manufacture", CrashDetails.getManufacturer(), "_cpu", CrashDetails.getCpu(), "_opengl", CrashDetails.getOpenGL(context), "_ram_current", CrashDetails.getRamCurrent(context), "_ram_total", CrashDetails.getRamTotal(context), "_disk_current", CrashDetails.getDiskCurrent(), "_disk_total", CrashDetails.getDiskTotal(), "_bat", CrashDetails.getBatteryLevel(context), "_run", CrashDetails.getRunningTime(), "_orientation", CrashDetails.getOrientation(context), "_root", CrashDetails.isRooted(), "_online", CrashDetails.isOnline(context), "_muted", CrashDetails.isMuted(context), "_background", CrashDetails.isInBackground());
        try {
            json.put("_custom", (Object)CrashDetails.getCustomSegments());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        String result = json.toString();
        return result;
    }

    public static String getIMCrashData(Context context, String error) {
        String result = CrashDetails.getCrashData(context, "", true);
        return result;
    }

    static void fillJSONIfValuesNotEmpty(JSONObject json, String ... objects) {
        try {
            if (objects.length > 0 && objects.length % 2 == 0) {
                for (int i = 0; i < objects.length; i += 2) {
                    String key = objects[i];
                    String value = objects[i + 1];
                    if (value == null || value.length() <= 0) continue;
                    json.put(key, (Object)value);
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }
}

