/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.statistics;

import android.content.Context;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import io.rong.imlib.statistics.Statistics;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

class DeviceInfo {
    DeviceInfo() {
    }

    static String getOS() {
        return "Android";
    }

    static String getOSVersion() {
        return Build.VERSION.RELEASE;
    }

    static String getDevice() {
        return Build.MODEL;
    }

    static String getResolution(Context context) {
        String resolution;
        block2: {
            resolution = "";
            try {
                WindowManager wm = (WindowManager)context.getSystemService("window");
                Display display = wm.getDefaultDisplay();
                DisplayMetrics metrics = new DisplayMetrics();
                display.getMetrics(metrics);
                resolution = metrics.widthPixels + "x" + metrics.heightPixels;
            }
            catch (Throwable t) {
                if (!Statistics.sharedInstance().isLoggingEnabled()) break block2;
                Log.i((String)"Statistics", (String)"Device resolution cannot be determined");
            }
        }
        return resolution;
    }

    static String getDensity(Context context) {
        String densityStr = "";
        int density = context.getResources().getDisplayMetrics().densityDpi;
        switch (density) {
            case 120: {
                densityStr = "LDPI";
                break;
            }
            case 160: {
                densityStr = "MDPI";
                break;
            }
            case 213: {
                densityStr = "TVDPI";
                break;
            }
            case 240: {
                densityStr = "HDPI";
                break;
            }
            case 320: {
                densityStr = "XHDPI";
                break;
            }
            case 400: {
                densityStr = "XMHDPI";
                break;
            }
            case 480: {
                densityStr = "XXHDPI";
                break;
            }
            case 640: {
                densityStr = "XXXHDPI";
            }
        }
        return densityStr;
    }

    static String getCarrier(Context context) {
        String carrier = "";
        try {
            TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
            if (manager != null) {
                carrier = manager.getNetworkOperatorName();
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (carrier == null || carrier.length() == 0) {
            carrier = "";
            if (Statistics.sharedInstance().isLoggingEnabled()) {
                Log.i((String)"Statistics", (String)"No carrier found");
            }
        }
        return carrier;
    }

    static String getNetworkType(Context context) {
        NetworkInfo info;
        String type = "UNKNOWN";
        ConnectivityManager connectMgr = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectMgr != null && (info = connectMgr.getActiveNetworkInfo()) != null) {
            if (info.getType() == 1) {
                type = "WIFI";
            } else if (info.getType() == 0) {
                type = "MOBILE";
            }
        }
        return type;
    }

    static String getLocale() {
        Locale locale = Locale.getDefault();
        return locale.getLanguage() + "_" + locale.getCountry();
    }

    static String getAppVersion(Context context) {
        String result;
        block2: {
            result = "1.0";
            try {
                result = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
            }
            catch (PackageManager.NameNotFoundException e) {
                if (!Statistics.sharedInstance().isLoggingEnabled()) break block2;
                Log.i((String)"Statistics", (String)"No app version found");
            }
        }
        return result;
    }

    static String getStore(Context context) {
        String result = "";
        if (Build.VERSION.SDK_INT >= 3) {
            block5: {
                try {
                    result = context.getPackageManager().getInstallerPackageName(context.getPackageName());
                }
                catch (Exception e) {
                    if (!Statistics.sharedInstance().isLoggingEnabled()) break block5;
                    Log.i((String)"Statistics", (String)"Can't get Installer package");
                }
            }
            if (result == null || result.length() == 0) {
                result = "";
                if (Statistics.sharedInstance().isLoggingEnabled()) {
                    Log.i((String)"Statistics", (String)"No store found");
                }
            }
        }
        return result;
    }

    static String getMetrics(Context context) {
        JSONObject json = new JSONObject();
        String displayName = "";
        try {
            displayName = TimeZone.getDefault().getDisplayName(false, 0);
        }
        catch (AssertionError e) {
            displayName = "";
        }
        DeviceInfo.fillJSONIfValuesNotEmpty(json, "device", DeviceInfo.getDevice(), "osName", DeviceInfo.getOS(), "osVersion", DeviceInfo.getOSVersion(), "carrier", DeviceInfo.getCarrier(context), "resolution", DeviceInfo.getResolution(context), "density", DeviceInfo.getDensity(context), "locale", DeviceInfo.getLocale(), "appVersion", DeviceInfo.getAppVersion(context), "channel", DeviceInfo.getStore(context), "bundleId", context.getPackageName(), "sdkVersion", "2.9.18", "network", DeviceInfo.getNetworkType(context), "timeZone", displayName);
        String result = json.toString();
        try {
            result = URLEncoder.encode(result, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }

    static void fillJSONIfValuesNotEmpty(JSONObject json, String ... objects) {
        try {
            if (objects.length > 0 && objects.length % 2 == 0) {
                for (int i = 0; i < objects.length; i += 2) {
                    String key = objects[i];
                    String value = objects[i + 1];
                    if (value == null || value.length() <= 0) continue;
                    json.put(key, (Object)value);
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }
}

