/*
 * Decompiled with CFR 0.152.
 */
package io.rong.message;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import io.rong.common.ParcelUtils;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.UserInfo;
import io.rong.message.MediaMessageContent;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:FileMsg", flag=3)
public class FileMessage
extends MediaMessageContent {
    private static final String TAG = "FileMessage";
    private long mSize;
    private String mType;
    public int progress;
    public static final Parcelable.Creator<FileMessage> CREATOR = new Parcelable.Creator<FileMessage>(){

        public FileMessage createFromParcel(Parcel source) {
            return new FileMessage(source);
        }

        public FileMessage[] newArray(int size) {
            return new FileMessage[size];
        }
    };

    public long getSize() {
        return this.mSize;
    }

    public void setSize(long size) {
        this.mSize = size;
    }

    public String getType() {
        return this.mType;
    }

    public void setType(String type) {
        this.mType = !TextUtils.isEmpty((CharSequence)type) ? type : "bin";
    }

    public Uri getFileUrl() {
        return this.getMediaUrl();
    }

    public void setFileUrl(Uri uri) {
        this.setMediaUrl(uri);
    }

    @Override
    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            if (!TextUtils.isEmpty((CharSequence)this.getName())) {
                jsonObj.put("name", (Object)this.getName());
            }
            jsonObj.put("size", this.mSize);
            if (!TextUtils.isEmpty((CharSequence)this.mType)) {
                jsonObj.put("type", (Object)this.mType);
            }
            if (this.getLocalPath() != null) {
                jsonObj.put("localPath", (Object)this.getLocalPath().toString());
            }
            if (this.getMediaUrl() != null) {
                jsonObj.put("fileUrl", (Object)this.getMediaUrl().toString());
            }
            if (!TextUtils.isEmpty((CharSequence)this.getExtra())) {
                jsonObj.put("extra", (Object)this.getExtra());
            }
            if (this.getJSONUserInfo() != null) {
                jsonObj.putOpt("user", (Object)this.getJSONUserInfo());
            }
        }
        catch (JSONException e) {
            RLog.e(TAG, "JSONException " + e.getMessage());
        }
        try {
            return jsonObj.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            RLog.e(TAG, "UnsupportedEncodingException", e);
            return null;
        }
    }

    public FileMessage(byte[] data) {
        String jsonStr = null;
        try {
            jsonStr = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            RLog.e(TAG, "UnsupportedEncodingException", e);
        }
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            if (jsonObj.has("name")) {
                this.setName(jsonObj.optString("name"));
            }
            if (jsonObj.has("size")) {
                this.setSize(jsonObj.getLong("size"));
            }
            if (jsonObj.has("type")) {
                this.setType(jsonObj.optString("type"));
            }
            if (jsonObj.has("localPath")) {
                this.setLocalPath(Uri.parse((String)jsonObj.optString("localPath")));
            }
            if (jsonObj.has("fileUrl")) {
                this.setFileUrl(Uri.parse((String)jsonObj.optString("fileUrl")));
            }
            if (jsonObj.has("extra")) {
                this.setExtra(jsonObj.optString("extra"));
            }
            if (jsonObj.has("user")) {
                this.setUserInfo(this.parseJsonToUserInfo(jsonObj.getJSONObject("user")));
            }
        }
        catch (JSONException e) {
            RLog.e(TAG, "JSONException " + e.getMessage());
        }
    }

    private FileMessage() {
    }

    private FileMessage(File file, Uri url) {
        if (url.toString().startsWith("file")) {
            this.setLocalPath(url);
        } else {
            this.setMediaUrl(url);
        }
        this.setName(file.getName());
        this.mSize = file.length();
    }

    public static FileMessage obtain(Uri url) {
        if (url == null) {
            return null;
        }
        if (url.toString().startsWith("file")) {
            File file = new File(url.toString().substring(7));
            if (!file.exists() || !file.isFile()) {
                return null;
            }
            return new FileMessage(file, url);
        }
        File webFile = new File(url.toString());
        return new FileMessage(webFile, url);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel(dest, this.getExtra());
        ParcelUtils.writeToParcel(dest, this.getName());
        ParcelUtils.writeToParcel(dest, this.getSize());
        ParcelUtils.writeToParcel(dest, this.getType());
        ParcelUtils.writeToParcel(dest, this.getLocalPath());
        ParcelUtils.writeToParcel(dest, this.getFileUrl());
        ParcelUtils.writeToParcel(dest, this.getUserInfo());
    }

    public FileMessage(Parcel in) {
        this.setExtra(ParcelUtils.readFromParcel(in));
        this.setName(ParcelUtils.readFromParcel(in));
        this.setSize(ParcelUtils.readLongFromParcel(in));
        this.setType(ParcelUtils.readFromParcel(in));
        this.setLocalPath(ParcelUtils.readFromParcel(in, Uri.class));
        this.setFileUrl(ParcelUtils.readFromParcel(in, Uri.class));
        this.setUserInfo(ParcelUtils.readFromParcel(in, UserInfo.class));
    }

    @Override
    public List<String> getSearchableWord() {
        ArrayList<String> words = new ArrayList<String>();
        if (this.getName() != null) {
            words.add(this.getName());
        }
        return words;
    }
}

