/*
 * Decompiled with CFR 0.152.
 */
package io.rong.message;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import io.rong.common.ParcelUtils;
import io.rong.common.RLog;
import io.rong.imlib.DestructionTag;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.UserInfo;
import io.rong.message.ImageMessageHandler;
import io.rong.message.MediaMessageContent;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:ImgMsg", flag=3, messageHandler=ImageMessageHandler.class)
@DestructionTag(destructionFlag=0)
public class ImageMessage
extends MediaMessageContent {
    private Uri mThumUri;
    private boolean mUpLoadExp = false;
    private String mBase64;
    boolean mIsFull;
    public static final Parcelable.Creator<ImageMessage> CREATOR = new Parcelable.Creator<ImageMessage>(){

        public ImageMessage createFromParcel(Parcel source) {
            return new ImageMessage(source);
        }

        public ImageMessage[] newArray(int size) {
            return new ImageMessage[size];
        }
    };

    public ImageMessage(byte[] data) {
        String jsonStr = new String(data);
        try {
            String uri;
            JSONObject jsonObj = new JSONObject(jsonStr);
            if (jsonObj.has("imageUri") && !TextUtils.isEmpty((CharSequence)(uri = jsonObj.optString("imageUri")))) {
                this.setRemoteUri(Uri.parse((String)uri));
            }
            if (jsonObj.has("localPath")) {
                this.setLocalPath(Uri.parse((String)jsonObj.optString("localPath")));
            }
            if (jsonObj.has("content")) {
                this.setBase64(jsonObj.optString("content"));
            }
            if (jsonObj.has("extra")) {
                this.setExtra(jsonObj.optString("extra"));
            }
            if (jsonObj.has("exp")) {
                this.setUpLoadExp(true);
            }
            if (jsonObj.has("isFull")) {
                this.setIsFull(jsonObj.optBoolean("isFull"));
            } else if (jsonObj.has("full")) {
                this.setIsFull(jsonObj.optBoolean("full"));
            }
            if (jsonObj.has("user")) {
                this.setUserInfo(this.parseJsonToUserInfo(jsonObj.getJSONObject("user")));
            }
            if (jsonObj.has("isBurnAfterRead")) {
                this.setDestruct(jsonObj.getBoolean("isBurnAfterRead"));
            }
            if (jsonObj.has("burnDuration")) {
                this.setDestructTime(jsonObj.getLong("burnDuration"));
            }
        }
        catch (JSONException e) {
            Log.e((String)"JSONException", (String)e.getMessage());
        }
    }

    public ImageMessage() {
    }

    private ImageMessage(Uri thumbUri, Uri localUri) {
        this.mThumUri = thumbUri;
        this.setLocalPath(localUri);
    }

    private ImageMessage(Uri thumbUri, Uri localUri, boolean original) {
        this.mThumUri = thumbUri;
        this.setLocalPath(localUri);
        this.mIsFull = original;
    }

    public static ImageMessage obtain(Uri thumUri, Uri localUri) {
        return new ImageMessage(thumUri, localUri);
    }

    public static ImageMessage obtain(Uri thumUri, Uri localUri, boolean isFull) {
        return new ImageMessage(thumUri, localUri, isFull);
    }

    public static ImageMessage obtain() {
        return new ImageMessage();
    }

    public Uri getThumUri() {
        return this.mThumUri;
    }

    public boolean isFull() {
        return this.mIsFull;
    }

    public void setIsFull(boolean isFull) {
        this.mIsFull = isFull;
    }

    public void setThumUri(Uri thumUri) {
        this.mThumUri = thumUri;
    }

    public Uri getLocalUri() {
        return this.getLocalPath();
    }

    public void setLocalUri(Uri localUri) {
        this.setLocalPath(localUri);
    }

    public Uri getRemoteUri() {
        return this.getMediaUrl();
    }

    public void setRemoteUri(Uri remoteUri) {
        this.setMediaUrl(remoteUri);
    }

    public void setBase64(String base64) {
        this.mBase64 = base64;
    }

    public String getBase64() {
        return this.mBase64;
    }

    public boolean isUpLoadExp() {
        return this.mUpLoadExp;
    }

    public void setUpLoadExp(boolean upLoadExp) {
        this.mUpLoadExp = upLoadExp;
    }

    @Override
    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            if (!TextUtils.isEmpty((CharSequence)this.mBase64)) {
                jsonObj.put("content", (Object)this.mBase64);
            } else {
                RLog.d("ImageMessage", "\u7f29\u7565\u56fe\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6784\u9020\u56fe\u7247\u6d88\u606f\u7684\u5730\u5740");
            }
            if (this.getMediaUrl() != null) {
                jsonObj.put("imageUri", (Object)this.getMediaUrl().toString());
            }
            if (this.getLocalUri() != null) {
                jsonObj.put("localPath", (Object)this.getLocalUri().toString());
            }
            if (this.mUpLoadExp) {
                jsonObj.put("exp", true);
            }
            jsonObj.put("isFull", this.mIsFull);
            if (!TextUtils.isEmpty((CharSequence)this.getExtra())) {
                jsonObj.put("extra", (Object)this.getExtra());
            }
            if (this.getJSONUserInfo() != null) {
                jsonObj.putOpt("user", (Object)this.getJSONUserInfo());
            }
            jsonObj.put("isBurnAfterRead", this.isDestruct());
            jsonObj.put("burnDuration", this.getDestructTime());
        }
        catch (JSONException e) {
            RLog.e("JSONException", e.getMessage());
        }
        this.mBase64 = null;
        return jsonObj.toString().getBytes();
    }

    public int describeContents() {
        return 0;
    }

    public ImageMessage(Parcel in) {
        this.setExtra(ParcelUtils.readFromParcel(in));
        this.setLocalPath(ParcelUtils.readFromParcel(in, Uri.class));
        this.setMediaUrl(ParcelUtils.readFromParcel(in, Uri.class));
        this.mThumUri = ParcelUtils.readFromParcel(in, Uri.class);
        this.setUserInfo(ParcelUtils.readFromParcel(in, UserInfo.class));
        this.mIsFull = ParcelUtils.readIntFromParcel(in) == 1;
        this.setDestruct(ParcelUtils.readIntFromParcel(in) == 1);
        this.setDestructTime(ParcelUtils.readLongFromParcel(in));
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel(dest, this.getExtra());
        ParcelUtils.writeToParcel(dest, this.getLocalPath());
        ParcelUtils.writeToParcel(dest, this.getMediaUrl());
        ParcelUtils.writeToParcel(dest, this.mThumUri);
        ParcelUtils.writeToParcel(dest, this.getUserInfo());
        ParcelUtils.writeToParcel(dest, this.mIsFull ? 1 : 0);
        ParcelUtils.writeToParcel(dest, this.isDestruct() ? 1 : 0);
        ParcelUtils.writeToParcel(dest, this.getDestructTime());
    }
}

