/*
 * Decompiled with CFR 0.152.
 */
package io.rong.message;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Base64;
import io.rong.common.FileUtils;
import io.rong.common.RLog;
import io.rong.imlib.NativeClient;
import io.rong.imlib.model.Message;
import io.rong.message.ImageMessage;
import io.rong.message.MessageHandler;
import io.rong.message.utils.BitmapUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ImageMessageHandler
extends MessageHandler<ImageMessage> {
    private static final String TAG = "ImageMessageHandler";
    private static int COMPRESSED_SIZE = 960;
    private static int COMPRESSED_QUALITY = 85;
    private static int MAX_ORIGINAL_IMAGE_SIZE = 200;
    private static int THUMB_COMPRESSED_SIZE = 240;
    private static int THUMB_COMPRESSED_MIN_SIZE = 100;
    private static int THUMB_COMPRESSED_QUALITY = 30;
    private static final String IMAGE_LOCAL_PATH = "/image/local/";
    private static final String IMAGE_THUMBNAIL_PATH = "/image/thumbnail/";
    private static final int MAX_FILE_LENGTH = 20480;

    public ImageMessageHandler(Context context) {
        super(context);
    }

    @Override
    public void decodeMessage(Message message, ImageMessage model) {
        Uri uri = NativeClient.getInstance().obtainMediaFileSavedUri();
        String name = message.getUId() + ".jpg";
        if (TextUtils.isEmpty((CharSequence)message.getUId())) {
            name = message.getMessageId() + ".jpg";
        }
        String thumb = uri.toString() + IMAGE_THUMBNAIL_PATH;
        String local = uri.toString() + IMAGE_LOCAL_PATH;
        model.setLocalUri(null);
        File localFile = new File(local + name);
        if (localFile.exists()) {
            model.setLocalUri(Uri.parse((String)("file://" + local + name)));
        }
        File thumbFile = new File(thumb + name);
        if (!TextUtils.isEmpty((CharSequence)model.getBase64()) && !thumbFile.exists()) {
            byte[] data = null;
            try {
                data = Base64.decode((String)model.getBase64(), (int)2);
            }
            catch (IllegalArgumentException e) {
                RLog.e(TAG, "afterDecodeMessage Not Base64 Content!");
                RLog.e(TAG, "IllegalArgumentException ", e);
            }
            if (!ImageMessageHandler.isImageFile(data)) {
                RLog.e(TAG, "afterDecodeMessage Not Image File!");
                return;
            }
            FileUtils.byte2File(data, thumb, name);
        }
        model.setThumUri(Uri.parse((String)("file://" + thumb + name)));
        model.setBase64(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void encodeMessage(Message message) {
        Object bitmap;
        BitmapFactory.Options options;
        String name;
        Uri uri;
        ImageMessage model;
        block24: {
            model = (ImageMessage)message.getContent();
            uri = NativeClient.getInstance().obtainMediaFileSavedUri();
            name = message.getMessageId() + ".jpg";
            options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            Resources resources = this.getContext().getResources();
            try {
                COMPRESSED_QUALITY = resources.getInteger(resources.getIdentifier("rc_image_quality", "integer", this.getContext().getPackageName()));
                COMPRESSED_SIZE = resources.getInteger(resources.getIdentifier("rc_image_size", "integer", this.getContext().getPackageName()));
                MAX_ORIGINAL_IMAGE_SIZE = resources.getInteger(resources.getIdentifier("rc_max_original_image_size", "integer", this.getContext().getPackageName()));
            }
            catch (Resources.NotFoundException e) {
                e.printStackTrace();
            }
            if (model.getThumUri() != null && model.getThumUri().getScheme() != null && model.getThumUri().getScheme().equals("file")) {
                byte[] data = null;
                File file = new File(uri.toString() + IMAGE_THUMBNAIL_PATH + name);
                if (file.exists()) {
                    model.setThumUri(Uri.parse((String)("file://" + uri.toString() + IMAGE_THUMBNAIL_PATH + name)));
                    data = FileUtils.file2byte(file);
                    if (data != null) {
                        model.setBase64(Base64.encodeToString((byte[])data, (int)2));
                    }
                } else {
                    try {
                        String thumbPath = model.getThumUri().toString().substring(5);
                        RLog.d(TAG, "beforeEncodeMessage Thumbnail not save yet! " + thumbPath);
                        BitmapFactory.decodeFile((String)thumbPath, (BitmapFactory.Options)options);
                        String imageFormat = options.outMimeType != null ? options.outMimeType : "";
                        RLog.d(TAG, "Image format:" + imageFormat);
                        if (options.outWidth > THUMB_COMPRESSED_SIZE || options.outHeight > THUMB_COMPRESSED_SIZE) {
                            bitmap = BitmapUtil.getThumbBitmap(this.getContext(), model.getThumUri(), THUMB_COMPRESSED_SIZE, THUMB_COMPRESSED_MIN_SIZE);
                            if (bitmap == null) break block24;
                            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                            bitmap.compress(Bitmap.CompressFormat.JPEG, THUMB_COMPRESSED_QUALITY, (OutputStream)outputStream);
                            data = outputStream.toByteArray();
                            model.setBase64(Base64.encodeToString((byte[])data, (int)2));
                            outputStream.close();
                            FileUtils.byte2File(data, uri.toString() + IMAGE_THUMBNAIL_PATH, name);
                            model.setThumUri(Uri.parse((String)("file://" + uri.toString() + IMAGE_THUMBNAIL_PATH + name)));
                            if (!bitmap.isRecycled()) {
                                bitmap.recycle();
                            }
                            break block24;
                        }
                        switch (imageFormat) {
                            case "image/gif": 
                            case "image/webp": {
                                BitmapFactory.Options bmOptions = new BitmapFactory.Options();
                                bmOptions.inJustDecodeBounds = false;
                                Bitmap bitmap2 = BitmapFactory.decodeFile((String)thumbPath, (BitmapFactory.Options)bmOptions);
                                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                                bitmap2.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)outputStream);
                                data = outputStream.toByteArray();
                                outputStream.close();
                                if (data != null) {
                                    model.setBase64(Base64.encodeToString((byte[])data, (int)2));
                                    FileUtils.byte2File(data, uri.toString() + IMAGE_THUMBNAIL_PATH, name);
                                    model.setThumUri(Uri.parse((String)("file://" + uri.toString() + IMAGE_THUMBNAIL_PATH + name)));
                                }
                                if (bitmap2.isRecycled()) break;
                                bitmap2.recycle();
                                break;
                            }
                            default: {
                                File src = new File(thumbPath);
                                long fileSize = FileUtils.getFileSize(src);
                                if (fileSize > 20480L) {
                                    int sizeLimit = options.outWidth > options.outHeight ? options.outWidth : options.outHeight;
                                    Bitmap bitmapLargeFile = BitmapUtil.getThumbBitmap(this.getContext(), model.getThumUri(), sizeLimit, THUMB_COMPRESSED_MIN_SIZE);
                                    if (bitmapLargeFile == null) break;
                                    ByteArrayOutputStream outputStreamLargeFile = new ByteArrayOutputStream();
                                    bitmapLargeFile.compress(Bitmap.CompressFormat.JPEG, THUMB_COMPRESSED_QUALITY, (OutputStream)outputStreamLargeFile);
                                    data = outputStreamLargeFile.toByteArray();
                                    model.setBase64(Base64.encodeToString((byte[])data, (int)2));
                                    outputStreamLargeFile.close();
                                    FileUtils.byte2File(data, uri.toString() + IMAGE_THUMBNAIL_PATH, name);
                                    model.setThumUri(Uri.parse((String)("file://" + uri.toString() + IMAGE_THUMBNAIL_PATH + name)));
                                    if (bitmapLargeFile.isRecycled()) break;
                                    bitmapLargeFile.recycle();
                                    break;
                                }
                                data = FileUtils.file2byte(src);
                                if (data == null) break;
                                model.setBase64(Base64.encodeToString((byte[])data, (int)2));
                                String path = uri.toString() + IMAGE_THUMBNAIL_PATH;
                                if (FileUtils.copyFile(src, path, name) == null) break;
                                model.setThumUri(Uri.parse((String)("file://" + path + name)));
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        RLog.e(TAG, "Exception ", e);
                    }
                }
            }
        }
        if (model.getLocalUri() == null) return;
        if (model.getLocalUri().getScheme() == null) return;
        if (!model.getLocalUri().getScheme().equals("file")) return;
        File file = new File(uri.toString() + IMAGE_LOCAL_PATH + name);
        if (file.exists()) {
            model.setLocalUri(Uri.parse((String)("file://" + uri.toString() + IMAGE_LOCAL_PATH + name)));
            return;
        }
        try {
            String localPath = model.getLocalUri().toString().substring(5);
            BitmapFactory.decodeFile((String)localPath, (BitmapFactory.Options)options);
            file = new File(localPath);
            long fileSize = file.length() / 1024L;
            if (!(options.outWidth <= COMPRESSED_SIZE && options.outHeight <= COMPRESSED_SIZE || model.isFull() || fileSize <= (long)MAX_ORIGINAL_IMAGE_SIZE)) {
                bitmap = BitmapUtil.getResizedBitmap(this.getContext(), model.getLocalUri(), COMPRESSED_SIZE, COMPRESSED_SIZE);
                if (bitmap == null) return;
                String dir = uri.toString() + IMAGE_LOCAL_PATH;
                file = new File(dir);
                if (!file.exists()) {
                    file.mkdirs();
                }
                file = new File(dir + name);
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
                bitmap.compress(Bitmap.CompressFormat.JPEG, COMPRESSED_QUALITY, (OutputStream)bos);
                bos.close();
                model.setLocalUri(Uri.parse((String)("file://" + dir + name)));
                if (bitmap.isRecycled()) return;
                bitmap.recycle();
                return;
            }
            if (FileUtils.copyFile(new File(localPath), uri.toString() + IMAGE_LOCAL_PATH, name) == null) return;
            model.setLocalUri(Uri.parse((String)("file://" + uri.toString() + IMAGE_LOCAL_PATH + name)));
            return;
        }
        catch (IOException e) {
            RLog.e(TAG, "IOException  ", e);
            RLog.e(TAG, "beforeEncodeMessage IOException");
        }
    }

    private static boolean isImageFile(byte[] data) {
        if (data == null || data.length == 0) {
            return false;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)options);
        return options.outWidth != -1;
    }
}

