/*
 * Decompiled with CFR 0.152.
 */
package io.rong.message;

import android.os.Parcel;
import android.os.Parcelable;
import io.rong.common.ParcelUtils;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.MentionedInfo;
import io.rong.imlib.model.MessageContent;
import io.rong.imlib.model.UserInfo;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:EncryptedMsg", flag=0)
public class RCEncryptedMessage
extends MessageContent {
    private static String TAG = RCEncryptedMessage.class.getName();
    private String encryptedContent;
    private String remoteEncId;
    private String originalObjName;
    public static final Parcelable.Creator<RCEncryptedMessage> CREATOR = new Parcelable.Creator<RCEncryptedMessage>(){

        public RCEncryptedMessage createFromParcel(Parcel source) {
            return new RCEncryptedMessage(source);
        }

        public RCEncryptedMessage[] newArray(int size) {
            return new RCEncryptedMessage[size];
        }
    };

    public RCEncryptedMessage() {
    }

    public RCEncryptedMessage(byte[] data) {
        String jsonStr = null;
        try {
            jsonStr = new String(data, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            RLog.e(TAG, "RCEncryptedMessage", e);
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonStr);
            if (jsonObject.has("encryptedContent")) {
                this.setEncryptedContent(jsonObject.optString("encryptedContent"));
            }
            if (jsonObject.has("remoteEncId")) {
                this.setRemoteEncId(jsonObject.optString("remoteEncId"));
            }
            if (jsonObject.has("originalObjName")) {
                this.setOriginalObjName(jsonObject.optString("originalObjName"));
            }
            if (jsonObject.has("user")) {
                this.setUserInfo(this.parseJsonToUserInfo(jsonObject.getJSONObject("user")));
            }
            if (jsonObject.has("mentionedInfo")) {
                this.setMentionedInfo(this.parseJsonToMentionInfo(jsonObject.getJSONObject("mentionedInfo")));
            }
        }
        catch (JSONException e) {
            RLog.e(TAG, "JSONException " + e.getMessage());
        }
    }

    public String getEncryptedContent() {
        return this.encryptedContent;
    }

    public void setEncryptedContent(String encryptedContent) {
        this.encryptedContent = encryptedContent;
    }

    public String getRemoteEncId() {
        return this.remoteEncId;
    }

    public void setRemoteEncId(String remoteEncId) {
        this.remoteEncId = remoteEncId;
    }

    public String getOriginalObjName() {
        return this.originalObjName;
    }

    public void setOriginalObjName(String originalObjName) {
        this.originalObjName = originalObjName;
    }

    @Override
    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("remoteEncId", (Object)this.getRemoteEncId());
            jsonObj.put("originalObjName", (Object)this.getOriginalObjName());
            jsonObj.put("encryptedContent", (Object)this.getEncryptedContent());
            if (this.getJSONUserInfo() != null) {
                jsonObj.putOpt("user", (Object)this.getJSONUserInfo());
            }
            if (this.getJsonMentionInfo() != null) {
                jsonObj.putOpt("mentionedInfo", (Object)this.getJsonMentionInfo());
            }
        }
        catch (JSONException e) {
            RLog.e(TAG, "JSONException " + e.getMessage());
        }
        try {
            return jsonObj.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getEmotion(String content) {
        Pattern pattern = Pattern.compile("\\[/u([0-9A-Fa-f]+)\\]");
        Matcher matcher = pattern.matcher(content);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            int inthex = Integer.parseInt(matcher.group(1), 16);
            matcher.appendReplacement(sb, String.valueOf(Character.toChars(inthex)));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.encryptedContent);
        dest.writeString(this.remoteEncId);
        dest.writeString(this.originalObjName);
        dest.writeParcelable((Parcelable)this.getUserInfo(), flags);
        dest.writeParcelable((Parcelable)this.getMentionedInfo(), flags);
    }

    protected RCEncryptedMessage(Parcel in) {
        this.encryptedContent = in.readString();
        this.remoteEncId = in.readString();
        this.originalObjName = in.readString();
        this.setUserInfo(ParcelUtils.readFromParcel(in, UserInfo.class));
        this.setMentionedInfo(ParcelUtils.readFromParcel(in, MentionedInfo.class));
    }
}

