/*
 * Decompiled with CFR 0.152.
 */
package io.rong.message;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Base64;
import io.rong.common.FileUtils;
import io.rong.common.RLog;
import io.rong.imlib.NativeClient;
import io.rong.imlib.model.Message;
import io.rong.message.MessageHandler;
import io.rong.message.VoiceMessage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class VoiceMessageHandler
extends MessageHandler<VoiceMessage> {
    private static final String TAG = "VoiceMessageHandler";
    private static final String VOICE_PATH = "/voice/";

    public VoiceMessageHandler(Context context) {
        super(context);
    }

    @Override
    public void decodeMessage(Message message, VoiceMessage model) {
        Uri uri = NativeClient.getInstance().obtainMediaFileSavedUri();
        String name = message.getMessageId() + ".amr";
        if (message.getMessageId() == 0) {
            name = message.getSentTime() + ".amr";
        }
        File file = new File(uri.toString() + VOICE_PATH + name);
        if (!TextUtils.isEmpty((CharSequence)model.getBase64()) && !file.exists()) {
            try {
                byte[] data = Base64.decode((String)model.getBase64(), (int)2);
                file = VoiceMessageHandler.saveFile(data, uri.toString() + VOICE_PATH, name);
            }
            catch (IllegalArgumentException e) {
                RLog.e(TAG, "afterDecodeMessage Not Base64 Content!");
                RLog.e(TAG, "IllegalArgumentException ", e);
            }
            catch (IOException e) {
                RLog.e(TAG, "IOException ", e);
            }
        }
        model.setUri(Uri.fromFile((File)file));
        model.setBase64(null);
    }

    @Override
    public void encodeMessage(Message message) {
        VoiceMessage model = (VoiceMessage)message.getContent();
        Uri uri = NativeClient.getInstance().obtainMediaFileSavedUri();
        byte[] voiceData = FileUtils.getByteFromUri(model.getUri());
        File file = null;
        try {
            String base64 = Base64.encodeToString((byte[])voiceData, (int)2);
            model.setBase64(base64);
            String name = message.getMessageId() + ".amr";
            file = VoiceMessageHandler.saveFile(voiceData, uri.toString() + VOICE_PATH, name);
        }
        catch (IllegalArgumentException e) {
            RLog.e(TAG, "beforeEncodeMessage Not Base64 Content!");
            RLog.e(TAG, "IllegalArgumentException ", e);
        }
        catch (IOException e) {
            RLog.e(TAG, "IOException ", e);
        }
        if (file != null && file.exists()) {
            model.setUri(Uri.fromFile((File)file));
        }
    }

    private static File saveFile(byte[] data, String path, String fileName) throws IOException {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        file = new File(path + fileName);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
        bos.write(data);
        bos.flush();
        bos.close();
        return file;
    }
}

