/*
 * Decompiled with CFR 0.152.
 */
package io.rong.message.utils;

import io.rong.common.RLog;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class RCDHCodecTool {
    private static final String TAG = RCDHCodecTool.class.getName();
    private static final String pStrDefault = "25135566567101483196994790440833279750474660393232382279277736257066266618532493517139001963526957179514521981877335815379755618191324858392834843718048308951653115284529736874534289456833723962912807104017411854314007953484461899139734367756070456068592886771130491355511301923675421649355211882120329692353507392677087555292357140606251171702417804959957862991259464749806480821163999054978911727901705780417863120490095024926067731615229486812312187386108568833026386220686253160504779704721744600638258183939573405528962511242337923530869616215532193967628076922234051908977996352800560160181197923404454023908443";
    private static final String gStrDefault = "3";
    private static final int lSize = 2048;
    private KeyPair mLocalKeyPair;
    private RCSecretKey mRCSecretKey;
    private static Map<String, RCDHCodecTool> sToolBag = new HashMap<String, RCDHCodecTool>();

    private static RCDHCodecTool create() {
        return new RCDHCodecTool();
    }

    public static RCDHCodecTool obtainWithEncId(String encId) {
        if (encId == null || encId.length() == 0) {
            RLog.w(TAG, "encId is null or empty while creating RCDHTool,so create a normal one.");
            return RCDHCodecTool.create();
        }
        if (sToolBag.containsKey(encId)) {
            return sToolBag.get(encId);
        }
        RCDHCodecTool tool = RCDHCodecTool.create();
        sToolBag.put(encId, tool);
        return tool;
    }

    public static RCSecretKey getRCSecretKeyByEncId(String encId) {
        RCDHCodecTool localTool = RCDHCodecTool.obtainWithEncId(encId);
        if (localTool == null) {
            return null;
        }
        return localTool.mRCSecretKey;
    }

    private KeyPair genLocalKeyPair(DHParameterSpec parameterSpec) {
        BigInteger x;
        SecureRandom random;
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            RLog.e(TAG, "genLocalKeyPair could not get the NativePRNG random algorithm , generate local keypair failed!", e);
            return null;
        }
        if (parameterSpec == null) {
            parameterSpec = new DHParameterSpec(new BigInteger(pStrDefault), new BigInteger(gStrDefault), 2048);
        }
        BigInteger p = parameterSpec.getP();
        BigInteger g = parameterSpec.getG();
        int l = parameterSpec.getL();
        BigInteger pMinus2 = p.subtract(BigInteger.valueOf(2L));
        while ((x = new BigInteger(l, random)).compareTo(BigInteger.valueOf(1L)) < 0 || x.compareTo(pMinus2) > 0 || x.bitLength() != l) {
        }
        BigInteger y = g.modPow(x, p);
        RCDHPublicKey pubKey = new RCDHPublicKey(y);
        RCDHPrivateKey priKey = new RCDHPrivateKey(x);
        this.mLocalKeyPair = new KeyPair(pubKey, priKey);
        return this.mLocalKeyPair;
    }

    public KeyPair getOrCreateLocalKeyPair(DHParameterSpec parameterSpec) {
        if (this.mLocalKeyPair == null) {
            this.mLocalKeyPair = this.genLocalKeyPair(parameterSpec);
        }
        return this.mLocalKeyPair;
    }

    public RCSecretKey genSecretKey(RCDHPublicKey publicKey) {
        if (this.mLocalKeyPair == null || this.mLocalKeyPair.getPrivate() == null) {
            this.genLocalKeyPair(null);
        }
        if (publicKey == null || publicKey.getY() == null) {
            RLog.e(TAG, "public key is null ,can not generate the SecretKey.");
            return null;
        }
        RCDHPrivateKey priKey2Use = null;
        if (this.mLocalKeyPair.getPrivate() instanceof RCDHPrivateKey) {
            priKey2Use = (RCDHPrivateKey)this.mLocalKeyPair.getPrivate();
        }
        if (priKey2Use == null) {
            RLog.e(TAG, "private key is null ,can not generate the SecretKey.");
            return null;
        }
        try {
            BigInteger keyInteger = publicKey.getY().modPow(priKey2Use.getX(), new BigInteger(pStrDefault));
            this.mRCSecretKey = new RCSecretKey(keyInteger);
            return this.mRCSecretKey;
        }
        catch (Exception e) {
            RLog.e(TAG, "exception of " + e.getLocalizedMessage() + "occurs,return null.");
            return null;
        }
    }

    public static byte[] encrypt(byte[] content, RCSecretKey rcSecretKey) {
        try {
            byte[] encodedKey = rcSecretKey.getEncoded();
            SecretKeySpec secretKeySpec = new SecretKeySpec(encodedKey, "AES");
            byte[] ivByte = new byte[16];
            System.arraycopy(encodedKey, 0, ivByte, 0, 16);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(ivByte);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            RLog.e(TAG, "return byte[0],exception occurs while calling encrypt() " + e.getLocalizedMessage());
            return new byte[0];
        }
    }

    public static byte[] decrypt(byte[] content, RCSecretKey rcSecretKey) {
        try {
            byte[] encodedKey = rcSecretKey.getEncoded();
            SecretKeySpec secretKeySpec = new SecretKeySpec(encodedKey, "AES");
            byte[] ivByte = new byte[16];
            System.arraycopy(encodedKey, 0, ivByte, 0, 16);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(ivByte);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
            return cipher.doFinal(content);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            RLog.e(TAG, "decrypt", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            RLog.e(TAG, "decrypt", e);
        }
        return null;
    }

    public static String[] parseEncTargetId(String targetId) {
        if (targetId == null || targetId.length() == 0) {
            RLog.e(TAG, "targetId is null or empty!");
            return null;
        }
        return targetId.split(";;;");
    }

    public static String genEncId() {
        int randomInt;
        long timeStamp = System.currentTimeMillis();
        Random random = new Random();
        while ((randomInt = random.nextInt(9999)) / 1000 <= 0) {
        }
        return String.valueOf(timeStamp) + randomInt;
    }

    public RCDHPublicKey getRCPubKey() {
        if (this.mLocalKeyPair == null) {
            return null;
        }
        if (this.mLocalKeyPair.getPublic() instanceof RCDHPublicKey) {
            return (RCDHPublicKey)this.mLocalKeyPair.getPublic();
        }
        return null;
    }

    public RCDHPrivateKey getRCPriKey() {
        if (this.mLocalKeyPair == null) {
            return null;
        }
        if (this.mLocalKeyPair.getPrivate() instanceof RCDHPrivateKey) {
            return (RCDHPrivateKey)this.mLocalKeyPair.getPrivate();
        }
        return null;
    }

    public static RCSecretKey fromString2RCSecretKey(String keyString) {
        BigInteger keyBI;
        try {
            keyBI = new BigInteger(keyString);
        }
        catch (Exception e) {
            RLog.e(TAG, "exception occurs when transforming keyString to BigInger.");
            return null;
        }
        return new RCSecretKey(keyBI);
    }

    public static RCDHPublicKey fromString2RCDHPublicKey(String keyString) {
        BigInteger keyBI;
        try {
            keyBI = new BigInteger(keyString);
        }
        catch (Exception e) {
            RLog.e(TAG, "fromString2RCDHPublicKey exception occurs when transforming keyString to BigInger.", e);
            return null;
        }
        return new RCDHPublicKey(keyBI);
    }

    public static RCDHPrivateKey fromString2RCDHPrivateKey(String keyString) {
        BigInteger keyBI;
        try {
            keyBI = new BigInteger(keyString);
        }
        catch (Exception e) {
            RLog.e(TAG, "fromString2RCDHPrivateKey exception occurs when transforming keyString to BigInger.", e);
            return null;
        }
        return new RCDHPrivateKey(keyBI);
    }

    private static byte[] sha265Digest(byte[] origin) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(origin);
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            RLog.e(TAG, "sha265Digest", e);
            return null;
        }
    }

    public static class RCSecretKey
    implements SecretKey {
        public BigInteger key;

        RCSecretKey(BigInteger key) {
            this.key = key;
        }

        @Override
        public String getAlgorithm() {
            return null;
        }

        @Override
        public String getFormat() {
            return null;
        }

        @Override
        public byte[] getEncoded() {
            byte[] encodedKey = null;
            if (this.key != null) {
                try {
                    encodedKey = this.key.toString().getBytes("utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    RLog.e(TAG, "RCSecretKey getEncoded", e);
                    return null;
                }
            }
            return RCDHCodecTool.sha265Digest(encodedKey);
        }

        public String toString() {
            return this.key.toString();
        }
    }

    public static class RCDHPrivateKey
    implements DHPrivateKey {
        private BigInteger x;

        RCDHPrivateKey(BigInteger x) {
            this.x = x;
        }

        @Override
        public BigInteger getX() {
            return this.x;
        }

        @Override
        public String getAlgorithm() {
            return null;
        }

        @Override
        public String getFormat() {
            return null;
        }

        @Override
        public byte[] getEncoded() {
            return new byte[0];
        }

        @Override
        public DHParameterSpec getParams() {
            return null;
        }

        public String toString() {
            return this.x.toString();
        }
    }

    public static class RCDHPublicKey
    implements DHPublicKey {
        private BigInteger Y;

        RCDHPublicKey(BigInteger y) {
            this.Y = y;
        }

        @Override
        public BigInteger getY() {
            return this.Y;
        }

        @Override
        public String getAlgorithm() {
            return null;
        }

        @Override
        public String getFormat() {
            return null;
        }

        @Override
        public byte[] getEncoded() {
            return new byte[0];
        }

        @Override
        public DHParameterSpec getParams() {
            return null;
        }

        public String toString() {
            return this.Y.toString();
        }
    }
}

