/*
 * Decompiled with CFR 0.152.
 */
package io.rong.push.core;

import android.content.Context;
import io.rong.push.PushErrorCode;
import io.rong.push.common.RLog;
import io.rong.push.core.PushProtocalStack;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;

public class PushClient {
    private static final String TAG = "PushClient";
    private PushProtocalStack.MessageInputStream in;
    private Socket socket;
    private PushProtocalStack.MessageOutputStream out;
    private PushReader reader;
    private ClientListener listener;
    private ConnectStatusCallback connectCallback;
    private QueryCallback queryCallback;
    private String deviceInfo;
    private boolean running;
    private Context context;
    private String appKey;

    public PushClient(Context context, String appKey, String deviceInfo, ClientListener listener) {
        this.context = context;
        this.appKey = appKey;
        this.listener = listener;
        this.deviceInfo = deviceInfo;
        this.appKey = appKey;
    }

    public void connect(String host, int port, String deviceId, ConnectStatusCallback callback) {
        block4: {
            RLog.d(TAG, "connect, deviceId = " + deviceId + ", host = " + host + ", port = " + port);
            if (this.reader != null) {
                if (this.socket != null && this.socket.isConnected()) {
                    RLog.d(TAG, "old socket is connected. Ignore this connect event.");
                    return;
                }
                RLog.d(TAG, "reset old socket.");
                this.reset();
            }
            try {
                this.socket = new Socket();
                InetSocketAddress address = new InetSocketAddress(host, port);
                this.socket.connect(address, 4000);
                InputStream is = this.socket.getInputStream();
                this.in = new PushProtocalStack.MessageInputStream(is);
                this.out = new PushProtocalStack.MessageOutputStream(this.socket.getOutputStream());
                this.connectCallback = callback;
                PushProtocalStack.ConnectMessage connectMessage = new PushProtocalStack.ConnectMessage(deviceId, true, 300);
                connectMessage.setWill(this.context.getPackageName(), String.format("%s-%s-%s", "AndroidPush", this.deviceInfo, "2.9.18"));
                connectMessage.setCredentials(this.appKey);
                this.out.writeMessage(connectMessage);
                this.reader = new PushReader();
                this.running = true;
                this.reader.start();
            }
            catch (Exception e) {
                RLog.e(TAG, "connect IOException");
                e.printStackTrace();
                if (callback == null) break block4;
                callback.onError();
            }
        }
    }

    public void ping() {
        block5: {
            try {
                if (this.socket != null && this.socket.isConnected() && this.out != null) {
                    this.out.writeMessage(new PushProtocalStack.PingReqMessage());
                } else if (this.listener != null) {
                    this.listener.onPingFailure();
                }
            }
            catch (IOException e) {
                RLog.e(TAG, "ping IOException");
                e.printStackTrace();
                if (this.listener == null) break block5;
                this.listener.onPingFailure();
            }
        }
    }

    public void query(QueryMethod method, String queryInfo, String deviceId, QueryCallback callback) {
        RLog.d(TAG, "query. topic:" + method.getMethodName() + ", queryInfo:" + queryInfo);
        this.queryCallback = callback;
        try {
            if (this.socket != null && this.socket.isConnected() && this.out != null && this.running) {
                this.out.writeMessage(new PushProtocalStack.QueryMessage(method.getMethodName(), queryInfo, deviceId));
            } else {
                RLog.e(TAG, "server has disconnected");
                this.queryCallback.onFailure(PushErrorCode.SERVER_DISCONNECTED);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.queryCallback.onFailure(PushErrorCode.IO_EXCEPTION);
        }
    }

    public void uninit() {
        this.listener = null;
        this.disconnect();
    }

    public void disconnect() {
        RLog.d(TAG, "disconnect");
        try {
            if (this.reader != null) {
                this.reader.interrupt();
            }
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            RLog.e(TAG, "disconnect IOException");
            e.printStackTrace();
        }
        finally {
            this.running = false;
            this.reader = null;
            this.in = null;
            this.out = null;
            this.socket = null;
            if (this.listener != null) {
                this.listener.onDisConnected();
            }
        }
    }

    public void reset() {
        RLog.d(TAG, "reset");
        try {
            if (this.reader != null) {
                this.reader.interrupt();
            }
            if (this.socket != null) {
                this.socket.close();
            }
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException e) {
            RLog.e(TAG, "reset IOException");
            e.printStackTrace();
        }
        finally {
            this.running = false;
            this.reader = null;
            this.socket = null;
            this.in = null;
            this.out = null;
        }
    }

    private void handleMessage(PushProtocalStack.Message msg) throws IOException {
        if (msg == null) {
            return;
        }
        RLog.d(TAG, "handleMessage, msg type = " + (Object)((Object)msg.getType()));
        switch (msg.getType()) {
            case CONNACK: {
                if (this.connectCallback == null) break;
                this.connectCallback.onConnected();
                break;
            }
            case PINGRESP: {
                if (this.listener == null) break;
                this.listener.onPingSuccess();
                break;
            }
            case QUERYACK: {
                PushProtocalStack.QueryAckMessage message = (PushProtocalStack.QueryAckMessage)msg;
                int status = message.getStatus();
                RLog.d(TAG, "queryAck status:" + status + "content:" + message.getDataAsString());
                if (this.queryCallback == null) break;
                if (status == PushProtocalStack.QueryAckMessage.QueryStatus.STATUS_OK.get()) {
                    this.queryCallback.onSuccess(message.getDataAsString());
                    break;
                }
                this.queryCallback.onFailure(PushErrorCode.NOT_REGISTER_IN_ADMIN);
                break;
            }
            case PUBLISH: {
                if (this.listener == null) break;
                PushProtocalStack.PublishMessage publishMsg = (PushProtocalStack.PublishMessage)msg;
                this.listener.onMessageArrived(publishMsg);
                break;
            }
            case DISCONNECT: {
                if (this.listener == null) break;
                this.listener.onDisConnected();
            }
        }
    }

    public static enum QueryMethod {
        GET_PUSH_TYPE("getPushType"),
        SET_TOKEN("setToken");

        private String methodName;

        private QueryMethod(String name) {
            this.methodName = name;
        }

        public String getMethodName() {
            return this.methodName;
        }
    }

    public static interface QueryCallback {
        public void onSuccess(String var1);

        public void onFailure(PushErrorCode var1);
    }

    public static interface ConnectStatusCallback {
        public void onConnected();

        public void onError();
    }

    public static interface ClientListener {
        public void onMessageArrived(PushProtocalStack.PublishMessage var1);

        public void onDisConnected();

        public void onPingSuccess();

        public void onPingFailure();
    }

    private class PushReader
    extends Thread {
        private PushReader() {
        }

        @Override
        public void run() {
            block4: {
                PushProtocalStack.Message msg = null;
                try {
                    while (PushClient.this.running) {
                        Thread.sleep(100L);
                        if (PushClient.this.in != null) {
                            msg = PushClient.this.in.readMessage();
                        }
                        if (msg == null) continue;
                        PushClient.this.handleMessage(msg);
                    }
                }
                catch (Exception e) {
                    RLog.e(PushClient.TAG, "PushReader IOException. " + e.getMessage());
                    e.printStackTrace();
                    if (PushClient.this.listener == null) break block4;
                    PushClient.this.listener.onDisConnected();
                }
            }
        }
    }
}

