/*
 * Decompiled with CFR 0.152.
 */
package io.rong.push.core;

import android.content.Context;
import android.os.Build;
import android.security.NetworkSecurityPolicy;
import android.text.TextUtils;
import io.rong.common.utils.SSLUtils;
import io.rong.imlib.common.DeviceUtils;
import io.rong.push.PushErrorCode;
import io.rong.push.common.PushCacheHelper;
import io.rong.push.common.RLog;
import io.rong.push.pushconfig.PushNaviObserver;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.json.JSONObject;

public class PushNaviClient {
    private static final String TAG = PushNaviClient.class.getSimpleName();
    private final String NAVI_SPLIT = ";";
    private final String IP_SPLIT = ",";
    private final String NAVI_PATH = "navipush.json";
    private ArrayList<String> naviList;
    private PushNaviObserver pushNaviObserver;

    public void setPushNaviUrl(String naviAddress) {
        RLog.i(TAG, "setPushNaviUrl " + naviAddress);
        if (TextUtils.isEmpty((CharSequence)naviAddress)) {
            RLog.e(TAG, "navi address is empty!!");
            return;
        }
        String[] naviArray = naviAddress.split(";");
        if (naviArray.length > 0) {
            this.naviList = new ArrayList();
            for (int i = 0; i < naviArray.length; ++i) {
                if (TextUtils.isEmpty((CharSequence)naviArray[i])) continue;
                String current = this.formatServerAddress(naviArray[i], "navipush.json");
                this.naviList.add(current);
            }
        }
    }

    private String formatServerAddress(String domain, String path) {
        String strFormat = domain.toLowerCase().startsWith("http") ? "%s/%s" : (Build.VERSION.SDK_INT >= 28 && !NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted() ? "https://%s/%s" : "http://%s/%s");
        return String.format(strFormat, domain, path);
    }

    public void getPushServerIPs(Context context, String appKey, boolean isSelfCertificate, PushNaviObserver observer) {
        this.pushNaviObserver = observer;
        if (PushCacheHelper.getInstance().isCacheValid(context, appKey)) {
            observer.onSuccess(PushCacheHelper.getInstance().getCachedAddressList(context));
        } else {
            this.connectToNavi(context, appKey, isSelfCertificate);
        }
    }

    private void connectToNavi(Context context, String appKey, boolean isSelfCertificate) {
        if (this.naviList == null || this.naviList.size() == 0) {
            if (this.pushNaviObserver != null) {
                this.pushNaviObserver.onError(PushErrorCode.PARAMETER_ERROR);
            }
            RLog.e(TAG, "no navi address.");
        } else {
            String navi;
            Iterator<String> iterator = this.naviList.iterator();
            while (iterator.hasNext() && !this.connect(context, navi = iterator.next(), appKey, isSelfCertificate, !iterator.hasNext())) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connect(Context context, String naviUrl, String appKey, boolean isSelfCertificate, boolean isLastNavi) {
        HttpURLConnection conn = null;
        BufferedInputStream responseStream = null;
        boolean result = false;
        String address = "";
        try {
            URL url = new URL(naviUrl);
            RLog.i(TAG, "navigation url : " + url);
            conn = this.createConnection(naviUrl, isSelfCertificate);
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(3000);
            conn.setUseCaches(false);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("appId", appKey);
            OutputStream os = conn.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
            String param = "deviceId=" + DeviceUtils.getDeviceId(context, appKey);
            writer.write(param);
            writer.flush();
            writer.close();
            os.close();
            conn.connect();
            int responseCode = conn.getResponseCode();
            if (responseCode >= 100 && responseCode <= 300) {
                int c;
                responseStream = new BufferedInputStream(conn.getInputStream());
                ByteArrayOutputStream responseData = new ByteArrayOutputStream(256);
                while ((c = responseStream.read()) != -1) {
                    responseData.write(c);
                }
                JSONObject responseDict = new JSONObject(responseData.toString("UTF-8"));
                boolean success = responseDict.optString("code").equalsIgnoreCase("200");
                if (success) {
                    String[] bsArray;
                    result = true;
                    ArrayList<String> addressList = new ArrayList<String>();
                    address = responseDict.optString("server");
                    addressList.add(address);
                    String bs = responseDict.optString("bs");
                    RLog.d(TAG, "server:" + address + ";bs server:" + bs);
                    if (!TextUtils.isEmpty((CharSequence)bs) && (bsArray = bs.split(",")).length > 0) {
                        for (String str : bsArray) {
                            addressList.add(str);
                        }
                    }
                    PushCacheHelper.getInstance().saveAllAddress(context, addressList, System.currentTimeMillis());
                    this.pushNaviObserver.onSuccess(addressList);
                } else if (this.pushNaviObserver != null && isLastNavi) {
                    RLog.e(TAG, "Fail to get navi. errorcode:" + responseCode);
                    this.pushNaviObserver.onError(PushErrorCode.IO_EXCEPTION);
                }
            }
        }
        catch (Exception e) {
            RLog.e(TAG, "Exception when get navigation address.Retry again.");
            if (this.pushNaviObserver != null && isLastNavi) {
                this.pushNaviObserver.onError(PushErrorCode.IO_EXCEPTION);
            }
            e.printStackTrace();
        }
        finally {
            if (responseStream != null) {
                try {
                    responseStream.close();
                }
                catch (IOException iOException) {}
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return result;
    }

    private HttpURLConnection createConnection(String urlStr, boolean isSelfCertificate) throws Exception {
        HttpURLConnection connection;
        if (urlStr.toLowerCase().startsWith("https")) {
            RLog.i(TAG, "https connection. isSelfCertificate: " + isSelfCertificate);
            URL url = new URL(urlStr);
            if (isSelfCertificate) {
                SSLContext sslContext = SSLUtils.getSSLContext();
                HttpsURLConnection c = (HttpsURLConnection)url.openConnection();
                c.setSSLSocketFactory(sslContext.getSocketFactory());
                c.setHostnameVerifier(SSLUtils.DO_NOT_VERIFY);
                connection = c;
            } else {
                connection = (HttpsURLConnection)url.openConnection();
            }
        } else {
            URL u = new URL(urlStr);
            connection = (HttpURLConnection)u.openConnection();
        }
        return connection;
    }
}

