/*
 * Decompiled with CFR 0.152.
 */
package io.rong.push.platform.hms;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.widget.Toast;
import com.huawei.hms.api.HuaweiApiClient;
import io.rong.push.PushType;
import io.rong.push.platform.hms.common.ActivityMgr;
import io.rong.push.platform.hms.common.ApiClientMgr;
import io.rong.push.platform.hms.common.CheckUpdateApi;
import io.rong.push.platform.hms.common.HMSAgentLog;
import io.rong.push.platform.hms.common.IClientConnectCallback;
import io.rong.push.platform.hms.common.INoProguard;
import io.rong.push.platform.hms.common.handler.CheckUpdateHandler;
import io.rong.push.platform.hms.common.handler.ConnectHandler;
import io.rong.push.platform.hms.push.DeleteTokenApi;
import io.rong.push.platform.hms.push.EnableReceiveNormalMsgApi;
import io.rong.push.platform.hms.push.EnableReceiveNotifyMsgApi;
import io.rong.push.platform.hms.push.GetPushStateApi;
import io.rong.push.platform.hms.push.GetTokenApi;
import io.rong.push.platform.hms.push.QueryAgreementApi;
import io.rong.push.platform.hms.push.handler.DeleteTokenHandler;
import io.rong.push.platform.hms.push.handler.EnableReceiveNormalMsgHandler;
import io.rong.push.platform.hms.push.handler.EnableReceiveNotifyMsgHandler;
import io.rong.push.platform.hms.push.handler.GetPushStateHandler;
import io.rong.push.platform.hms.push.handler.GetTokenHandler;
import io.rong.push.platform.hms.push.handler.QueryAgreementHandler;

public final class HMSAgent
implements INoProguard {
    private static Context context;
    private static final String VER_020503001 = "020503001";
    private static final String VER_020600001 = "020600001";
    private static final String VER_020600200 = "020600200";
    private static final String VER_020601002 = "020601002";
    private static final String VER_020601302 = "020601302";
    public static final String CURVER = "020601302";

    private HMSAgent() {
    }

    private static boolean checkSDKVersion(Context context) {
        long sdkMainVerL = 20601L;
        long agentMainVerL = Long.parseLong("020601302") / 1000L;
        if (sdkMainVerL != agentMainVerL) {
            String errMsg = "error: HMSAgent major version code (" + agentMainVerL + ") does not match HMSSDK major version code (" + sdkMainVerL + ")";
            HMSAgentLog.e(errMsg);
            Toast.makeText((Context)context, (CharSequence)errMsg, (int)1).show();
            return false;
        }
        return true;
    }

    public static boolean init(Activity activity) {
        context = activity;
        return HMSAgent.init(null, activity);
    }

    public static boolean init(Application app) {
        context = app;
        return HMSAgent.init(app, null);
    }

    public static boolean init(Application app, Activity activity) {
        Application appTmp = app;
        Activity activityTmp = activity;
        if (appTmp == null && activityTmp == null) {
            HMSAgentLog.e("the param of method HMSAgent.init can not be null !!!");
            return false;
        }
        if (appTmp == null) {
            appTmp = activityTmp.getApplication();
        }
        if (appTmp == null) {
            HMSAgentLog.e("the param of method HMSAgent.init app can not be null !!!");
            return false;
        }
        if (activityTmp != null && activityTmp.isFinishing()) {
            activityTmp = null;
        }
        if (!HMSAgent.checkSDKVersion((Context)appTmp)) {
            return false;
        }
        HMSAgentLog.i("init HMSAgent 020601302 with hmssdkver 20601301");
        ActivityMgr.INST.init(appTmp, activityTmp);
        ApiClientMgr.INST.init(appTmp);
        context = appTmp;
        return true;
    }

    public static void destroy() {
        HMSAgentLog.i("destroy HMSAgent");
        ActivityMgr.INST.release();
        ApiClientMgr.INST.release();
    }

    public static void connect(Activity activity, final ConnectHandler callback) {
        HMSAgentLog.i("start connect");
        ApiClientMgr.INST.connect(new IClientConnectCallback(){

            @Override
            public void onConnect(final int rst, HuaweiApiClient client) {
                if (callback != null) {
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onConnect(rst);
                        }
                    });
                }
            }
        }, false);
    }

    public static void checkUpdate(Activity activity, CheckUpdateHandler callback) {
        new CheckUpdateApi().checkUpdate(activity, callback);
    }

    public static void resolveError(long errCode) {
        ApiClientMgr.INST.registerClientConnect(new IClientConnectCallback(){

            @Override
            public void onConnect(int rst, HuaweiApiClient client) {
                if (rst == 0) {
                    new GetTokenApi().getToken(new GetTokenHandler(){

                        @Override
                        public void onResult(int rst) {
                            Intent intent = new Intent();
                            intent.setAction("io.rong.push.intent.THIRD_PARTY_PUSH_STATE");
                            intent.putExtra("pushType", PushType.HUAWEI.getName());
                            intent.putExtra("action", "Get token");
                            intent.putExtra("resultCode", (long)rst);
                            intent.setPackage(context.getPackageName());
                            context.sendBroadcast(intent);
                        }
                    });
                }
            }
        });
        ApiClientMgr.INST.resolveError((int)errCode);
    }

    public static final class Push {
        public static void getToken(GetTokenHandler handler) {
            new GetTokenApi().getToken(handler);
        }

        public static void deleteToken(String token, DeleteTokenHandler handler) {
            new DeleteTokenApi().deleteToken(token, handler);
        }

        public static void getPushState(GetPushStateHandler handler) {
            new GetPushStateApi().getPushState(handler);
        }

        public static void enableReceiveNotifyMsg(boolean enable, EnableReceiveNotifyMsgHandler handler) {
            new EnableReceiveNotifyMsgApi().enableReceiveNotifyMsg(enable, handler);
        }

        public static void enableReceiveNormalMsg(boolean enable, EnableReceiveNormalMsgHandler handler) {
            new EnableReceiveNormalMsgApi().enableReceiveNormalMsg(enable, handler);
        }

        public static void queryAgreement(QueryAgreementHandler handler) {
            new QueryAgreementApi().queryAgreement(handler);
        }
    }

    public static final class AgentResultCode {
        public static final int HMSAGENT_SUCCESS = 0;
        public static final int HMSAGENT_NO_INIT = -1000;
        public static final int NO_ACTIVITY_FOR_USE = -1001;
        public static final int RESULT_IS_NULL = -1002;
        public static final int STATUS_IS_NULL = -1003;
        public static final int START_ACTIVITY_ERROR = -1004;
        public static final int ON_ACTIVITY_RESULT_ERROR = -1005;
        public static final int REQUEST_REPEATED = -1006;
        public static final int APICLIENT_TIMEOUT = -1007;
        public static final int CALL_EXCEPTION = -1008;
        public static final int EMPTY_PARAM = -1009;
    }
}

