/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.Switch;
import android.widget.TextView;
import androidx.appcompat.app.AlertDialog;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.byh.lib.byhim.FrameContractsActivity;
import com.byh.lib.byhim.GroupMembersActivity;
import com.byh.lib.byhim.ModifyGroupNameActivity;
import com.byh.lib.byhim.R;
import com.byh.lib.byhim.adapter.GroupMembersAdapter;
import com.byh.lib.byhim.bean.ImGroupInfoEntity;
import com.byh.lib.byhim.bean.UnGroupBody;
import com.byh.lib.byhim.module.impl.ReqIconNickModel;
import com.byh.lib.byhim.present.impl.GroupMembersPresent;
import com.byh.lib.byhim.present.impl.ModifyGroupNameIconPresent;
import com.byh.lib.byhim.utils.RongUtil;
import com.byh.lib.byhim.view.GroupMembersView;
import com.byh.lib.byhim.view.ModifyGroupNameOkView;
import com.kangxin.common.Pretty;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.entity.ExpertInfoEntity;
import com.kangxin.common.byh.entity.response.GroupMembersEntity;
import com.kangxin.common.byh.entity.response.MembersPageBean;
import com.kangxin.common.byh.entity.response.UpImgEntity;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.present.impl.UpFilePresent;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.view.IUpFileView;
import com.kangxin.common.byh.widget.UpPicBottomDialog;
import com.kangxin.common.util.FileUtils;
import com.kangxin.common.widget.NoScrollGridView;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.rong.imkit.RongIM;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Group;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.jetbrains.annotations.NotNull;
import top.zibin.luban.Luban;
import top.zibin.luban.OnCompressListener;

@Route(path="/immsg/GroupInfoActivity")
public class GroupInfoActivity
extends BaseActivity
implements IToolView,
GroupMembersView,
IUpFileView,
ModifyGroupNameOkView {
    private static final String TAG = "GroupInfoActivity";
    private NoScrollGridView mNoScrollGridView;
    private GroupMembersPresent mGroupMembersPresent;
    private TextView mCheckMoreMembersView;
    private Switch mGroupTopSwitch;
    private Switch mGroupNoDisturbSwitch;
    private UpFilePresent mUpFilePresent;
    private ModifyGroupNameIconPresent mModifyNameIconPresent;
    private TextView mGroupNameTextView;
    private ImageView mGroupIconImageView;
    private GroupMembersAdapter mBaseGroupMembersAdapter;
    private String mIconUrl;
    private String mGroupId;
    private List<GroupMembersEntity> mGroupMemBersList;
    private boolean isGroupOwner = false;

    public void start() {
        this.mUpFilePresent = new UpFilePresent((IUpFileView)this);
        this.mModifyNameIconPresent = new ModifyGroupNameIconPresent(this);
        this.vToolTitleTextView.setText((CharSequence)"\u7fa4\u7ec4\u4fe1\u606f");
        this.mGroupId = RongUtil.getInstance().getChatExtraBean().getTargetId();
        this.mGroupTopSwitch = (Switch)this.findViewById(R.id.switch_group_top);
        this.mGroupNoDisturbSwitch = (Switch)this.findViewById(R.id.switch_group_disturb);
        this.mNoScrollGridView = (NoScrollGridView)this.findViewById(R.id.vGridView);
        this.mCheckMoreMembersView = (TextView)this.findViewById(R.id.check_more_members);
        this.findViewById(R.id.del_group_members).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                new AlertDialog.Builder((Context)GroupInfoActivity.this).setTitle(R.string.byhim_delemembers_title).setMessage(R.string.byhim_delmembers_message).setNegativeButton(R.string.im_ok, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        GroupInfoActivity.this.quitGroup(GroupInfoActivity.this.mGroupId);
                    }
                }).setPositiveButton(R.string.byhim_dialog_cancel, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                    }
                }).show();
            }
        });
        this.mBaseGroupMembersAdapter = new GroupMembersAdapter(this.getBaseContext());
        this.mBaseGroupMembersAdapter.setOnClickMemberItemListener(new GroupMembersAdapter.ClickMemberItemListener(){

            @Override
            public void clickItem(int position, GroupMembersEntity groupMembersEntity) {
                String doctorId = groupMembersEntity.getDoctorId();
                if (!TextUtils.isEmpty((CharSequence)doctorId)) {
                    int docId = Integer.parseInt(doctorId);
                    GroupInfoActivity.this.startActivity(new Intent(GroupInfoActivity.this.getBaseContext(), FrameContractsActivity.class).putExtra("MSG_JUMP_TYPE", 5394).putExtra("IM_DOCTOR_ID", docId));
                }
            }
        });
        this.mNoScrollGridView.setAdapter((ListAdapter)this.mBaseGroupMembersAdapter);
        this.mGroupMembersPresent = new GroupMembersPresent(this);
        String doctorId = VertifyDataUtil.getInstance((Context)this.getBaseContext()).getLoginUserId() + "";
        this.mGroupMembersPresent.reqQueryGroupMembers(this.mGroupId, doctorId, 1, 30, "");
        this.initGroupSwitchListener(this.mGroupId);
        this.mGroupNameTextView = (TextView)this.findViewById(R.id.modify_group_name);
        this.mGroupNameTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GroupInfoActivity.this.startActivity(new Intent(GroupInfoActivity.this.getBaseContext(), ModifyGroupNameActivity.class));
            }
        });
        this.mGroupIconImageView = (ImageView)this.findViewById(R.id.group_header);
        this.mGroupIconImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                new UpPicBottomDialog((Context)GroupInfoActivity.this, R.id.group_header).show();
            }
        });
        this.reqGroupIconName(this.mGroupId);
    }

    private void initGroupSwitchListener(final String groupId) {
        RongIMClient.getInstance().getConversation(Conversation.ConversationType.GROUP, groupId, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Conversation>(){

            public void onSuccess(Conversation conversation) {
                if (conversation == null) {
                    return;
                }
                boolean isTop = conversation.isTop();
                Conversation.ConversationNotificationStatus conversationNotificationStatus = conversation.getNotificationStatus();
                if (conversationNotificationStatus.getValue() == 0) {
                    GroupInfoActivity.this.mGroupNoDisturbSwitch.setChecked(true);
                } else {
                    GroupInfoActivity.this.mGroupNoDisturbSwitch.setChecked(false);
                }
                GroupInfoActivity.this.mGroupTopSwitch.setChecked(isTop);
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
            }
        });
        this.mGroupNoDisturbSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (isChecked) {
                    RongIM.getInstance().setConversationNotificationStatus(Conversation.ConversationType.GROUP, groupId, Conversation.ConversationNotificationStatus.DO_NOT_DISTURB, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Conversation.ConversationNotificationStatus>(){

                        public void onSuccess(Conversation.ConversationNotificationStatus conversationNotificationStatus) {
                            Log.i((String)GroupInfoActivity.TAG, (String)"\u5c4f\u853d\u7fa4\u6d88\u606f==onSuccess===");
                        }

                        public void onError(RongIMClient.ErrorCode errorCode) {
                            Log.i((String)GroupInfoActivity.TAG, (String)("\u5c4f\u853d\u7fa4\u6d88\u606f==onError===" + errorCode));
                        }
                    });
                } else {
                    RongIM.getInstance().setConversationNotificationStatus(Conversation.ConversationType.GROUP, groupId, Conversation.ConversationNotificationStatus.NOTIFY, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Conversation.ConversationNotificationStatus>(){

                        public void onSuccess(Conversation.ConversationNotificationStatus conversationNotificationStatus) {
                            Log.i((String)GroupInfoActivity.TAG, (String)"\u5c4f\u853d\u7fa4\u6d88\u606f==onSuccess===");
                        }

                        public void onError(RongIMClient.ErrorCode errorCode) {
                            Log.i((String)GroupInfoActivity.TAG, (String)("\u5c4f\u853d\u7fa4\u6d88\u606f==onError===" + errorCode));
                        }
                    });
                }
            }
        });
        this.mGroupTopSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                RongIM.getInstance().setConversationToTop(Conversation.ConversationType.GROUP, groupId, isChecked, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Boolean>(){

                    public void onSuccess(Boolean aBoolean) {
                        Log.i((String)GroupInfoActivity.TAG, (String)"\u7fa4\u804a\u7f6e\u9876==onSuccess===");
                    }

                    public void onError(RongIMClient.ErrorCode errorCode) {
                        Log.i((String)GroupInfoActivity.TAG, (String)("\u7fa4\u804a\u7f6e\u9876==onError===" + errorCode));
                    }
                });
            }
        });
    }

    private void reqGroupIconName(String groupId) {
        new ReqIconNickModel().reqGroupIconNickname(groupId).subscribe((Observer)new Observer<ResponseBody<ImGroupInfoEntity>>(){

            public void onSubscribe(Disposable d) {
            }

            @SuppressLint(value={"ResourceType"})
            public void onNext(ResponseBody<ImGroupInfoEntity> imGroupInfoEntityResponseBody) {
                ImGroupInfoEntity imGroupInfoEntity = (ImGroupInfoEntity)imGroupInfoEntityResponseBody.getResult();
                if (imGroupInfoEntity != null) {
                    String iconUrl = imGroupInfoEntity.getLogoUrl();
                    GroupInfoActivity.this.mIconUrl = iconUrl;
                    String groupName = imGroupInfoEntity.getGroupName();
                    Pretty.create().loadImage(iconUrl).placeholder(R.mipmap.logo_patient).into(GroupInfoActivity.this.mGroupIconImageView);
                    GroupInfoActivity.this.mGroupNameTextView.setText((CharSequence)groupName);
                }
            }

            public void onError(Throwable e) {
                GroupInfoActivity.this.showShortToast(e.toString());
            }

            public void onComplete() {
            }
        });
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void dealWithPicPathEvent(ByhCommEvent.UploadImg uploadImgEvent) {
        String path = (String)uploadImgEvent.getPhotoInfoList().get(0);
        if (this.getBaseContext() == null) {
            return;
        }
        Luban.with((Context)this.getBaseContext()).load(path).ignoreBy(20).setCompressListener(new OnCompressListener(){

            public void onStart() {
                Log.i((String)GroupInfoActivity.TAG, (String)"==onStart====");
            }

            public void onSuccess(File file) {
                String filePath = file.getAbsolutePath();
                String fileSize = FileUtils.getAutoFileOrFilesSize((String)filePath);
                Log.i((String)GroupInfoActivity.TAG, (String)("==onSuccess====fileSize==" + fileSize));
                GroupInfoActivity.this.mUpFilePresent.upImgFile(filePath);
            }

            public void onError(Throwable e) {
                Log.i((String)GroupInfoActivity.TAG, (String)("==onError==" + e.toString()));
            }
        }).launch();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void deleteMembersOk(ByhCommEvent.DelMembersOk delMembersOk) {
        String groupId = RongUtil.getInstance().getChatExtraBean().getTargetId();
        String doctorId = VertifyDataUtil.getInstance((Context)this.getBaseContext()).getLoginUserId() + "";
        this.mGroupMembersPresent.reqQueryGroupMembers(groupId, doctorId, 1, 30, "");
    }

    private void quitGroup(String groupId) {
        UnGroupBody unGroupBody = new UnGroupBody();
        unGroupBody.setGroupId(groupId);
        UnGroupBody.RongCloudUserIdVoListBean rongCloudUserIdVoListBean = new UnGroupBody.RongCloudUserIdVoListBean();
        int doctorId = VertifyDataUtil.getInstance((Context)this.getBaseContext()).getLoginUserId();
        String rongId = VertifyDataUtil.getInstance((Context)this.getBaseContext()).getRongCloundId();
        rongCloudUserIdVoListBean.setRongCloudId(rongId);
        rongCloudUserIdVoListBean.setUserId(doctorId + "");
        ArrayList<UnGroupBody.RongCloudUserIdVoListBean> rongCloudUserIdVoListBeanList = new ArrayList<UnGroupBody.RongCloudUserIdVoListBean>();
        rongCloudUserIdVoListBeanList.add(rongCloudUserIdVoListBean);
        unGroupBody.setRongCloudUserIdVoList(rongCloudUserIdVoListBeanList);
        if (this.isGroupOwner) {
            this.mGroupMembersPresent.reqUnGroupMembers(unGroupBody);
        } else {
            this.mGroupMembersPresent.reqQuitGroup(unGroupBody);
        }
    }

    public int getContentLayoutId() {
        return R.layout.byhim_groupinfo_activity;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.finish();
    }

    @Override
    public void bindGroupMembers(MembersPageBean membersPageBean) {
        List groupMembersEntityList = membersPageBean.getPageData();
        if (groupMembersEntityList == null) {
            return;
        }
        if (this.mGroupMemBersList != null) {
            this.mGroupMemBersList.clear();
        }
        this.mGroupMemBersList = groupMembersEntityList;
        this.mCheckMoreMembersView.setVisibility(0);
        this.isGroupOwner = membersPageBean.getRole() == 1;
        List<GroupMembersEntity> grouAddList = this.subListByNum(groupMembersEntityList, 24);
        if (grouAddList != null) {
            grouAddList.add(new GroupMembersEntity(13090));
            if (this.isGroupOwner) {
                grouAddList.add(new GroupMembersEntity(13091));
            }
        }
        this.mBaseGroupMembersAdapter.clear();
        this.mBaseGroupMembersAdapter.addCollection(grouAddList);
        this.mBaseGroupMembersAdapter.notifyDataSetChanged();
        if (groupMembersEntityList.size() > 24) {
            this.mCheckMoreMembersView.setVisibility(0);
            this.mCheckMoreMembersView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    GroupInfoActivity.this.startActivity(new Intent(GroupInfoActivity.this.getBaseContext(), GroupMembersActivity.class));
                }
            });
        } else {
            this.mCheckMoreMembersView.setVisibility(8);
        }
    }

    @Override
    public void unGroupMembersOk() {
        this.showShortToast("\u89e3\u6563\u6210\u529f");
        ARouter.getInstance().build("/home/MainActivity").navigation();
    }

    @Override
    public void quitGroupOk() {
        this.showShortToast("\u9000\u7fa4\u6210\u529f");
        ARouter.getInstance().build("/home/MainActivity").navigation();
    }

    private List<GroupMembersEntity> subListByNum(List<GroupMembersEntity> groupMembers, int maxNum) {
        ArrayList<GroupMembersEntity> groupMembersEntityList = new ArrayList<GroupMembersEntity>();
        for (GroupMembersEntity groupMembersEntity : groupMembers) {
            groupMembersEntityList.add(groupMembersEntity);
        }
        if (groupMembersEntityList.size() > maxNum) {
            return groupMembersEntityList.subList(0, maxNum);
        }
        return groupMembersEntityList;
    }

    public void showUpFileInfo(ResponseBody<UpImgEntity> upImgEntityResponseBody) {
        UpImgEntity upImgEntity = (UpImgEntity)upImgEntityResponseBody.getResult();
        this.mIconUrl = upImgEntity.getUrl();
        if (!TextUtils.isEmpty((CharSequence)upImgEntity.getUrl())) {
            String groupId = RongUtil.getInstance().getChatExtraBean().getTargetId();
            this.mModifyNameIconPresent.modifyGroupNameIcon(groupId, "", upImgEntity.getUrl());
        }
    }

    @Override
    @SuppressLint(value={"ResourceType"})
    public void modifyGroupNameOk() {
        this.showShortToast("\u4fee\u6539\u6210\u529f");
        if (TextUtils.isEmpty((CharSequence)this.mIconUrl)) {
            return;
        }
        String groupId = RongUtil.getInstance().getChatExtraBean().getTargetId();
        if (TextUtils.isEmpty((CharSequence)groupId)) {
            return;
        }
        String groupName = this.mGroupNameTextView.getText().toString().trim();
        Group group2 = new Group(groupId, groupName, Uri.parse((String)this.mIconUrl));
        RongIM.getInstance().refreshGroupInfoCache(group2);
        Pretty.create().loadImage(this.mIconUrl).placeholder(R.mipmap.logo_patient).into(this.mGroupIconImageView);
        ExpertInfoEntity.UserInfoVOBean userInfoVOBean = VertifyDataUtil.getInstance((Context)this.getBaseContext()).getUserInfo();
        if (userInfoVOBean != null) {
            String localName = userInfoVOBean.getName();
            RongUtil.getInstance().sendGroupNotifyMsg(this.mGroupId, localName + "\u4fee\u6539\u4e86\u7fa4\u5934\u50cf");
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void modifyGroupNameOkEvent(ByhCommEvent.ModifyGroupNameOk modifyGroupNameOk) {
        if (TextUtils.isEmpty((CharSequence)this.mIconUrl)) {
            return;
        }
        String groupId = RongUtil.getInstance().getChatExtraBean().getTargetId();
        if (TextUtils.isEmpty((CharSequence)groupId)) {
            return;
        }
        String groupName = modifyGroupNameOk.getGroupName();
        Group group2 = new Group(groupId, groupName, Uri.parse((String)this.mIconUrl));
        RongIM.getInstance().refreshGroupInfoCache(group2);
        this.mGroupNameTextView.setText((CharSequence)groupName);
        ExpertInfoEntity.UserInfoVOBean userInfoVOBean = VertifyDataUtil.getInstance((Context)this.getBaseContext()).getUserInfo();
        if (userInfoVOBean != null) {
            String localName = userInfoVOBean.getName();
            RongUtil.getInstance().sendGroupNotifyMsg(this.mGroupId, localName + "\u4fee\u6539\u4e86\u7fa4\u540d\u79f0");
        }
        EventBus.getDefault().post((Object)new ByhCommEvent.UpdateGroupName(groupId, ByhCommEvent.UpdateGroupName.IM_CHATIN));
    }

    public void onError(String msg) {
        this.showShortToast(msg);
    }
}

