/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim;

import android.os.Bundle;
import android.util.Log;
import android.view.View;
import com.alibaba.android.arouter.launcher.ARouter;
import com.byh.lib.byhim.R;
import com.byh.lib.byhim.bean.RongChatExtraBean;
import com.byh.lib.byhim.fragment.ImGroupChatFragment;
import com.byh.lib.byhim.fragment.ImPrivateChatFragment;
import com.byh.lib.byhim.fragment.TeleConsultFragment;
import com.byh.lib.byhim.fragment.VideoConsFragment;
import com.byh.lib.byhim.present.IiConsuLationPresent;
import com.byh.lib.byhim.present.clc.ClcConsuLationPresent;
import com.byh.lib.byhim.present.impl.ImConsuLationPresent;
import com.byh.lib.byhim.utils.RongUtil;
import com.byh.lib.byhim.view.ImConsulationView;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.entity.response.ImConsulationEntity;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.global.ByConstant;
import com.kangxin.common.byh.util.inter.IUpdateVerStatus;
import io.rong.imlib.model.Conversation;
import java.io.Serializable;
import java.util.Locale;
import me.yokeyword.fragmentation.ISupportFragment;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.jetbrains.annotations.NotNull;

public class ImChatActivity
extends BaseActivity
implements IToolView,
ImConsulationView {
    private static final String TAG = "ImChatActivity";
    private IiConsuLationPresent mConsulationPresent;
    private IUpdateVerStatus mUpdateVerStatus;

    public void start() {
        this.initConsuPresent();
        String chatTitle = this.getIntent().getData().getQueryParameter("title");
        this.vToolTitleTextView.setText((CharSequence)chatTitle);
        this.loadChatPageByType();
    }

    private void initConsuPresent() {
        RongChatExtraBean rongChatExtraBean = RongUtil.getInstance().getChatExtraBean();
        if (rongChatExtraBean != null) {
            int orderType = rongChatExtraBean.getOrderType();
            Log.i((String)TAG, (String)("initConsuPresent: chatType:" + orderType));
            switch (orderType) {
                case 4: 
                case 6: {
                    this.mConsulationPresent = new ClcConsuLationPresent(this);
                    break;
                }
                case 3: {
                    this.mConsulationPresent = new ImConsuLationPresent(this);
                    break;
                }
                default: {
                    Log.i((String)TAG, (String)("initConsuPresent: no match ordertype:" + orderType));
                }
            }
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receiveUpdateGrouNameEvent(ByhCommEvent.UpdateGroupName updateGroupName) {
        if (updateGroupName.getType() == ByhCommEvent.UpdateGroupName.IM_CHATIN) {
            RongUtil.getInstance().updateGroupIconNick(updateGroupName.getGroupId(), groupInfoEntity -> this.vToolTitleTextView.setText((CharSequence)groupInfoEntity.getGroupName()));
        }
    }

    private void loadChatPageByType() {
        Conversation.ConversationType conversationType = Conversation.ConversationType.valueOf((String)this.getIntent().getData().getLastPathSegment().toUpperCase(Locale.getDefault()));
        switch (conversationType) {
            case GROUP: {
                String orderId = RongUtil.getInstance().getChatExtraBean().getOrderUuid();
                Log.i((String)TAG, (String)("orderId==>" + orderId));
                int chatType = Integer.parseInt(RongUtil.getInstance().getChatExtraBean().getChatType());
                int orderType = RongUtil.getInstance().getChatExtraBean().getOrderType();
                if (orderType == 4 || orderType == 6) {
                    if ("0".equals(orderId)) break;
                    this.mConsulationPresent.reqConsulationInfoByOrderId(orderId);
                    break;
                }
                if (orderType == 3 || orderType == ByConstant.NORMAL_GROUP_CHAT) {
                    RongUtil.getInstance();
                    if (!RongUtil.isContypeMsgByChatType(chatType)) {
                        this.loadGroupFragment();
                        break;
                    }
                    if ("0".equals(orderId)) break;
                    this.mConsulationPresent.reqConsulationInfoByOrderId(orderId);
                    break;
                }
                Log.i((String)TAG, (String)("loadChatPageByType: chatType:" + chatType + ", orderType:" + orderType));
                break;
            }
            case PRIVATE: {
                this.loadRootFragment(R.id.frame_content, (ISupportFragment)ImPrivateChatFragment.getInstance());
            }
        }
    }

    private void loadGroupFragment(ImConsulationEntity consulationEntity, long orderId) {
        int groupType = consulationEntity.getConsultationEntity().getType();
        Log.i((String)TAG, (String)("groupType==>" + groupType));
        switch (groupType) {
            case 4: 
            case 6: {
                Bundle videoBundle = new Bundle();
                videoBundle.putSerializable("CONSUINFO_KEY", (Serializable)consulationEntity);
                videoBundle.putLong("orderId", orderId);
                VideoConsFragment videoConsFragment = VideoConsFragment.getInstance();
                videoConsFragment.setArguments(videoBundle);
                this.loadRootFragment(R.id.frame_content, (ISupportFragment)videoConsFragment);
                break;
            }
            case 5: {
                Bundle imgTextBundle = new Bundle();
                imgTextBundle.putSerializable("CONSUINFO_KEY", (Serializable)consulationEntity);
                imgTextBundle.putLong("orderId", orderId);
                TeleConsultFragment teleConsultFragment = TeleConsultFragment.getInstance();
                teleConsultFragment.setArguments(imgTextBundle);
                this.loadRootFragment(R.id.frame_content, (ISupportFragment)teleConsultFragment);
            }
        }
    }

    private void loadGroupFragment() {
        this.vToolRightView.setVisibility(0);
        this.vToolRightView.setImageResource(R.drawable.ic_byhim_group_righticon);
        this.vToolRightView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ARouter.getInstance().build("/immsg/GroupInfoActivity").navigation();
            }
        });
        this.loadRootFragment(R.id.frame_content, (ISupportFragment)ImGroupChatFragment.getInstance());
    }

    public int getContentLayoutId() {
        return R.layout.title_frame_layout;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.finish();
    }

    @Override
    public void bindConsulationInfo(ImConsulationEntity consulationEntity, long orderId) {
        if (consulationEntity == null) {
            return;
        }
        this.loadGroupFragment(consulationEntity, orderId);
    }

    public void onError(String msg) {
        this.showShortToast(msg);
    }
}

