/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim;

import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.ToastUtils;
import com.byh.lib.byhim.R;
import com.byh.lib.byhim.adapter.GroupChatAdapter;
import com.byh.lib.byhim.bean.CreateChatGroupEntity;
import com.byh.lib.byhim.bean.FriendsEntity;
import com.byh.lib.byhim.bean.RongChatExtraBean;
import com.byh.lib.byhim.bean.UnGroupBody;
import com.byh.lib.byhim.present.FriendsListPresent;
import com.byh.lib.byhim.utils.RongUtil;
import com.byh.lib.byhim.view.IShowFriendsView;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.entity.ExpertInfoEntity;
import com.kangxin.common.byh.entity.response.GroupMembersEntity;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.global.ByConstant;
import com.kangxin.common.byh.service.IMeetingService;
import com.kangxin.common.byh.util.VertifyDataUtil;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.rong.imlib.model.Conversation;
import java.util.ArrayList;
import java.util.List;
import me.yokeyword.indexablerv.IndexableAdapter;
import me.yokeyword.indexablerv.IndexableLayout;
import org.greenrobot.eventbus.EventBus;
import org.jetbrains.annotations.NotNull;

@Route(path="/chat/friends/ImGroupChatActivity")
public class ImGroupChatActivity
extends BaseActivity
implements IToolView,
IShowFriendsView {
    private static final String TAG = "ImGroupChatActivity";
    private EditText mSearchEdtView;
    private IndexableLayout mIndexLayout;
    private GroupChatAdapter mGroupChatAdapter;
    private FriendsListPresent mFriendsListPresent;
    private List<GroupMembersEntity> mGroupMembersEntities;
    private List<UnGroupBody.RongCloudUserIdVoListBean> mRongCloudUserIdVoListBeanList;
    private int mPageType = -1;
    private String mMeetNum;
    private List<FriendsEntity> mFriendsList;
    private StringBuilder mGroupNameBuild;

    private boolean isAddMembersType() {
        int jumpType = this.getIntent().getIntExtra("MSG_JUMP_TYPE", -1);
        return jumpType == 86393;
    }

    private void jointGroup() {
        List<FriendsEntity> friendsEntityList = this.filterFriendListForJointGroup();
        if (friendsEntityList == null) {
            return;
        }
        if (friendsEntityList.size() == 0) {
            this.showShortToast("\u8bf7\u9009\u62e9\u597d\u53cb");
            return;
        }
        String groupId = RongUtil.getInstance().getChatExtraBean().getTargetId();
        UnGroupBody unGroupBody = new UnGroupBody();
        unGroupBody.setGroupId(groupId);
        unGroupBody.setName("\u52a0\u597d\u53cb");
        unGroupBody.setGroupType(5);
        this.mRongCloudUserIdVoListBeanList = new ArrayList<UnGroupBody.RongCloudUserIdVoListBean>();
        for (FriendsEntity friendsEntity : friendsEntityList) {
            UnGroupBody.RongCloudUserIdVoListBean rongCloudUserIdVoListBean = new UnGroupBody.RongCloudUserIdVoListBean();
            rongCloudUserIdVoListBean.setUserId(friendsEntity.getDoctorId() + "");
            rongCloudUserIdVoListBean.setRongCloudId(friendsEntity.getRongCloudId());
            rongCloudUserIdVoListBean.setUserType(3);
            rongCloudUserIdVoListBean.setHeadImageUrl(friendsEntity.getHeadImageUrl());
            rongCloudUserIdVoListBean.setUserName(friendsEntity.getDisplayName());
            this.mRongCloudUserIdVoListBeanList.add(rongCloudUserIdVoListBean);
        }
        unGroupBody.setRongCloudUserIdVoList(this.mRongCloudUserIdVoListBeanList);
        this.mFriendsListPresent.reqJointGroup(unGroupBody);
    }

    private List<FriendsEntity> filterFriendListForJointGroup() {
        if (this.mFriendsList == null) {
            return null;
        }
        ArrayList<FriendsEntity> friendsEntityList = new ArrayList<FriendsEntity>();
        for (FriendsEntity friendsEntity : this.mFriendsList) {
            if (!friendsEntity.isSelected() || friendsEntity.isGroupMember()) continue;
            friendsEntityList.add(friendsEntity);
        }
        return friendsEntityList;
    }

    private void sendJointMettingInviteMsg() {
        if (TextUtils.isEmpty((CharSequence)this.mMeetNum)) {
            ToastUtils.showLong((CharSequence)"\u65e0\u623f\u95f4\u53f7");
            return;
        }
        if (this.mFriendsList == null) {
            ToastUtils.showLong((CharSequence)"\u8bf7\u9009\u62e9\u6210\u5458");
            return;
        }
        if (this.mFriendsList.size() == 0) {
            ToastUtils.showLong((CharSequence)"\u8bf7\u9009\u62e9\u6210\u5458");
            return;
        }
        ArrayList<FriendsEntity> jointList = new ArrayList<FriendsEntity>();
        for (FriendsEntity friendsEntity : this.mFriendsList) {
            if (!friendsEntity.isSelected()) continue;
            jointList.add(friendsEntity);
        }
        String localName = VertifyDataUtil.getInstance((Context)this.mContext).getLoginData().getName();
        for (FriendsEntity name : jointList) {
            String targetId = name.getRongCloudId();
            String phoneNum = name.getRegisterMobile();
            RongUtil.getInstance().getChatExtraBean().setPhoneNum(phoneNum);
            String desc = localName + "\u9080\u8bf7\u60a8\u52a0\u5165\u8fdc\u7a0b\u4f1a\u8bae";
            RongUtil.getInstance().sendJoinMettingMsg(targetId, desc, this.mMeetNum, phoneNum, () -> {
                Log.i((String)TAG, (String)("sendJointMettingInviteMsg: targetId:" + targetId));
                ToastUtils.showLong((CharSequence)"\u4f1a\u8bae\u9080\u8bf7\u5df2\u53d1\u9001");
                final ProgressDialog progressDialog = new ProgressDialog(this.mContext);
                new AlertDialog.Builder(this.mContext).setMessage((CharSequence)"\u662f\u5426\u7acb\u5373\u5f00\u542f\u4f1a\u8bae").setPositiveButton((CharSequence)"\u7acb\u5373\u5f00\u542f", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        IMeetingService service = (IMeetingService)ARouter.getInstance().build("/meeting_service/meeting_service").navigation();
                        ExpertInfoEntity.UserInfoVOBean userInfo = VertifyDataUtil.getInstance((Context)ImGroupChatActivity.this.mContext).getUserInfo();
                        service.startMeeting(userInfo.getRegisterMobile().toString(), userInfo.getName(), userInfo.getHeadPortrait()).subscribe((Observer)new Observer<IMeetingService.State>(){

                            public void onSubscribe(Disposable d) {
                                progressDialog.setMessage((CharSequence)"\u52a0\u8f7d\u4e2d...");
                                progressDialog.show();
                            }

                            public void onNext(IMeetingService.State state) {
                                if (state == IMeetingService.State.Success) {
                                    progressDialog.dismiss();
                                }
                                ImGroupChatActivity.this.finish();
                            }

                            public void onError(Throwable e) {
                                Log.i((String)ImGroupChatActivity.TAG, (String)"onError: ============");
                                progressDialog.dismiss();
                            }

                            public void onComplete() {
                                Log.i((String)ImGroupChatActivity.TAG, (String)"onComplete: ============");
                                progressDialog.dismiss();
                            }
                        });
                    }
                }).setNegativeButton((CharSequence)"\u6682\u4e0d\u5f00\u542f", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        ImGroupChatActivity.this.finish();
                    }
                }).show();
            });
        }
    }

    public void start() {
        this.mFriendsListPresent = new FriendsListPresent(this);
        this.mPageType = this.getIntent().getIntExtra("PAGE_TYPE", -1);
        if (this.isAddMembersType()) {
            this.vToolTitleTextView.setText(R.string.byhim_im_add_members);
            this.mGroupMembersEntities = (List)((Object)this.getIntent().getSerializableExtra("GROUP_MEMBERS_KEY"));
        } else if (this.mPageType == 4386) {
            this.vToolTitleTextView.setText(R.string.im_chat_group);
        } else if (this.mPageType == 4387) {
            this.mMeetNum = this.getIntent().getStringExtra("MeetNum");
            this.vToolTitleTextView.setText(R.string.byhim_chat_joint_metting);
        }
        this.vToolRightTextView.setVisibility(0);
        this.vToolRightTextView.setText(R.string.im_ok);
        this.vToolRightTextView.setTextColor(-1);
        this.vToolRightTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ImGroupChatActivity.this.mPageType == 4386) {
                    if (ImGroupChatActivity.this.isAddMembersType()) {
                        ImGroupChatActivity.this.jointGroup();
                    } else {
                        ImGroupChatActivity.this.createGroup();
                    }
                } else if (ImGroupChatActivity.this.mPageType == 4387) {
                    ImGroupChatActivity.this.sendJointMettingInviteMsg();
                }
            }
        });
        this.mSearchEdtView = (EditText)this.findViewById(R.id.search_bar);
        this.mIndexLayout = (IndexableLayout)this.findViewById(R.id.vIndexLayout);
        this.mIndexLayout.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getMContext()));
        this.mGroupChatAdapter = new GroupChatAdapter(this.getBaseContext());
        this.mIndexLayout.setAdapter((IndexableAdapter)this.mGroupChatAdapter);
        this.mGroupChatAdapter.setOnItemContentClickListener((IndexableAdapter.OnItemContentClickListener)new IndexableAdapter.OnItemContentClickListener<FriendsEntity>(){

            public void onItemClick(View v, int originalPosition, int currentPosition, FriendsEntity entity) {
                Log.i((String)ImGroupChatActivity.TAG, (String)("originalPosition==>" + originalPosition));
                Log.i((String)ImGroupChatActivity.TAG, (String)("currentPosition==>" + currentPosition));
                if (((FriendsEntity)ImGroupChatActivity.this.mFriendsList.get(originalPosition)).isGroupMember()) {
                    return;
                }
                if (((FriendsEntity)ImGroupChatActivity.this.mFriendsList.get(originalPosition)).isSelected()) {
                    ((FriendsEntity)ImGroupChatActivity.this.mFriendsList.get(originalPosition)).setSelected(false);
                } else {
                    ((FriendsEntity)ImGroupChatActivity.this.mFriendsList.get(originalPosition)).setSelected(true);
                }
                ImGroupChatActivity.this.mGroupChatAdapter.notifyDataSetChanged();
            }
        });
        final int loginUserId = VertifyDataUtil.getInstance((Context)this.getBaseContext()).getLoginUserId();
        if (loginUserId != -1) {
            this.mFriendsListPresent.showFriendsList(loginUserId + "", "", true);
        }
        this.mSearchEdtView.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView textView, int actionId, KeyEvent event) {
                if (actionId == 3) {
                    String searchParam = ImGroupChatActivity.this.mSearchEdtView.getText().toString().trim();
                    if (loginUserId != -1) {
                        ImGroupChatActivity.this.mFriendsListPresent.showFriendsList(loginUserId + "", searchParam, true);
                    }
                }
                return false;
            }
        });
    }

    public int getContentLayoutId() {
        return R.layout.im_groupchat_activity;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.finish();
    }

    @Override
    public void showFriendsList(List<FriendsEntity> friendsEntities) {
        this.mFriendsList = friendsEntities;
        this.changeGroupMembersList();
        this.mGroupChatAdapter.setDatas(this.mFriendsList);
        this.mGroupChatAdapter.notifyDataSetChanged();
    }

    private void changeGroupMembersList() {
        if (this.mFriendsList == null) {
            return;
        }
        if (this.isAddMembersType()) {
            if (this.mGroupMembersEntities == null) {
                return;
            }
            for (int i = 0; i < this.mGroupMembersEntities.size(); ++i) {
                for (int j = 0; j < this.mFriendsList.size(); ++j) {
                    int gDocId = Integer.parseInt(this.mGroupMembersEntities.get(i).getDoctorId());
                    if (gDocId != this.mFriendsList.get(j).getDoctorId()) continue;
                    this.mFriendsList.get(j).setGroupMember(true);
                    this.mFriendsList.get(j).setSelected(true);
                }
            }
        }
    }

    private void createGroup() {
        CreateChatGroupEntity createChatGroupEntity = new CreateChatGroupEntity();
        createChatGroupEntity.setGroupType(5);
        int loginUserId = VertifyDataUtil.getInstance((Context)this.getBaseContext()).getLoginUserId();
        LoginSuccess loginSuccess = VertifyDataUtil.getInstance((Context)this.getBaseContext()).getLoginData();
        int loginUserType = VertifyDataUtil.getInstance((Context)this.getBaseContext()).getLoginData().getUserType();
        if (loginUserType != 0) {
            createChatGroupEntity.setLoginUserType(loginUserType);
        }
        if (loginUserId != -1) {
            createChatGroupEntity.setLoginUserId(loginUserId + "");
        }
        this.mGroupNameBuild = new StringBuilder();
        ArrayList<CreateChatGroupEntity.RongCloudUserIdVoListBean> rongCloudUserIdVoListBeanList = new ArrayList<CreateChatGroupEntity.RongCloudUserIdVoListBean>();
        if (this.mFriendsList == null) {
            ToastUtils.showShort((CharSequence)"\u6ca1\u6709\u597d\u53cb\uff0c\u5c1d\u8bd5\u6dfb\u52a0\u51e0\u4e2a\u5427");
            return;
        }
        for (FriendsEntity friendsEntity : this.mFriendsList) {
            if (!friendsEntity.isSelected()) continue;
            CreateChatGroupEntity.RongCloudUserIdVoListBean rongCloudUserIdVoListBean = new CreateChatGroupEntity.RongCloudUserIdVoListBean();
            this.mGroupNameBuild.append(friendsEntity.getDisplayName() + ",");
            rongCloudUserIdVoListBean.setHeadImageUrl(friendsEntity.getHeadImageUrl());
            String friendRongId = friendsEntity.getRongCloudId();
            Log.i((String)TAG, (String)("friendRongId==>" + friendRongId));
            rongCloudUserIdVoListBean.setRongCloudId(friendRongId);
            rongCloudUserIdVoListBean.setUserId(friendsEntity.getDoctorId() + "");
            rongCloudUserIdVoListBean.setUserType(loginUserType);
            rongCloudUserIdVoListBean.setUserName(friendsEntity.getDisplayName());
            rongCloudUserIdVoListBeanList.add(rongCloudUserIdVoListBean);
        }
        ExpertInfoEntity.UserInfoVOBean userInfoVOBean = VertifyDataUtil.getInstance((Context)this.getBaseContext()).getUserInfo();
        String groupName = this.mGroupNameBuild.append(userInfoVOBean.getName()).toString();
        createChatGroupEntity.setName(groupName);
        if (rongCloudUserIdVoListBeanList.isEmpty()) {
            this.showShortToast("\u8bf7\u9009\u62e9\u6210\u5458");
            return;
        }
        CreateChatGroupEntity.RongCloudUserIdVoListBean mineBean = new CreateChatGroupEntity.RongCloudUserIdVoListBean();
        mineBean.setHeadImageUrl(userInfoVOBean.getHeadPortrait());
        String mineRongId = loginSuccess.getRongCloudId();
        Log.i((String)TAG, (String)("mineRongId===>" + mineRongId));
        if (TextUtils.isEmpty((CharSequence)mineRongId)) {
            this.showShortToast("myself rong id is null");
            return;
        }
        mineBean.setRongCloudId(mineRongId);
        mineBean.setUserType(loginUserType);
        mineBean.setUserId(loginUserId + "");
        mineBean.setUserName(userInfoVOBean.getName());
        rongCloudUserIdVoListBeanList.add(mineBean);
        createChatGroupEntity.setRongCloudUserIdVoList(rongCloudUserIdVoListBeanList);
        this.mFriendsListPresent.createChatGroup(createChatGroupEntity);
    }

    @Override
    public void startGroupChatPage(String groupId) {
        RongChatExtraBean rongChatExtraBean = new RongChatExtraBean();
        rongChatExtraBean.setTargetId(groupId);
        rongChatExtraBean.setName(this.mGroupNameBuild.toString());
        rongChatExtraBean.setOrderType(ByConstant.NORMAL_GROUP_CHAT);
        RongUtil.startConversation(this.getBaseContext(), Conversation.ConversationType.GROUP, rongChatExtraBean);
        ExpertInfoEntity.UserInfoVOBean userInfoVOBean = VertifyDataUtil.getInstance((Context)this.getBaseContext()).getUserInfo();
        if (userInfoVOBean != null) {
            String localName = userInfoVOBean.getName();
            String groupName = this.fillSelf(this.mGroupNameBuild.toString(), localName);
            RongUtil.getInstance().sendGroupNotifyMsg(groupId, localName + "\u9080\u8bf7" + groupName + "\u52a0\u5165\u4e86\u7fa4\u804a");
        }
    }

    private String fillSelf(String members, String localName) {
        if (members == null) {
            return null;
        }
        String[] memArray = members.split(",");
        ArrayList<String> memList = new ArrayList<String>();
        StringBuilder memBuilder = new StringBuilder();
        String groupName = null;
        if (memArray != null) {
            for (String str : memArray) {
                if (localName.equals(str)) continue;
                memList.add(str);
            }
            for (String mem : memList) {
                memBuilder.append(mem + ",");
            }
            groupName = memBuilder.substring(0, memBuilder.length() - 1);
        }
        return groupName;
    }

    @Override
    public void jointGroupMembersOk() {
        this.showShortToast("\u6dfb\u52a0\u6210\u529f");
        if (this.mRongCloudUserIdVoListBeanList != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (UnGroupBody.RongCloudUserIdVoListBean pInfo : this.mRongCloudUserIdVoListBeanList) {
                stringBuffer.append(pInfo.getUserName() + ",");
            }
            String memners = stringBuffer.substring(0, stringBuffer.length() - 1);
            String groupId = RongUtil.getInstance().getChatExtraBean().getTargetId();
            ExpertInfoEntity.UserInfoVOBean userInfoVOBean = VertifyDataUtil.getInstance((Context)this.getBaseContext()).getUserInfo();
            if (userInfoVOBean != null) {
                String localName = userInfoVOBean.getName();
                RongUtil.getInstance().sendGroupNotifyMsg(groupId, localName + "\u9080\u8bf7" + memners + "\u52a0\u5165\u4e86\u7fa4\u804a");
            }
        }
        EventBus.getDefault().post((Object)new ByhCommEvent.DelMembersOk());
        this.finish();
    }

    public void onError(String msg) {
        this.showShortToast(msg);
    }
}

