/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim;

import android.content.Context;
import android.content.Intent;
import android.os.Vibrator;
import android.text.TextUtils;
import android.util.Log;
import cn.bingoogolapple.qrcode.core.QRCodeView;
import cn.bingoogolapple.qrcode.zxing.ZXingView;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.blankj.utilcode.util.ToastUtils;
import com.byh.lib.byhim.FrameContractsActivity;
import com.byh.lib.byhim.R;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.util.StringUtil;
import com.tbruyelle.rxpermissions.RxPermissions;

@Route(path="/byhim/ScanActivity")
public class ScanActivity
extends BaseActivity
implements QRCodeView.Delegate {
    private static final String TAG = "ScanActivity";
    public static String Key_CaseUuid = "Key_CaseUuid";
    private int mScanType = 4;
    private QRCodeView mQRCodeView;
    public static String key_ScanType = "key_ScanType";

    private void initPermission() {
        RxPermissions.getInstance((Context)this).request(new String[]{"android.permission.CAMERA"}).subscribe(grated -> {
            if (grated.booleanValue()) {
                this.mQRCodeView.startCamera();
                this.mQRCodeView.setDelegate((QRCodeView.Delegate)this);
                this.mQRCodeView.startSpotAndShowRect();
            }
        });
    }

    public void onScanQRCodeSuccess(String result) {
        Log.i((String)TAG, (String)("\u626b\u7801\u7ed3\u679c==>" + result));
        String doctorId = this.parseDoctorId(result);
        if (TextUtils.isEmpty((CharSequence)doctorId)) {
            ToastUtils.showLong((CharSequence)"doctorId\u89e3\u6790\u5931\u8d25");
            return;
        }
        Log.i((String)TAG, (String)("onScanQRCodeSuccess: doctorId==>" + doctorId));
        if (!StringUtil.isNumeric((String)doctorId)) {
            ToastUtils.showLong((CharSequence)"\u533b\u751fid\u89e3\u6790\u5f02\u5e38");
            return;
        }
        Intent cardIntent = new Intent((Context)this, FrameContractsActivity.class);
        int docId = Integer.parseInt(doctorId);
        cardIntent.putExtra("IM_DOCTOR_ID", docId);
        cardIntent.putExtra("MSG_JUMP_TYPE", 5394);
        this.startActivity(cardIntent);
        this.finish();
        Vibrator vibrator = (Vibrator)this.getSystemService("vibrator");
        vibrator.vibrate(200L);
        this.finish();
    }

    private String parseDoctorId(String url) {
        String[] subUrlArray;
        if (TextUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        if (url.startsWith("http") && (subUrlArray = url.split("\\?")).length == 2) {
            String[] docSegArray;
            String params = subUrlArray[1];
            String[] segmentArray = params.split("&");
            String docIdSegment = null;
            for (String segment : segmentArray) {
                if (TextUtils.isEmpty((CharSequence)segment) || !segment.contains("doctorId")) continue;
                docIdSegment = segment;
                break;
            }
            if (docIdSegment != null && docIdSegment.contains("=") && (docSegArray = docIdSegment.split("=")).length == 2) {
                return docSegArray[1];
            }
        }
        return null;
    }

    public void onScanQRCodeOpenCameraError() {
        this.finish();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.mQRCodeView.onDestroy();
    }

    public void start() {
        this.mQRCodeView = (ZXingView)this.findViewById(R.id.zxingview02);
        this.findViewById(R.id.back_img).setOnClickListener(v -> this.finish());
        this.initPermission();
        this.mScanType = this.getIntent().getIntExtra(key_ScanType, -1);
        Log.i((String)TAG, (String)("start: mScanType:" + this.mScanType));
    }

    public int getContentLayoutId() {
        return R.layout.activity_scan;
    }
}

