/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.byh.lib.byhim.R;
import com.byh.lib.byhim.bean.ContractEntity;
import com.byh.lib.byhim.callback.OnItemCallClickListener;
import com.kangxin.common.Pretty;
import me.yokeyword.indexablerv.IndexableAdapter;

public class ContractListAdapter
extends IndexableAdapter<ContractEntity> {
    private Context mcontext;
    private OnItemCallClickListener onItemCallClickListener;

    public ContractListAdapter(Context mcontext) {
        this.mcontext = mcontext;
    }

    public RecyclerView.ViewHolder onCreateTitleViewHolder(ViewGroup parent) {
        View inflate = LayoutInflater.from((Context)this.mcontext).inflate(R.layout.contract_index, parent, false);
        return new IndexVH(inflate);
    }

    public RecyclerView.ViewHolder onCreateContentViewHolder(ViewGroup parent) {
        View inflate = LayoutInflater.from((Context)this.mcontext).inflate(R.layout.contract_content, parent, false);
        return new ContractVH(inflate);
    }

    public void onBindTitleViewHolder(RecyclerView.ViewHolder holder, String indexTitle) {
        ((IndexVH)holder).index.setText((CharSequence)indexTitle);
    }

    @SuppressLint(value={"ResourceType"})
    public void onBindContentViewHolder(RecyclerView.ViewHolder holder, ContractEntity entity) {
        ((ContractVH)holder).vContractName.setText((CharSequence)entity.getDisplayName());
        ((ContractVH)holder).vContractDep.setText((CharSequence)entity.getHospitalDeptName());
        Pretty.create().loadImage(entity.getHeadImageUrl()).placeholder(R.drawable.ic_byh_comm_header).err(R.drawable.ic_img_load_err).into(((ContractVH)holder).vImageHead);
        ((ContractVH)holder).vImageCall.setOnClickListener(v -> {
            if (this.onItemCallClickListener != null) {
                this.onItemCallClickListener.call(entity.getPhone());
            }
        });
    }

    public OnItemCallClickListener getOnItemCallClickListener() {
        return this.onItemCallClickListener;
    }

    public void setOnItemCallClickListener(OnItemCallClickListener onItemCallClickListener) {
        this.onItemCallClickListener = onItemCallClickListener;
    }

    private class ContractVH
    extends RecyclerView.ViewHolder {
        ImageView vImageHead;
        TextView vContractName;
        TextView vContractDep;
        ImageView vImageCall;

        public ContractVH(View itemView) {
            super(itemView);
            this.vImageHead = (ImageView)itemView.findViewById(R.id.vImageHead);
            this.vContractName = (TextView)itemView.findViewById(R.id.vContractName);
            this.vContractDep = (TextView)itemView.findViewById(R.id.vContractDep);
            this.vImageCall = (ImageView)itemView.findViewById(R.id.vContractCall);
        }
    }

    private class IndexVH
    extends RecyclerView.ViewHolder {
        TextView index;

        public IndexVH(View itemView) {
            super(itemView);
            this.index = (TextView)itemView.findViewById(R.id.vContractIndex);
        }
    }
}

