/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.net.Uri;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.byh.lib.byhim.bean.InviteInvaMessage;
import com.byh.lib.byhim.bean.JoinMettingMessage;
import com.byh.lib.byhim.bean.PreDiaDescMessage;
import io.rong.common.RLog;
import io.rong.imkit.R;
import io.rong.imkit.RongContext;
import io.rong.imkit.mention.RongMentionManager;
import io.rong.imkit.model.ConversationKey;
import io.rong.imkit.model.GroupUserInfo;
import io.rong.imkit.model.ProviderTag;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.userInfoCache.RongUserInfoManager;
import io.rong.imkit.utilities.RongUtils;
import io.rong.imkit.utils.RongDateUtils;
import io.rong.imkit.widget.AsyncImageView;
import io.rong.imkit.widget.DebouncedOnClickListener;
import io.rong.imkit.widget.ProviderContainerView;
import io.rong.imkit.widget.adapter.MessageListAdapter;
import io.rong.imkit.widget.provider.EvaluateTextMessageItemProvider;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.PublicServiceProfile;
import io.rong.imlib.model.ReadReceiptInfo;
import io.rong.imlib.model.UnknownMessage;
import io.rong.imlib.model.UserInfo;
import io.rong.message.TextMessage;
import org.json.JSONException;
import org.json.JSONObject;

public class ConversationExAdapter
extends MessageListAdapter {
    private boolean timeGone = false;
    private LayoutInflater mInflater;
    boolean evaForRobot = false;
    boolean robotMode = true;
    private Context mContext;
    private MessageListAdapter.OnItemHandlerListener mOnItemHandlerListener;
    private static final String TAG = "ConversationExAdapter";

    public ConversationExAdapter(Context context) {
        super(context);
        this.mInflater = LayoutInflater.from((Context)context);
        this.mContext = context;
    }

    protected boolean getNeedEvaluate(UIMessage data) {
        String extra = "";
        String robotEva = "";
        String sid = "";
        if (data != null && data.getConversationType() != null && data.getConversationType().equals((Object)Conversation.ConversationType.CUSTOMER_SERVICE)) {
            if (data.getContent() instanceof TextMessage) {
                extra = ((TextMessage)data.getContent()).getExtra();
                if (TextUtils.isEmpty((CharSequence)extra)) {
                    return false;
                }
                try {
                    JSONObject jsonObj = new JSONObject(extra);
                    robotEva = jsonObj.optString("robotEva");
                    sid = jsonObj.optString("sid");
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            if (data.getMessageDirection() == Message.MessageDirection.RECEIVE && data.getContent() instanceof TextMessage && this.evaForRobot && this.robotMode && !TextUtils.isEmpty((CharSequence)robotEva) && !TextUtils.isEmpty((CharSequence)sid) && !data.getIsHistoryMessage()) {
                return true;
            }
        }
        return false;
    }

    protected void setGravity(View view, int gravity) {
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)view.getLayoutParams();
        params.gravity = gravity;
    }

    @SuppressLint(value={"WrongConstant"})
    protected void bindView(View v, final int position, final UIMessage data) {
        if (data != null) {
            final ViewHolder holder = (ViewHolder)v.getTag();
            if (holder == null) {
                RLog.e((String)"MessageListAdapter", (String)"view holder is null !");
            } else {
                ProviderTag tag;
                EvaluateTextMessageItemProvider provider;
                if (data.getMessageDirection() == Message.MessageDirection.SEND && data.getMessage().getContent() instanceof InviteInvaMessage) {
                    holder.leftIconView.setVisibility(8);
                    holder.rightIconView.setVisibility(8);
                    holder.nameView.setVisibility(8);
                    holder.contentView.setVisibility(8);
                    holder.progressBar.setVisibility(8);
                    holder.warning.setVisibility(8);
                    holder.readReceipt.setVisibility(8);
                    holder.readReceiptRequest.setVisibility(8);
                    holder.sentStatus.setVisibility(8);
                    holder.time.setVisibility(0);
                    holder.time.setText((CharSequence)"\u4e13\u5bb6\u9080\u8bf7\u5df2\u53d1\u9001");
                    return;
                }
                if (this.getNeedEvaluate(data)) {
                    provider = RongContext.getInstance().getEvaluateProvider();
                    tag = RongContext.getInstance().getMessageProviderTag(data.getContent().getClass());
                } else {
                    if (RongContext.getInstance() == null || data == null || data.getContent() == null) {
                        RLog.e((String)"MessageListAdapter", (String)"Message is null !");
                        return;
                    }
                    provider = RongContext.getInstance().getMessageTemplate(data.getContent().getClass());
                    if (provider == null) {
                        provider = RongContext.getInstance().getMessageTemplate(UnknownMessage.class);
                        tag = RongContext.getInstance().getMessageProviderTag(UnknownMessage.class);
                    } else {
                        tag = RongContext.getInstance().getMessageProviderTag(data.getContent().getClass());
                    }
                    if (provider == null) {
                        RLog.e((String)"MessageListAdapter", (String)(data.getObjectName() + " message provider not found !"));
                        return;
                    }
                }
                final View view = holder.contentView.inflate((IContainerItemProvider)provider);
                ((IContainerItemProvider)provider).bindView(view, position, (Object)data);
                if (tag == null) {
                    RLog.e((String)"MessageListAdapter", (String)("Can not find ProviderTag for " + data.getObjectName()));
                } else {
                    UserInfo userInfo;
                    if (tag.hide()) {
                        holder.contentView.setVisibility(8);
                        holder.time.setVisibility(8);
                        holder.nameView.setVisibility(8);
                        holder.leftIconView.setVisibility(8);
                        holder.rightIconView.setVisibility(8);
                        holder.layoutItem.setVisibility(8);
                        holder.layoutItem.setPadding(0, 0, 0, 0);
                    } else {
                        holder.contentView.setVisibility(0);
                        holder.layoutItem.setVisibility(0);
                        holder.layoutItem.setPadding(RongUtils.dip2px((float)8.0f), RongUtils.dip2px((float)6.0f), RongUtils.dip2px((float)8.0f), RongUtils.dip2px((float)6.0f));
                    }
                    if (data.getMessageDirection() == Message.MessageDirection.SEND) {
                        if (tag.showPortrait()) {
                            holder.rightIconView.setVisibility(0);
                            holder.leftIconView.setVisibility(8);
                        } else {
                            holder.leftIconView.setVisibility(8);
                            holder.rightIconView.setVisibility(8);
                        }
                        if (!tag.centerInHorizontal()) {
                            this.setGravity((View)holder.layout, 5);
                            holder.contentView.containerViewRight();
                            holder.nameView.setGravity(5);
                        } else {
                            this.setGravity((View)holder.layout, 17);
                            holder.contentView.containerViewCenter();
                            holder.nameView.setGravity(1);
                            holder.contentView.setBackgroundColor(0);
                        }
                        boolean readRec = false;
                        try {
                            readRec = this.mContext.getResources().getBoolean(R.bool.rc_read_receipt);
                        }
                        catch (Resources.NotFoundException var12) {
                            RLog.e((String)"MessageListAdapter", (String)"rc_read_receipt not configure in rc_config.xml");
                            var12.printStackTrace();
                        }
                        if (data.getSentStatus() == Message.SentStatus.SENDING) {
                            if (tag.showProgress()) {
                                holder.progressBar.setVisibility(0);
                            } else {
                                holder.progressBar.setVisibility(8);
                            }
                            holder.warning.setVisibility(8);
                            holder.readReceipt.setVisibility(8);
                        } else if (data.getSentStatus() == Message.SentStatus.FAILED) {
                            holder.progressBar.setVisibility(8);
                            holder.warning.setVisibility(0);
                            holder.readReceipt.setVisibility(8);
                        } else if (data.getSentStatus() == Message.SentStatus.SENT) {
                            holder.progressBar.setVisibility(8);
                            holder.warning.setVisibility(8);
                            holder.readReceipt.setVisibility(8);
                        } else if (readRec && data.getSentStatus() == Message.SentStatus.READ) {
                            holder.progressBar.setVisibility(8);
                            holder.warning.setVisibility(8);
                            if (data.getConversationType().equals((Object)Conversation.ConversationType.PRIVATE) && tag.showReadState()) {
                                holder.readReceipt.setVisibility(0);
                            } else {
                                holder.readReceipt.setVisibility(8);
                            }
                        } else {
                            holder.progressBar.setVisibility(8);
                            holder.warning.setVisibility(8);
                            holder.readReceipt.setVisibility(8);
                        }
                        holder.readReceiptRequest.setVisibility(8);
                        holder.readReceiptStatus.setVisibility(8);
                        if (readRec && RongContext.getInstance().isReadReceiptConversationType(data.getConversationType()) && (data.getConversationType().equals((Object)Conversation.ConversationType.GROUP) || data.getConversationType().equals((Object)Conversation.ConversationType.DISCUSSION))) {
                            if (data.getContent() instanceof TextMessage && !TextUtils.isEmpty((CharSequence)data.getUId())) {
                                long serverTime;
                                boolean isLastSentMessage = true;
                                for (int i = position + 1; i < this.getCount(); ++i) {
                                    if (((UIMessage)this.getItem(i)).getMessageDirection() != Message.MessageDirection.SEND) continue;
                                    isLastSentMessage = false;
                                    break;
                                }
                                if ((serverTime = System.currentTimeMillis() - RongIMClient.getInstance().getDeltaTime()) - data.getSentTime() < 120000L && isLastSentMessage && (data.getReadReceiptInfo() == null || !data.getReadReceiptInfo().isReadReceiptMessage())) {
                                    holder.readReceiptRequest.setVisibility(0);
                                }
                            }
                            if (data.getContent() instanceof TextMessage && data.getReadReceiptInfo() != null && data.getReadReceiptInfo().isReadReceiptMessage()) {
                                if (data.getReadReceiptInfo().getRespondUserIdList() != null) {
                                    holder.readReceiptStatus.setText((CharSequence)String.format(view.getResources().getString(R.string.rc_read_receipt_status), data.getReadReceiptInfo().getRespondUserIdList().size()));
                                } else {
                                    holder.readReceiptStatus.setText((CharSequence)String.format(view.getResources().getString(R.string.rc_read_receipt_status), 0));
                                }
                                holder.readReceiptStatus.setVisibility(0);
                            }
                        }
                        holder.nameView.setVisibility(8);
                        holder.readReceiptRequest.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                RongIMClient.getInstance().sendReadReceiptRequest(data.getMessage(), new RongIMClient.OperationCallback(){

                                    public void onSuccess() {
                                        ReadReceiptInfo readReceiptInfo = data.getReadReceiptInfo();
                                        if (readReceiptInfo == null) {
                                            readReceiptInfo = new ReadReceiptInfo();
                                            data.setReadReceiptInfo(readReceiptInfo);
                                        }
                                        readReceiptInfo.setIsReadReceiptMessage(true);
                                        holder.readReceiptStatus.setText((CharSequence)String.format(view.getResources().getString(R.string.rc_read_receipt_status), 0));
                                        holder.readReceiptRequest.setVisibility(8);
                                        holder.readReceiptStatus.setVisibility(0);
                                    }

                                    public void onError(RongIMClient.ErrorCode errorCode) {
                                        RLog.e((String)"MessageListAdapter", (String)("sendReadReceiptRequest failed, errorCode = " + errorCode));
                                    }
                                });
                            }
                        });
                        holder.readReceiptStatus.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                if (ConversationExAdapter.this.mOnItemHandlerListener != null) {
                                    ConversationExAdapter.this.mOnItemHandlerListener.onReadReceiptStateClick(data.getMessage());
                                }
                            }
                        });
                        holder.rightIconView.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                if (RongContext.getInstance().getConversationBehaviorListener() != null) {
                                    UserInfo userInfo = null;
                                    if (!TextUtils.isEmpty((CharSequence)data.getSenderUserId())) {
                                        userInfo = RongUserInfoManager.getInstance().getUserInfo(data.getSenderUserId());
                                        userInfo = userInfo == null ? new UserInfo(data.getSenderUserId(), (String)null, (Uri)null) : userInfo;
                                    }
                                    RongContext.getInstance().getConversationBehaviorListener().onUserPortraitClick(ConversationExAdapter.this.mContext, data.getConversationType(), userInfo);
                                }
                            }
                        });
                        holder.rightIconView.setOnLongClickListener(new View.OnLongClickListener(){

                            public boolean onLongClick(View v) {
                                if (RongContext.getInstance().getConversationBehaviorListener() != null) {
                                    UserInfo userInfo = null;
                                    if (!TextUtils.isEmpty((CharSequence)data.getSenderUserId())) {
                                        userInfo = RongUserInfoManager.getInstance().getUserInfo(data.getSenderUserId());
                                        userInfo = userInfo == null ? new UserInfo(data.getSenderUserId(), (String)null, (Uri)null) : userInfo;
                                    }
                                    return RongContext.getInstance().getConversationBehaviorListener().onUserPortraitLongClick(ConversationExAdapter.this.mContext, data.getConversationType(), userInfo);
                                }
                                return true;
                            }
                        });
                        if (!tag.showWarning()) {
                            holder.warning.setVisibility(8);
                        }
                    } else {
                        if (tag.showPortrait()) {
                            holder.rightIconView.setVisibility(8);
                            holder.leftIconView.setVisibility(0);
                        } else {
                            holder.leftIconView.setVisibility(8);
                            holder.rightIconView.setVisibility(8);
                        }
                        if (!tag.centerInHorizontal()) {
                            this.setGravity((View)holder.layout, 3);
                            holder.contentView.containerViewLeft();
                            holder.nameView.setGravity(3);
                        } else {
                            this.setGravity((View)holder.layout, 17);
                            holder.contentView.containerViewCenter();
                            holder.nameView.setGravity(1);
                            holder.contentView.setBackgroundColor(0);
                        }
                        holder.progressBar.setVisibility(8);
                        holder.warning.setVisibility(8);
                        holder.readReceipt.setVisibility(8);
                        holder.readReceiptRequest.setVisibility(8);
                        holder.readReceiptStatus.setVisibility(8);
                        holder.nameView.setVisibility(0);
                        if (data.getConversationType() != Conversation.ConversationType.PRIVATE && tag.showSummaryWithName() && data.getConversationType() != Conversation.ConversationType.PUBLIC_SERVICE && data.getConversationType() != Conversation.ConversationType.APP_PUBLIC_SERVICE) {
                            userInfo = null;
                            if (data.getConversationType().equals((Object)Conversation.ConversationType.CUSTOMER_SERVICE) && data.getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE)) {
                                if (data.getUserInfo() != null) {
                                    userInfo = data.getUserInfo();
                                } else if (data.getMessage() != null && data.getMessage().getContent() != null) {
                                    userInfo = data.getMessage().getContent().getUserInfo();
                                }
                                if (userInfo != null) {
                                    holder.nameView.setText((CharSequence)userInfo.getName());
                                } else {
                                    holder.nameView.setText((CharSequence)data.getSenderUserId());
                                }
                            } else if (data.getConversationType() == Conversation.ConversationType.GROUP) {
                                GroupUserInfo portrait = RongUserInfoManager.getInstance().getGroupUserInfo(data.getTargetId(), data.getSenderUserId());
                                if (portrait != null) {
                                    holder.nameView.setText((CharSequence)portrait.getNickname());
                                } else {
                                    userInfo = RongUserInfoManager.getInstance().getUserInfo(data.getSenderUserId());
                                    if (userInfo == null) {
                                        holder.nameView.setText((CharSequence)data.getSenderUserId());
                                    } else {
                                        holder.nameView.setText((CharSequence)userInfo.getName());
                                    }
                                }
                            } else {
                                userInfo = RongUserInfoManager.getInstance().getUserInfo(data.getSenderUserId());
                                if (userInfo == null) {
                                    holder.nameView.setText((CharSequence)data.getSenderUserId());
                                } else {
                                    holder.nameView.setText((CharSequence)userInfo.getName());
                                }
                            }
                        } else {
                            holder.nameView.setVisibility(8);
                        }
                        holder.leftIconView.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                if (RongContext.getInstance().getConversationBehaviorListener() != null) {
                                    UserInfo userInfo = null;
                                    if (!TextUtils.isEmpty((CharSequence)data.getSenderUserId())) {
                                        userInfo = RongUserInfoManager.getInstance().getUserInfo(data.getSenderUserId());
                                        userInfo = userInfo == null ? new UserInfo(data.getSenderUserId(), (String)null, (Uri)null) : userInfo;
                                    }
                                    RongContext.getInstance().getConversationBehaviorListener().onUserPortraitClick(ConversationExAdapter.this.mContext, data.getConversationType(), userInfo);
                                }
                            }
                        });
                    }
                    holder.leftIconView.setOnLongClickListener(new View.OnLongClickListener(){

                        public boolean onLongClick(View v) {
                            UserInfo userInfo = null;
                            if (!TextUtils.isEmpty((CharSequence)data.getSenderUserId())) {
                                userInfo = RongUserInfoManager.getInstance().getUserInfo(data.getSenderUserId());
                                UserInfo userInfo2 = userInfo = userInfo == null ? new UserInfo(data.getSenderUserId(), (String)null, (Uri)null) : userInfo;
                            }
                            if (RongContext.getInstance().getConversationBehaviorListener() != null && RongContext.getInstance().getConversationBehaviorListener().onUserPortraitLongClick(ConversationExAdapter.this.mContext, data.getConversationType(), userInfo)) {
                                return RongContext.getInstance().getConversationBehaviorListener().onUserPortraitLongClick(ConversationExAdapter.this.mContext, data.getConversationType(), userInfo);
                            }
                            if (!RongContext.getInstance().getResources().getBoolean(R.bool.rc_enable_mentioned_message) || !data.getConversationType().equals((Object)Conversation.ConversationType.GROUP) && !data.getConversationType().equals((Object)Conversation.ConversationType.DISCUSSION)) {
                                return false;
                            }
                            RongMentionManager.getInstance().mentionMember(data.getConversationType(), data.getTargetId(), data.getSenderUserId());
                            return true;
                        }
                    });
                    if (holder.rightIconView.getVisibility() == 0) {
                        if (data.getConversationType().equals((Object)Conversation.ConversationType.CUSTOMER_SERVICE) && data.getUserInfo() != null && data.getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE)) {
                            userInfo = data.getUserInfo();
                            Uri portraitUri = userInfo.getPortraitUri();
                            if (portraitUri != null) {
                                holder.rightIconView.setAvatar(portraitUri.toString(), 0);
                            }
                        } else if ((data.getConversationType().equals((Object)Conversation.ConversationType.PUBLIC_SERVICE) || data.getConversationType().equals((Object)Conversation.ConversationType.APP_PUBLIC_SERVICE)) && data.getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE)) {
                            userInfo = data.getUserInfo();
                            if (userInfo != null) {
                                Uri portraitUri = userInfo.getPortraitUri();
                                if (portraitUri != null) {
                                    holder.leftIconView.setAvatar(portraitUri.toString(), 0);
                                }
                            } else {
                                ConversationKey mKey = ConversationKey.obtain((String)data.getTargetId(), (Conversation.ConversationType)data.getConversationType());
                                PublicServiceProfile publicServiceProfile = RongContext.getInstance().getPublicServiceInfoFromCache(mKey.getKey());
                                Uri portraitUri = publicServiceProfile.getPortraitUri();
                                if (portraitUri != null) {
                                    holder.rightIconView.setAvatar(portraitUri.toString(), 0);
                                }
                            }
                        } else if (!TextUtils.isEmpty((CharSequence)data.getSenderUserId()) && (userInfo = RongUserInfoManager.getInstance().getUserInfo(data.getSenderUserId())) != null && userInfo.getPortraitUri() != null) {
                            holder.rightIconView.setAvatar(userInfo.getPortraitUri().toString(), 0);
                        }
                    } else if (holder.leftIconView.getVisibility() == 0) {
                        userInfo = null;
                        Uri portraitUri = null;
                        if (data.getConversationType().equals((Object)Conversation.ConversationType.CUSTOMER_SERVICE) && data.getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE)) {
                            if (data.getUserInfo() != null) {
                                userInfo = data.getUserInfo();
                            } else if (data.getMessage() != null && data.getMessage().getContent() != null) {
                                userInfo = data.getMessage().getContent().getUserInfo();
                            }
                            if (userInfo != null && (portraitUri = userInfo.getPortraitUri()) != null) {
                                holder.leftIconView.setAvatar(portraitUri.toString(), 0);
                            }
                        } else if ((data.getConversationType().equals((Object)Conversation.ConversationType.PUBLIC_SERVICE) || data.getConversationType().equals((Object)Conversation.ConversationType.APP_PUBLIC_SERVICE)) && data.getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE)) {
                            userInfo = data.getUserInfo();
                            if (userInfo != null) {
                                portraitUri = userInfo.getPortraitUri();
                                if (portraitUri != null) {
                                    holder.leftIconView.setAvatar(portraitUri.toString(), 0);
                                }
                            } else {
                                ConversationKey mKey = ConversationKey.obtain((String)data.getTargetId(), (Conversation.ConversationType)data.getConversationType());
                                PublicServiceProfile publicServiceProfile = RongContext.getInstance().getPublicServiceInfoFromCache(mKey.getKey());
                                if (publicServiceProfile != null && publicServiceProfile.getPortraitUri() != null) {
                                    holder.leftIconView.setAvatar(publicServiceProfile.getPortraitUri().toString(), 0);
                                }
                            }
                        } else if (!TextUtils.isEmpty((CharSequence)data.getSenderUserId()) && (userInfo = RongUserInfoManager.getInstance().getUserInfo(data.getSenderUserId())) != null && userInfo.getPortraitUri() != null) {
                            holder.leftIconView.setAvatar(userInfo.getPortraitUri().toString(), 0);
                        }
                    }
                    if (view != null) {
                        view.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                Object provider;
                                if (!(RongContext.getInstance().getConversationBehaviorListener() != null && RongContext.getInstance().getConversationBehaviorListener().onMessageClick(ConversationExAdapter.this.mContext, v, data.getMessage()) || (provider = ConversationExAdapter.this.getNeedEvaluate(data) ? RongContext.getInstance().getEvaluateProvider() : RongContext.getInstance().getMessageTemplate(data.getContent().getClass())) == null)) {
                                    ((IContainerItemProvider.MessageProvider)provider).onItemClick(v, position, data.getContent(), data);
                                }
                            }
                        });
                        view.setOnLongClickListener(new View.OnLongClickListener(){

                            public boolean onLongClick(View v) {
                                if (RongContext.getInstance().getConversationBehaviorListener() != null && RongContext.getInstance().getConversationBehaviorListener().onMessageLongClick(ConversationExAdapter.this.mContext, v, data.getMessage())) {
                                    return true;
                                }
                                Object provider = ConversationExAdapter.this.getNeedEvaluate(data) ? RongContext.getInstance().getEvaluateProvider() : RongContext.getInstance().getMessageTemplate(data.getContent().getClass());
                                if (provider != null) {
                                    ((IContainerItemProvider.MessageProvider)provider).onItemLongClick(v, position, data.getContent(), data);
                                }
                                return true;
                            }
                        });
                    }
                    holder.warning.setOnClickListener((View.OnClickListener)new DebouncedOnClickListener(){

                        public void onDebouncedClick(View view) {
                            if (ConversationExAdapter.this.mOnItemHandlerListener != null) {
                                ConversationExAdapter.this.mOnItemHandlerListener.onWarningViewClick(position, data.getMessage(), view);
                            }
                        }
                    });
                    if (tag.hide()) {
                        holder.time.setVisibility(8);
                    } else if (!this.timeGone) {
                        String time = RongDateUtils.getConversationFormatDate((long)data.getSentTime(), (Context)view.getContext());
                        holder.time.setText((CharSequence)time);
                        if (position == 0) {
                            holder.time.setVisibility(0);
                        } else {
                            UIMessage pre = (UIMessage)this.getItem(position - 1);
                            if (RongDateUtils.isShowChatTime((long)data.getSentTime(), (long)pre.getSentTime(), (int)180)) {
                                holder.time.setVisibility(0);
                            } else {
                                holder.time.setVisibility(8);
                            }
                        }
                    }
                }
            }
            if (data.getMessage().getContent() instanceof PreDiaDescMessage || data.getMessage().getContent() instanceof JoinMettingMessage) {
                holder.leftIconView.setVisibility(8);
                holder.rightIconView.setVisibility(8);
                holder.countDownTimeSend.setVisibility(8);
                holder.countDownTimeReceive.setVisibility(8);
            }
        }
    }

    @SuppressLint(value={"WrongConstant"})
    protected View newView(Context context, int position, ViewGroup group2) {
        View result = this.mInflater.inflate(R.layout.rc_item_message, (ViewGroup)null);
        ViewHolder holder = new ViewHolder();
        holder.leftIconView = (AsyncImageView)this.findViewById(result, R.id.rc_left);
        holder.rightIconView = (AsyncImageView)this.findViewById(result, R.id.rc_right);
        holder.nameView = (TextView)this.findViewById(result, R.id.rc_title);
        holder.contentView = (ProviderContainerView)this.findViewById(result, R.id.rc_content);
        holder.layout = (ViewGroup)this.findViewById(result, R.id.rc_layout);
        holder.progressBar = (ProgressBar)this.findViewById(result, R.id.rc_progress);
        holder.warning = (ImageView)this.findViewById(result, R.id.rc_warning);
        holder.readReceipt = (TextView)this.findViewById(result, R.id.rc_read_receipt);
        holder.readReceiptRequest = (TextView)this.findViewById(result, R.id.rc_read_receipt_request);
        holder.readReceiptStatus = (TextView)this.findViewById(result, R.id.rc_read_receipt_status);
        holder.time = (TextView)this.findViewById(result, R.id.rc_time);
        holder.sentStatus = (TextView)this.findViewById(result, R.id.rc_sent_status);
        holder.layoutItem = (RelativeLayout)this.findViewById(result, R.id.rc_layout_item_message);
        holder.countDownTimeSend = (TextView)this.findViewById(result, R.id.countdown_time_send);
        holder.countDownTimeReceive = (TextView)this.findViewById(result, R.id.countdown_time_receive);
        this.timeGone = holder.time.getVisibility() == 8;
        result.setTag((Object)holder);
        return result;
    }

    class ViewHolder {
        AsyncImageView leftIconView;
        AsyncImageView rightIconView;
        TextView nameView;
        ProviderContainerView contentView;
        ProgressBar progressBar;
        ImageView warning;
        TextView readReceipt;
        TextView readReceiptRequest;
        TextView readReceiptStatus;
        ViewGroup layout;
        TextView time;
        TextView sentStatus;
        TextView countDownTimeSend;
        TextView countDownTimeReceive;
        RelativeLayout layoutItem;

        ViewHolder() {
        }
    }
}

