/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.adapter;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.byh.lib.byhim.R;
import com.byh.lib.byhim.bean.FriendsHeader;
import com.kangxin.common.Pretty;
import com.kangxin.common.byh.widget.PileLayout;
import java.util.List;
import me.yokeyword.indexablerv.IndexableHeaderAdapter;

public class FriendsHeaderAdapter
extends IndexableHeaderAdapter<FriendsHeader> {
    private static final String TAG = "FriendsHeaderAdapter";
    private Context mContext;
    private FriendsHeaderHolder mFriendHolder;
    private int mDataSize;
    private List<String> mHeaderUrls;

    public FriendsHeaderAdapter(Context context, String index, String indexTitle, List<FriendsHeader> datas) {
        super(index, indexTitle, datas);
        this.mContext = context;
    }

    public int getItemViewType() {
        return 0;
    }

    public RecyclerView.ViewHolder onCreateContentViewHolder(ViewGroup parent) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.im_friends_header_view, null);
        return new FriendsHeaderHolder(view);
    }

    private void setDataSize(int size) {
        this.mDataSize = size;
    }

    private void setHeaderUrls(List<String> urls) {
        this.mHeaderUrls = urls;
    }

    public void updateHeaderUrl(int size, List<String> urls) {
        this.setDataSize(size);
        this.setHeaderUrls(urls);
        this.notifyDataSetChanged();
    }

    public void onBindContentViewHolder(RecyclerView.ViewHolder holder, FriendsHeader entity) {
        if (holder instanceof FriendsHeaderHolder) {
            ((FriendsHeaderHolder)holder).headerIcon.setImageResource(entity.getImgDrawable());
            ((FriendsHeaderHolder)holder).headerName.setText((CharSequence)entity.getName());
            if (entity.isShowImgs()) {
                Log.i((String)TAG, (String)"onBindContentViewHolder: debug11111");
                this.mFriendHolder = (FriendsHeaderHolder)holder;
                ((FriendsHeaderHolder)holder).imgsLayout.setVisibility(0);
                ((FriendsHeaderHolder)holder).personNum.setVisibility(0);
                if (this.mDataSize > 9999) {
                    this.mFriendHolder.personNum.setText((CharSequence)(this.mDataSize + "+"));
                } else {
                    this.mFriendHolder.personNum.setText((CharSequence)(this.mDataSize + ""));
                }
                if (this.mHeaderUrls != null) {
                    for (String url : this.mHeaderUrls) {
                        Log.i((String)TAG, (String)("bindImgsToViews: url=>" + url));
                        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.mContext);
                        ImageView imageView = (ImageView)layoutInflater.inflate(R.layout.byhim_friend_img_pies_layout, (ViewGroup)this.mFriendHolder.pileLayout, false);
                        Pretty.create().loadImage(url).bitmapTransform(2).placeholder(R.drawable.ic_header_img).err(R.drawable.ic_header_img).into(imageView);
                        this.mFriendHolder.pileLayout.addView((View)imageView);
                    }
                    this.mHeaderUrls.clear();
                }
            } else {
                ((FriendsHeaderHolder)holder).imgsLayout.setVisibility(8);
                ((FriendsHeaderHolder)holder).personNum.setVisibility(8);
            }
        }
    }

    static class FriendsHeaderHolder
    extends RecyclerView.ViewHolder {
        public ImageView headerIcon;
        public TextView headerName;
        public View imgsLayout;
        public PileLayout pileLayout;
        public TextView personNum;

        public FriendsHeaderHolder(View itemView) {
            super(itemView);
            this.headerIcon = (ImageView)itemView.findViewById(R.id.img_header);
            this.headerName = (TextView)itemView.findViewById(R.id.name_header);
            this.imgsLayout = itemView.findViewById(R.id.imgs_layout);
            this.pileLayout = (PileLayout)itemView.findViewById(R.id.pielayout);
            this.personNum = (TextView)itemView.findViewById(R.id.p_num);
        }
    }
}

