/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.byh.lib.byhim.ImGroupChatActivity;
import com.byh.lib.byhim.ImQuitGroupMemberActivity;
import com.byh.lib.byhim.R;
import com.kangxin.common.Pretty;
import com.kangxin.common.byh.entity.response.GroupMembersEntity;
import io.rong.common.RLog;
import io.rong.imkit.widget.adapter.BaseAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GroupMembersAdapter
extends BaseAdapter<GroupMembersEntity> {
    private Context mContext;
    private List<GroupMembersEntity> mGroupMemBersList;
    private ClickMemberItemListener onClickMemberItemListener;

    public GroupMembersAdapter(Context context) {
        this.mContext = context;
    }

    public void addCollection(Collection<GroupMembersEntity> collection) {
        this.mGroupMemBersList = (List)collection;
        super.addCollection(collection);
    }

    private List<GroupMembersEntity> filterGroupOnwner() {
        if (this.mGroupMemBersList == null) {
            return null;
        }
        ArrayList<GroupMembersEntity> groupMembersEntityList = new ArrayList<GroupMembersEntity>();
        for (GroupMembersEntity groupMembersEntity : this.mGroupMemBersList) {
            if (1 == groupMembersEntity.getRole() || groupMembersEntity.getShowType() != -1) continue;
            groupMembersEntityList.add(groupMembersEntity);
        }
        return groupMembersEntityList;
    }

    public void setOnClickMemberItemListener(ClickMemberItemListener onClickMemberItemListener) {
        this.onClickMemberItemListener = onClickMemberItemListener;
    }

    protected View newView(Context context, int i, ViewGroup viewGroup) {
        View result = LayoutInflater.from((Context)this.mContext).inflate(R.layout.byhim_group_members_item, viewGroup, false);
        GroupMembersHolder holder = new GroupMembersHolder();
        holder.memberIcon = (ImageView)this.findViewById(result, R.id.member_header_icon);
        holder.memberNickName = (TextView)this.findViewById(result, R.id.member_nickname);
        result.setTag((Object)holder);
        return result;
    }

    @SuppressLint(value={"ResourceType"})
    protected void bindView(View view, final int position, final GroupMembersEntity groupMembersEntity) {
        if (groupMembersEntity != null) {
            GroupMembersHolder groupMembersHolder = (GroupMembersHolder)view.getTag();
            if (groupMembersHolder == null) {
                RLog.e((String)"GroupMembersAdapter", (String)"view holder is null !");
            } else {
                switch (groupMembersEntity.getShowType()) {
                    case -1: {
                        groupMembersHolder.memberNickName.setText((CharSequence)groupMembersEntity.getDisplayName());
                        Pretty.create().loadImage(groupMembersEntity.getHeadImageUrl()).placeholder(R.mipmap.logo_patient).into(groupMembersHolder.memberIcon);
                        if (this.onClickMemberItemListener == null) break;
                        groupMembersHolder.memberIcon.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                GroupMembersAdapter.this.onClickMemberItemListener.clickItem(position, groupMembersEntity);
                            }
                        });
                        break;
                    }
                    case 13090: {
                        groupMembersHolder.memberNickName.setVisibility(8);
                        groupMembersHolder.memberIcon.setImageResource(R.drawable.ic_byhim_add);
                        groupMembersHolder.memberIcon.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                Intent addMemberIntent = new Intent(GroupMembersAdapter.this.mContext, ImGroupChatActivity.class);
                                addMemberIntent.putExtra("GROUP_MEMBERS_KEY", (Serializable)((Object)GroupMembersAdapter.this.filterGroupOnwner()));
                                addMemberIntent.putExtra("MSG_JUMP_TYPE", 86393);
                                addMemberIntent.addFlags(0x10000000);
                                addMemberIntent.putExtra("PAGE_TYPE", 4386);
                                GroupMembersAdapter.this.mContext.startActivity(addMemberIntent);
                            }
                        });
                        break;
                    }
                    case 13091: {
                        groupMembersHolder.memberNickName.setVisibility(8);
                        groupMembersHolder.memberIcon.setImageResource(R.drawable.ic_byhim_reduce);
                        groupMembersHolder.memberIcon.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                Intent quitGroupIntent = new Intent(GroupMembersAdapter.this.mContext, ImQuitGroupMemberActivity.class);
                                quitGroupIntent.putExtra("GROUP_MEMBERS_KEY", (Serializable)((Object)GroupMembersAdapter.this.filterGroupOnwner()));
                                quitGroupIntent.addFlags(0x10000000);
                                GroupMembersAdapter.this.mContext.startActivity(quitGroupIntent);
                            }
                        });
                    }
                }
            }
        }
    }

    public long getItemId(int position) {
        return position;
    }

    class GroupMembersHolder {
        ImageView memberIcon;
        TextView memberNickName;

        GroupMembersHolder() {
        }
    }

    public static interface ClickMemberItemListener {
        public void clickItem(int var1, GroupMembersEntity var2);
    }
}

