/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.byh.lib.byhim.R;
import io.rong.common.RLog;
import io.rong.imkit.R;
import io.rong.imkit.RongContext;
import io.rong.imkit.model.ConversationProviderTag;
import io.rong.imkit.model.UIConversation;
import io.rong.imkit.widget.AsyncImageView;
import io.rong.imkit.widget.ProviderContainerView;
import io.rong.imkit.widget.adapter.ConversationListAdapter;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import io.rong.imlib.model.Conversation;

public class ImChatListAdapter
extends ConversationListAdapter {
    private LayoutInflater mInflater;
    private Context mContext;
    private ConversationListAdapter.OnPortraitItemClick mOnPortraitItemClick;

    public ImChatListAdapter(Context context) {
        super(context);
        this.mContext = context;
        this.mInflater = LayoutInflater.from((Context)this.mContext);
    }

    protected void bindView(View v, int position, final UIConversation data) {
        ViewHolder holder = (ViewHolder)v.getTag();
        if (data != null) {
            IContainerItemProvider.ConversationProvider provider = RongContext.getInstance().getConversationTemplate(data.getConversationType().getName());
            if (provider == null) {
                RLog.e((String)"ConversationListAdapter", (String)"provider is null");
            } else {
                View view = holder.contentView.inflate((IContainerItemProvider)provider);
                provider.bindView(view, position, (Object)data);
                if (data.isTop()) {
                    holder.layout.setBackgroundDrawable(this.mContext.getResources().getDrawable(R.drawable.rc_item_top_list_selector));
                } else {
                    holder.layout.setBackgroundDrawable(this.mContext.getResources().getDrawable(R.drawable.rc_item_list_selector));
                }
                ConversationProviderTag tag = RongContext.getInstance().getConversationProviderTag(data.getConversationType().getName());
                boolean defaultId = false;
                if (tag.portraitPosition() == 1) {
                    holder.leftImageLayout.setVisibility(0);
                    int defaultId1 = data.getConversationType().equals((Object)Conversation.ConversationType.GROUP) ? R.mipmap.group_chat_logo : (data.getConversationType().equals((Object)Conversation.ConversationType.DISCUSSION) ? R.drawable.rc_default_discussion_portrait : R.drawable.ic_byh_comm_header);
                    holder.leftImageLayout.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            if (ImChatListAdapter.this.mOnPortraitItemClick != null) {
                                ImChatListAdapter.this.mOnPortraitItemClick.onPortraitItemClick(v, data);
                            }
                        }
                    });
                    holder.leftImageLayout.setOnLongClickListener(new View.OnLongClickListener(){

                        public boolean onLongClick(View v) {
                            if (ImChatListAdapter.this.mOnPortraitItemClick != null) {
                                ImChatListAdapter.this.mOnPortraitItemClick.onPortraitItemLongClick(v, data);
                            }
                            return true;
                        }
                    });
                    if (data.getConversationGatherState()) {
                        holder.leftImageView.setAvatar((String)null, defaultId1);
                    } else {
                        this.setIcon(holder.leftImageView, data, defaultId1);
                    }
                    if (data.getUnReadMessageCount() > 0) {
                        holder.unReadMsgCountIcon.setVisibility(0);
                        if (data.getUnReadType().equals((Object)UIConversation.UnreadRemindType.REMIND_WITH_COUNTING)) {
                            if (data.getUnReadMessageCount() > 99) {
                                holder.unReadMsgCount.setText((CharSequence)this.mContext.getResources().getString(R.string.rc_message_unread_count));
                            } else {
                                holder.unReadMsgCount.setText((CharSequence)Integer.toString(data.getUnReadMessageCount()));
                            }
                            holder.unReadMsgCount.setVisibility(0);
                            holder.unReadMsgCountIcon.setImageResource(R.drawable.rc_unread_count_bg);
                        } else {
                            holder.unReadMsgCount.setVisibility(8);
                            holder.unReadMsgCountIcon.setImageResource(R.drawable.rc_unread_remind_list_count);
                        }
                    } else {
                        holder.unReadMsgCountIcon.setVisibility(8);
                        holder.unReadMsgCount.setVisibility(8);
                    }
                    holder.rightImageLayout.setVisibility(8);
                } else if (tag.portraitPosition() == 2) {
                    holder.rightImageLayout.setVisibility(0);
                    holder.rightImageLayout.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            if (ImChatListAdapter.this.mOnPortraitItemClick != null) {
                                ImChatListAdapter.this.mOnPortraitItemClick.onPortraitItemClick(v, data);
                            }
                        }
                    });
                    holder.rightImageLayout.setOnLongClickListener(new View.OnLongClickListener(){

                        public boolean onLongClick(View v) {
                            if (ImChatListAdapter.this.mOnPortraitItemClick != null) {
                                ImChatListAdapter.this.mOnPortraitItemClick.onPortraitItemLongClick(v, data);
                            }
                            return true;
                        }
                    });
                    int defaultId1 = data.getConversationType().equals((Object)Conversation.ConversationType.GROUP) ? R.mipmap.group_chat_logo : (data.getConversationType().equals((Object)Conversation.ConversationType.DISCUSSION) ? R.drawable.rc_default_discussion_portrait : R.drawable.ic_byh_comm_header);
                    if (data.getConversationGatherState()) {
                        holder.rightImageView.setAvatar((String)null, defaultId1);
                    } else {
                        this.setIcon(holder.rightImageView, data, defaultId1);
                    }
                    if (data.getUnReadMessageCount() > 0) {
                        holder.unReadMsgCountRightIcon.setVisibility(0);
                        if (data.getUnReadType().equals((Object)UIConversation.UnreadRemindType.REMIND_WITH_COUNTING)) {
                            holder.unReadMsgCount.setVisibility(0);
                            if (data.getUnReadMessageCount() > 99) {
                                holder.unReadMsgCountRight.setText((CharSequence)this.mContext.getResources().getString(R.string.rc_message_unread_count));
                            } else {
                                holder.unReadMsgCountRight.setText((CharSequence)Integer.toString(data.getUnReadMessageCount()));
                            }
                            holder.unReadMsgCountRightIcon.setImageResource(R.drawable.rc_unread_count_bg);
                        } else {
                            holder.unReadMsgCount.setVisibility(8);
                            holder.unReadMsgCountRightIcon.setImageResource(R.drawable.rc_unread_remind_without_count);
                        }
                    } else {
                        holder.unReadMsgCountIcon.setVisibility(8);
                        holder.unReadMsgCount.setVisibility(8);
                    }
                    holder.leftImageLayout.setVisibility(8);
                } else {
                    if (tag.portraitPosition() != 3) {
                        throw new IllegalArgumentException("the portrait position is wrong!");
                    }
                    holder.rightImageLayout.setVisibility(8);
                    holder.leftImageLayout.setVisibility(8);
                }
            }
        }
    }

    protected View newView(Context context, int position, ViewGroup group2) {
        View result = this.mInflater.inflate(R.layout.rc_item_conversation, (ViewGroup)null);
        ViewHolder holder = new ViewHolder();
        holder.layout = this.findViewById(result, R.id.rc_item_conversation);
        holder.leftImageLayout = this.findViewById(result, R.id.rc_item1);
        holder.rightImageLayout = this.findViewById(result, R.id.rc_item2);
        holder.leftImageView = (AsyncImageView)this.findViewById(result, R.id.rc_left);
        holder.rightImageView = (AsyncImageView)this.findViewById(result, R.id.rc_right);
        holder.contentView = (ProviderContainerView)this.findViewById(result, R.id.rc_content);
        holder.unReadMsgCount = (TextView)this.findViewById(result, R.id.rc_unread_message);
        holder.unReadMsgCountRight = (TextView)this.findViewById(result, R.id.rc_unread_message_right);
        holder.unReadMsgCountIcon = (ImageView)this.findViewById(result, R.id.rc_unread_message_icon);
        holder.unReadMsgCountRightIcon = (ImageView)this.findViewById(result, R.id.rc_unread_message_icon_right);
        result.setTag((Object)holder);
        return result;
    }

    private void setIcon(AsyncImageView imageView, UIConversation conversation, int defaultUrl) {
        String imageuri = "";
        if (conversation.getIconUrl() != null) {
            imageuri = conversation.getIconUrl().toString();
        }
        imageView.setAvatar(imageuri, defaultUrl);
    }

    public void setOnPortraitItemClick(ConversationListAdapter.OnPortraitItemClick onPortraitItemClick) {
        this.mOnPortraitItemClick = onPortraitItemClick;
    }

    static class ViewHolder {
        View layout;
        View leftImageLayout;
        View rightImageLayout;
        AsyncImageView leftImageView;
        TextView unReadMsgCount;
        ImageView unReadMsgCountIcon;
        AsyncImageView rightImageView;
        TextView unReadMsgCountRight;
        ImageView unReadMsgCountRightIcon;
        ProviderContainerView contentView;

        ViewHolder() {
        }
    }
}

