/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.blankj.utilcode.util.ToastUtils;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.byh.lib.byhim.R;
import com.byh.lib.byhim.bean.FriendsEntity;
import com.byh.lib.byhim.module.impl.ContractsModel;
import com.byh.lib.byhim.utils.ChangeUtil;
import com.kangxin.common.Pretty;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.ExpertInfoEntity;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.widget.RxProgressObserver;
import com.zhy.view.flowlayout.FlowLayout;
import com.zhy.view.flowlayout.TagAdapter;
import com.zhy.view.flowlayout.TagFlowLayout;
import io.reactivex.Observer;
import java.util.Arrays;
import me.yokeyword.indexablerv.IndexableAdapter;

public class RecommendListAdapter
extends IndexableAdapter<FriendsEntity> {
    private Context mContext;

    public RecommendListAdapter(Context mContext) {
        this.mContext = mContext;
    }

    public RecyclerView.ViewHolder onCreateTitleViewHolder(ViewGroup parent) {
        View inflate = LayoutInflater.from((Context)this.mContext).inflate(R.layout.contract_index, parent, false);
        return new IndexTitle(inflate);
    }

    public RecyclerView.ViewHolder onCreateContentViewHolder(ViewGroup parent) {
        View inflate = LayoutInflater.from((Context)this.mContext).inflate(R.layout.byhim_recommend_content_item, parent, false);
        return new FriendsVH(inflate);
    }

    public void onBindTitleViewHolder(RecyclerView.ViewHolder holder, String indexTitle) {
    }

    @SuppressLint(value={"ResourceType"})
    public void onBindContentViewHolder(RecyclerView.ViewHolder holder, final FriendsEntity entity) {
        if (holder instanceof FriendsVH) {
            Pretty.create().loadImage(entity.getHeadImageUrl()).transform((Transformation)new RoundedCorners(4)).centerCrop().placeholder(R.drawable.ic_byh_comm_header).err(R.drawable.ic_byh_comm_header).into(((FriendsVH)holder).headerIconView);
            ((FriendsVH)holder).docNameView.setText((CharSequence)entity.getDisplayName());
            ((FriendsVH)holder).docZhicView.setText((CharSequence)entity.getProfession());
            ((FriendsVH)holder).hosDescView.setText((CharSequence)(entity.getRegHospitalName() + " " + entity.getStdSecondDeptName()));
            ((FriendsVH)holder).addFriendView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    RecommendListAdapter.this.reqSendAddVertify(entity);
                }
            });
            String typeNames = entity.getTypeNames();
            if (!TextUtils.isEmpty((CharSequence)typeNames)) {
                String[] typeNameArray = typeNames.split(",");
                ((FriendsVH)holder).tagFlowLayout.setAdapter((TagAdapter)new TagAdapter<String>(Arrays.asList(typeNameArray)){

                    public View getView(FlowLayout parent, int position, String label) {
                        View labelView = LayoutInflater.from((Context)RecommendListAdapter.this.mContext).inflate(R.layout.byhim_recommend_label_item, (ViewGroup)parent, false);
                        if (labelView instanceof TextView) {
                            ((TextView)labelView).setText((CharSequence)label);
                        }
                        return labelView;
                    }
                });
            }
        }
    }

    @SuppressLint(value={"CheckResult"})
    private void reqSendAddVertify(FriendsEntity friendsEntity) {
        String docId = VertifyDataUtil.getInstance((Context)this.mContext).getLoginUserId() + "";
        ExpertInfoEntity.UserInfoVOBean userInfoVOBean = VertifyDataUtil.getInstance((Context)this.mContext).getUserInfo();
        String loginName = null;
        if (userInfoVOBean != null) {
            loginName = userInfoVOBean.getName();
        }
        new ContractsModel().sendFriendValidate(docId, "3", "3", friendsEntity.getDoctorId() + "", "3", "3", "", loginName, ChangeUtil.changeDetailInfoToJson(this.mContext, friendsEntity)).subscribe((Observer)new RxProgressObserver<ResponseBody>(){

            public void onReqNext(ResponseBody responseBody) {
                if (200 == responseBody.getCode()) {
                    ToastUtils.showShort((CharSequence)"\u6210\u529f\u53d1\u9001\u597d\u53cb\u7533\u8bf7");
                }
            }
        });
    }

    private class FriendsVH
    extends RecyclerView.ViewHolder {
        public ImageView headerIconView;
        public TextView docNameView;
        public TextView docZhicView;
        public TextView hosDescView;
        public TextView addFriendView;
        public TagFlowLayout tagFlowLayout;

        public FriendsVH(View itemView) {
            super(itemView);
            this.headerIconView = (ImageView)itemView.findViewById(R.id.header_icon);
            this.docNameView = (TextView)itemView.findViewById(R.id.doc_name);
            this.docZhicView = (TextView)itemView.findViewById(R.id.doc_zhic);
            this.hosDescView = (TextView)itemView.findViewById(R.id.hos_desc);
            this.addFriendView = (TextView)itemView.findViewById(R.id.add);
            this.tagFlowLayout = (TagFlowLayout)itemView.findViewById(R.id.tag_flow_layout);
        }
    }

    private class IndexTitle
    extends RecyclerView.ViewHolder {
        TextView index;

        public IndexTitle(View itemView) {
            super(itemView);
            itemView.setVisibility(8);
            this.index = (TextView)itemView.findViewById(R.id.vContractIndex);
        }
    }
}

