/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.fragment;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.blankj.utilcode.util.ToastUtils;
import com.byh.lib.byhim.R;
import com.byh.lib.byhim.bean.DoctorsEntity;
import com.byh.lib.byhim.holder.FriendsApplyHolder;
import com.byh.lib.byhim.present.impl.ReqDoctorsListPresent;
import com.byh.lib.byhim.present.impl.SendFriendValPresent;
import com.byh.lib.byhim.utils.ChangeUtil;
import com.byh.lib.byhim.view.IReqDoctorsListView;
import com.byh.lib.byhim.view.ISendFriendValidateView;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.byh.entity.ExpertInfoEntity;
import com.kangxin.common.byh.util.VertifyDataUtil;
import java.util.List;

public class AddFriendFragment
extends BaseFragment
implements IReqDoctorsListView,
ISendFriendValidateView {
    private RecyclerView mAddFriendCycler;
    private ReqDoctorsListPresent mDoctorListPresent;
    private EditText mSearchEdtView;
    private SendFriendValPresent mFriendValidatePresent;
    private String mLoginUserId;
    private String mUserName;

    public static AddFriendFragment getInstance() {
        return new AddFriendFragment();
    }

    public void init() {
        String doctorId = VertifyDataUtil.getInstance((Context)this.getContext()).getDoctorId();
        ExpertInfoEntity.UserInfoVOBean userInfoVOBean = VertifyDataUtil.getInstance((Context)this.getContext()).getUserInfo();
        if (userInfoVOBean != null) {
            this.mUserName = userInfoVOBean.getName();
        }
        if (!TextUtils.isEmpty((CharSequence)doctorId)) {
            this.mLoginUserId = doctorId;
        }
        this.mDoctorListPresent = new ReqDoctorsListPresent(this);
        this.mFriendValidatePresent = new SendFriendValPresent(this);
        this.mSearchEdtView = (EditText)this.findViewById(this.rootView, R.id.search_bar);
        this.mSearchEdtView.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView textView, int actionId, KeyEvent keyEvent) {
                if (actionId == 3) {
                    String searchParam = AddFriendFragment.this.mSearchEdtView.getText().toString().trim();
                    AddFriendFragment.this.mDoctorListPresent.reqDoctorsList(AddFriendFragment.this.getContext(), searchParam);
                }
                return false;
            }
        });
        this.mAddFriendCycler = (RecyclerView)this.findViewById(this.rootView, R.id.recycler_list);
        this.mAddFriendCycler.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
    }

    protected int getLayoutId() {
        return R.layout.im_addfriend_fragment;
    }

    @Override
    public void bindDoctorsList(List<DoctorsEntity> doctorsEntityList) {
        this.mAddFriendCycler.setAdapter((RecyclerView.Adapter)new BaseQuickAdapter<DoctorsEntity, FriendsApplyHolder>(R.layout.im_addfriend_item, doctorsEntityList){

            @SuppressLint(value={"ResourceAsColor"})
            protected void convert(FriendsApplyHolder helper, final DoctorsEntity item) {
                helper.setImageView(R.id.left_img, item.getHeadPortrait());
                helper.setText(R.id.doc_name, item.getName());
                String yykeshi = item.getRegHospitalName() + " " + item.getHospitalDeptName();
                helper.setText(R.id.yykeshi_name, yykeshi);
                if (0 == item.getIsFriend()) {
                    helper.setBackgroundRes(R.id.add_friend, R.color.colorPrimary);
                    helper.setText(R.id.add_friend, R.string.im_add_friend2);
                    helper.setOnItemViewClickListener(R.id.add_friend, new View.OnClickListener(){

                        @SuppressLint(value={"ResourceAsColor"})
                        public void onClick(View view) {
                            String detailInfo = ChangeUtil.changeDetailInfoToJson(AddFriendFragment.this.getContext(), item);
                            if (TextUtils.isEmpty((CharSequence)detailInfo)) {
                                AddFriendFragment.this.showShortToast("\u65e0\u6cd5\u53d1\u9001\u9a8c\u8bc1\u7533\u8bf7");
                                return;
                            }
                            if ((long)item.getDoctorId() == Long.valueOf(AddFriendFragment.this.mLoginUserId)) {
                                ToastUtils.showLong((CharSequence)"\u4e0d\u80fd\u6dfb\u52a0\u81ea\u5df1\u4e3a\u597d\u53cb");
                                return;
                            }
                            AddFriendFragment.this.mFriendValidatePresent.sendFriendValidate(AddFriendFragment.this.mLoginUserId, "3", "3", item.getDoctorId() + "", "3", "3", "", AddFriendFragment.this.mUserName, detailInfo);
                        }
                    });
                } else if (1 == item.getIsFriend()) {
                    helper.setBackgroundRes(R.id.add_friend, R.color.im_color_gray_ccc);
                    helper.setText(R.id.add_friend, R.string.im_already_add);
                }
            }
        });
    }

    public void onError(String msg) {
        if (TextUtils.isEmpty((CharSequence)msg)) {
            return;
        }
        this.showShortToast(msg);
    }

    @Override
    public void showValidateResule(ResponseBody responseBody) {
        this.showShortToast("\u53d1\u9001\u8bf7\u6c42\u6210\u529f\uff0c\u5f85\u5bf9\u65b9\u9a8c\u8bc1");
    }
}

