/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.provider.ContactsContract;
import android.util.Log;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.byh.lib.byhim.FrameContrActivity;
import com.byh.lib.byhim.R;
import com.byh.lib.byhim.adapter.FriendsHeaderAdapter;
import com.byh.lib.byhim.bean.FriendsEntity;
import com.byh.lib.byhim.bean.FriendsHeader;
import com.byh.lib.byhim.event.ImEvent;
import com.byh.lib.byhim.present.FriendsListPresent;
import com.byh.lib.byhim.provider.ImStatusDispatch;
import com.byh.lib.byhim.view.ReCommendView;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.tbruyelle.rxpermissions.RxPermissions;
import java.util.ArrayList;
import java.util.List;
import me.yokeyword.indexablerv.IndexableHeaderAdapter;
import me.yokeyword.indexablerv.IndexableLayout;
import org.greenrobot.eventbus.EventBus;

public class BaseIndexFriendsFragment
extends BaseFragment
implements ReCommendView {
    protected static final String TAG = "BaseIndexFriendsFragmen";
    protected IndexableLayout mFriendsCycleView;
    protected FriendsHeaderAdapter mFriendsHeaderAdapter;
    protected List<FriendsEntity> mMorePersonList = new ArrayList<FriendsEntity>();
    private FriendsListPresent mReCommendPresent;
    protected int mLoginUserId;
    private static final int REQ_ACC_CODE = 2;
    private static final int REQ_NO_NOTICE = 3;
    private boolean hasBindHeaders;

    public void init() {
        this.mLoginUserId = VertifyDataUtil.getInstance((Context)this.getContext()).getLoginUserId();
        this.mFriendsCycleView = (IndexableLayout)this.findViewById(this.rootView, R.id.vIndexLayout);
        this.mFriendsCycleView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.addHeaderView();
        this.mReCommendPresent = new FriendsListPresent(this);
        this.reqRecommendList();
    }

    public void reqRecommendList() {
        RxPermissions.getInstance((Context)this.getActivity()).request(new String[]{"android.permission.GET_ACCOUNTS", "android.permission.READ_CONTACTS"}).subscribe(aBoolean -> {
            if (aBoolean.booleanValue()) {
                List<String> contactsList = this.readContactsInfo();
                if (!contactsList.isEmpty()) {
                    this.mReCommendPresent.reqReCommend(this.mLoginUserId + "", contactsList);
                } else {
                    this.mReCommendPresent.reqReCommend(this.mLoginUserId + "", null);
                }
            }
        });
    }

    private void reqAccountPermision() {
        if (ContextCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.GET_ACCOUNTS") != 0) {
            Log.i((String)TAG, (String)"reqAccountPermision: req acc permision");
            ActivityCompat.requestPermissions((Activity)this.getActivity(), (String[])new String[]{"android.permission.GET_ACCOUNTS"}, (int)2);
        } else {
            Log.i((String)TAG, (String)"reqAccountPermision: req reccmmend list");
            this.reqRecommendList();
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        Log.i((String)TAG, (String)("onRequestPermissionsResult: *******requestCode:" + requestCode));
        if (requestCode == 2) {
            for (int i = 0; i < permissions.length; ++i) {
                if (grantResults[i] == 0) {
                    Log.i((String)TAG, (String)"onRequestPermissionsResult: apply permision");
                    this.reqRecommendList();
                    continue;
                }
                if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.getActivity(), (String)permissions[i])) {
                    Log.i((String)TAG, (String)"onRequestPermissionsResult: select no request");
                    this.showNoReqAccPermisionDialog();
                    continue;
                }
                Log.i((String)TAG, (String)"onRequestPermissionsResult: select ban=====");
                this.showBanSelDialog();
            }
        } else {
            Log.i((String)TAG, (String)("onRequestPermissionsResult: requestCode:" + requestCode));
        }
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    private void showNoReqAccPermisionDialog() {
        AlertDialog alertDialog = null;
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        final AlertDialog finalAlertDialog = alertDialog;
        builder.setTitle((CharSequence)"\u6743\u9650\u7533\u8bf7").setMessage((CharSequence)"\u70b9\u51fb\u5141\u8bb8\u624d\u53ef\u4ee5\u4f7f\u7528\u901a\u8baf\u5f55\u529f\u80fd").setPositiveButton((CharSequence)"\u53bb\u5141\u8bb8", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                if (finalAlertDialog != null && finalAlertDialog.isShowing()) {
                    finalAlertDialog.dismiss();
                }
                Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
                Uri uri = Uri.fromParts((String)"package", (String)BaseIndexFriendsFragment.this.getActivity().getPackageName(), null);
                intent.setData(uri);
                BaseIndexFriendsFragment.this.startActivityForResult(intent, 3);
            }
        });
        alertDialog = builder.create();
        alertDialog.setCanceledOnTouchOutside(false);
        alertDialog.show();
    }

    private void showBanSelDialog() {
        AlertDialog alertDialog = null;
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        final AlertDialog finalAlertDialog = alertDialog;
        builder.setTitle((CharSequence)"\u6743\u9650\u7533\u8bf7").setMessage((CharSequence)"\u70b9\u51fb\u5141\u8bb8\u624d\u53ef\u4ee5\u4f7f\u7528\u901a\u8baf\u5f55\u529f\u80fd").setPositiveButton((CharSequence)"\u53bb\u5141\u8bb8", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                if (finalAlertDialog != null && finalAlertDialog.isShowing()) {
                    finalAlertDialog.dismiss();
                }
                ActivityCompat.requestPermissions((Activity)BaseIndexFriendsFragment.this.getActivity(), (String[])new String[]{"android.permission.GET_ACCOUNTS"}, (int)2);
            }
        });
        alertDialog = builder.create();
        alertDialog.setCanceledOnTouchOutside(false);
        alertDialog.show();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 3) {
            this.reqAccountPermision();
        }
    }

    private List<String> readContactsInfo() {
        ArrayList<String> contactList = new ArrayList<String>();
        String[] cols = new String[]{"display_name", "data1"};
        Context context = this.getMContext();
        if (context == null) {
            return contactList;
        }
        Cursor cursor = context.getContentResolver().query(ContactsContract.CommonDataKinds.Phone.CONTENT_URI, cols, null, null, null);
        if (cursor == null) {
            return contactList;
        }
        Log.i((String)TAG, (String)("cusor:" + cursor.getCount()));
        for (int i = 0; i < cursor.getCount(); ++i) {
            cursor.moveToPosition(i);
            int nameFieldColumnIndex = cursor.getColumnIndex("display_name");
            int numberFieldColumnIndex = cursor.getColumnIndex("data1");
            String name = cursor.getString(nameFieldColumnIndex);
            String number = cursor.getString(numberFieldColumnIndex);
            contactList.add(number);
        }
        return contactList;
    }

    protected void addHeaderView() {
        ArrayList<FriendsHeader> list = new ArrayList<FriendsHeader>();
        list.add(new FriendsHeader(R.drawable.ic_recommend, this.getString(R.string.byhim_im_recommend), true));
        list.add(new FriendsHeader(R.drawable.ic_byhim_friend_shenq, this.getString(R.string.im_friends_shenq), false));
        list.add(new FriendsHeader(R.drawable.ic_byhim_chatgroup, this.getString(R.string.im_qunl), false));
        this.mFriendsHeaderAdapter = new FriendsHeaderAdapter(this.mContext, "A", null, list);
        this.mFriendsHeaderAdapter.setOnItemHeaderClickListener((IndexableHeaderAdapter.OnItemHeaderClickListener)new IndexableHeaderAdapter.OnItemHeaderClickListener<FriendsHeader>(){

            public void onItemClick(View v, int currentPosition, FriendsHeader entity) {
                ImStatusDispatch.getInstance(BaseIndexFriendsFragment.this.getContext()).dispatchStatus(true, () -> {
                    if (entity.getImgDrawable() == R.drawable.ic_byhim_friend_shenq) {
                        BaseIndexFriendsFragment.this.startActivity(new Intent(BaseIndexFriendsFragment.this.getContext(), FrameContrActivity.class).putExtra("MSG_JUMP_TYPE", 5395));
                    } else if (entity.getImgDrawable() == R.drawable.ic_byhim_chatgroup) {
                        BaseIndexFriendsFragment.this.startActivity(new Intent(BaseIndexFriendsFragment.this.getContext(), FrameContrActivity.class).putExtra("MSG_JUMP_TYPE", 5396));
                    } else if (entity.getImgDrawable() == R.drawable.ic_recommend) {
                        BaseIndexFriendsFragment.this.startActivity(new Intent(BaseIndexFriendsFragment.this.getContext(), FrameContrActivity.class).putExtra("MSG_JUMP_TYPE", 86401));
                        EventBus.getDefault().postSticky((Object)new ImEvent.RecommendInfoEvent(BaseIndexFriendsFragment.this.mMorePersonList));
                    }
                });
            }
        });
        this.mFriendsCycleView.addHeaderAdapter((IndexableHeaderAdapter)this.mFriendsHeaderAdapter);
    }

    protected int getLayoutId() {
        return R.layout.byhim_indexbar_layout;
    }

    public void bindReHeaders() {
        if (!this.hasBindHeaders && this.mFriendsHeaderAdapter != null) {
            if (this.mMorePersonList == null) {
                return;
            }
            if (this.mMorePersonList.isEmpty()) {
                return;
            }
            ArrayList<String> headerList = new ArrayList<String>();
            int size = this.mMorePersonList.size();
            if (size > 5) {
                for (int i = 0; i < 5; ++i) {
                    headerList.add(this.mMorePersonList.get(i).getHeadImageUrl());
                }
            }
            Log.i((String)TAG, (String)("showReCommendList: size=>" + size));
            this.mFriendsHeaderAdapter.updateHeaderUrl(size, headerList);
        }
        this.hasBindHeaders = true;
    }

    @Override
    public void showReCommendList(List<FriendsEntity> friendsEntities) {
        if (friendsEntities == null) {
            return;
        }
        if (friendsEntities.size() == 0) {
            return;
        }
        this.mMorePersonList.addAll(friendsEntities);
        this.bindReHeaders();
        this.refreshRecoViews();
    }

    public void refreshRecoViews() {
    }

    public void onError(String msg) {
    }
}

