/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.fragment;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.RequiresApi;
import androidx.appcompat.view.menu.MenuPopupHelper;
import androidx.appcompat.widget.PopupMenu;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.SPUtils;
import com.byh.lib.byhim.FrameContrActivity;
import com.byh.lib.byhim.ImGroupChatActivity;
import com.byh.lib.byhim.R;
import com.byh.lib.byhim.bean.FriendsEntity;
import com.byh.lib.byhim.fragment.IndexBarFriendsFragment;
import com.byh.lib.byhim.fragment.IndexBarRecomFragment;
import com.byh.lib.byhim.present.FriendsListPresent;
import com.byh.lib.byhim.provider.ImStatusDispatch;
import com.byh.lib.byhim.utils.RongUtil;
import com.byh.lib.byhim.view.IShowFriendsView;
import com.google.gson.Gson;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.event.VerClickItemDispatch;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.util.StringUtil;
import com.kangxin.doctor.libdata.http.utils.ConstantUtil;
import io.rong.imkit.RongIM;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.List;
import me.yokeyword.fragmentation.ISupportFragment;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.jetbrains.annotations.NotNull;

@Route(path="/byhim/FriendsListFragment")
public class FriendsListFragment
extends BaseFragment
implements IShowFriendsView,
IToolView {
    private static final String TAG = "FriendsListFragment";
    private static final int NO_LOGIN_TAG = 20000;
    private static final int NET_ERROR_TAG = 30000;
    private FriendsListPresent mFriendsListPresent;
    private int mLoginUserId;
    private View mFrameContent;
    private View mNetErrLayout;
    private ImageView vImageView;
    private TextView vTextDesc;
    private EditText mSearchBarEdtView;

    public static FriendsListFragment getInstance() {
        return new FriendsListFragment();
    }

    @RequiresApi(api=3)
    public void init() {
        this.mFriendsListPresent = new FriendsListPresent(this);
        this.initActionBar();
        this.initSearchEdt();
        this.mFrameContent = this.findViewById(this.rootView, R.id.frame_content);
        this.mNetErrLayout = this.findViewById(this.rootView, R.id.net_err_layout);
        this.vImageView = (ImageView)this.findViewById(this.rootView, R.id.ic_imageview);
        this.vTextDesc = (TextView)this.findViewById(this.rootView, R.id.net_desc);
        this.mLoginUserId = VertifyDataUtil.getInstance((Context)this.getContext()).getLoginUserId();
        Log.i((String)TAG, (String)("mLoginUserId==>" + this.mLoginUserId));
        this.mNetErrLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if ((Integer)FriendsListFragment.this.mNetErrLayout.getTag() == 20000) {
                    ARouter.getInstance().build("/verification/LoginActivity").navigation();
                } else if ((Integer)FriendsListFragment.this.mNetErrLayout.getTag() == 30000) {
                    FriendsListFragment.this.mLoginUserId = VertifyDataUtil.getInstance((Context)FriendsListFragment.this.getContext()).getLoginUserId();
                    if (FriendsListFragment.this.mLoginUserId != -1) {
                        FriendsListFragment.this.mFriendsListPresent.showFriendsList(FriendsListFragment.this.mLoginUserId + "", "", false);
                    }
                }
            }
        });
        if (this.mLoginUserId == -1) {
            this.mNetErrLayout.setTag((Object)20000);
            this.showNetErrLayoutView(true);
        } else {
            this.mFriendsListPresent.showFriendsList(this.mLoginUserId + "", "", false);
        }
    }

    private void showNetErrLayoutView(boolean isShow) {
        if (isShow) {
            Object tagObj = this.mNetErrLayout.getTag();
            if (tagObj != null) {
                if ((Integer)tagObj == 20000) {
                    this.vImageView.setImageResource(R.drawable.ic_icon_no_login);
                    this.vTextDesc.setText((CharSequence)"\u672a\u767b\u5f55");
                } else if ((Integer)tagObj == 30000) {
                    this.vImageView.setImageResource(R.mipmap.ic_net_error);
                    this.vTextDesc.setText((CharSequence)"\u70b9\u51fb\u91cd\u8bd5");
                }
            } else {
                this.mNetErrLayout.setTag((Object)30000);
            }
            this.mFrameContent.setVisibility(8);
            this.mNetErrLayout.setVisibility(0);
        } else {
            this.mFrameContent.setVisibility(0);
            this.mNetErrLayout.setVisibility(8);
        }
    }

    private void initSearchEdt() {
        this.mSearchBarEdtView = (EditText)this.findViewById(this.rootView, R.id.search_bar);
        this.mSearchBarEdtView.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView textView, int actionId, KeyEvent event) {
                if (actionId == 3) {
                    String friendName = FriendsListFragment.this.mSearchBarEdtView.getText().toString().trim();
                    if (FriendsListFragment.this.mLoginUserId != -1) {
                        FriendsListFragment.this.mFriendsListPresent.showFriendsList(FriendsListFragment.this.mLoginUserId + "", friendName, true);
                    }
                }
                return false;
            }
        });
    }

    private void initActionBar() {
        this.vToolLeftImage.setVisibility(8);
        this.vToolTitleTextView.setText(R.string.byhim_constracts);
        this.vToolRightView.setVisibility(0);
        this.vToolRightView.setImageResource(R.drawable.ic_imcon_jia);
        this.vToolRightView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                FriendsListFragment.this.showPopUpMenu(view);
            }
        });
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void refreshFriendListEvent(ByhCommEvent.AgreeAddFriend agreeAddFriend) {
        if (this.mLoginUserId == -1) {
            this.mNetErrLayout.setTag((Object)20000);
            this.showNetErrLayoutView(true);
            return;
        }
        this.mFriendsListPresent.showFriendsList(this.mLoginUserId + "", "", false);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void refreshFriendListEvent(ByhCommEvent.UpdateFriendsListEvent updateFriendsListEvent) {
        String docId = VertifyDataUtil.getInstance((Context)this.mContext).getDoctorId();
        this.mLoginUserId = -1;
        if (!TextUtils.isEmpty((CharSequence)docId) && StringUtil.isNumeric((String)docId)) {
            this.mLoginUserId = Integer.parseInt(docId);
        }
        if (this.mLoginUserId == -1) {
            this.mNetErrLayout.setTag((Object)20000);
            this.showNetErrLayoutView(true);
            return;
        }
        this.mFriendsListPresent.showFriendsList(this.mLoginUserId + "", "", false);
        String targetId = updateFriendsListEvent.getTargetId();
        Log.i((String)TAG, (String)("refreshFriendListEvent: targetId:" + targetId));
        if (!TextUtils.isEmpty((CharSequence)targetId)) {
            RongIM.getInstance().removeConversation(Conversation.ConversationType.PRIVATE, targetId, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Boolean>(){

                public void onSuccess(Boolean aBoolean) {
                    Log.i((String)FriendsListFragment.TAG, (String)"onSuccess: delete friend");
                }

                public void onError(RongIMClient.ErrorCode errorCode) {
                    Log.i((String)FriendsListFragment.TAG, (String)("onError: delete friend:" + errorCode));
                }
            });
        }
    }

    @SuppressLint(value={"RestrictedApi"})
    private void showPopUpMenu(View view) {
        PopupMenu popupMenu = new PopupMenu(this.getContext(), view);
        popupMenu.setOnMenuItemClickListener(new PopupMenu.OnMenuItemClickListener(){

            public boolean onMenuItemClick(final MenuItem item) {
                ImStatusDispatch.getInstance(FriendsListFragment.this.getContext()).dispatchStatus(true, new VerClickItemDispatch.OnVerItemClickListener(){

                    public void onItemClickOk() {
                        int itemId = item.getItemId();
                        if (itemId == R.id.im_chat_group) {
                            FriendsListFragment.this.startActivity(new Intent(FriendsListFragment.this.getContext(), ImGroupChatActivity.class).putExtra("PAGE_TYPE", 4386));
                        } else if (itemId == R.id.im_add_friends) {
                            FriendsListFragment.this.startActivity(new Intent(FriendsListFragment.this.getContext(), FrameContrActivity.class).putExtra("MSG_JUMP_TYPE", 5397));
                        } else if (itemId == R.id.im_scan) {
                            ARouter.getInstance().build("/byhim/ScanActivity").withInt("key_ScanType", ConstantUtil.SCAN_TYPE_CASE_MANAGER).navigation();
                        }
                    }
                });
                return true;
            }
        });
        Menu menu2 = popupMenu.getMenu();
        popupMenu.getMenuInflater().inflate(R.menu.pop_menu, menu2);
        try {
            Field field = popupMenu.getClass().getDeclaredField("mPopup");
            field.setAccessible(true);
            MenuPopupHelper mHelper = (MenuPopupHelper)field.get(popupMenu);
            mHelper.setForceShowIcon(true);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        popupMenu.show();
    }

    protected int getLayoutId() {
        return R.layout.im_friendslist_fragment;
    }

    @Override
    public void showFriendsList(List<FriendsEntity> friendsEntities) {
        this.showNetErrLayoutView(false);
        if (friendsEntities != null && friendsEntities.size() > 0) {
            this.mSearchBarEdtView.setVisibility(0);
            Bundle friendBundle = new Bundle();
            IndexBarFriendsFragment indexBarFriendsFragment = IndexBarFriendsFragment.getInstance();
            friendBundle.putSerializable("FRIENDSLIST_KEY", (Serializable)((Object)friendsEntities));
            indexBarFriendsFragment.setArguments(friendBundle);
            this.loadRootFragment(R.id.frame_content, (ISupportFragment)indexBarFriendsFragment);
            RongUtil.getInstance().saveRongIdToLocal(friendsEntities);
            this.loadLocalFriendsId();
        } else {
            this.mSearchBarEdtView.setVisibility(8);
            this.loadRootFragment(R.id.frame_content, (ISupportFragment)IndexBarRecomFragment.getInstance());
            this.clearFriendIds();
        }
    }

    private void loadLocalFriendsId() {
        String friensId = SPUtils.getInstance().getString("FRIENDSID_KEY");
        if (!TextUtils.isEmpty((CharSequence)friensId)) {
            Gson gson = new Gson();
            List friendIdList = (List)gson.fromJson(friensId, List.class);
            RongUtil.getInstance().setFriendIds(friendIdList);
        }
    }

    private void clearFriendIds() {
        SPUtils.getInstance().put("FRIENDSID_KEY", "");
        RongUtil.getInstance().setFriendIds(null);
    }

    @Override
    public void startGroupChatPage(String groupId) {
    }

    @Override
    public void jointGroupMembersOk() {
    }

    public void onError(String msg) {
        this.showNetErrLayoutView(true);
        this.mNetErrLayout.setTag((Object)30000);
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
    }
}

