/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.fragment;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.blankj.utilcode.util.ToastUtils;
import com.byh.lib.byhim.R;
import com.byh.lib.byhim.bean.GroupListEntity;
import com.byh.lib.byhim.bean.RongChatExtraBean;
import com.byh.lib.byhim.holder.FriendsApplyHolder;
import com.byh.lib.byhim.present.impl.GroupListPresent;
import com.byh.lib.byhim.utils.RongUtil;
import com.byh.lib.byhim.view.IShowGroupListView;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.byh.global.ByConstant;
import com.kangxin.common.byh.util.VertifyDataUtil;
import io.rong.imkit.RongIM;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.MessageContent;
import io.rong.message.ImageMessage;
import java.util.List;

public class GroupListFragment
extends BaseFragment
implements IShowGroupListView {
    private static final String TAG = "GroupListFragment";
    private RecyclerView mGroupListCycler;
    private GroupListPresent mGroupListPresent;
    private String mImImgPath;

    public static GroupListFragment getInstance() {
        return new GroupListFragment();
    }

    public void init() {
        this.mImImgPath = this.getArguments().getString("imgPath");
        String loginUserId = VertifyDataUtil.getInstance((Context)this.getContext()).getLoginUserId() + "";
        this.mGroupListPresent = new GroupListPresent(this);
        this.mGroupListCycler = (RecyclerView)this.findViewById(this.rootView, R.id.recycler_list);
        this.mGroupListCycler.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mGroupListPresent.reqGroupList(loginUserId);
    }

    protected int getLayoutId() {
        return R.layout.recycler_view_layout;
    }

    @Override
    public void showGroupList(List<GroupListEntity> groupListEntities) {
        BaseQuickAdapter<GroupListEntity, FriendsApplyHolder> baseQuickAdapter2 = new BaseQuickAdapter<GroupListEntity, FriendsApplyHolder>(R.layout.im_grouplist_item, groupListEntities){

            protected void convert(FriendsApplyHolder helper, GroupListEntity item) {
                helper.setImageView(R.id.left_img, item.getLogoUrl());
                helper.setText(R.id.group_name, item.getGroupName());
            }
        };
        baseQuickAdapter2.setOnItemClickListener((adapter, view, position) -> {
            GroupListEntity groupListEntity = (GroupListEntity)adapter.getItem(position);
            RongChatExtraBean rongChatExtraBean = new RongChatExtraBean();
            rongChatExtraBean.setName(groupListEntity.getGroupName());
            rongChatExtraBean.setTargetId(groupListEntity.getGroupUuid());
            rongChatExtraBean.setOrderType(ByConstant.NORMAL_GROUP_CHAT);
            if (TextUtils.isEmpty((CharSequence)this.mImImgPath)) {
                RongUtil.startConversation(this.getContext(), Conversation.ConversationType.GROUP, rongChatExtraBean);
            } else {
                RongUtil.getInstance().setChatExtraBean(rongChatExtraBean);
                this.sendImgToIm(rongChatExtraBean.getTargetId());
            }
        });
        this.mGroupListCycler.setAdapter((RecyclerView.Adapter)baseQuickAdapter2);
    }

    public void onError(String msg) {
        this.showShortToast(msg);
    }

    private void sendImgToIm(String groupId) {
        if (TextUtils.isEmpty((CharSequence)this.mImImgPath)) {
            return;
        }
        ImageMessage imageMessage = ImageMessage.obtain((Uri)Uri.parse((String)("file://" + this.mImImgPath)), (Uri)Uri.parse((String)("file://" + this.mImImgPath)));
        Log.i((String)TAG, (String)("mImImgPath==>" + this.mImImgPath));
        Log.i((String)TAG, (String)("groupId==>" + groupId));
        RongIM.getInstance().sendImageMessage(Conversation.ConversationType.GROUP, groupId, (MessageContent)imageMessage, null, null, new RongIMClient.SendImageMessageCallback(){

            public void onAttached(Message message2) {
            }

            public void onError(Message message2, RongIMClient.ErrorCode errorCode) {
                ToastUtils.showLong((int)R.string.byhim_shareimg_err);
                Log.i((String)GroupListFragment.TAG, (String)("onError==>" + errorCode));
            }

            public void onSuccess(Message message2) {
                ToastUtils.showLong((int)R.string.byhim_shareimg_ok);
                if (GroupListFragment.this.getActivity() != null) {
                    GroupListFragment.this.getActivity().finish();
                }
            }

            public void onProgress(Message message2, int i) {
            }
        });
    }
}

