/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.fragment;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.view.View;
import androidx.fragment.app.Fragment;
import com.alibaba.android.arouter.launcher.ARouter;
import com.byh.lib.byhim.Event;
import com.byh.lib.byhim.R;
import com.byh.lib.byhim.bean.NoticeDbBean;
import com.byh.lib.byhim.fragment.JobChatListFragment;
import com.byh.lib.byhim.present.impl.NoticeListPresenter;
import com.byh.lib.byhim.view.INoticeListView;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.byh.entity.OrderItemEntity;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.event.VertifyClickListener;
import com.kangxin.common.byh.service.IConsChatReceProvider;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.widget.MarqueeTextView;
import com.kangxin.common.byh.widget.MarqueeTextViewClickListener;
import java.io.Serializable;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class ImJobFragment
extends BaseFragment
implements INoticeListView {
    private NoticeListPresenter mNoticeListPresent;
    private MarqueeTextView mNoticeScrollView;
    private IConsChatReceProvider mConsuChatReceiverProvider = (IConsChatReceProvider)ARouter.getInstance().build("/consuchat/receiver/ConsuChatReceiverProvider").navigation();

    public void initView() {
        this.mConsuChatReceiverProvider.registerConsuChatReceiver();
        this.mNoticeScrollView = (MarqueeTextView)this.findViewById(this.rootView, R.id.marquee_text);
        this.initFragment();
        this.findViewById(this.rootView, R.id.ll_search).setOnClickListener((View.OnClickListener)new VertifyClickListener(){

            protected void onClickOk(View view) {
                OrderItemEntity orderItemEntity = new OrderItemEntity();
                orderItemEntity.setOrderType(5);
                if (Build.VERSION.SDK_INT >= 26) {
                    ImJobFragment.this.mConsuChatReceiverProvider.sendConsuChatReceiver((Serializable)orderItemEntity);
                } else {
                    Intent intent = new Intent("com.kangxin.doctor.worktable.orderlist.consulation.chat");
                    intent.putExtra("ORDER_ITEM_ENTITY", (Serializable)orderItemEntity);
                    ImJobFragment.this.getContext().sendBroadcast(intent);
                }
            }
        });
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mNoticeScrollView.releaseResources();
    }

    public void onDestroy() {
        super.onDestroy();
        this.mConsuChatReceiverProvider.unRegisterConsuChatReceiver();
    }

    private void initFragment() {
        JobChatListFragment jobChatListFragment = JobChatListFragment.getInstance();
        this.getChildFragmentManager().beginTransaction().replace(R.id.frame_content, (Fragment)jobChatListFragment).commit();
    }

    public void init() {
        this.initView();
        this.mNoticeListPresent = new NoticeListPresenter(this);
        this.reqNoticeListEvent(new ByhCommEvent.UpdateNoticeList());
    }

    @Subscribe(threadMode=ThreadMode.MAIN, sticky=true)
    public void reqNoticeListEvent(ByhCommEvent.UpdateNoticeList updateNoticeList) {
        String hospitalId = VertifyDataUtil.getInstance((Context)this.getContext()).getHospitalId() + "";
        this.mNoticeListPresent.reqHosDocNoticeList(hospitalId);
    }

    protected int getLayoutId() {
        return R.layout.im_job_fragment;
    }

    @Override
    public void bindDatas(final List<NoticeDbBean> beans) {
        if (beans != null && beans.size() > 0) {
            String[] titles = new String[beans.size()];
            for (int i = 0; i < beans.size(); ++i) {
                titles[i] = beans.get(i).getTitle();
            }
            this.mNoticeScrollView.setTextArraysAndClickListener(titles, new MarqueeTextViewClickListener(){

                public void onClick(View view) {
                    view.setOnClickListener((View.OnClickListener)new VertifyClickListener(){

                        protected void onClickOk(View view) {
                            ARouter.getInstance().build("/drircle/NoticeListActivity").navigation();
                            EventBus.getDefault().postSticky((Object)new Event.NoticeListEvent(beans));
                        }
                    });
                }
            });
        } else {
            String[] noDataTitles = new String[]{"\u6682\u65e0\u516c\u544a"};
            this.mNoticeScrollView.setTextArraysAndClickListener(noDataTitles, new MarqueeTextViewClickListener(){

                public void onClick(View view) {
                }
            });
        }
    }

    public void onError(String msg) {
        this.showShortToast(msg);
    }
}

