/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.fragment;

import android.app.AlertDialog;
import android.content.Intent;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import com.byh.lib.byhim.FrameContractsActivity;
import com.byh.lib.byhim.R;
import com.byh.lib.byhim.adapter.FriendsListAdapter;
import com.byh.lib.byhim.bean.FriendsEntity;
import com.byh.lib.byhim.fragment.BaseIndexFriendsFragment;
import com.byh.lib.byhim.present.FriendsDeletePresent;
import com.byh.lib.byhim.provider.ImStatusDispatch;
import com.byh.lib.byhim.view.IDeleteFriendsView;
import com.kangxin.common.byh.event.ByhCommEvent;
import io.rong.imkit.RongIM;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import java.util.List;
import me.yokeyword.indexablerv.IndexableAdapter;
import org.greenrobot.eventbus.EventBus;

public class IndexBarFriendsFragment
extends BaseIndexFriendsFragment
implements IDeleteFriendsView {
    private static final String TAG = "FriendsListFragment";
    private FriendsListAdapter mFriendsListAdapter;
    private FriendsDeletePresent mFriendsDeletePresent;
    private String mRongTargetId = "-1";

    public static IndexBarFriendsFragment getInstance() {
        return new IndexBarFriendsFragment();
    }

    @Override
    public void init() {
        super.init();
        this.mFriendsDeletePresent = new FriendsDeletePresent(this);
        this.initAdapter();
        this.refreshFriendList();
    }

    private void refreshFriendList() {
        List friendsEntityList = (List)((Object)this.getArguments().getSerializable("FRIENDSLIST_KEY"));
        this.mFriendsListAdapter.setDatas(friendsEntityList);
        this.mFriendsListAdapter.notifyDataSetChanged();
    }

    @Override
    public void deleteOK(int code) {
        if (code == 200) {
            this.showShortToast("\u597d\u53cb\u5220\u9664\u6210\u529f");
            EventBus.getDefault().post((Object)new ByhCommEvent.AgreeAddFriend());
            Log.i((String)TAG, (String)("deleteOK: targetId:" + this.mRongTargetId));
            RongIM.getInstance().removeConversation(Conversation.ConversationType.PRIVATE, this.mRongTargetId, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Boolean>(){

                public void onSuccess(Boolean aBoolean) {
                }

                public void onError(RongIMClient.ErrorCode errorCode) {
                }
            });
        } else {
            this.showShortToast("\u597d\u53cb\u5220\u9664\u5931\u8d25");
        }
    }

    @Override
    public void onError(String msg) {
    }

    private void initAdapter() {
        if (this.mFriendsListAdapter == null) {
            this.mFriendsListAdapter = new FriendsListAdapter(this.getContext());
            this.mFriendsListAdapter.setOnItemContentClickListener((IndexableAdapter.OnItemContentClickListener)new IndexableAdapter.OnItemContentClickListener<FriendsEntity>(){

                public void onItemClick(View v, int originalPosition, int currentPosition, FriendsEntity entity) {
                    ImStatusDispatch.getInstance(IndexBarFriendsFragment.this.getContext()).dispatchStatus(true, () -> IndexBarFriendsFragment.this.startActivity(new Intent(IndexBarFriendsFragment.this.getContext(), FrameContractsActivity.class).putExtra("MSG_JUMP_TYPE", 5394).putExtra("IM_DOCTOR_ID", entity.getDoctorId())));
                }
            });
            this.mFriendsListAdapter.setItemContentLongClickListener((view, item) -> {
                AlertDialog alertDialog = new AlertDialog.Builder(this.mContext).create();
                alertDialog.setCancelable(false);
                alertDialog.show();
                Window window = alertDialog.getWindow();
                window.setContentView(R.layout.byhim_dialog_delete_friend_layout);
                WindowManager.LayoutParams params = window.getAttributes();
                Display display = this.getActivity().getWindowManager().getDefaultDisplay();
                params.height = (int)((double)display.getHeight() * 0.25);
                params.width = (int)((double)display.getWidth() * 0.7);
                alertDialog.getWindow().setAttributes(params);
                alertDialog.getWindow().setBackgroundDrawableResource(R.drawable.byhim_search_order_bg);
                window.findViewById(R.id.ok_tv).setOnClickListener(v -> {
                    alertDialog.dismiss();
                    ImStatusDispatch.getInstance(this.getContext()).dispatchStatus(true, () -> {
                        this.mRongTargetId = item.getRongCloudId();
                        this.mFriendsDeletePresent.reDeleteFriends(String.valueOf(this.mLoginUserId), String.valueOf(item.getDoctorId()), true);
                    });
                });
                window.findViewById(R.id.cancel_tv).setOnClickListener(v -> alertDialog.dismiss());
            });
            this.mFriendsCycleView.setAdapter((IndexableAdapter)this.mFriendsListAdapter);
        }
    }
}

