/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.fragment;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import androidx.fragment.app.Fragment;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.LogUtils;
import com.blankj.utilcode.util.SPUtils;
import com.blankj.utilcode.util.StringUtils;
import com.byh.lib.byhim.Event;
import com.byh.lib.byhim.FrameContrActivity;
import com.byh.lib.byhim.FrameNotitleActivity;
import com.byh.lib.byhim.R;
import com.byh.lib.byhim.bean.FriendsEntity;
import com.byh.lib.byhim.bean.NoticeDbBean;
import com.byh.lib.byhim.fragment.ImConverListFragment;
import com.byh.lib.byhim.module.impl.ContractsModel;
import com.byh.lib.byhim.present.impl.NoticeListPresenter;
import com.byh.lib.byhim.provider.ImStatusDispatch;
import com.byh.lib.byhim.utils.RongUtil;
import com.byh.lib.byhim.view.INoticeListView;
import com.byh.lib.byhim.widget.MessageItem;
import com.google.gson.Gson;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.db.IPushPresenter;
import com.kangxin.common.byh.db.entity.ByPushEntity;
import com.kangxin.common.byh.db.impl.PushPresenter;
import com.kangxin.common.byh.entity.UpdateDataEntity;
import com.kangxin.common.byh.event.ByPushListEvent;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.event.HXIMMsgEvent;
import com.kangxin.common.byh.event.VertifyClickListener;
import com.kangxin.common.byh.inter.INotifyEvent;
import com.kangxin.common.byh.inter.IPushEvent;
import com.kangxin.common.byh.service.HXService;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.widget.RxBaseObserver;
import com.kangxin.doctor.libdata.http.utils.ConstantUtil;
import com.tbruyelle.rxpermissions.RxPermissions;
import io.reactivex.Observer;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.jetbrains.annotations.NotNull;

@Route(path="/message/ImMessageFragment")
public class JobChatListFragment
extends BaseFragment
implements IPushEvent,
INotifyEvent,
INoticeListView,
IToolView {
    private static final String TAG = "JobChatListFragment";
    private MessageItem applyNewItem;
    private MessageItem subscribeNewItem;
    private MessageItem notifyNewItem;
    private MessageItem mHosInNoticeItem;
    private MessageItem mOnlineQueItem;
    private NoticeListPresenter mNoticeListPresent;
    private IPushPresenter pushPresenter = new PushPresenter();

    public static JobChatListFragment getInstance() {
        return new JobChatListFragment();
    }

    @Subscribe(threadMode=ThreadMode.MAIN, sticky=true)
    public void reqNoticeListEvent(ByhCommEvent.UpdateNoticeList updateNoticeList) {
        String hospitalId = VertifyDataUtil.getInstance((Context)this.getContext()).getHospitalId() + "";
    }

    private void initView(View rootView) {
        LinearLayout headerLayout = (LinearLayout)rootView.findViewById(R.id.ll_header_view);
        headerLayout.addView(this.getHeaderView());
    }

    @Subscribe(threadMode=ThreadMode.MAIN, sticky=true)
    public void loadImListFragment(ByhCommEvent.ImConnectOkEvent connectOkEvent) {
        ImConverListFragment imConverListFragment = ImConverListFragment.getInstance();
        Bundle imListBundle = new Bundle();
        imListBundle.putString(ImConverListFragment.CHATLISTTYPE, "3");
        imConverListFragment.setArguments(imListBundle);
        this.getChildFragmentManager().beginTransaction().replace(R.id.frame_content, (Fragment)imConverListFragment).commit();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void refreshFriendListEvent(ByhCommEvent.UpdateFriendsListEvent updateFriendsListEvent) {
        ContractsModel iContractsModel = new ContractsModel();
        String docId = VertifyDataUtil.getInstance((Context)this.getContext()).getDoctorId();
        if (TextUtils.isEmpty((CharSequence)docId)) {
            return;
        }
        if ("-1".equals(docId)) {
            return;
        }
        iContractsModel.reqFriendsList(docId, "").subscribe((Observer)new RxBaseObserver<ResponseBody<List<FriendsEntity>>>(){

            public void onReqNext(ResponseBody<List<FriendsEntity>> listResponseBody) {
                List friendsEntities = (List)listResponseBody.getResult();
                if (friendsEntities != null && friendsEntities.size() > 0) {
                    RongUtil.getInstance().saveRongIdToLocal(friendsEntities);
                    JobChatListFragment.this.loadLocalFriendsId();
                } else {
                    JobChatListFragment.this.clearFriendIds();
                }
            }

            public void onError(Throwable e) {
            }

            public void onComplete() {
            }
        });
    }

    private void loadLocalFriendsId() {
        String friensId = SPUtils.getInstance().getString("FRIENDSID_KEY");
        if (!TextUtils.isEmpty((CharSequence)friensId)) {
            Gson gson = new Gson();
            List friendIdList = (List)gson.fromJson(friensId, List.class);
            RongUtil.getInstance().setFriendIds(friendIdList);
        }
    }

    private void clearFriendIds() {
        SPUtils.getInstance().put("FRIENDSID_KEY", "");
        RongUtil.getInstance().setFriendIds(null);
    }

    private View getHeaderView() {
        View headerView = LayoutInflater.from((Context)this.getActivity().getApplicationContext()).inflate(R.layout.job_chatlist_header, null);
        this.applyNewItem = (MessageItem)headerView.findViewById(R.id.apply_new);
        this.subscribeNewItem = (MessageItem)headerView.findViewById(R.id.service_pkg);
        this.notifyNewItem = (MessageItem)headerView.findViewById(R.id.notice_msg);
        this.mHosInNoticeItem = (MessageItem)headerView.findViewById(R.id.hos_notice_in);
        this.mOnlineQueItem = (MessageItem)headerView.findViewById(R.id.online_que);
        this.mOnlineQueItem.setOnClickListener((View.OnClickListener)new VertifyClickListener(){

            protected void onClickOk(View view) {
                JobChatListFragment.this.toOnlineQue();
            }
        });
        this.applyNewItem.setOnClickListener((View.OnClickListener)new VertifyClickListener(){

            protected void onClickOk(View view) {
                JobChatListFragment.this.toNewApply();
            }
        });
        this.subscribeNewItem.setOnClickListener((View.OnClickListener)new VertifyClickListener(){

            protected void onClickOk(View view) {
                JobChatListFragment.this.toServicePkg();
            }
        });
        this.notifyNewItem.setOnClickListener((View.OnClickListener)new VertifyClickListener(){

            protected void onClickOk(View view) {
                JobChatListFragment.this.toNotifyList();
            }
        });
        return headerView;
    }

    private void checkOnlineUnread() {
        HXService service = (HXService)ARouter.getInstance().navigation(HXService.class);
        final int unreadCount = service.getIMUnreadCount();
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (JobChatListFragment.this.mOnlineQueItem == null) {
                    return;
                }
                JobChatListFragment.this.mOnlineQueItem.setPointValue(unreadCount + "");
                if (!VertifyDataUtil.getInstance((Context)JobChatListFragment.this.getContext()).hasLogin() || unreadCount < 1) {
                    JobChatListFragment.this.mOnlineQueItem.setPointVisible(8);
                    JobChatListFragment.this.mOnlineQueItem.setContent("\u6682\u65e0");
                } else {
                    JobChatListFragment.this.mOnlineQueItem.setPointVisible(0);
                    JobChatListFragment.this.mOnlineQueItem.setContent("\u6709\u65b0\u6d88\u606f");
                }
            }
        });
    }

    public void onResume() {
        super.onResume();
        this.checkOnlineUnread();
    }

    public void onHiddenChanged(boolean hidden) {
        super.onHiddenChanged(hidden);
        if (!hidden) {
            this.checkOnlineUnread();
        }
    }

    @Subscribe
    public void onEvent(HXIMMsgEvent event) {
        this.checkOnlineUnread();
    }

    private void toOnlineQue() {
        ARouter.getInstance().build("/hx/advisory_record").navigation();
    }

    private void toServicePkg() {
        Intent intent = new Intent(this.getContext(), FrameContrActivity.class).putExtra("MSG_JUMP_TYPE", 5376);
        this.startActivity(intent);
    }

    private void toNewApply() {
        Intent intent = new Intent(this.getContext(), FrameContrActivity.class).putExtra("MSG_JUMP_TYPE", 5377);
        this.startActivity(intent);
    }

    private void toSubscribe() {
        Intent intent = new Intent(this.getContext(), FrameNotitleActivity.class).putExtra("MSG_JUMP_TYPE", 5378);
        this.startActivity(intent);
    }

    private void toNotifyList() {
        Intent intent = new Intent(this.getContext(), FrameContrActivity.class).putExtra("MSG_JUMP_TYPE", 5379);
        this.startActivity(intent);
    }

    private void queryNewApply() {
        this.pushPresenter.getPushListByBusType("300");
    }

    private void queryNotify() {
        this.pushPresenter.getPushListByUnBusType(new String[]{"300", "servicePkg", "ZXZX"});
    }

    private void queryServicePkg() {
        this.pushPresenter.getPushListByBusType("servicePkg");
    }

    @Subscribe(sticky=true, threadMode=ThreadMode.MAIN)
    public void injectUpdataEntity(UpdateDataEntity entity) {
        this.queryNewApply();
        this.queryNotify();
        this.queryServicePkg();
    }

    @Subscribe(sticky=true)
    public void injectByPushListEvent(ByPushListEvent event) {
        String code;
        switch (code = event.getCode() + "") {
            case "300": {
                this.newApplyMsg(event.getEntities());
                break;
            }
            case "servicePkg": {
                this.bindServicePkgItem(event.getEntities());
                break;
            }
            case "4": {
                this.notifyMsg(event.getEntities());
            }
        }
    }

    private void notifyMsg(List<ByPushEntity> byPushEntities) {
        if (byPushEntities.size() > 0) {
            int count = 0;
            for (ByPushEntity entity : byPushEntities) {
                if (entity.getIsRead() != 0) continue;
                ++count;
            }
            this.notifyNewItem.setPointValue(count + "");
            this.notifyNewItem.setContent(byPushEntities.get(byPushEntities.size() - 1).getContent());
            this.notifyNewItem.setPointVisible(0);
            if (count == 0) {
                this.notifyNewItem.setPointVisible(8);
            }
        } else {
            this.notifyNewItem.setPointVisible(8);
        }
    }

    private void bindServicePkgItem(List<ByPushEntity> byPushEntities) {
        if (byPushEntities.size() > 0) {
            int countSubscribe = 0;
            for (ByPushEntity entity : byPushEntities) {
                if (entity.getIsRead() != 0) continue;
                ++countSubscribe;
            }
            this.subscribeNewItem.setPointValue(countSubscribe + "");
            this.subscribeNewItem.setContent(byPushEntities.get(byPushEntities.size() - 1).getContent());
            this.subscribeNewItem.setPointVisible(0);
            if (countSubscribe == 0) {
                this.subscribeNewItem.setPointVisible(8);
            }
        } else {
            this.subscribeNewItem.setPointVisible(8);
        }
    }

    private void newApplyMsg(List<ByPushEntity> byPushEntities) {
        if (byPushEntities.size() > 0) {
            int countNewApply = 0;
            for (ByPushEntity entity : byPushEntities) {
                if (entity.getIsRead() != 0) continue;
                ++countNewApply;
            }
            this.applyNewItem.setPointValue(countNewApply + "");
            this.applyNewItem.setContent(byPushEntities.get(byPushEntities.size() - 1).getContent());
            this.applyNewItem.setPointVisible(0);
            if (countNewApply == 0) {
                this.applyNewItem.setPointVisible(8);
            }
        } else {
            this.applyNewItem.setPointVisible(8);
        }
    }

    @Subscribe(sticky=true)
    public void injectPushEntity(ByPushEntity entity) {
        boolean flag;
        String businessType = entity.getBusinessType();
        if (!StringUtils.isEmpty((CharSequence)businessType) && (flag = this.toFragmentByNotifyCode(entity.getBusinessType()))) {
            EventBus.getDefault().removeStickyEvent((Object)entity);
        }
    }

    private boolean toFragmentByNotifyCode(String notifyCode) {
        boolean flag = false;
        if (notifyCode != null) {
            switch (notifyCode) {
                case "300": {
                    this.toNewApply();
                    flag = true;
                    break;
                }
                case "311": {
                    this.toSubscribe();
                    flag = true;
                    break;
                }
                default: {
                    LogUtils.d((Object[])new Object[]{"received other notifycode = " + notifyCode});
                }
            }
        }
        return flag;
    }

    public void onDestroy() {
        super.onDestroy();
        EventBus.getDefault().unregister((Object)this);
    }

    @Override
    public void bindDatas(final List<NoticeDbBean> beans) {
        if (beans != null && beans.size() > 0) {
            String desc = beans.get(0).getTitle();
            this.mHosInNoticeItem.setContent(desc);
            this.mHosInNoticeItem.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ARouter.getInstance().build("/drircle/NoticeListActivity").navigation();
                    EventBus.getDefault().postSticky((Object)new Event.NoticeListEvent(beans));
                }
            });
        } else {
            this.mHosInNoticeItem.setContent("\u6682\u65e0\u516c\u544a");
        }
    }

    public void onError(String msg) {
    }

    @NotNull
    public View getVToolView() {
        return this.findViewById(this.rootView, R.id.vToolBar);
    }

    public void finishCurrentView() {
        ImStatusDispatch.getInstance(this.getContext()).dispatchStatus(true, () -> RxPermissions.getInstance((Context)this.getActivity()).request(new String[]{"android.permission.CAMERA"}).subscribe(aBoolean -> {
            if (aBoolean.booleanValue()) {
                ARouter.getInstance().build("/byhim/ScanActivity").withInt("key_ScanType", ConstantUtil.SCAN_TYPE_CASE_MANAGER).navigation();
            }
        }));
    }

    public void init() {
        this.initView(this.rootView);
        EventBus.getDefault().register((Object)this);
        this.mNoticeListPresent = new NoticeListPresenter(this);
        this.reqNoticeListEvent(new ByhCommEvent.UpdateNoticeList());
        this.vToolTitleTextView.setText((CharSequence)"\u6d88\u606f");
        this.vToolLeftImage.setImageResource(R.mipmap.ic_scanning);
        this.refreshFriendListEvent(new ByhCommEvent.UpdateFriendsListEvent());
    }

    protected int getLayoutId() {
        return R.layout.job_chatlist_fragment;
    }
}

