/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.fragment;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.blankj.utilcode.util.ToastUtils;
import com.byh.lib.byhim.FrameContractsActivity;
import com.byh.lib.byhim.R;
import com.byh.lib.byhim.bean.FriendsEntity;
import com.byh.lib.byhim.event.ImEvent;
import com.byh.lib.byhim.holder.FriendsApplyHolder;
import com.byh.lib.byhim.module.impl.ContractsModel;
import com.byh.lib.byhim.utils.ChangeUtil;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.byh.entity.ExpertInfoEntity;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.widget.RxProgressObserver;
import com.zhy.view.flowlayout.FlowLayout;
import com.zhy.view.flowlayout.TagAdapter;
import io.reactivex.Observer;
import java.util.Arrays;
import java.util.List;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class MayKnowPersonFragment
extends BaseFragment {
    private static final String TAG = "MayKnowPersonFragment";
    private RecyclerView mPersonCyclerView;

    public static MayKnowPersonFragment getInstance() {
        return new MayKnowPersonFragment();
    }

    public void init() {
        this.mPersonCyclerView = (RecyclerView)this.findViewById(this.rootView, R.id.recycler_list);
        this.mPersonCyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
    }

    protected int getLayoutId() {
        return R.layout.byhim_may_knowperson_fragment;
    }

    @Subscribe(threadMode=ThreadMode.MAIN, sticky=true)
    public void bindListToViewsEvent(final ImEvent.RecommendInfoEvent recommendInfoEvent) {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                MayKnowPersonFragment.this.bindDatasToAdapter(recommendInfoEvent.getFriendsEntities());
            }
        }, 300L);
    }

    private void bindDatasToAdapter(List<FriendsEntity> friendsEntities) {
        BaseQuickAdapter<FriendsEntity, FriendsApplyHolder> baseQuickAdapter2 = new BaseQuickAdapter<FriendsEntity, FriendsApplyHolder>(R.layout.byhim_recommend_content_item, friendsEntities){

            protected void convert(FriendsApplyHolder helper, final FriendsEntity friendsEntity) {
                helper.setImageView(R.id.header_icon, friendsEntity.getHeadImageUrl());
                helper.setText(R.id.doc_name, friendsEntity.getDisplayName());
                helper.setText(R.id.doc_zhic, friendsEntity.getProfession());
                helper.setText(R.id.hos_desc, friendsEntity.getRegHospitalName() + " " + friendsEntity.getStdSecondDeptName());
                helper.setOnItemViewClickListener(R.id.add, new View.OnClickListener(){

                    public void onClick(View v) {
                        this.reqSendAddVertify(friendsEntity);
                    }
                });
                String typeNames = friendsEntity.getTypeNames();
                if (!TextUtils.isEmpty((CharSequence)typeNames)) {
                    String[] typeNameArray = typeNames.split(",");
                    helper.setTagAdapter(R.id.tag_flow_layout, (TagAdapter)new TagAdapter<String>(Arrays.asList(typeNameArray)){

                        public View getView(FlowLayout parent, int position, String label) {
                            View labelView = LayoutInflater.from((Context)mContext).inflate(R.layout.byhim_recommend_label_item, (ViewGroup)parent, false);
                            if (labelView instanceof TextView) {
                                ((TextView)labelView).setText((CharSequence)label);
                            }
                            return labelView;
                        }
                    });
                }
            }

            @SuppressLint(value={"CheckResult"})
            private void reqSendAddVertify(FriendsEntity friendsEntity) {
                String docId = VertifyDataUtil.getInstance((Context)this.mContext).getLoginUserId() + "";
                ExpertInfoEntity.UserInfoVOBean expertInfoEntity = VertifyDataUtil.getInstance((Context)this.mContext).getUserInfo();
                String loginName = null;
                if (expertInfoEntity != null) {
                    loginName = expertInfoEntity.getName();
                }
                new ContractsModel().sendFriendValidate(docId, "3", "3", friendsEntity.getDoctorId() + "", "3", "3", "", loginName, ChangeUtil.changeDetailInfoToJson(this.mContext, friendsEntity)).subscribe((Observer)new RxProgressObserver<ResponseBody>(){

                    public void onReqNext(ResponseBody responseBody) {
                        if (200 == responseBody.getCode()) {
                            ToastUtils.showShort((CharSequence)"\u6210\u529f\u53d1\u9001\u597d\u53cb\u7533\u8bf7");
                        }
                    }
                });
            }
        };
        baseQuickAdapter2.setOnItemClickListener((adapter, view, position) -> {
            FriendsEntity friendsEntity = (FriendsEntity)adapter.getItem(position);
            this.startActivity(new Intent(this.getContext(), FrameContractsActivity.class).putExtra("MSG_JUMP_TYPE", 5394).putExtra("IM_DOCTOR_ID", friendsEntity.getDoctorId()));
        });
        this.mPersonCyclerView.setAdapter((RecyclerView.Adapter)baseQuickAdapter2);
    }
}

