/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.fragment;

import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.StringUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.byh.lib.byhim.R;
import com.byh.lib.byhim.adapter.MsgNoticeListAdapter;
import com.byh.lib.byhim.present.IMsgNoticeListPresenter;
import com.byh.lib.byhim.present.impl.MsgNoticepresenter;
import com.byh.lib.byhim.view.IMsgNoticeView;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.kangxin.common.byh.base.ByBaseStateFlushMoreFragment;
import com.kangxin.common.byh.db.IPushPresenter;
import com.kangxin.common.byh.db.impl.PushPresenter;
import com.kangxin.common.byh.entity.OrderDetailEntity;
import com.kangxin.common.byh.entity.v2.PushNoticeEntity;
import com.kangxin.common.byh.entity.v2.PushOrderEntity;
import com.kangxin.common.byh.service.IConsuNoticeReceiverProvider;
import java.util.ArrayList;
import org.greenrobot.eventbus.Subscribe;
import org.json.JSONException;
import org.json.JSONObject;

@Route(path="/notice/list")
public class MsgNoticeFragment
extends ByBaseStateFlushMoreFragment<PushNoticeEntity>
implements IMsgNoticeView<PushNoticeEntity> {
    private static final String TAG = "MsgNoticeFragment";
    private IMsgNoticeListPresenter mMsgNoticeListPresenter;
    private MsgNoticeListAdapter mAdapter;
    private String serviceType = "ALL_MSG_D";
    private IPushPresenter pushPresenter = new PushPresenter();
    private IConsuNoticeReceiverProvider mConsuNoticeProvider = (IConsuNoticeReceiverProvider)ARouter.getInstance().build("/consu/notice/ConsuNoticeReceiverProvider").navigation();

    public static MsgNoticeFragment getInstance(String serviceType) {
        MsgNoticeFragment msgNoticeFragment = new MsgNoticeFragment();
        Bundle bundle = new Bundle();
        bundle.putString("serviceType", serviceType);
        msgNoticeFragment.setArguments(bundle);
        return msgNoticeFragment;
    }

    public void init() {
        super.init();
        this.mConsuNoticeProvider.registerNoticeReceiver();
        this.serviceType = this.getArguments().getString("serviceType");
        this.mMsgNoticeListPresenter = new MsgNoticepresenter(this);
        this.mAdapter = new MsgNoticeListAdapter(new ArrayList<PushNoticeEntity>());
        this.mAdapter.setListener(item -> {
            String extraJson = item.getExtraStr();
            String orderType = "-1";
            try {
                JSONObject jsonObject = new JSONObject(extraJson);
                Log.i((String)TAG, (String)("init: jsonObject:" + jsonObject));
                if (jsonObject.has("orderType")) {
                    orderType = jsonObject.optString("orderType");
                    Log.i((String)TAG, (String)("init: orderType:" + orderType));
                }
            }
            catch (JSONException e) {
                Log.i((String)TAG, (String)("init: JSONException:" + (Object)((Object)e)));
                e.printStackTrace();
            }
            PushOrderEntity pushOrderEntity = item.getPushOrderEntity();
            if (pushOrderEntity == null) {
                return;
            }
            String code = pushOrderEntity.getPushCode();
            if (StringUtils.isEmpty((CharSequence)code)) {
                return;
            }
            switch (code) {
                case "310": {
                    ARouter.getInstance().build("/framecontry/FrameContrActivity").withInt("MSG_JUMP_TYPE", 5395).navigation();
                    break;
                }
                case "309": {
                    ARouter.getInstance().build("/acount/SchedulingManagerCountryActivity").navigation();
                    break;
                }
                case "100": 
                case "104": 
                case "105": 
                case "101": 
                case "100100": 
                case "100101": 
                case "100111": 
                case "100104": 
                case "100105": 
                case "100110": {
                    if (orderType.equals("6")) {
                        this.mMsgNoticeListPresenter.reqClcConsuInfo(4, pushOrderEntity.getOrderViewId());
                        break;
                    }
                    this.mMsgNoticeListPresenter.reqConsuInfo(4, pushOrderEntity.getOrderViewId());
                    break;
                }
                case "110": {
                    if (orderType.equals("6")) {
                        this.mMsgNoticeListPresenter.reqClcConsuInfo(5, pushOrderEntity.getOrderViewId());
                        break;
                    }
                    this.mMsgNoticeListPresenter.reqConsuInfo(5, pushOrderEntity.getOrderViewId());
                    break;
                }
                case "202": 
                case "2": 
                case "3": {
                    return;
                }
                case "311": {
                    ARouter.getInstance().build("/framecontry/FrameContrActivity").withInt("MSG_JUMP_TYPE", 5395).navigation();
                    break;
                }
                case "1000": 
                case "305": 
                case "200": 
                case "210": 
                case "111": 
                case "201": 
                case "211": 
                case "301": 
                case "103": 
                case "115": 
                case "302": 
                case "303": 
                case "304": 
                case "306": 
                case "307": 
                case "308": 
                case "312": 
                case "1001": {
                    break;
                }
                default: {
                    String orderId = pushOrderEntity.getOrderViewId();
                    if (Build.VERSION.SDK_INT >= 26) {
                        this.mConsuNoticeProvider.sendNoticeReceiver(orderType, orderId);
                    } else {
                        Intent noticeIntent = new Intent("com.kangxin.doctor.worktable.action.notice");
                        noticeIntent.putExtra("ORDERID_KEY", orderId);
                        noticeIntent.putExtra("ORDER_TYPE_KEY", orderType);
                        this.getContext().sendBroadcast(noticeIntent);
                    }
                    Log.i((String)TAG, (String)("init: sendbroadcast--orderType:" + orderType));
                }
            }
        });
        if (this.serviceType.equals("servicePkg")) {
            this.pushPresenter.readPushByBusType(new String[]{"servicePkg"});
        } else {
            this.pushPresenter.readPushUnbussType(new String[]{"300", "servicePkg"});
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mConsuNoticeProvider.unRegisterNoticeReceiver();
    }

    @Subscribe
    public void subscribeOrderDetail(OrderDetailEntity orderDetailEntity) {
        ToastUtils.showShort((CharSequence)"\u6536\u5230\u6d88\u606f\u4e86");
    }

    protected void flushOrLoad(boolean isGetMore) {
        this.mMsgNoticeListPresenter.getMsgNoticeList(isGetMore, false, this.serviceType);
    }

    protected BaseQuickAdapter<PushNoticeEntity, ? extends BaseViewHolder> getBaseQuickAdapter() {
        return this.mAdapter;
    }

    protected int getLayoutId() {
        return R.layout.im_msg_list_fragment;
    }
}

