/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.fragment;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.alibaba.android.arouter.launcher.ARouter;
import com.byh.lib.byhim.FrameNotitleActivity;
import com.byh.lib.byhim.R;
import com.byh.lib.byhim.bean.RongChatExtraBean;
import com.byh.lib.byhim.help.ChangeEntityHelper;
import com.byh.lib.byhim.help.ConsPresBtnHelper;
import com.byh.lib.byhim.holder.FriendsApplyHolder;
import com.byh.lib.byhim.present.IiConsuLationPresent;
import com.byh.lib.byhim.present.clc.ClcConsuLationPresent;
import com.byh.lib.byhim.present.impl.AgreenReceiPatiPresent;
import com.byh.lib.byhim.present.impl.FinishConsuPresent;
import com.byh.lib.byhim.present.impl.ImConsuLationPresent;
import com.byh.lib.byhim.utils.RongUtil;
import com.byh.lib.byhim.view.BindReceiPatientOk;
import com.byh.lib.byhim.view.FinishConsuView;
import com.byh.lib.byhim.view.ImConsulationView;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.byh.entity.ConsulationReportItemEntity;
import com.kangxin.common.byh.entity.OrderDetailEntity;
import com.kangxin.common.byh.entity.response.ImConsulationEntity;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.help.ConsuCountTimeHelper;
import com.kangxin.common.byh.inter.IConverExFragment;
import com.kangxin.common.byh.util.VertifyDataUtil;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class TeleConsultFragment
extends BaseFragment
implements FinishConsuView,
BindReceiPatientOk,
ImConsulationView {
    private static final String TAG = "TeleConsultFragment";
    private RecyclerView mDocHeadersCyclerView;
    private TextView mConsTimeDesc;
    private ImConsulationEntity mConsulationInfoEntity;
    private FinishConsuPresent mFinishConsuPresent;
    private IConverExFragment mConversationExFragment;
    private AgreenReceiPatiPresent mReceivePatientPresent;
    private View mPrediaNoticeLabelView;
    private TextView mPrediaNoticeNameView;
    private ImageView mPrediaNoticeCloseView;
    private long mOrderId;
    private IiConsuLationPresent mConsulationPresent;
    private ConsuCountTimeHelper mConsuCountTimeHelper;
    private ConsPresBtnHelper mConsPreBtnHelp;

    public static TeleConsultFragment getInstance() {
        return new TeleConsultFragment();
    }

    private void initConsuPresent() {
        RongChatExtraBean rongChatExtraBean = RongUtil.getInstance().getChatExtraBean();
        if (rongChatExtraBean != null) {
            int orderType = rongChatExtraBean.getOrderType();
            Log.i((String)TAG, (String)("initConsuPresent: chatType:" + orderType));
            switch (orderType) {
                case 4: {
                    this.mConsulationPresent = new ClcConsuLationPresent(this);
                    break;
                }
                case 3: {
                    this.mConsulationPresent = new ImConsuLationPresent(this);
                    break;
                }
                default: {
                    Log.i((String)TAG, (String)("initConsuPresent: no match ordertype:" + orderType));
                }
            }
        }
    }

    public void init() {
        this.initConsuPresent();
        this.mPrediaNoticeLabelView = this.findViewById(this.rootView, R.id.predia_notice_label);
        this.mPrediaNoticeNameView = (TextView)this.findViewById(this.rootView, R.id.predia_notice_name);
        this.mPrediaNoticeCloseView = (ImageView)this.findViewById(this.rootView, R.id.close_predianotice_label);
        this.mReceivePatientPresent = new AgreenReceiPatiPresent(this);
        this.mConversationExFragment = (IConverExFragment)this.getChildFragmentManager().findFragmentById(R.id.conversation);
        this.mFinishConsuPresent = new FinishConsuPresent(this);
        this.mConsulationInfoEntity = (ImConsulationEntity)this.getArguments().getSerializable("CONSUINFO_KEY");
        this.findViewById(this.rootView, R.id.rela_video).setVisibility(8);
        this.mConsTimeDesc = (TextView)this.findViewById(this.rootView, R.id.cons_time_desc);
        this.mDocHeadersCyclerView = (RecyclerView)this.findViewById(this.rootView, R.id.doc_headers);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(this.getContext());
        linearLayoutManager.setOrientation(0);
        this.mDocHeadersCyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.mDocHeadersCyclerView.setAdapter((RecyclerView.Adapter)new BaseQuickAdapter<String, FriendsApplyHolder>(R.layout.byhim_im_consheaders_top_item, this.getDocHeaders()){

            protected void convert(FriendsApplyHolder helper, String item) {
                helper.setImageView(R.id.doc_header, item);
            }
        });
        this.mConsTimeDesc.setText((CharSequence)this.getString(R.string.byhim_cons_wait_profess));
        this.findViewById(this.rootView, R.id.check_casebook).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TeleConsultFragment.this.checkCaseBook(new ByhCommEvent.PatientDetailEvent());
            }
        });
        this.findViewById(this.rootView, R.id.vLookOrderDetail).setOnClickListener(v -> {
            OrderDetailEntity orderDetailEntity = this.getOrderDetailEntity();
            if (orderDetailEntity != null) {
                String orderViewId = orderDetailEntity.getOrderViewId();
                ARouter.getInstance().build("/activity_empty/parent_empty").withString("orderViewId", orderViewId).withString("routerPath", "/orders/detail/OrderDetailFragmentV2").navigation();
            }
        });
        this.initPresentation();
        this.showChatMainBar(this.mConsulationInfoEntity);
        this.startConsuCountTime();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receiveNoDealWithTempEvent(ByhCommEvent.NoDealWithTempEvent noDealWithTempEvent) {
        this.getActivity().finish();
    }

    @Nullable
    private OrderDetailEntity getOrderDetailEntity() {
        if (this.mConsulationInfoEntity == null) {
            return null;
        }
        ImConsulationEntity.PatientInfoDTOBean patientInfoDTOBean = this.mConsulationInfoEntity.getPatientInfoDTO();
        ImConsulationEntity.PatientCaseInfoDTOBean patientCaseInfoDTOBean = this.mConsulationInfoEntity.getPatientCaseInfoDTO();
        ImConsulationEntity.ConsultationEntityBean consultationEntityBean = this.mConsulationInfoEntity.getConsultationEntity();
        if (patientCaseInfoDTOBean == null) {
            return null;
        }
        if (patientInfoDTOBean == null) {
            return null;
        }
        OrderDetailEntity orderDetailEntity = new OrderDetailEntity();
        orderDetailEntity.setPatientName(patientInfoDTOBean.getName());
        orderDetailEntity.setPatientAge(patientInfoDTOBean.getAge());
        orderDetailEntity.setPatIdCard(patientInfoDTOBean.getIdCard());
        orderDetailEntity.setPatientSex(patientInfoDTOBean.getGender());
        orderDetailEntity.setPatientTel(patientInfoDTOBean.getMobileNumber());
        orderDetailEntity.setPastHistory(patientCaseInfoDTOBean.getPastHistory());
        orderDetailEntity.setPresentHistory(patientCaseInfoDTOBean.getPresentHistory());
        orderDetailEntity.setPatCaseConsultAim(patientCaseInfoDTOBean.getConsultAim());
        orderDetailEntity.setPatPrimaryDiagno(patientCaseInfoDTOBean.getPrimaryDiagno());
        orderDetailEntity.setPatCaseFamilyHistory(patientCaseInfoDTOBean.getFamilyHistory());
        orderDetailEntity.setPatCaseMedicationHistory(patientCaseInfoDTOBean.getMedicationHistory());
        orderDetailEntity.setCaseAttachmentList(this.mConsulationInfoEntity.getCaseAttachmentList());
        orderDetailEntity.setConsulation(true);
        ImConsulationEntity.ExpertDetailInfoEntityBean expert = this.mConsulationInfoEntity.getExpertDetailInfoEntity();
        orderDetailEntity.setExpertId(expert.getId());
        orderDetailEntity.setExpertDepId(expert.getHospitalDeptId());
        orderDetailEntity.setExpertDepName(expert.getHospitalDeptName());
        orderDetailEntity.setExpertHosName(this.mConsulationInfoEntity.getExpertHosName());
        orderDetailEntity.setExpertHospId(expert.getHospitalId());
        orderDetailEntity.setExpertProfession(expert.getProfession());
        orderDetailEntity.setExpertProfessionCode(expert.getProfessionCode());
        orderDetailEntity.setExpertName(expert.getName());
        orderDetailEntity.setExpertTel(expert.getContactMobile());
        orderDetailEntity.setOrderId((long)consultationEntityBean.getId());
        orderDetailEntity.setOrderViewId(consultationEntityBean.getViewId());
        ImConsulationEntity.PatientCaseInfoDTOBean patientCaseInfo = this.mConsulationInfoEntity.getPatientCaseInfoDTO();
        if (patientCaseInfo != null) {
            orderDetailEntity.setPatCaseMainSuit(patientCaseInfo.getMainSuit());
        }
        return orderDetailEntity;
    }

    private void startConsuCountTime() {
        if (this.mConsulationInfoEntity == null) {
            this.mConsTimeDesc.setVisibility(8);
            return;
        }
        final ImConsulationEntity.ConsultationEntityBean consultationEntityBean = this.mConsulationInfoEntity.getConsultationEntity();
        if (consultationEntityBean == null) {
            this.mConsTimeDesc.setVisibility(8);
            return;
        }
        if (20 == consultationEntityBean.getStatus()) {
            this.mPrediaNoticeLabelView.setVisibility(8);
            return;
        }
        if (30 == consultationEntityBean.getStatus()) {
            this.mPrediaNoticeCloseView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    TeleConsultFragment.this.mPrediaNoticeLabelView.setVisibility(8);
                }
            });
        }
        if (40 == consultationEntityBean.getStatus()) {
            this.showShortToast("\u4f1a\u8bca\u5df2\u7ed3\u675f");
            this.mPrediaNoticeLabelView.setVisibility(8);
            this.mConsTimeDesc.setText((CharSequence)"\u5df2\u5b8c\u6210");
            return;
        }
        this.mConsuCountTimeHelper = new ConsuCountTimeHelper();
        String acceptTime = consultationEntityBean.getAcceptTime();
        if (TextUtils.isEmpty((CharSequence)(acceptTime = this.conputerEndTime(acceptTime)))) {
            this.mConsTimeDesc.setVisibility(8);
            return;
        }
        this.mConsuCountTimeHelper.init(this.mConsTimeDesc, acceptTime);
        this.mConsuCountTimeHelper.start(new ConsuCountTimeHelper.OnEndConsuTimeCallback(){

            public void onEndConsuTime() {
                TeleConsultFragment.this.showShortToast("\u4f1a\u8bca\u5df2\u7ed3\u675f");
                int userId = VertifyDataUtil.getInstance((Context)TeleConsultFragment.this.getContext()).getLoginUserId();
                TeleConsultFragment.this.mFinishConsuPresent.finishConsulation(consultationEntityBean.getId() + "", userId + "");
            }
        });
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.mConsuCountTimeHelper != null) {
            this.mConsuCountTimeHelper.finishCountTime();
        }
    }

    private String conputerEndTime(String time) {
        if (TextUtils.isEmpty((CharSequence)time)) {
            return null;
        }
        try {
            Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH).parse(time);
            long startTime = date.getTime();
            long endTime = startTime + 86400000L;
            Date endDate = new Date();
            endDate.setTime(endTime);
            String endtime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(endDate);
            return endtime;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void finishConsuEvent(ByhCommEvent.FinishConsuEvent finishConsuEvent) {
        new AlertDialog.Builder((Context)this.getActivity()).setTitle((CharSequence)"\u7ed3\u675f\u4f1a\u8bca").setMessage((CharSequence)"\u7ed3\u675f\u4f1a\u8bca\u4e4b\u540e\u5c06\u4e0d\u80fd\u804a\u5929\uff0c\u662f\u5426\u7ed3\u675f").setNegativeButton(R.string.byhim_dialog_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).setPositiveButton((CharSequence)"\u7ed3\u675f", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ImConsulationEntity.ConsultationEntityBean consultationEntityBean;
                if (TeleConsultFragment.this.mConsulationInfoEntity != null && (consultationEntityBean = TeleConsultFragment.this.mConsulationInfoEntity.getConsultationEntity()) != null) {
                    String userId = VertifyDataUtil.getInstance((Context)TeleConsultFragment.this.getContext()).getLoginUserId() + "";
                    TeleConsultFragment.this.mFinishConsuPresent.finishConsulation(consultationEntityBean.getId() + "", userId);
                }
            }
        }).show();
    }

    private void initPresentation() {
        ImageView presentImgView = (ImageView)this.findViewById(this.rootView, R.id.check_presentasion);
        TextView presentTxtView = (TextView)this.findViewById(this.rootView, R.id.txt_check_presentasion);
        this.mConsPreBtnHelp = new ConsPresBtnHelper(this.getContext(), presentImgView, presentTxtView);
        this.mConsPreBtnHelp.showPresenTationBtn(this.mConsulationInfoEntity);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receivePresentationEvent(ByhCommEvent.ClickPreEvent clickPreEvent) {
        ChangeEntityHelper changeEntityHelper = new ChangeEntityHelper();
        ConsulationReportItemEntity consulationReportItemEntity = null;
        boolean isPross = clickPreEvent.hasPresentation();
        consulationReportItemEntity = isPross ? changeEntityHelper.changeToReportItemEntity(this.mConsulationInfoEntity, isPross) : changeEntityHelper.changeToReportItemEntity(this.mConsulationInfoEntity, isPross);
        if (consulationReportItemEntity == null) {
            return;
        }
        ARouter.getInstance().build("/consulation/reportactivity").withString("orderViewId", consulationReportItemEntity.getOrderViewId()).navigation();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void finishConsReport(ByhCommEvent.FinishPageEvent finishPageEvent) {
        this.reqUpdateStatus();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void checkCaseBook(ByhCommEvent.PatientDetailEvent patientDetailEvent) {
        Intent intent = new Intent(this.getContext(), FrameNotitleActivity.class);
        intent.putExtra("MSG_JUMP_TYPE", 5399);
        ImConsulationEntity.ConsultationEntityBean consultationEntityBean = this.mConsulationInfoEntity.getConsultationEntity();
        if (consultationEntityBean == null) {
            return;
        }
        ImConsulationEntity.PatientInfoDTOBean patientInfoDTOBean = this.mConsulationInfoEntity.getPatientInfoDTO();
        ImConsulationEntity.PatientCaseInfoDTOBean patientCaseInfoDTOBean = this.mConsulationInfoEntity.getPatientCaseInfoDTO();
        if (patientInfoDTOBean == null) {
            return;
        }
        if (patientCaseInfoDTOBean == null) {
            return;
        }
        ImConsulationEntity.DoctorDetailInfoEntityBean doctorDetailInfoEntityBean = this.mConsulationInfoEntity.getDoctorDetailInfoEntity();
        if (doctorDetailInfoEntityBean == null) {
            return;
        }
        ImConsulationEntity.ExpertDetailInfoEntityBean expertDetailInfoEntityBean = this.mConsulationInfoEntity.getExpertDetailInfoEntity();
        if (expertDetailInfoEntityBean == null) {
            return;
        }
        OrderDetailEntity orderDetailEntity = new OrderDetailEntity();
        orderDetailEntity.setPatientName(patientInfoDTOBean.getName());
        orderDetailEntity.setPatientAge(patientInfoDTOBean.getAge());
        orderDetailEntity.setPatIdCard(patientInfoDTOBean.getIdCard());
        orderDetailEntity.setPatientSex(patientInfoDTOBean.getGender());
        orderDetailEntity.setPatientTel(patientInfoDTOBean.getMobileNumber());
        orderDetailEntity.setPastHistory(patientCaseInfoDTOBean.getPastHistory());
        orderDetailEntity.setPresentHistory(patientCaseInfoDTOBean.getPresentHistory());
        orderDetailEntity.setPatCaseConsultAim(patientCaseInfoDTOBean.getConsultAim());
        orderDetailEntity.setPatPrimaryDiagno(patientCaseInfoDTOBean.getPrimaryDiagno());
        orderDetailEntity.setPatCaseFamilyHistory(patientCaseInfoDTOBean.getFamilyHistory());
        orderDetailEntity.setPatCaseMedicationHistory(patientCaseInfoDTOBean.getMedicationHistory());
        orderDetailEntity.setCaseAttachmentList(this.mConsulationInfoEntity.getCaseAttachmentList());
        orderDetailEntity.setConsulation(true);
        orderDetailEntity.setPatientId((long)patientInfoDTOBean.getId());
        orderDetailEntity.setPatientTel(patientInfoDTOBean.getMobileNumber());
        orderDetailEntity.setDocId(doctorDetailInfoEntityBean.getId());
        orderDetailEntity.setDocTel(doctorDetailInfoEntityBean.getContactMobile());
        orderDetailEntity.setExpertId(expertDetailInfoEntityBean.getId());
        orderDetailEntity.setExpertTel(expertDetailInfoEntityBean.getContactMobile());
        orderDetailEntity.setPatientName(patientInfoDTOBean.getName());
        orderDetailEntity.setPatientSex(patientInfoDTOBean.getGender());
        orderDetailEntity.setPatIdCard(patientInfoDTOBean.getIdCard());
        orderDetailEntity.setPatientAge(patientInfoDTOBean.getAge());
        orderDetailEntity.setDocName(doctorDetailInfoEntityBean.getName());
        orderDetailEntity.setExpertName(expertDetailInfoEntityBean.getName());
        orderDetailEntity.setOrderId((long)consultationEntityBean.getId());
        orderDetailEntity.setPatCaseMainSuit(patientCaseInfoDTOBean.getMainSuit());
        orderDetailEntity.setPresentHistory(patientCaseInfoDTOBean.getPresentHistory());
        orderDetailEntity.setPastHistory(patientCaseInfoDTOBean.getPastHistory());
        orderDetailEntity.setPatPrimaryDiagno(patientCaseInfoDTOBean.getPrimaryDiagno());
        orderDetailEntity.setPatCaseFamilyHistory(patientCaseInfoDTOBean.getFamilyHistory());
        orderDetailEntity.setPatCaseMedicationHistory(patientCaseInfoDTOBean.getMedicationHistory());
        orderDetailEntity.setConsultAim(patientCaseInfoDTOBean.getConsultAim());
        orderDetailEntity.setCaseAttachmentList(this.mConsulationInfoEntity.getCaseAttachmentList());
        orderDetailEntity.setOrderId((long)consultationEntityBean.getId());
        orderDetailEntity.setOrderViewId(consultationEntityBean.getViewId());
        ImConsulationEntity.PatientCaseInfoDTOBean patientCaseInfo = this.mConsulationInfoEntity.getPatientCaseInfoDTO();
        if (patientCaseInfo != null) {
            orderDetailEntity.setPatCaseMainSuit(patientCaseInfo.getMainSuit());
        }
        intent.putExtra("orderDetailEntity", (Serializable)orderDetailEntity);
        this.startActivity(intent);
    }

    private List<String> getDocHeaders() {
        if (this.mConsulationInfoEntity == null) {
            return null;
        }
        ImConsulationEntity.ExpertDetailInfoEntityBean expertDetailInfoEntityBean = this.mConsulationInfoEntity.getExpertDetailInfoEntity();
        if (expertDetailInfoEntityBean == null) {
            return null;
        }
        ImConsulationEntity.DoctorDetailInfoEntityBean doctorDetailInfoEntityBean = this.mConsulationInfoEntity.getDoctorDetailInfoEntity();
        if (doctorDetailInfoEntityBean == null) {
            return null;
        }
        String headerUrl1 = expertDetailInfoEntityBean.getHeadPortrait();
        String headerUrl2 = doctorDetailInfoEntityBean.getHeadPortrait();
        ArrayList<String> headerList = new ArrayList<String>();
        headerList.add(headerUrl1);
        headerList.add(headerUrl2);
        return headerList;
    }

    protected int getLayoutId() {
        return R.layout.im_teleconsult_fragment;
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void agreeInviteExpEvent(ByhCommEvent.InviteExpOkEvent inviteExpOkEvent) {
        if (this.mConsulationInfoEntity == null) {
            return;
        }
        ImConsulationEntity.ConsultationEntityBean consultationEntityBean = this.mConsulationInfoEntity.getConsultationEntity();
        if (consultationEntityBean == null) {
            return;
        }
        if (consultationEntityBean.getStatus() == 30) {
            this.showShortToast(this.getString(R.string.byhim_ready_ordered_time));
            return;
        }
        if (consultationEntityBean.getStatus() == 40) {
            this.showShortToast("\u4f1a\u8bca\u5df2\u5b8c\u6210");
            return;
        }
        if (consultationEntityBean.getStatus() == 50) {
            this.showShortToast("\u4f1a\u8bca\u5df2\u53d6\u6d88");
            return;
        }
        this.mReceivePatientPresent.reqTuwenExpertAccept(consultationEntityBean.getId() + "");
    }

    @Override
    public void bindFinishConsuView(ResponseBody responseBody) {
        this.showIsFillinPreseDialog();
    }

    @Override
    public void bindOrderDetail(OrderDetailEntity result) {
    }

    private void showChatMainBar(ImConsulationEntity consulationEntity) {
        if (consulationEntity == null) {
            return;
        }
        ImConsulationEntity.ConsultationEntityBean consultationEntityBean = consulationEntity.getConsultationEntity();
        if (consultationEntityBean == null) {
            return;
        }
        if (this.mConversationExFragment == null) {
            return;
        }
        if (consultationEntityBean.getStatus() == 30) {
            this.mConversationExFragment.showChatMainBar();
        } else {
            this.mConversationExFragment.hideChatMainBar();
        }
    }

    private void showCountDownTime() {
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void updateConsuStatusEvent(ByhCommEvent.ShowMainBarEvent showMainBarEvent) {
        this.reqUpdateStatus();
    }

    public void reqUpdateStatus() {
        if (this.mConsulationInfoEntity == null) {
            return;
        }
        ImConsulationEntity.ConsultationEntityBean consultationEntityBean = this.mConsulationInfoEntity.getConsultationEntity();
        if (this.mConsulationPresent != null) {
            this.mConsulationPresent.reqConsulationInfoByOrderId(consultationEntityBean.getViewId());
        }
    }

    private void showIsFillinPreseDialog() {
        new AlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.byhim_consend).setMessage(R.string.byhim_fillin_pres).setNegativeButton(R.string.byhim_dialog_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).setPositiveButton(R.string.byhim_fillin_press, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (TeleConsultFragment.this.mConsPreBtnHelp != null) {
                    if (TeleConsultFragment.this.mConsulationInfoEntity == null) {
                        return;
                    }
                    ImConsulationEntity.ConsultationReportEntityBean consultationReportEntityBean = TeleConsultFragment.this.mConsulationInfoEntity.getConsultationReportEntity();
                    if (consultationReportEntityBean == null) {
                        TeleConsultFragment.this.receivePresentationEvent(new ByhCommEvent.ClickPreEvent(false));
                    } else if (!TextUtils.isEmpty((CharSequence)consultationReportEntityBean.getSignature()) || !TextUtils.isEmpty((CharSequence)consultationReportEntityBean.getPhotoReport())) {
                        TeleConsultFragment.this.receivePresentationEvent(new ByhCommEvent.ClickPreEvent(true));
                    } else {
                        TeleConsultFragment.this.receivePresentationEvent(new ByhCommEvent.ClickPreEvent(false));
                    }
                    dialog.dismiss();
                    TeleConsultFragment.this.getActivity().finish();
                }
            }
        }).show();
    }

    public void onError(String msg) {
        this.showShortToast(msg);
    }

    @Override
    public void bindRevivePtientOk(ResponseBody responseBody) {
        this.showShortToast(responseBody.getMsg());
        this.reqUpdateStatus();
    }

    @Override
    public void bindConsulationInfo(ImConsulationEntity consulationEntity, long orderId) {
        this.mConsulationInfoEntity = consulationEntity;
        this.mOrderId = orderId;
        this.showChatMainBar(this.mConsulationInfoEntity);
        this.initPresentation();
        this.startConsuCountTime();
    }
}

