/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.provider;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.ToastUtils;
import com.byh.lib.byhim.bean.RongChatExtraBean;
import com.byh.lib.byhim.present.IFinishConsuPresent;
import com.byh.lib.byhim.present.IiConsuLationPresent;
import com.byh.lib.byhim.present.clc.ClcConsuLationPresent;
import com.byh.lib.byhim.present.clc.ClcFinishConsuPresent;
import com.byh.lib.byhim.present.impl.FinishConsuPresent;
import com.byh.lib.byhim.present.impl.ImConsuLationPresent;
import com.byh.lib.byhim.utils.RongUtil;
import com.byh.lib.byhim.view.FinishConsuView;
import com.byh.lib.byhim.view.ImConsulationView;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.OrderDetailEntity;
import com.kangxin.common.byh.entity.response.ImConsulationEntity;
import com.kangxin.common.byh.inter.ILive;
import com.kangxin.common.byh.service.ConsVideoService;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.view.ILiveView;
import com.kangxin.common.past.AppManager;
import com.kangxin.doctor.libdata.http.callback.DownloadCallback;
import com.kangxin.doctor.live.presenter.impl.LivePresenter;
import com.tbruyelle.rxpermissions.RxPermissions;
import java.io.IOException;

@Route(path="/cons/video/ConsVideoProvider")
public class ConsVideoProvider
implements ConsVideoService,
ImConsulationView,
FinishConsuView {
    private IFinishConsuPresent mFinishConsuPresent;
    private static final String TAG = "ConsVideoProvider";
    private IiConsuLationPresent mConsulationPresent;
    private ImConsulationEntity mConsulationEntity;

    public void initConsuPresent() {
        RongChatExtraBean rongChatExtraBean = RongUtil.getInstance().getChatExtraBean();
        if (rongChatExtraBean != null) {
            int orderType = rongChatExtraBean.getOrderType();
            Log.i((String)TAG, (String)("initConsuPresent: chatType:" + orderType));
            switch (orderType) {
                case 4: {
                    this.mFinishConsuPresent = new ClcFinishConsuPresent(this);
                    this.mConsulationPresent = new ClcConsuLationPresent(this);
                    break;
                }
                case 3: {
                    this.mFinishConsuPresent = new FinishConsuPresent(this);
                    this.mConsulationPresent = new ImConsuLationPresent(this);
                    break;
                }
                default: {
                    Log.i((String)TAG, (String)("initConsuPresent: no match ordertype:" + orderType));
                }
            }
        }
    }

    public void startConsVideo(String orderId) {
        Activity context = AppManager.getAppManager().currentActivity();
        if (context == null) {
            return;
        }
        RxPermissions.getInstance((Context)context).request(new String[]{"android.permission.CAMERA"}).subscribe(arg_0 -> this.lambda$startConsVideo$0((Context)context, orderId, arg_0));
    }

    public void init(Context context) {
    }

    @Override
    public void bindConsulationInfo(ImConsulationEntity consulationEntity, long orderId) {
        if (consulationEntity == null) {
            return;
        }
        this.mConsulationEntity = consulationEntity;
        ImConsulationEntity.ConsultationEntityBean consultationEntityBean = consulationEntity.getConsultationEntity();
        this.mFinishConsuPresent.getOrderDetail(consultationEntityBean.getViewId());
        this.mFinishConsuPresent.startConsulation(consultationEntityBean.getId());
    }

    public void onError(String msg) {
    }

    @Override
    public void bindFinishConsuView(ResponseBody responseBody) {
    }

    @Override
    public void bindOrderDetail(OrderDetailEntity orderDetailEntity) {
        String localDocId;
        Activity context = AppManager.getAppManager().currentActivity();
        LivePresenter livePresenter = new LivePresenter(new ILiveView((Context)context){
            final /* synthetic */ Context val$context;
            {
                this.val$context = context;
            }

            public void error(String msg) {
                ToastUtils.showLong((CharSequence)msg);
            }

            public Context injectContext() {
                return this.val$context;
            }

            public void error() {
            }
        });
        if (this.mConsulationEntity == null) {
            return;
        }
        ImConsulationEntity.DoctorDetailInfoEntityBean doctorDetailInfoEntityBean = this.mConsulationEntity.getDoctorDetailInfoEntity();
        String docId = doctorDetailInfoEntityBean.getId() + "";
        boolean isInitiator = docId.equals(localDocId = VertifyDataUtil.getInstance((Context)context).getDoctorId());
        if (isInitiator) {
            livePresenter.loginLiveAndEnterRoom(orderDetailEntity, 3);
        } else {
            livePresenter.loginLiveAndEnterRoom(orderDetailEntity, 2);
        }
    }

    private /* synthetic */ void lambda$startConsVideo$0(Context context, final String orderId, Boolean aBoolean) {
        if (aBoolean.booleanValue()) {
            ILive live = (ILive)ARouter.getInstance().build("/liveservice/lib_init").navigation();
            live.downloadSos(context, new DownloadCallback(){

                public void onSucc(String destFileDir) {
                    if (ConsVideoProvider.this.mConsulationPresent != null) {
                        ConsVideoProvider.this.mConsulationPresent.reqConsulationInfoByOrderId(orderId);
                    }
                }

                public void onFail(IOException e, String destFileDir) {
                }
            });
        }
    }
}

