/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.provider;

import android.content.Context;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.byh.lib.byhim.R;
import com.byh.lib.byhim.bean.PreDiaDescMessage;
import com.byh.lib.byhim.bean.PrediaDescEntity;
import com.google.gson.Gson;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.util.StringUtil;
import com.kangxin.common.util.TimeUtil;
import io.rong.imkit.model.ProviderTag;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import org.greenrobot.eventbus.EventBus;

@ProviderTag(messageContent=PreDiaDescMessage.class)
public class PreDiaDescProvider
extends IContainerItemProvider.MessageProvider<PreDiaDescMessage> {
    private Context mContext;

    public void bindView(View view, int i, PreDiaDescMessage preDiaDescMessage, UIMessage uiMessage) {
        PrediaHolder holder = (PrediaHolder)view.getTag();
        String msgContent = preDiaDescMessage.getContent();
        PrediaDescEntity prediaDescEntity = null;
        if (!TextUtils.isEmpty((CharSequence)msgContent)) {
            prediaDescEntity = (PrediaDescEntity)new Gson().fromJson(msgContent, PrediaDescEntity.class);
        }
        if (prediaDescEntity == null) {
            return;
        }
        String time = prediaDescEntity.getpDiaTime();
        if (!TextUtils.isEmpty((CharSequence)time)) {
            time = TimeUtil.timeFormat((String)time, (String)"yyyy-MM-dd HH:mm");
            String pDiadesc = prediaDescEntity.getpDiaDesc();
            if (!TextUtils.isEmpty((CharSequence)pDiadesc)) {
                String finalDesc = StringUtil.changeSubText((String)pDiadesc, (int)8);
                holder.prediaTitle.setText((CharSequence)("\u521d\u6b65\u8bca\u65ad\uff1a" + finalDesc));
            } else {
                holder.prediaTitle.setText((CharSequence)"\u521d\u6b65\u8bca\u65ad\uff1a\u6682\u65e0\u63cf\u8ff0");
            }
            holder.prediaTime.setText((CharSequence)time);
        }
        String patiSex = "1".equals(prediaDescEntity.getpDiaSex()) ? "\u7537" : "\u5973";
        holder.prediaPerInfo.setText((CharSequence)(prediaDescEntity.getpDiaName() + " " + patiSex + " " + prediaDescEntity.getpDiaAge() + "\u5c81"));
        holder.prediaChiefComint.setText((CharSequence)("\u4e3b\u8bc9\uff1a" + prediaDescEntity.getpDiaTimeChieCom()));
    }

    public Spannable getContentSummary(PreDiaDescMessage preDiaDescMessage) {
        return new SpannableString((CharSequence)"\u8bca\u65ad\u63cf\u8ff0");
    }

    public void onItemClick(View view, int i, PreDiaDescMessage preDiaDescMessage, UIMessage uiMessage) {
        EventBus.getDefault().post((Object)new ByhCommEvent.PatientDetailEvent());
    }

    public void onItemLongClick(View view, int i, PreDiaDescMessage preDiaDescMessage, UIMessage uiMessage) {
    }

    public View newView(Context context, ViewGroup viewGroup) {
        View itemView = LayoutInflater.from((Context)context).inflate(R.layout.byhim_prediadesc_item, viewGroup, false);
        PrediaHolder prediaHolder = new PrediaHolder();
        prediaHolder.prediaTitle = (TextView)itemView.findViewById(R.id.predia_title);
        prediaHolder.prediaTime = (TextView)itemView.findViewById(R.id.predia_time);
        prediaHolder.prediaPerInfo = (TextView)itemView.findViewById(R.id.predia_name_age_sex);
        prediaHolder.prediaChiefComint = (TextView)itemView.findViewById(R.id.predia_zhusu);
        itemView.setTag((Object)prediaHolder);
        this.mContext = context;
        return itemView;
    }

    class PrediaHolder {
        TextView prediaTitle;
        TextView prediaTime;
        TextView prediaPerInfo;
        TextView prediaChiefComint;

        PrediaHolder() {
        }
    }
}

