/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.cbs.service.handler;

import com.alibaba.fastjson.JSON;
import com.doctor.basedata.api.bo.doc_service.HLZDServiceBo;
import com.doctor.basedata.api.utils.ValidPropertyUtil;
import com.doctor.basedata.api.utils.ValidateResult;
import com.ebaiyihui.cbs.model.doctor.DocServiceConfigParam;
import com.ebaiyihui.cbs.service.handler.DocServiceHandler;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.nursingguidance.client.AdvisoryClient;
import com.ebaiyihui.nursingguidance.common.model.ServiceNursingConfigEntity;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="hlzd_handler")
public class HLZDServiceHandler
extends DocServiceHandler {
    private static final Logger log = LoggerFactory.getLogger(HLZDServiceHandler.class);
    @Autowired
    private AdvisoryClient advisoryClient;

    public ValidateResult validateServiceConfig(DocServiceConfigParam docServiceConfigParam) {
        HLZDServiceBo hlzdServiceBo = (HLZDServiceBo)JSON.parseObject((String)docServiceConfigParam.getServiceConfig(), HLZDServiceBo.class);
        if (Objects.isNull(hlzdServiceBo)) {
            return new ValidateResult("\u670d\u52a1\u914d\u7f6e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", false);
        }
        return ValidPropertyUtil.validate((Object)hlzdServiceBo);
    }

    public BaseResponse executeSynchroniseService(DocServiceConfigParam docServiceConfigParam) {
        HLZDServiceBo serviceInfo = (HLZDServiceBo)JSON.parseObject((String)docServiceConfigParam.getServiceConfig(), HLZDServiceBo.class);
        if (Objects.nonNull(serviceInfo)) {
            ServiceNursingConfigEntity serviceNursingConfig = new ServiceNursingConfigEntity();
            serviceNursingConfig.setAmPrice(serviceInfo.getDayServicePrice());
            serviceNursingConfig.setAmTimeEnd(serviceInfo.getMorningEndTime());
            serviceNursingConfig.setAmTimeStart(serviceInfo.getMorningStartTime());
            serviceNursingConfig.setPmPrice(serviceInfo.getNightServicePrice());
            serviceNursingConfig.setNightTimeEnd(serviceInfo.getNightEndTime());
            serviceNursingConfig.setNightTimeStart(serviceInfo.getNightStartTime());
            serviceNursingConfig.setPmTimeEnd(serviceInfo.getNoonEndTime());
            serviceNursingConfig.setPmTimeStart(serviceInfo.getNoonStartTime());
            serviceNursingConfig.setServTime(serviceInfo.getEffectiveTime());
            serviceNursingConfig.setNumLimit(serviceInfo.getReplyLimit());
            serviceNursingConfig.setDailyLimit(serviceInfo.getNumLimit());
            serviceNursingConfig.setAppCode(docServiceConfigParam.getAppCode());
            serviceNursingConfig.setCreateTime(new Date());
            serviceNursingConfig.setOrganId(String.valueOf(docServiceConfigParam.getOrganId()));
            serviceNursingConfig.setWeekendPrice(serviceInfo.getWeekendServicePrice());
            serviceNursingConfig.setDoctorId(String.valueOf(docServiceConfigParam.getDoctorId()));
            for (Long deptId : docServiceConfigParam.getDeptId()) {
                serviceNursingConfig.setDeptId(String.valueOf(deptId));
                log.info("\u8c03\u7528\u62a4\u7406\u6307\u5bfc\u670d\u52a1\u8bbe\u7f6e\u670d\u52a1\u5165\u53c2:{}", (Object)serviceNursingConfig.toString());
                BaseResponse response = this.advisoryClient.saveServiceInfo(serviceNursingConfig);
                log.info("\u8c03\u7528\u62a4\u7406\u6307\u5bfc\u670d\u52a1\u8bbe\u7f6e\u670d\u52a1\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)response));
                if (response != null && response.getCode().equals("1")) continue;
                log.error("\u8c03\u7528\u62a4\u7406\u6307\u5bfc\u670d\u52a1\u8bbe\u7f6e\u670d\u52a1\u8be6\u60c5\u5931\u8d25,\u9519\u8bef\u4fe1\u606f:{}", (Object)response);
                throw new RuntimeException("\u8c03\u7528\u62a4\u7406\u6307\u5bfc\u670d\u52a1\u8bbe\u7f6e\u670d\u52a1\u8be6\u60c5\u5931\u8d25");
            }
        } else {
            log.info("\u670d\u52a1\u914d\u7f6e\u4e3a\u7a7a:{}", (Object)JSON.toJSONString((Object)docServiceConfigParam));
            throw new RuntimeException("\u670d\u52a1\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return BaseResponse.success();
    }
}

