/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.cbs.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.card.client.PatientServiceClient;
import com.ebaiyihui.card.common.vo.GetPatientInfoByCrednoAndTypeReqVO;
import com.ebaiyihui.card.common.vo.PatientInfoRespVO;
import com.ebaiyihui.cbs.model.DoctorPatientRelationReqVo;
import com.ebaiyihui.cbs.model.doctor.DoctorPatientRelationVo;
import com.ebaiyihui.cbs.service.DoctorPatientRelationService;
import com.ebaiyihui.cbs.util.HxHttpClient;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DoctorPatientRelationServiceImpl
implements DoctorPatientRelationService {
    private static final Logger log = LoggerFactory.getLogger(DoctorPatientRelationServiceImpl.class);
    @Value(value="${cloud.domain}")
    private String domain;
    @Autowired
    private PatientServiceClient patientServiceClient;

    public BaseResponse saveDoctorPatientRelation(DoctorPatientRelationReqVo doctorPatientRelationReqVo) {
        GetPatientInfoByCrednoAndTypeReqVO reqVO = new GetPatientInfoByCrednoAndTypeReqVO();
        reqVO.setCredNo(doctorPatientRelationReqVo.getCardNum());
        reqVO.setCredTypeCode(doctorPatientRelationReqVo.getCardType());
        log.info("\u8c03\u7528\u60a3\u8005\u670d\u52a1\u67e5\u8be2\u60a3\u8005\u5165\u53c2[{}]", (Object)JSON.toJSONString((Object)reqVO));
        BaseResponse patientResponse = this.patientServiceClient.getpatientinfobycrednoAndType(reqVO);
        log.info("\u8c03\u7528\u60a3\u8005\u670d\u52a1\u67e5\u8be2\u60a3\u8005\u4fe1\u606f\u8fd4\u56de[{}]", (Object)JSON.toJSONString((Object)patientResponse));
        if (Objects.nonNull(patientResponse)) {
            PatientInfoRespVO patientInfo = (PatientInfoRespVO)patientResponse.getData();
            if (Objects.isNull(patientInfo)) {
                return BaseResponse.error((String)"\u5f53\u524d\u60a3\u8005\u4e0d\u5b58\u5728,\u8bf7\u6838\u5bf9\u540e\u6dfb\u52a0");
            }
            if (!patientInfo.getName().equals(doctorPatientRelationReqVo.getPatientName())) {
                return BaseResponse.error((String)"\u7528\u6237\u59d3\u540d\u4e0e\u8eab\u4efd\u4fe1\u606f\u4e0d\u4e00\u81f4,\u8bf7\u6838\u5bf9\u540e\u91cd\u8bd5");
            }
            DoctorPatientRelationVo doctorPatientRelationReq = new DoctorPatientRelationVo();
            doctorPatientRelationReq.setAppCode(doctorPatientRelationReqVo.getAppCode());
            doctorPatientRelationReq.setDoctorId(doctorPatientRelationReqVo.getDoctorId());
            doctorPatientRelationReq.setGroupId(doctorPatientRelationReqVo.getGroupId());
            doctorPatientRelationReq.setPatientId(Long.valueOf(patientInfo.getPatientId()));
            doctorPatientRelationReq.setPatientName(patientInfo.getName());
            doctorPatientRelationReq.setStatus(Byte.valueOf((byte)1));
            doctorPatientRelationReq.setUserId(String.valueOf(0));
            try {
                log.info("\u8c03\u7528\u4e91\u4e0a\u6dfb\u52a0\u5173\u6ce8\u60a3\u8005\u5165\u53c2[{}]", (Object)JSON.toJSONString((Object)doctorPatientRelationReq));
                String doctorFocusUrl = this.domain + "cloud/doctorbasedata/doc_patient_relation/saveDoctorPatientRelation";
                String result = HxHttpClient.post((String)doctorFocusUrl, (String)JSON.toJSONString((Object)doctorPatientRelationReq));
                log.info("\u8c03\u7528\u4e91\u4e0a\u6dfb\u52a0\u5173\u6ce8\u60a3\u8005\u8fd4\u56de[{}]", (Object)result);
                return (BaseResponse)JSON.parseObject((String)result, BaseResponse.class);
            }
            catch (Exception e) {
                log.error("\u8c03\u7528\u4e91\u4e0a\u6dfb\u52a0\u5173\u6ce8\u5931\u8d25", (Throwable)e);
                return BaseResponse.error((String)"\u8c03\u7528\u4e91\u4e0a\u6dfb\u52a0\u5173\u6ce8\u5931\u8d25");
            }
        }
        return BaseResponse.error((String)"\u8c03\u7528\u60a3\u8005\u670d\u52a1\u67e5\u8be2\u60a3\u8005\u4fe1\u606f\u5931\u8d25");
    }
}

