/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.cbs.service.impl;

import com.ebaiyihui.cbs.client.GhClient;
import com.ebaiyihui.cbs.client.HisBillClient;
import com.ebaiyihui.cbs.service.GetBillService;
import com.ebaiyihui.cbs.vo.BillRespVo;
import com.ebaiyihui.cbs.vo.GetBillReqVo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.bill.GetHisBillInfoReqVo;
import com.ebaiyihui.his.pojo.vo.bill.GetHisBillInfoRes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class GetBillServiceImpl
implements GetBillService {
    private static final Logger log = LoggerFactory.getLogger(GetBillServiceImpl.class);
    @Autowired
    private HisBillClient hisBillApi;
    @Autowired
    private GhClient ghClient;
    @Value(value="${organCode}")
    private String organCode;

    public GatewayResponse<GetHisBillInfoRes> getHisBillInfo(GetBillReqVo getBillReqVo) {
        GetHisBillInfoReqVo getHisBillInfoReqVo = new GetHisBillInfoReqVo();
        getHisBillInfoReqVo.setTransDate(getBillReqVo.getTransDate());
        getHisBillInfoReqVo.setMerchantSeq(getBillReqVo.getMerchantSeq());
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setBody((Object)getHisBillInfoReqVo);
        gatewayRequest.setChannel("manger_web");
        gatewayRequest.setChannelName("\u7ba1\u7406\u7aef");
        gatewayRequest.setKeyWord("getHisBillInfo");
        gatewayRequest.setOrganCode(this.organCode);
        gatewayRequest.setTransactionId("4243252345345");
        log.info("his\u6570\u636e\u8c03\u7528\u53c2\u6570\uff1a{}", (Object)gatewayRequest.toString());
        GatewayResponse gatewayResponse = this.hisBillApi.getHisBillInfo(gatewayRequest);
        log.info("his\u8c03\u7528\u7ed3\u679ccode\uff1a{}", (Object)gatewayResponse.getCode());
        log.info("his\u8c03\u7528\u7ed3\u679c\uff1a{}", (Object)((GetHisBillInfoRes)gatewayResponse.getData()).getItems().toString());
        if ("0".equals(gatewayResponse.getCode()) || null == gatewayResponse.getData() || ((GetHisBillInfoRes)gatewayResponse.getData()).getItems().size() == 0) {
            return gatewayResponse;
        }
        List getHisBillInfoResItems = ((GetHisBillInfoRes)gatewayResponse.getData()).getItems();
        ArrayList ids = new ArrayList();
        getHisBillInfoResItems.forEach(e -> ids.add(e.getMerchantNo()));
        log.info("\u8bf7\u6c42\u667a\u6167\u5c31\u533b\u53c2\u6570:{}", (Object)((Object)ids).toString());
        ArrayList list = new ArrayList();
        BaseResponse baseResponse = this.ghClient.getGh(ids);
        log.info("\u6302\u53f7\u83b7\u53d6\u7684\u6570\u636e\uff1a{}", (Object)baseResponse.toString());
        if ("1".equals(baseResponse.getCode()) && null != baseResponse.getData()) {
            list.addAll((Collection)baseResponse.getData());
        }
        BaseResponse baseResponse1 = this.ghClient.getMzjf(ids);
        log.info("\u95e8\u8bca\u7f34\u8d39\u83b7\u53d6\u7684\u6570\u636e\uff1a{}", (Object)baseResponse1.toString());
        if ("1".equals(baseResponse1.getCode()) && null != baseResponse1.getData()) {
            list.addAll((Collection)baseResponse1.getData());
        }
        BaseResponse baseResponse2 = this.ghClient.getZyyjj(ids);
        log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u83b7\u53d6\u7684\u6570\u636e\uff1a{}", (Object)baseResponse2.toString());
        if ("1".equals(baseResponse2.getCode()) && null != baseResponse2.getData()) {
            list.addAll((Collection)baseResponse2.getData());
        }
        log.info("\u6570\u636e\u6574\u7406\uff1a{}", (Object)((Object)list).toString());
        HashMap map = new HashMap();
        list.forEach(e -> map.put(e.getReceiptId(), e));
        log.info("map\u5185\u5bb9\uff1a{}", (Object)((Object)map).toString());
        ArrayList getHisBillInfoResItemList = new ArrayList();
        getHisBillInfoResItems.forEach(e -> {
            if (null == map || null == map.get(e.getMerchantNo())) {
                e.setBillStatus("2");
                e.setBusinnessType("GH");
                getHisBillInfoResItemList.add(e);
                return;
            }
            BillRespVo billRespVo = (BillRespVo)map.get(e.getMerchantNo());
            e.setBankTranSerNo(billRespVo.getPayBillNo());
            e.setBusinnessType(this.getServiceCode(billRespVo.getBusinessType()));
            getHisBillInfoResItemList.add(e);
        });
        GatewayResponse resGatewayResponse = new GatewayResponse();
        GetHisBillInfoRes getHisBillInfoRes = new GetHisBillInfoRes();
        getHisBillInfoRes.setItems(getHisBillInfoResItemList);
        resGatewayResponse.setTransactionId(gatewayResponse.getTransactionId());
        resGatewayResponse.setData((Object)getHisBillInfoRes);
        resGatewayResponse.setCode("1");
        resGatewayResponse.setErrCode("0");
        resGatewayResponse.setMsg("\u64cd\u4f5c\u6210\u529f");
        log.info("\u7ed9\u5bf9\u8d26\u670d\u52a1\u7684\u8fd4\u56de\u5185\u5bb9:{}", (Object)resGatewayResponse.toString());
        return resGatewayResponse;
    }

    public String getServiceCode(String type) {
        if ("1".equals(type)) {
            return "GH";
        }
        if ("2".equals(type)) {
            return "MZJF";
        }
        if ("3".equals(type)) {
            return "ZYYJJ";
        }
        return type;
    }
}

