/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.doctor.feign.error;

import com.ebaiyihui.doctor.common.vo.business.BusinessAddVO;
import com.ebaiyihui.doctor.common.vo.business.BusinessListVO;
import com.ebaiyihui.doctor.common.vo.business.BusinessReqVO;
import com.ebaiyihui.doctor.common.vo.business.BusinessResVO;
import com.ebaiyihui.doctor.common.vo.business.BusinessUpdateVO;
import com.ebaiyihui.doctor.common.vo.business.IdVO;
import com.ebaiyihui.doctor.common.vo.business.UserIdVO;
import com.ebaiyihui.doctor.feign.BusinessFeignClient;
import com.ebaiyihui.doctor.util.ClientErrorUtil;
import com.ebaiyihui.framework.page.PageRequest;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import feign.hystrix.FallbackFactory;
import java.util.List;

public class BusinessFeignClientError
implements FallbackFactory<BusinessFeignClient> {
    private String serverName = "byh-doctor-basedata";

    public BusinessFeignClient create(final Throwable cause) {
        return new BusinessFeignClient(){

            @Override
            public BaseResponse<String> saveBusiness(BusinessAddVO businessAddVo) {
                return ClientErrorUtil.byError(cause, BusinessFeignClientError.this.serverName);
            }

            @Override
            public BaseResponse<String> updateBusiness(BusinessUpdateVO businessUpdateVo) {
                return ClientErrorUtil.byError(cause, BusinessFeignClientError.this.serverName);
            }

            @Override
            public BaseResponse<String> deleteBusiness(IdVO vo) {
                return ClientErrorUtil.byError(cause, BusinessFeignClientError.this.serverName);
            }

            @Override
            public BaseResponse<String> updateBusinessOnlineOffline(IdVO vo) {
                return ClientErrorUtil.byError(cause, BusinessFeignClientError.this.serverName);
            }

            @Override
            public BaseResponse<PageResult<BusinessResVO>> findListBusinessAll(PageRequest<BusinessListVO> businessListVO) {
                return ClientErrorUtil.byError(cause, BusinessFeignClientError.this.serverName);
            }

            @Override
            public BaseResponse<BusinessResVO> findBySystemPlatAndBusinessName(BusinessReqVO vo) {
                return ClientErrorUtil.byError(cause, BusinessFeignClientError.this.serverName);
            }

            @Override
            public BaseResponse<List<BusinessResVO>> findAllBusiness(UserIdVO vo) {
                return ClientErrorUtil.byError(cause, BusinessFeignClientError.this.serverName);
            }
        };
    }
}

