/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.doctor.util;

import com.ebaiyihui.doctor.common.vo.ResultData;
import com.ebaiyihui.framework.response.BaseResponse;

public class ClientErrorUtil {
    private static String SOCKET_TIME_OUT_C0DE = "203";
    private static String CLIENT_NOT_FOUND_CODE = "204";
    private static String CONNECTION_TIME_OUT_CODE = "403";
    private static String EXCEPTION_CODE = "202";

    public static BaseResponse byError(Throwable cause, String name) {
        BaseResponse resultInfo = new BaseResponse();
        String exceptionName = cause.getCause().getClass().getName();
        resultInfo.setMsg(exceptionName + "------>" + name);
        if (exceptionName.contains("SocketTimeoutException")) {
            resultInfo.setCode(SOCKET_TIME_OUT_C0DE);
            return resultInfo;
        }
        if (exceptionName.contains("ClientException")) {
            resultInfo.setCode(CLIENT_NOT_FOUND_CODE);
            return resultInfo;
        }
        if (exceptionName.contains("ConnectTimeoutException")) {
            resultInfo.setCode(CONNECTION_TIME_OUT_CODE);
            return resultInfo;
        }
        resultInfo.setCode(EXCEPTION_CODE);
        return resultInfo;
    }

    public static ResultData byErrorResultData(Throwable cause, String name) {
        ResultData resultInfo = new ResultData();
        String exceptionName = cause.getCause().getClass().getName();
        resultInfo.setMsg(exceptionName + "------>" + name);
        if (exceptionName.contains("SocketTimeoutException")) {
            resultInfo.setCode(SOCKET_TIME_OUT_C0DE);
            return resultInfo;
        }
        if (exceptionName.contains("ClientException")) {
            resultInfo.setCode(CLIENT_NOT_FOUND_CODE);
            return resultInfo;
        }
        if (exceptionName.contains("ConnectTimeoutException")) {
            resultInfo.setCode(CONNECTION_TIME_OUT_CODE);
            return resultInfo;
        }
        resultInfo.setCode(EXCEPTION_CODE);
        return resultInfo;
    }
}

